#include "windows.h"
#include "commctrl.h"
#include "stdlib.h"
#include "resource.h"

// ============================================================================
//  Comment out next two lines to remove expiration code
//#define DO_EXPIRE
//#define EXPIRE_MONTH  4


// ============================================================================

BOOL WINAPI MainDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL WINAPI AboutDlgProc( HWND, UINT, WPARAM, LPARAM );
LRESULT WINAPI DiceWndProc( HWND, UINT, WPARAM, LPARAM );
BOOL SuperclassDice( void );
BOOL DrawButton( LPDRAWITEMSTRUCT );
BOOL DrawDice( LPDRAWITEMSTRUCT );
BOOL DrawRoll( LPDRAWITEMSTRUCT );
BOOL DrawScore( LPDRAWITEMSTRUCT );
BOOL InitGameBoard( HWND );
BOOL RollMarkedDice( HWND );
BOOL ApplyScore( HWND, WPARAM );
int AddDice( HWND, int );
int AddType( HWND, int );
BOOL InitDice( HWND );
BOOL ScanScores( HWND );
int GetScore( HWND, BOOL * );
BOOL AnyDiceSelected( HWND );
BOOL UnapplyScore( HWND, WPARAM );
BOOL CenterWindow( HWND );
BOOL FillIconList( HINSTANCE );

// ============================================================================

HINSTANCE hInst;
HWND hMainWnd, hSplash;
WNDPROC lpfnButtonProc;
int iDiceUser, iRollNumber, iLastScore, iLastBtn, iIconCount;
HFONT hFont;
HBRUSH hGBrush;
BOOL bScoreMode;
HICON hIconList[ 6 ];

// ============================================================================

int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrev, LPWSTR lpCmd,
					  int nShow )
{
	MSG msg;

#ifdef DO_EXPIRE
	SYSTEMTIME st;
	GetLocalTime( &st );
	if( st.wMonth >= EXPIRE_MONTH )
		return( -1 );
#endif

	if( ! SuperclassDice() )
		return( FALSE );

	hInst = hInstance;
	hMainWnd = CreateDialog( hInstance, MAKEINTRESOURCE( IDD_MAINDLG ), NULL,
							 MainDlgProc );
	if( ! hMainWnd )
		return( FALSE );

	FillIconList( hInstance );
	SendMessage( hMainWnd, WM_SETICON, 0, (LPARAM)LoadImage( hInst,
				 MAKEINTRESOURCE( IDI_MAINICON ), IMAGE_ICON, 16, 16,
				 LR_DEFAULTCOLOR ) );
	ShowWindow( hMainWnd, nShow );
	UpdateWindow( hMainWnd );

	while( GetMessage( &msg, NULL, 0, 0 ) )
	{
		if( IsDialogMessage( hMainWnd, &msg ) )
			continue;
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}
	return( FALSE );
}

// ============================================================================

BOOL FillIconList( HINSTANCE hInstance )
{
	int i;

	for( i = 0; i< 6; i++ )
		hIconList[ i ] = LoadImage( hInst, MAKEINTRESOURCE( IDI_ICON1 + i ),
									IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR );
	return( TRUE );
}

// ============================================================================

BOOL WINAPI MainDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
		{
			LOGFONT lf;

			CenterWindow( hDlg );
			memset( &lf, 0, sizeof(LOGFONT) );
			lf.lfHeight = 12;
			lf.lfWeight = FW_BOLD;
			wcscpy( lf.lfFaceName, L"Arial" );
			hFont = CreateFontIndirect( &lf );

			InitGameBoard( hDlg );
			RollMarkedDice( hDlg );
			iRollNumber = 1;
			bScoreMode = FALSE;
			ShowWindow( GetDlgItem( hDlg, IDC_ROLL ), SW_HIDE );
			iIconCount = 1;
			hSplash = CreateDialog( hInst, MAKEINTRESOURCE( IDD_SPLASH ), hDlg,
									NULL );
			CenterWindow( hSplash );
			ShowWindow( hSplash, SW_SHOW );
			UpdateWindow( hSplash );
			SetTimer( hDlg, 1, 3000, NULL );
			SetTimer( hDlg, 2, 2000, NULL );
			return( TRUE );
		}


		case WM_TIMER:
			if( wParam == 2 )
			{
				KillTimer( hDlg, 2 );
				DestroyWindow( hSplash );
				break;
			}
			SendMessage( hDlg, WM_SETICON, 0, 
						 (LPARAM)hIconList[ iIconCount ] );
			++iIconCount;
			if( iIconCount == 6 )
				iIconCount = 0;
			break;


		case WM_DRAWITEM:
			return( DrawButton( (LPDRAWITEMSTRUCT)lParam ) );


		case WM_COMMAND:
			if( wParam == IDCANCEL )
			{
				int i;


				KillTimer( hDlg, 1 );
				for( i = 0; i < 6; i++ )
					DeleteObject( hIconList[ i ] );
				DeleteObject( hFont );
				DestroyWindow( hDlg );
				PostQuitMessage( 0 );
				return( TRUE );
			}
			if( wParam == IDC_ABOUT )
			{
				DialogBox( hInst, MAKEINTRESOURCE( IDD_ABOUT ), hDlg,
						   AboutDlgProc );
				break;
			}
			if( wParam == IDC_NEWGAME )
			{
				InitGameBoard( hDlg );
				RollMarkedDice( hDlg );
				iRollNumber = 1;
				ShowWindow( GetDlgItem( hDlg, IDC_ROLL ), SW_HIDE );
				break;
			}
			if( wParam == IDC_ROLL )                    //  Roll button pressed
			{
				if( bScoreMode )                         //  If in scoring mode
				{                                   //  Apply score to a button
					if( ScanScores( hDlg ) )       //  All scores complete?
					{
						MessageBox( hDlg,
							    L"Game Over!\nPress any board item for a new game",
							        L"YachtCE", MB_OK | MB_ICONINFORMATION );
						iRollNumber = 10;
					}
					else
					{
						ShowWindow( GetDlgItem( hDlg, IDC_ROLL ), SW_SHOW );
						iRollNumber = 1;
						iLastBtn = 0;
						InitDice( hDlg );
					}
					ShowWindow( GetDlgItem( hDlg, IDC_ROLL ), SW_HIDE );
					bScoreMode = FALSE;
					iLastBtn = 0;
					break;
				}

				if( iRollNumber < 3 )                   //  If not the 3rd roll
				{
					ShowWindow( GetDlgItem( hDlg, IDC_ROLL ), SW_HIDE );
					RollMarkedDice( hDlg );            //  Roll all marked dice
					++iRollNumber;                     //  Increment roll count
				}
				break;
			}
			if( wParam >= IDC_DICE1 && wParam <= IDC_DICE5 )
			{
				BOOL bJunk;


				if( iRollNumber == 10 )
				{
					InitGameBoard( hDlg );
					RollMarkedDice( hDlg );
					ShowWindow( GetDlgItem( hDlg, IDC_ROLL ), SW_HIDE );
					iRollNumber = 1;
					break;
				}

				if( iRollNumber < 3 )
				{
					if( bScoreMode )
					{
						bScoreMode = FALSE;
						UnapplyScore( GetDlgItem( hDlg, iLastBtn ), iLastBtn );
						InvalidateRect( GetDlgItem( hDlg, IDC_ROLL ), NULL, FALSE );
					}

					if( GetDlgItemInt( hDlg, wParam, &bJunk, TRUE ) )
					{
						if( SendDlgItemMessage( hDlg, wParam, BM_GETCHECK, 0, 0 ) )
							SendDlgItemMessage( hDlg, wParam, BM_SETCHECK, FALSE, 0 );
						else
							SendDlgItemMessage( hDlg, wParam, BM_SETCHECK, TRUE, 0 );
				
						InvalidateRect( GetDlgItem( hDlg, wParam ), NULL, TRUE );
						
						if( AnyDiceSelected( hDlg ) )
							ShowWindow( GetDlgItem( hDlg, IDC_ROLL ), SW_SHOW );
						else
							ShowWindow( GetDlgItem( hDlg, IDC_ROLL ), SW_HIDE );
					}
				}
				break;
			}
			if( wParam >= IDC_ONES && wParam <= IDC_YACHT )
			{
				if( iRollNumber == 10 )
				{
					InitGameBoard( hDlg );
					RollMarkedDice( hDlg );
					ShowWindow( GetDlgItem( hDlg, IDC_ROLL ), SW_HIDE );
					iRollNumber = 1;
					break;
				}
				if( ApplyScore( GetDlgItem( hDlg, wParam ), wParam ) )
				{
					UnapplyScore( GetDlgItem( hDlg, iLastBtn ), iLastBtn );
					iLastBtn = wParam;

					bScoreMode = TRUE;
					ShowWindow( GetDlgItem( hDlg, IDC_ROLL ), TRUE );
					InvalidateRect( GetDlgItem( hDlg, IDC_ROLL ), NULL, FALSE );
				}
				break;
			}
			break;
	}
	return( FALSE );
}

// ============================================================================

BOOL SuperclassDice( void )
{
	WNDCLASS wc;

	if( ! GetClassInfo( NULL, L"button", &wc ) )
		return( FALSE );

	iDiceUser = wc.cbWndExtra;
	lpfnButtonProc = wc.lpfnWndProc;

	wc.lpfnWndProc = DiceWndProc;
	wc.lpszClassName = L"MGDice";
	wc.cbWndExtra += 4;
	return( RegisterClass( &wc ) );
}

// ============================================================================

BOOL DrawButton( LPDRAWITEMSTRUCT lpDs )
{
	if( lpDs->CtlID == IDC_DICE1 || lpDs->CtlID == IDC_DICE2 ||
		lpDs->CtlID == IDC_DICE3 || lpDs->CtlID == IDC_DICE4 ||
		lpDs->CtlID == IDC_DICE5 )
		return( DrawDice( lpDs ) );
	if( lpDs->CtlID == IDC_ROLL )
		return( DrawRoll( lpDs ) );

	return( DrawScore( lpDs ) );
}

// ============================================================================

BOOL DrawDice( LPDRAWITEMSTRUCT lpDs )
{
	int iValue, iLeft, iRight, iTop, iBottom, iVMid, iHMid;
	BOOL bJunk;
	RECT Rect;


	GetClientRect( lpDs->hwndItem, &Rect );
	iLeft = Rect.left + 2;
	iRight = Rect.right - 10;
	iTop = Rect.top + 2;
	iBottom = Rect.bottom - 10;
	iHMid = ( Rect.right / 2 ) - 4;
	iVMid = ( Rect.bottom / 2 ) - 4;

	if( SendMessage( lpDs->hwndItem, BM_GETCHECK, 0, 0 ) )
	{
		SelectObject( lpDs->hDC, GetStockObject( BLACK_BRUSH ) );
		SelectObject( lpDs->hDC, GetStockObject( WHITE_PEN ) );
	}
	else
	{
		SelectObject( lpDs->hDC, GetStockObject( WHITE_BRUSH ) );
		SelectObject( lpDs->hDC, GetStockObject( BLACK_PEN ) );
	}
	Rectangle( lpDs->hDC, 0, 0, Rect.right, Rect.bottom );

	if( SendMessage( lpDs->hwndItem, BM_GETCHECK, 0, 0 ) )
		SelectObject( lpDs->hDC, GetStockObject( WHITE_BRUSH ) );
	else
		SelectObject( lpDs->hDC, GetStockObject( BLACK_BRUSH ) );

	iValue = GetDlgItemInt( GetParent( lpDs->hwndItem ), lpDs->CtlID,
							&bJunk, TRUE );
	if( ! iValue )
		return( TRUE );

	if( iValue == 1 || iValue == 3 || iValue == 5 )
		Ellipse( lpDs->hDC, iHMid, iVMid, iHMid + 8, iVMid + 8 );
	
	if( iValue == 2 || iValue == 3 )
	{
		Ellipse( lpDs->hDC, iLeft, iTop,  iLeft + 8, iTop + 8 );
		Ellipse( lpDs->hDC, iRight, iBottom, iRight + 8, iBottom + 8 );
	}
	if( iValue == 4 || iValue == 5 || iValue == 6 )
	{
		Ellipse( lpDs->hDC, iLeft, iTop,  iLeft + 8, iTop + 8 );
		Ellipse( lpDs->hDC, iRight, iTop,  iRight + 8, iTop + 8 );
		Ellipse( lpDs->hDC, iRight, iBottom, iRight + 8, iBottom + 8 );
		Ellipse( lpDs->hDC, iLeft, iBottom, iLeft + 8, iBottom + 8 );
	}
	if( iValue == 6 )
	{
		Ellipse( lpDs->hDC, iHMid, iTop,  iHMid + 8, iTop + 8 );
		Ellipse( lpDs->hDC, iHMid, iBottom, iHMid + 8, iBottom + 8 );
	}

	return( TRUE );
}

// ============================================================================

BOOL DrawRoll( LPDRAWITEMSTRUCT lpDs )
{
	TEXTMETRIC tm;
	RECT Rect;
	int iPos;
	HFONT hOldFont;


	GetTextMetrics( lpDs->hDC, &tm );
	GetClientRect( lpDs->hwndItem, &Rect );

	SelectObject( lpDs->hDC, GetStockObject( BLACK_BRUSH ) );
	SelectObject( lpDs->hDC, GetStockObject( BLACK_PEN ) );
	Rectangle( lpDs->hDC, 0, 0, Rect.right, Rect.bottom );

	SetBkMode( lpDs->hDC, TRANSPARENT );
	SetTextColor( lpDs->hDC, RGB( 255, 255, 255 ) );

	hOldFont = SelectObject( lpDs->hDC, hFont );
	if( ! bScoreMode )
	{
		iPos = ( Rect.bottom / 2 ) - ( ( tm.tmHeight + 2 ) * 2 );
		ExtTextOut( lpDs->hDC, 7, iPos, 0, &Rect, L"R", 1, NULL );

		iPos = ( Rect.bottom / 2 ) - ( tm.tmHeight + 2 );
		ExtTextOut( lpDs->hDC, 7, iPos, 0, &Rect, L"O", 1, NULL );

		iPos = ( Rect.bottom / 2 );
		ExtTextOut( lpDs->hDC, 7, iPos, 0, &Rect, L"L", 1, NULL );

		iPos = ( Rect.bottom / 2 ) + ( tm.tmHeight + 2 );
		ExtTextOut( lpDs->hDC, 7, iPos, 0, &Rect, L"L", 1, NULL );
	}
	else
	{
		iPos = ( Rect.bottom / 2 ) - ( ( tm.tmHeight + 2 ) * 2 );
		ExtTextOut( lpDs->hDC, 7, iPos, 0, &Rect, L"S", 1, NULL );

		iPos = ( Rect.bottom / 2 ) - ( tm.tmHeight + 2 );
		ExtTextOut( lpDs->hDC, 7, iPos, 0, &Rect, L"C", 1, NULL );

		iPos = ( Rect.bottom / 2 );
		ExtTextOut( lpDs->hDC, 7, iPos, 0, &Rect, L"O", 1, NULL );

		iPos = ( Rect.bottom / 2 ) + ( tm.tmHeight + 2 );
		ExtTextOut( lpDs->hDC, 7, iPos, 0, &Rect, L"R", 1, NULL );

		iPos = ( Rect.bottom / 2 ) + ( ( tm.tmHeight + 2 ) * 2 );
		ExtTextOut( lpDs->hDC, 7, iPos, 0, &Rect, L"E", 1, NULL );
	}
	SelectObject( lpDs->hDC, hOldFont );
	return( TRUE );
}

// ============================================================================

BOOL DrawScore( LPDRAWITEMSTRUCT lpDs )
{
	TCHAR szText[ 32 ], *pszTab;
	RECT Rect;
	LOGPEN lp;
	HPEN hPen;
	HFONT hOldFont;
	HBRUSH hBrush;


	if( ! GetWindowText( lpDs->hwndItem, szText, 32 ) )
		return( TRUE );

	pszTab = wcschr( szText, L'\t' );
	if( pszTab )
	{
		*pszTab = L'\0';
		pszTab += 1;
	}

	GetClientRect( lpDs->hwndItem, &Rect );
	if( lpDs->CtlID == IDC_ONES || lpDs->CtlID == IDC_TWOS ||
		lpDs->CtlID == IDC_THREES || lpDs->CtlID == IDC_FOURS ||
		lpDs->CtlID == IDC_FIVES || lpDs->CtlID == IDC_SIXES )
		hBrush = CreateSolidBrush( RGB( 255, 255, 0 ) );
	else
		hBrush = CreateSolidBrush( RGB( 0, 255, 255 ) );
	hBrush = SelectObject( lpDs->hDC, hBrush );
	lp.lopnStyle = PS_SOLID;
	lp.lopnWidth.x =  lp.lopnWidth.y = 1;
	lp.lopnColor = RGB( 0, 0, 0 );
	hPen = CreatePenIndirect( &lp );
	hPen = SelectObject( lpDs->hDC, hPen );
	Rectangle( lpDs->hDC, 0, 0, Rect.right, Rect.bottom - 1 );

	DeleteObject( SelectObject( lpDs->hDC, GetStockObject( BLACK_BRUSH ) ) );
	DeleteObject( SelectObject( lpDs->hDC, GetStockObject( BLACK_PEN ) ) );
	Rectangle( lpDs->hDC, Rect.right - 34, 0, Rect.right, Rect.bottom - 1 );

	SetBkMode( lpDs->hDC, TRANSPARENT );
	SetTextColor( lpDs->hDC, RGB( 0, 0, 0 ) );
	
	hOldFont = SelectObject( lpDs->hDC, hFont );
	ExtTextOut( lpDs->hDC, 3, 2, 0, &Rect, szText, wcslen( szText ), NULL );

	if( pszTab )
	{
		if( lpDs->CtlID == IDC_ONES || lpDs->CtlID == IDC_TWOS ||
			lpDs->CtlID == IDC_THREES || lpDs->CtlID == IDC_FOURS ||
			lpDs->CtlID == IDC_FIVES || lpDs->CtlID == IDC_SIXES )
			SetTextColor( lpDs->hDC, RGB( 255, 255, 0 ) );
		else
			SetTextColor( lpDs->hDC, RGB( 0, 255, 255 ) );

		ExtTextOut( lpDs->hDC, Rect.right - 24, 2, 0, &Rect, pszTab, 
					wcslen( pszTab ), NULL );
	}

	SelectObject( lpDs->hDC, hOldFont );
	return( TRUE );
}

// ============================================================================

BOOL InitDice( HWND hDlg )
{
	int i;

	for( i = 0; i < 5; i++ )
		SendDlgItemMessage( hDlg, IDC_DICE1 + i, BM_SETCHECK, TRUE, 0 );
	RollMarkedDice( hDlg );
	return( TRUE );
}

// ============================================================================

BOOL InitGameBoard( HWND hDlg )
{
	int i;

	iLastScore = iLastBtn = 0;
	for( i = 0; i < 5; i++ )
		SendDlgItemMessage( hDlg, IDC_DICE1 + i, BM_SETCHECK, TRUE, 0 );

	SetDlgItemText( hDlg, IDC_ONES, L"Ones" );
	SetDlgItemText( hDlg, IDC_TWOS, L"Twos" );
	SetDlgItemText( hDlg, IDC_THREES, L"Threes" );
	SetDlgItemText( hDlg, IDC_FOURS, L"Fours" );
	SetDlgItemText( hDlg, IDC_FIVES, L"Fives" );
	SetDlgItemText( hDlg, IDC_SIXES, L"Sixes" );

	SetDlgItemText( hDlg, IDC_BONUS, L"Bonus:" );
	SetDlgItemText( hDlg, IDC_SUBTOTAL, L"Subtotal:" );
	SetDlgItemText( hDlg, IDC_SCORE, L"Score:" );

	SetDlgItemText( hDlg, IDC_ONEPAIR, L"One Pair" );
	SetDlgItemText( hDlg, IDC_TWOPAIR, L"Two Pair" );
	SetDlgItemText( hDlg, IDC_THREEOFAKIND, L"Three Of A Kind" );
	SetDlgItemText( hDlg, IDC_FOUROFAKIND, L"Four Of A Kind" );
	SetDlgItemText( hDlg, IDC_SMSTRAIGHT, L"Small Straight" );
	SetDlgItemText( hDlg, IDC_LGSTRAIGHT, L"Large Straight" );
	SetDlgItemText( hDlg, IDC_FULLHOUSE, L"Full House" );
	SetDlgItemText( hDlg, IDC_CHANCE, L"Chance" );
	SetDlgItemText( hDlg, IDC_YACHT, L"Yacht" );

	return( TRUE );
}

// ============================================================================

BOOL RollMarkedDice( HWND hDlg )
{
	DWORD dwValue;
	TCHAR szStr[ 32 ];
	int i;

	for( i = 0; i < 5; i++ )
	{
		if( SendDlgItemMessage( hDlg, IDC_DICE1 + i, BM_GETCHECK, 0, 0 ) )
		{
			dwValue = 0;
			while( dwValue < 1 || dwValue > 6 )
				dwValue = ( ( Random() & 0x0F ) / 2 );
			wsprintf( szStr, L"%d", dwValue );
			SetDlgItemText( hDlg, IDC_DICE1 + i, szStr );
			SendDlgItemMessage( hDlg, IDC_DICE1 + i, BM_SETCHECK, 0, 0 );
			InvalidateRect( GetDlgItem( hDlg, IDC_DICE1 + i ), NULL, TRUE );
		}
	}
	return( TRUE );
}

// ============================================================================

LRESULT WINAPI DiceWndProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case BM_SETCHECK:
			return( SetWindowLong( hWnd, iDiceUser, wParam ) );

		case BM_GETCHECK:
			return( GetWindowLong( hWnd, iDiceUser ) );
	}
	return( CallWindowProc( lpfnButtonProc, hWnd, msg, wParam, lParam ) );
}

// ============================================================================

BOOL ApplyScore( HWND hCtrl, WPARAM wParam )
{
	TCHAR szStr[ 32 ], szText[ 8 ];
	int iValue;

	if( ! GetWindowText( hCtrl, szStr, 32 ) )
		return( FALSE );

	if( wcschr( szStr, L'\t' ) )
		return( FALSE );

	iValue = AddDice( GetParent( hCtrl ), wParam );
	wsprintf( szText, L"\t%d", iValue );
	wcscat( szStr, szText );
	SetWindowText( hCtrl, szStr );
	return( TRUE );
}

// ============================================================================

BOOL UnapplyScore( HWND hCtrl, WPARAM wParam )
{
	TCHAR szFull[ 32 ], *pszPtr;

	if( ! GetWindowText( hCtrl, szFull, 32 ) )
		return( FALSE );

	pszPtr = wcschr( szFull, L'\t' );
	if( ! pszPtr )
		return( FALSE );

	*pszPtr = L'\0';
	SetWindowText( hCtrl, szFull );
	return( TRUE );
}

// ============================================================================

int AddDice( HWND hDlg, int iType )
{
	int i, iTotal, iValue, iDie[ 5 ], iAmounts[ 6 ];
	BOOL bJunk;


	iTotal = 0;

	for( i = 0; i < 6; i++ )                //  Initialize all die amounts to 0
		iAmounts[ i ] = 0;

	for( i = 0; i < 5; i++ )
	{                                       //  Get number for a particular die
		iDie[ i ] = GetDlgItemInt( hDlg, IDC_DICE1 + i, &bJunk, TRUE );
		++iAmounts[ iDie[ i ] - 1 ];     //  Increment amount of particular die
	}

	if( iType >= IDC_ONES && iType <= IDC_SIXES )
		return( iAmounts[ iType - IDC_ONES ] * ( iType - IDC_ONES + 1 ) );

	if( iType == IDC_ONEPAIR || iType == IDC_TWOPAIR )
	{
		iValue = 0;

		for( i = 5; i != -1; i-- )
		{
			if( iAmounts[ i ] > 1 )
			{
				if( iType == IDC_ONEPAIR )
					return( ( i + 1 ) * 2 );
				else
				{
					iTotal = iTotal + ( ( i + 1 ) * 2 );
					++iValue;
					if( iValue == 2 )
						return( iTotal );
				}
			}
		}
		return( 0 );
	}

	if( iType == IDC_THREEOFAKIND || iType == IDC_FOUROFAKIND )
	{
		for( i = 5; i != -1; i-- )
		{
			if( iType == IDC_THREEOFAKIND && iAmounts[ i ] > 2 )
				return( ( i + 1 ) * iAmounts[ i ] );
			if( iType == IDC_FOUROFAKIND && iAmounts[ i ] > 3 )
				return( ( i + 1 ) * iAmounts[ i ] );
		}
		return( 0 );
	}

	if( iType == IDC_CHANCE )
	{
		for( i = 5; i != -1; i-- )
			iTotal = iTotal + ( iAmounts[ i ] * ( i + 1 ) );
		return( iTotal );
	}

	if( iType == IDC_YACHT )
	{
		for( i = 5; i != -1; i-- )
			if( iAmounts[ i ] == 5 )
				return( 50 );
		return( 0 );
	}

	if( iType == IDC_SMSTRAIGHT )
	{
		if( ( iAmounts[ 0 ] && iAmounts[ 1 ] && iAmounts[ 2 ] && iAmounts[ 3 ] ) ||
			( iAmounts[ 1 ] && iAmounts[ 2 ] && iAmounts[ 3 ] && iAmounts[ 4 ] ) ||
			( iAmounts[ 2 ] && iAmounts[ 3 ] && iAmounts[ 4 ] && iAmounts[ 5 ] ) )
			return( 15 );
		return( 0 );
	}

	if( iType == IDC_LGSTRAIGHT )
	{
		if( ( iAmounts[ 0 ] && iAmounts[ 1 ] && iAmounts[ 2 ] &&
			  iAmounts[ 3 ] && iAmounts[ 4 ] ) ||
			( iAmounts[ 1 ] && iAmounts[ 2 ] && iAmounts[ 3 ] &&
			  iAmounts[ 4 ] && iAmounts[ 5 ] ) )
			return( 20 );
		return( 0 );
	}

	if( iType == IDC_FULLHOUSE )
	{
		for( i = 0; i < 6; i++ )
		{
			if( iAmounts[ i ] == 3 )
			{
				iTotal = 3 * ( i + 1 );
				for( iValue = 0; iValue < 6; iValue++ )
				{
					if( iAmounts[ iValue ] == 2 )
					{
						iTotal = iTotal + ( ( iValue + 1 ) * 2 );
						return( iTotal );
					}
				}
			}
		}
		return( 0 );
	}
	return( iTotal );
}

// ============================================================================

BOOL ScanScores( HWND hDlg )
{
	int iTotal, iSubTotal, iBonus, iValue, i, iUsed;
	BOOL bUsed;
	TCHAR szStr[ 32 ];


	iTotal = iSubTotal = iBonus = iUsed = 0;

	for( i = 0; i < 6; i++ )
	{
		iValue = GetScore( GetDlgItem( hDlg, IDC_ONES + i ), &bUsed );
		iSubTotal = iSubTotal + iValue;
		if( bUsed )
			++iUsed;
	}
	if( iSubTotal > 63 )
		iBonus = 50;

	i = IDC_ONEPAIR;
	while( i <= IDC_YACHT )
	{
		iValue = GetScore( GetDlgItem( hDlg, i ), &bUsed );
		iTotal = iTotal + iValue;
		if( bUsed )
			++iUsed;
		++i;
	}

	if( iSubTotal )
	{
		wsprintf( szStr, L"Subtotal: %d", iSubTotal );
		SetDlgItemText( hDlg, IDC_SUBTOTAL, szStr );
	}

	if( iBonus )
	{
		wsprintf( szStr, L"Bonus: %d", iBonus );
		SetDlgItemText( hDlg, IDC_BONUS, szStr );
	}

	wsprintf( szStr, L"Total: %d", iSubTotal + iTotal + iBonus );
	SetDlgItemText( hDlg, IDC_SCORE, szStr );

	if( iUsed == 15 )
		return( TRUE );

	return( FALSE );
}

// ============================================================================

int GetScore( HWND hCtrl, BOOL *pbUsed )
{
	TCHAR szStr[ 32 ], *pszStr, *pszEnd;
	int iValue;

	iValue = 0;
	*pbUsed = FALSE;
	if( ! GetWindowText( hCtrl, szStr, 32 ) )
		return( 0 );

	pszStr = wcschr( szStr, L'\t' );
	if( pszStr )
	{
		*pbUsed = TRUE;
		++pszStr;
		iValue = (int)wcstol( pszStr, &pszEnd, 10 );
		return( iValue );
	}
	return( 0 );
}

// ============================================================================

BOOL AnyDiceSelected( HWND hDlg )
{
	int i;

	for( i = 0; i < 5; i++ )
		if( SendDlgItemMessage( hDlg, IDC_DICE1 + i, BM_GETCHECK, 0, 0 ) )
			return( TRUE );
	return( FALSE );
}

// ============================================================================

BOOL WINAPI AboutDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
			CenterWindow( hDlg );
			return( TRUE );


		case WM_COMMAND:
			if( wParam == IDCANCEL || wParam == IDOK )
			{
				EndDialog( hDlg, TRUE );
				return( TRUE );
			}
			break;
	}
	return( FALSE );
}

// ============================================================================

BOOL CenterWindow( HWND hWnd )
{
	int iXsize, iYsize;
	RECT Rect;

	iXsize = GetSystemMetrics( SM_CXSCREEN );
	iYsize = GetSystemMetrics( SM_CYSCREEN );
	GetWindowRect( hWnd, &Rect );
	Rect.right = Rect.right - Rect.left;
	Rect.bottom = Rect.bottom - Rect.top;
	Rect.left = ( iXsize - Rect.right ) / 2;
	Rect.top = ( iYsize - Rect.bottom ) / 2;
	SetWindowPos( hWnd, NULL, Rect.left, Rect.top, 0, 0,
				  SWP_NOSIZE | SWP_NOZORDER );
	return( TRUE );
}





