#include "windows.h"
#include "winsock.h"
#include "stdlib.h"
#include "resource.h"

// ============================================================================

BOOL WINAPI MainDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL WINAPI AboutDlgProc( HWND, UINT, WPARAM, LPARAM );
int wctomb( TCHAR *, char * );
int mbtowc( char *, TCHAR * );
BOOL CenterWindow( HWND );
BOOL DoWhois( HWND );

// ============================================================================

HINSTANCE hInst;
HWND hMainWnd;

// ============================================================================

int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrev, LPWSTR lpCmd,
					  int nShow )
{
	MSG msg;


	hInst = hInstance;
	hMainWnd = CreateDialog( hInst, MAKEINTRESOURCE( IDD_MAINDLG ), NULL,
							 MainDlgProc );
	if( ! hMainWnd )
		return( FALSE );

	ShowWindow( hMainWnd, nShow );
	UpdateWindow( hMainWnd );

	while( GetMessage( &msg, NULL, 0, 0 ) )
	{
		if( IsDialogMessage( hMainWnd, &msg ) )
			continue;

		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}
	return( FALSE );
}

// ============================================================================

BOOL WINAPI MainDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
			CenterWindow( hDlg );
			SetDlgItemText( hDlg, IDC_SERVER, L"whois.internic.net" );
			return( TRUE );


		case WM_COMMAND:
			if( wParam == IDCANCEL )
			{
				DestroyWindow( hDlg );
				PostQuitMessage( 0 );
				return( TRUE );
			}
			if( wParam == IDOK )
			{
				if( ! DoWhois( hDlg ) )
					MessageBox( hDlg, L"Whois failed!", L"WinWhois",
								MB_OK | MB_ICONEXCLAMATION );
				break;
			}
			if( wParam == IDC_ABOUT )
			{
				DialogBox( hInst, MAKEINTRESOURCE( IDD_ABOUT ), hDlg,
						   AboutDlgProc );
				break;
			}
			break;
	}
	return( FALSE );
}

// ============================================================================

int wctomb( TCHAR *szWide, char *szMByte )
{
	while( *szWide )
		*szMByte++ = (char)*szWide++;
	*szMByte = '\0';
	return( wcslen( szWide ) );
}

// ============================================================================

int mbtowc( char *szMByte, TCHAR *szWide )
{
	while( *szMByte )
		*szWide++ = (BYTE)*szMByte++ & 0xFF;
	*szWide = L'\0';
	return( wcslen( szWide ) );
}

// ============================================================================

BOOL CenterWindow( HWND hWnd )
{
	int iXsize, iYsize;
	RECT Rect;

	iXsize = GetSystemMetrics( SM_CXSCREEN );
	iYsize = GetSystemMetrics( SM_CYSCREEN );
	GetWindowRect( hWnd, &Rect );
	Rect.right = Rect.right - Rect.left;
	Rect.bottom = Rect.bottom - Rect.top;
	Rect.left = ( iXsize - Rect.right ) / 2;
	Rect.top = ( iYsize - Rect.bottom ) / 2;
	SetWindowPos( hWnd, NULL, Rect.left, Rect.top, 0, 0,
				  SWP_NOSIZE | SWP_NOZORDER );
	return( TRUE );
}

// ============================================================================

BOOL WINAPI AboutDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
			CenterWindow( hDlg );
			return( TRUE );


		case WM_COMMAND:
			if( wParam == IDCANCEL || wParam == IDOK )
			{
				EndDialog( hDlg, TRUE );
				return( TRUE );
			}
			break;
	}
	return( FALSE );
}

// ============================================================================

BOOL DoWhois( HWND hDlg )
{
	TCHAR szName[ 256 ], szServer[ 128 ], *pszBuffer;
	char cName[ 256 ], cServer[ 128 ], *pcBuffer, *pcStr;
	BOOL bStatus;
	struct hostent *phe;
	SOCKET s;
	LPBYTE bAddr;
	int iStatus, iOffset, iPos, iLen;
	SOCKADDR_IN sin;
	WSADATA wsa;


	if( ! GetDlgItemText( hDlg, IDC_NAME, szName, 256 ) )
		return( FALSE );

	if( ! GetDlgItemText( hDlg, IDC_SERVER, szServer, 256 ) )
		return( FALSE );

	bStatus = FALSE;

	WSAStartup( 0x0101, &wsa );

	EnableWindow( GetDlgItem( hDlg, IDOK ), FALSE );
	EnableWindow( GetDlgItem( hDlg, IDCANCEL ), FALSE );
	EnableWindow( GetDlgItem( hDlg, IDC_ABOUT ), FALSE );
	EnableWindow( GetDlgItem( hDlg, IDC_SERVERLIST ), FALSE );

	wctomb( szName, cName );
	wctomb( szServer, cServer );

	phe = gethostbyname( cServer );
	if( phe )
	{
		s = socket( PF_INET, SOCK_STREAM, 0 );
		if( s != INVALID_SOCKET )
		{
			bAddr = *phe->h_addr_list;
			sin.sin_family = AF_INET;
			sin.sin_port = htons( IPPORT_WHOIS );
			sin.sin_addr.s_addr = *(LPDWORD)bAddr;
			iStatus = connect( s, (LPSOCKADDR)&sin, sizeof(SOCKADDR_IN) );
			if( iStatus != SOCKET_ERROR )
			{
				pcBuffer = malloc( 4096 );
				if( pcBuffer )
				{
					pszBuffer = (TCHAR *)malloc( 4096 * sizeof(TCHAR) );
					if( pszBuffer )
					{
						send( s, cName, strlen( cName ), 0 );
						send( s, "\r\n", 2, 0 );
						
						iOffset = 0;
						memset( pcBuffer, 0, 4096 );
						memset( pszBuffer, 0, 4096 * sizeof(TCHAR) );

						while( 1 )
						{
							iStatus = recv( s, pcBuffer + iOffset,
											4096 - iOffset, 0 );
							if( ! iStatus )
								break;
							iOffset = iOffset + iStatus;
						}

						iLen = strlen( pcBuffer ) + 1;
						pcStr = strchr( pcBuffer, '\x0A' );
						while( pcStr )
						{
							iPos = (int)( pcStr - pcBuffer );
							memmove( pcStr + 1, pcStr, iLen - iPos );
							*pcStr = '\x0D';
							pcStr = strchr( pcStr + 2, '\x0A' );
						}

						mbtowc( pcBuffer, pszBuffer );

						SetDlgItemText( hDlg, IDC_INFO, pszBuffer );
						bStatus = TRUE;
						free( pszBuffer );
					}
					free( pcBuffer );
				}
			}
		}
	}

	EnableWindow( GetDlgItem( hDlg, IDOK ), TRUE );
	EnableWindow( GetDlgItem( hDlg, IDCANCEL ), TRUE );
	EnableWindow( GetDlgItem( hDlg, IDC_ABOUT ), TRUE );
	EnableWindow( GetDlgItem( hDlg, IDC_SERVERLIST ), TRUE );

	WSACleanup();
	return( bStatus );
}



