#include "windows.h"
#include "winsock.h"
#include "stdlib.h"
#include "resource.h"

// ============================================================================

BOOL WINAPI MainDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL WINAPI AboutDlgProc( HWND, UINT, WPARAM, LPARAM );
int wctomb( TCHAR *, char * );
int mbtowc( char *, TCHAR * );
BOOL FingerUser( HWND );
BOOL CenterWindow( HWND );

// ============================================================================

HINSTANCE hInst;
HWND hMainWnd;

// ============================================================================

int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrev, LPWSTR lpCmd,
					  int nShow )
{
	MSG msg;


	hInst = hInstance;
	hMainWnd = CreateDialog( hInst, MAKEINTRESOURCE( IDD_MAINDLG ), NULL,
							 MainDlgProc );
	if( ! hMainWnd )
		return( FALSE );

	ShowWindow( hMainWnd, nShow );
	UpdateWindow( hMainWnd );

	while( GetMessage( &msg, NULL, 0, 0 ) )
	{
		if( IsDialogMessage( hMainWnd, &msg ) )
			continue;

		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}

	return( FALSE );
}

// ============================================================================

BOOL WINAPI MainDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
			CenterWindow( hDlg );
			return( TRUE );


		case WM_COMMAND:
			if( wParam == IDCANCEL )
			{
				DestroyWindow( hDlg );
				PostQuitMessage( 0 );
				return( TRUE );
			}
			if( wParam == IDOK )
			{
				if( ! FingerUser( hDlg ) )
					MessageBox( hDlg, L"Finger attempt failed!", L"WinFinC",
								MB_OK | MB_ICONEXCLAMATION );
				break;
			}
			if( wParam == IDC_ABOUT )
			{
				DialogBox( hInst, MAKEINTRESOURCE( IDD_ABOUT ), hDlg,
						   AboutDlgProc );
				break;
			}
			break;
	}
	return( FALSE );
}

// ============================================================================

int wctomb( TCHAR *szWide, char *szMByte )
{
	while( *szWide )
		*szMByte++ = (char)*szWide++;
	*szMByte = '\0';
	return( wcslen( szWide ) );
}

// ============================================================================

int mbtowc( char *szMByte, TCHAR *szWide )
{
	while( *szMByte )
		*szWide++ = (USHORT)( (BYTE)*szMByte++ & 0xFF );
	*szWide = L'\0';
	return( wcslen( szWide ) );
}

// ============================================================================

BOOL FingerUser( HWND hDlg )
{
	TCHAR szEmail1[ 128 ], szEmail2[ 128 ], *pszBuff;
	char cEmail1[ 128 ], cEmail2[ 128 ], *pcBuff;
	struct hostent *phe;
	BOOL bStatus;
	LPBYTE bAddr;
	int iStatus;
	SOCKADDR_IN sin;
	SOCKET s;


	if( ! GetDlgItemText( hDlg, IDC_EMAIL1, szEmail1, 128 ) )
		return( FALSE );

	if( ! GetDlgItemText( hDlg, IDC_EMAIL2, szEmail2, 128 ) )
		return( FALSE );

	EnableWindow( GetDlgItem( hDlg, IDOK ), FALSE );
	EnableWindow( GetDlgItem( hDlg, IDCANCEL ), FALSE );
	EnableWindow( GetDlgItem( hDlg, IDC_ABOUT ), FALSE );

	bStatus = FALSE;
	wctomb( szEmail2, cEmail2 );
	phe = gethostbyname( cEmail2 );
	if( phe )
	{
		s = socket( PF_INET, SOCK_STREAM, 0 );
		if( s != INVALID_SOCKET )
		{
			bAddr = *phe->h_addr_list;
			sin.sin_family = AF_INET;
			sin.sin_port = htons( IPPORT_FINGER );
			sin.sin_addr.s_addr = *(LPDWORD)bAddr;
			iStatus = connect( s, (LPSOCKADDR)&sin, sizeof(SOCKADDR_IN) );
			if( iStatus != SOCKET_ERROR )
			{
				wctomb( szEmail1, cEmail1 );
				send( s, cEmail1, strlen( cEmail1 ), 0 );
				send( s, "\r\n", 2, 0 );
				
				pcBuff = malloc( 1024 );
				if( pcBuff )
				{
					*pcBuff = '\0';
					iStatus = recv( s, pcBuff, 1024, 0 );
					if( iStatus )
					{
						pszBuff = (TCHAR *)malloc( 1024 * sizeof(TCHAR) );
						if( pszBuff )
						{
							mbtowc( pcBuff, pszBuff );
							SetDlgItemText( hDlg, IDC_INFO, pszBuff );
							bStatus = TRUE;
							free( pszBuff );
						}
					}
					free( pcBuff );
				}
				closesocket( s );
			}
		}
	}

	EnableWindow( GetDlgItem( hDlg, IDOK ), TRUE );
	EnableWindow( GetDlgItem( hDlg, IDCANCEL ), TRUE );
	EnableWindow( GetDlgItem( hDlg, IDC_ABOUT ), TRUE );
	return( bStatus );
}

// ============================================================================

BOOL CenterWindow( HWND hWnd )
{
	int iXsize, iYsize;
	RECT Rect;

	iXsize = GetSystemMetrics( SM_CXSCREEN );
	iYsize = GetSystemMetrics( SM_CYSCREEN );
	GetWindowRect( hWnd, &Rect );
	Rect.right = Rect.right - Rect.left;
	Rect.bottom = Rect.bottom - Rect.top;
	Rect.left = ( iXsize - Rect.right ) / 2;
	Rect.top = ( iYsize - Rect.bottom ) / 2;
	SetWindowPos( hWnd, NULL, Rect.left, Rect.top, 0, 0,
				  SWP_NOSIZE | SWP_NOZORDER );
	return( TRUE );
}

// ============================================================================

BOOL WINAPI AboutDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
			CenterWindow( hDlg );
			return( TRUE );


		case WM_COMMAND:
			if( wParam == IDCANCEL || wParam == IDOK )
			{
				EndDialog( hDlg, TRUE );
				return( TRUE );
			}
			break;
	}
	return( FALSE );
}

// ============================================================================












