#include "windows.h"
#include "commctrl.h"
#include "commdlg.h"
#include "stdlib.h"
#include "string.h"
#include "resource.h"

// ============================================================================
//  Comment out next two lines to remove expiration code
//#define DO_EXPIRE
//#define EXPIRE_MONTH  4

//  Comment out next line to remove splash screen code
#define SPLASH


typedef struct {
	HMENU hMenu;
	HWND hTarget;
	HFONT hNewFont;
	int iCurrentID;
	BOOL bMenu;
	BOOL bListbox;
} ENUMSTRUCT, *PENUMSTRUCT;

typedef struct {
	TCHAR *pszFind;
	BOOL bUseCase;
	BOOL bHide;
} FINDSTRUCT, *PFINDSTRUCT;

// ============================================================================

LRESULT WINAPI CtrlWndProc( HWND, UINT, WPARAM, LPARAM );
LRESULT WINAPI MainWndProc( HWND, UINT, WPARAM, LPARAM );
LRESULT WINAPI EditSubProc( HWND, UINT, WPARAM, LPARAM );
BOOL WINAPI GetNameDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL WINAPI CloseDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL WINAPI AboutDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL WINAPI SelectDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL WINAPI FontDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL WINAPI FindTextDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL WINAPI ColorDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL CALLBACK FindNoteProc( HWND, LPARAM );
BOOL CALLBACK FindTextProc( HWND, LPARAM );
BOOL CALLBACK CloseNoteProc( HWND, LPARAM );
BOOL CALLBACK UpdateFontProc( HWND, LPARAM );
BOOL CALLBACK UpdateSizeProc( HWND, LPARAM );
BOOL CALLBACK SaveNotesProc( HWND, LPARAM );
int CALLBACK FindFontProc( ENUMLOGFONT *, TEXTMETRIC *, int, LPARAM );
int CALLBACK FindSizeProc( ENUMLOGFONT *, TEXTMETRIC *, int, LPARAM );
HFONT CreateSelectedFont( TCHAR *, int, BOOL );
BOOL SetFontSettings( TCHAR *, int, BOOL );
int GetFontSettings( TCHAR *, BOOL * );
BOOL CenterWindow( HWND );
BOOL SaveSingleNote( HWND );
BOOL LoadAllNotes( void );
BOOL DeleteNote( HWND );
BOOL SaveAllNotes( HWND );
BOOL CreateAndOpenDatabase( HWND );
BOOL FindTextInNotes( HWND, TCHAR *, BOOL, BOOL );
BOOL SetColorSettings( void );
BOOL GetColorSettings( void );
BOOL UnicodeToChar( TCHAR *, char * );
BOOL CharToUnicode( char *, TCHAR * );
BOOL SyncNotes( HWND );
BOOL DoWinHelp( TCHAR * );

// ============================================================================

#ifdef SPLASH
HWND hSplash;
#endif
HINSTANCE hInst;
HWND hMainWnd, hCtrlWnd;
TCHAR *szAppName = L"MGNoteC";
TCHAR *szWinName = L"MGNotes";
TCHAR *szFONTNAME = L"FontName";
TCHAR *szFONTSIZE = L"FontSize";
TCHAR *szFONTBOLD = L"FontBold";
TCHAR *szROOTKEY = L"\\Software\\MarkG\\MGNotes";
TCHAR *szDEFXSIZE = L"XSize";
TCHAR *szDEFYSIZE = L"YSize";
TCHAR *szNOTELIST = L"--- &Note List ---";
TCHAR *szSELECTALL = L"Select &All";
TCHAR *szUNSELECTALL = L"Unselect &All";
TCHAR szLastFind[ 64 ];
TCHAR szOutputFilename[ 256 ];
HFONT hCurrentFont;
int iDefXSize, iDefYSize;
WNDPROC lpfnOldEditProc;
DWORD dwTextColor;
DWORD dwBkColor;
HANDLE hDatabase;
DWORD dwColorTable[ 16 ] = { RGB( 0, 0, 0 ), RGB( 255, 255, 255 ),
							 RGB( 255, 0, 0 ), RGB( 0, 255, 0 ),
							 RGB( 0, 0, 255 ), RGB( 255, 255, 0 ),
							 RGB( 0, 255, 255 ), RGB( 255, 0, 255 ),
							 RGB( 128, 128, 128 ), RGB( 192, 192, 192 ),
							 RGB( 128, 0, 0 ), RGB( 0, 128, 0 ),
							 RGB( 0, 0, 128 ), RGB( 128, 128, 0 ),
							 RGB( 0, 128, 128 ), RGB( 128, 0, 128 ) };
HANDLE hYellowBrush;
HMENU hMenu, hSubMenu, hDelMenu;
BOOL bDelConfirm;

// ============================================================================

int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrev, LPWSTR lpCmd,
					  int nShow )
{
	WNDCLASS wc;
	MSG msg;


	hMainWnd = FindWindow( szAppName, NULL );
	if( hMainWnd )
	{
		SendMessage( hMainWnd, WM_COMMAND, 1000, WM_LBUTTONDOWN );
		return( FALSE );
	}

	GetClassInfo( NULL, L"edit", &wc );
	lpfnOldEditProc = wc.lpfnWndProc;

	memset( &wc, 0, sizeof(WNDCLASS) );
	wc.hInstance = hInstance;
	wc.lpfnWndProc = MainWndProc;
	wc.lpszClassName = szWinName;
	wc.hIcon = LoadIcon( hInstance, MAKEINTRESOURCE( IDI_TRAYICON ) );
	wc.hbrBackground = (HBRUSH)( COLOR_WINDOW );
	wc.cbWndExtra = 4;                    //  Used to track the database PEGOID
	if( ! RegisterClass( &wc ) )
		return( FALSE );

	wc.lpfnWndProc = CtrlWndProc;
	wc.lpszClassName = szAppName;
	wc.hIcon = NULL;
	if( ! RegisterClass( &wc ) )
		return( FALSE );

	hInst = hInstance;
	hCurrentFont = NULL;
	hMenu = hSubMenu = hDelMenu = NULL;
	bDelConfirm = TRUE;

	GetColorSettings();
	hYellowBrush = CreateSolidBrush( dwBkColor );

	hMainWnd = CreateWindow( szAppName, NULL, WS_POPUP, 0, 0, 1, 1,
							 NULL, NULL, hInst, NULL );
	if( ! hMainWnd )
		return( FALSE );

	ShowWindow( hMainWnd, nShow );
	UpdateWindow( hMainWnd );

	while( GetMessage( &msg, NULL, 0, 0 ) )
	{
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}

	DeleteObject( hYellowBrush );
	return( FALSE );
}

// ============================================================================

LRESULT WINAPI CtrlWndProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_CREATE:
		{
			NOTIFYICONDATA nid;
			TCHAR szFont[ 40 ];
			int iSize;
			BOOL bBold;
			HKEY hKey;
			LONG lResult;
			DWORD dwSize;

			#ifdef DO_EXPIRE
			SYSTEMTIME st;
			GetLocalTime( &st );
			if( st.wMonth >= EXPIRE_MONTH )
			{
				PostQuitMessage( 0 );
				return( -1 );
			}
			#endif
			#ifdef SPLASH
			hSplash = CreateDialog( hInst, MAKEINTRESOURCE( IDD_SPLASH ),
									NULL, NULL );
			CenterWindow( hSplash );
			ShowWindow( hSplash, SW_SHOW );
			UpdateWindow( hSplash );
			#endif
			hCtrlWnd = hWnd;
			memset( &nid, 0, sizeof(NOTIFYICONDATA) );
			nid.cbSize = sizeof(NOTIFYICONDATA);
			nid.hWnd = hWnd;
			nid.uID = 1000;
			nid.uFlags = NIF_ICON | NIF_MESSAGE;
			nid.uCallbackMessage = WM_COMMAND;
			nid.hIcon = LoadImage( hInst, MAKEINTRESOURCE( IDI_TRAYICON ),
								   IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR );
			Shell_NotifyIcon( NIM_ADD, &nid );
			iSize = GetFontSettings( szFont, &bBold );
			hCurrentFont = CreateSelectedFont( szFont, iSize, bBold );
			SetForegroundWindow( hWnd );
			CreateAndOpenDatabase( hWnd );
			lResult = RegCreateKeyEx( HKEY_CURRENT_USER, szROOTKEY, 0,
									  NULL, 0, 0, NULL, &hKey, &dwSize );
			if( lResult == ERROR_SUCCESS )
				RegCloseKey( hKey );
			LoadAllNotes();
			szLastFind[ 0 ] = '\0';
			#ifdef SPLASH
			SetTimer( hWnd, 2, 1000, NULL );
			#endif
			SetTimer( hWnd, 1, 15000, NULL );
			break;
		}


		case WM_COMMAND:
		{
			if( wParam == 1000 && lParam == WM_LBUTTONDOWN )
			{
				int x, y;
				ENUMSTRUCT es;


				x = GetSystemMetrics( SM_CXSCREEN ) - 2;
				y = GetSystemMetrics( SM_CYSCREEN ) - 28;

				if( hMenu )
					DestroyMenu( hMenu );
				if( hSubMenu )
					DestroyMenu( hSubMenu );
				if( hDelMenu )
					DestroyMenu( hDelMenu );

				hMenu = CreatePopupMenu();
				if( ! hMenu )
					break;

				hSubMenu = CreatePopupMenu();
				if( ! hSubMenu )
					break;
				AppendMenu( hSubMenu, MF_STRING, 104, szNOTELIST );
				es.iCurrentID = 500;
				es.hTarget = (HWND)hSubMenu;
				es.bMenu = TRUE;
				EnumWindows( FindNoteProc, (LPARAM)&es );

				hDelMenu = CreatePopupMenu();
				if( ! hDelMenu )
					break;
				AppendMenu( hDelMenu, MF_STRING, 101, szNOTELIST );
				es.iCurrentID = 600;
				es.hTarget = (HWND)hDelMenu;
				es.bMenu = TRUE;
				EnumWindows( FindNoteProc, (LPARAM)&es );

				SetForegroundWindow( hWnd );
				AppendMenu( hMenu, MF_STRING, 100, L"&New Note..." );
				AppendMenu( hMenu, MF_POPUP, (UINT)hSubMenu, L"&Display Note" );
				AppendMenu( hMenu, MF_POPUP, (UINT)hDelMenu, L"&Remove Note" );
				AppendMenu( hMenu, MF_STRING, 106, L"&Save All Notes" );
				AppendMenu( hMenu, MF_STRING, 107, L"&Find..." );
				AppendMenu( hMenu, MF_STRING, 105, L"S&ettings..." );
				AppendMenu( hMenu, MF_STRING, 108, L"&Help" );
				AppendMenu( hMenu, MF_STRING, 103, L"&About MGNotes" );
				AppendMenu( hMenu, MF_SEPARATOR, 0, NULL );
				AppendMenu( hMenu, MF_STRING, 102, L"E&xit" );

				TrackPopupMenu( hMenu, TPM_RIGHTALIGN | TPM_BOTTOMALIGN,
							    x, y, 0, hWnd, NULL );
				break;
			}

			if( wParam == 101 )
			{
				DialogBox( hInst, MAKEINTRESOURCE( IDD_CLOSEDLG ), hWnd,
						   CloseDlgProc );
				break;
			}
			if( wParam == 104 )
			{
				DialogBox( hInst, MAKEINTRESOURCE( IDD_SELECTNOTE ), hWnd,
						   SelectDlgProc );
				break;
			}
			if( wParam == 105 )
			{
				DialogBox( hInst, MAKEINTRESOURCE( IDD_FONTS ), hWnd,
						   FontDlgProc );
				break;
			}
			if( wParam == 100 )
			{
				TCHAR szName[ 128 ];
				HWND hNew;

				if( DialogBoxParam( hInst, MAKEINTRESOURCE( IDD_NOTENAME ),
									  NULL, GetNameDlgProc, (LPARAM)szName ) )
					hNew = CreateWindow( szWinName, szName, WS_BORDER | WS_POPUP |
										 WS_CAPTION | WS_SYSMENU | WS_VISIBLE,
 										 CW_USEDEFAULT, CW_USEDEFAULT,
										 iDefXSize, iDefYSize,
										 NULL, NULL, hInst, NULL );
				break;
			}
			if( wParam == 102 || wParam == 106 )
			{
				SaveAllNotes( hWnd );
				if( wParam == 102 )
				{
					KillTimer( hWnd, 1 );
					DestroyWindow( hWnd );
				}
				break;
			}
			if( wParam == 103 )
			{
				DialogBox( hInst, MAKEINTRESOURCE( IDD_ABOUT ), NULL,
						   AboutDlgProc );
				break;
			}
			if( wParam == 107 )
			{
				DialogBox( hInst, MAKEINTRESOURCE( IDD_FINDTEXT ), NULL,
						   FindTextDlgProc );
				break;
			}
			if( wParam == 108 )
			{
				DoWinHelp( L"MGNotes.htc" );
				break;
			}
			if( wParam > 499 && wParam < 600 )
			{
				MENUITEMINFO mmi;

				mmi.cbSize = sizeof(MENUITEMINFO);
				mmi.fMask = MIIM_DATA;
				GetMenuItemInfo( hSubMenu, wParam, FALSE, &mmi );
				ShowWindow( (HWND)mmi.dwItemData, SW_SHOW );
				SetForegroundWindow( (HWND)mmi.dwItemData );
				break;
			}
			if( wParam > 599 && wParam < 700 )
			{
				MENUITEMINFO mmi;
				TCHAR szStr[ 192 ];

				mmi.cbSize = sizeof(MENUITEMINFO);
				mmi.fMask = MIIM_DATA;
				GetMenuItemInfo( hDelMenu, wParam, FALSE, &mmi );
				if( bDelConfirm )
				{
					wcscpy( szStr, L"Are you sure you want to remove:\n" );
					GetWindowText( (HWND)mmi.dwItemData, szStr + wcslen( szStr ),
								   192 - wcslen( szStr ) );
					if( MessageBox( hWnd, szStr, szWinName,
						            MB_YESNO | MB_ICONQUESTION ) == IDNO )
						break;
				}

				if( DeleteNote( (HWND)mmi.dwItemData ) )
					DestroyWindow( (HWND)mmi.dwItemData );
				break;
			}
			break;
		}

		case WM_DESTROY:
		{
			NOTIFYICONDATA nid;

			memset( &nid, 0, sizeof(NOTIFYICONDATA) );
			nid.cbSize = sizeof(NOTIFYICONDATA);
			nid.hWnd = hWnd;
			nid.uID = 1000;
			nid.uFlags = NIF_MESSAGE;
			nid.uCallbackMessage = WM_COMMAND;
			Shell_NotifyIcon( NIM_DELETE, &nid );
			if( hCurrentFont )
				DeleteObject( hCurrentFont );
			if( hMenu )
				DestroyMenu( hMenu );
			if( hSubMenu )
				DestroyMenu( hSubMenu );
			if( hDelMenu )
				DestroyMenu( hDelMenu );
			PostQuitMessage( 0 );
			break;
		}


		case WM_TIMER:
			#ifdef SPLASH
			if( wParam == 2 )
			{
				KillTimer( hWnd, 2 );
				DestroyWindow( hSplash );
				hSplash = NULL;
				break;
			}
			#endif
			SyncNotes( hWnd );
			break;

		default:
			return( DefWindowProc( hWnd, msg, wParam, lParam ) );
	}
	return( FALSE );
}

// ============================================================================

LRESULT WINAPI MainWndProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_CREATE:
		{
			RECT Rect;
			HWND hNew;


			CenterWindow( hWnd );
			GetClientRect( hWnd, &Rect );
			hNew = CreateWindow( L"edit", NULL, WS_CHILD | WS_VISIBLE |
								 ES_MULTILINE | ES_WANTRETURN | WS_VSCROLL,
								 0, 0, Rect.right, Rect.bottom,
								 hWnd, (HMENU)100, hInst, NULL );
			if( ! hNew )
				return( -1 );

			SendDlgItemMessage( hWnd, 100, EM_SETMODIFY, 1, 0 );
			SetWindowLong( hNew, GWL_WNDPROC, (DWORD)EditSubProc );
			SendMessage( hNew, WM_SETFONT, (WPARAM)hCurrentFont, TRUE );
			SetFocus( hNew );
			SetForegroundWindow( hWnd );
			break;
		}


		case WM_CTLCOLOREDIT:
			SetBkColor( (HDC)wParam, dwBkColor );
			SetTextColor( (HDC)wParam, dwTextColor );
			return( (LRESULT)hYellowBrush );

		
		case WM_SETFOCUS:
			SetFocus( GetDlgItem( hWnd, 100 ) );
			SetForegroundWindow( hWnd );
			break;

		case WM_CLOSE:
		{
			SaveSingleNote( hWnd );
			ShowWindow( hWnd, SW_HIDE );
			break;
		}

		default:
			return( DefWindowProc( hWnd, msg, wParam, lParam ) );
	}
	return( FALSE );
}

// ============================================================================

BOOL CALLBACK FindNoteProc( HWND hWnd, LPARAM lParam )
{
	PENUMSTRUCT pInfo = (PENUMSTRUCT)lParam;
	TCHAR szName[ 128 ];
	MENUITEMINFO mmi;


	if( ! hWnd )
		return( FALSE );
	if( ! GetClassName( hWnd, szName, 128 ) )
		return( FALSE );
	if( ! wcscmp( szName, szWinName ) )
	{
		int iItem;

		if( ! pInfo->bMenu )
		{
			GetWindowText( hWnd, szName, 128 );
			if( pInfo->bListbox )
				iItem = SendMessage( pInfo->hTarget, LB_ADDSTRING, 0,
									(LPARAM)szName );
			else
				iItem = SendMessage( pInfo->hTarget, CB_ADDSTRING, 0,
									 (LPARAM)szName );
			SendMessage( pInfo->hTarget, LB_SETITEMDATA, iItem, (LPARAM)hWnd );
			++pInfo->iCurrentID;
		}
		else
		{
			GetWindowText( hWnd, szName, 128 );
			AppendMenu( (HMENU)pInfo->hTarget, MF_STRING, pInfo->iCurrentID,
						szName );
			mmi.cbSize = sizeof(MENUITEMINFO);
			mmi.fMask = MIIM_DATA;
			GetMenuItemInfo( (HMENU)pInfo->hTarget, pInfo->iCurrentID, FALSE,
							 &mmi );
			mmi.dwItemData = (DWORD)hWnd;
			SetMenuItemInfo( (HMENU)pInfo->hTarget, pInfo->iCurrentID, FALSE,
							 &mmi );
			++pInfo->iCurrentID;
		}
	}
	return( TRUE );
}

// ============================================================================

BOOL WINAPI GetNameDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
			CenterWindow( hDlg );
			SetWindowLong( hDlg, DWL_USER, (LONG)lParam );
			SendDlgItemMessage( hDlg, IDC_NAMEEDIT, EM_LIMITTEXT, 128, 0 );
			SetForegroundWindow( hDlg );
			return( TRUE );


		case WM_COMMAND:
			if( wParam == IDCANCEL )
			{
				EndDialog( hDlg, FALSE );
				return( TRUE );
			}
			if( wParam == IDOK )
			{
				TCHAR szText[ 128 ];

				if( ! GetDlgItemText( hDlg, IDC_NAMEEDIT, szText, 128 ) )
					break;
				if( FindWindow( szWinName, szText ) )
				{
					MessageBox( hDlg, L"This name is already in use!",
								szWinName, MB_OK | MB_ICONEXCLAMATION );
					break;
				}
				wcscpy( (LPWSTR)GetWindowLong( hDlg, DWL_USER ), szText );
				EndDialog( hDlg, TRUE );
				return( TRUE );
			}
			if( wParam == IDC_HELP )
			{
				DoWinHelp( L"MGNotes_NewNote.htp" );
				break;
			}
			break;
	}
	return( FALSE );
}

// ============================================================================

BOOL CALLBACK CloseNoteProc( HWND hWnd, LPARAM lParam )
{
	TCHAR szName[ 128 ];
	int iItem;


	if( ! hWnd )
		return( FALSE );

	if( ! GetClassName( hWnd, szName, 128 ) )
		return( FALSE );
	if( ! wcscmp( szName, szWinName ) )
	{
		GetWindowText( hWnd, szName, 128 );
		iItem = SendMessage( (HWND)lParam, LB_ADDSTRING, 0, (LPARAM)szName );
		SendMessage( (HWND)lParam, LB_SETITEMDATA, iItem, (LPARAM)hWnd );
	}
	return( TRUE );
}

// ============================================================================

BOOL WINAPI CloseDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
			CenterWindow( hDlg );
			EnumWindows( CloseNoteProc,
						 (LPARAM)GetDlgItem( hDlg, IDC_NOTELIST ) );
			SetForegroundWindow( hDlg );
			return( TRUE );


		case WM_COMMAND:
			if( wParam == IDCANCEL )
			{
				EndDialog( hDlg, FALSE );
				return( TRUE );
			}
			if( wParam == IDOK ||
				( HIWORD( wParam ) == LBN_DBLCLK && 
				  LOWORD( wParam ) == IDC_NOTELIST ) )
			{
				int iItem, iCount;
				HWND hWnd;


				if( ! SendDlgItemMessage( hDlg, IDC_NOTELIST,
										  LB_GETSELCOUNT, 0, 0 ) )
					break;

				if( bDelConfirm )
					if( MessageBox( hDlg, L"Remove selected notes?",
									L"MGNotes", MB_YESNO | MB_ICONQUESTION ) == IDNO )
						break;

				iCount = SendDlgItemMessage( hDlg, IDC_NOTELIST, LB_GETCOUNT,
											 0, 0 );
				iItem = SendDlgItemMessage( hDlg, IDC_NOTELIST, LB_GETCURSEL,
											0, 0 );
				for( iItem = iCount - 1; iItem != -1; iItem-- )
				{
					if( SendDlgItemMessage( hDlg, IDC_NOTELIST, LB_GETSEL,
											iItem, 0 ) )
					{
						hWnd = (HWND)SendDlgItemMessage( hDlg, IDC_NOTELIST,
												   LB_GETITEMDATA, iItem, 0 );
						if( DeleteNote( hWnd ) )
						{
							DestroyWindow( hWnd );
							SendDlgItemMessage( hDlg, IDC_NOTELIST,
												LB_DELETESTRING, iItem, 0 );
						}
					}
				}
				EndDialog( hDlg, TRUE );
				return( TRUE );
			}
			if( wParam == IDC_ALL )
			{
				int iEnd;
				TCHAR szText[ 16 ];

				GetDlgItemText( hDlg, IDC_ALL, szText, 16 );
				iEnd = SendDlgItemMessage( hDlg, IDC_NOTELIST, LB_GETCOUNT,
										   0, 0 );
				if( iEnd > 0 )
				{
					if( ! wcscmp( szText, szSELECTALL ) )
					{
						SendDlgItemMessage( hDlg, IDC_NOTELIST,
											LB_SELITEMRANGE, 1,
											MAKELONG( 0, iEnd - 1 ) );
						SetDlgItemText( hDlg, IDC_ALL, szUNSELECTALL );
					}
					else
					{
						SendDlgItemMessage( hDlg, IDC_NOTELIST,
											LB_SELITEMRANGE, 0,
											MAKELONG( 0, iEnd - 1 ) );
						SetDlgItemText( hDlg, IDC_ALL, szSELECTALL );
					}
				}
				break;
			}
			break;
	}
	return( FALSE );
}

// ============================================================================

BOOL WINAPI AboutDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
			CenterWindow( hDlg );
			SetForegroundWindow( hDlg );
			return( TRUE );

		case WM_COMMAND:
			if( wParam == IDCANCEL )
			{
				EndDialog( hDlg, TRUE );
				return( TRUE );
			}
	}
	return( FALSE );
}

// ============================================================================

BOOL WINAPI SelectDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
		{
			ENUMSTRUCT es;

			CenterWindow( hDlg );
			es.iCurrentID = 500;
			es.bMenu = FALSE;
			es.bListbox = TRUE;
			es.hTarget = GetDlgItem( hDlg, IDC_SELECTLIST );
			EnumWindows( FindNoteProc, (LPARAM)&es );
			SetForegroundWindow( hDlg );
			return( TRUE );
		}

		case WM_COMMAND:
			if( wParam == IDCANCEL )
			{
				EndDialog( hDlg, TRUE );
				return( TRUE );
			}
			if( wParam == IDOK || ( HIWORD( wParam ) == LBN_DBLCLK &&
				                    LOWORD( wParam ) == IDC_SELECTLIST ) )
			{
				int iCount, iItem;

				if( ! SendDlgItemMessage( hDlg, IDC_SELECTLIST, LB_GETSELCOUNT,
										  0, 0 ) )
					break;
				iCount = SendDlgItemMessage( hDlg, IDC_SELECTLIST, LB_GETCOUNT,
											 0, 0 );
				for( iItem = iCount - 1; iItem != -1; iItem-- )
				{
					if( SendDlgItemMessage( hDlg, IDC_SELECTLIST,
											LB_GETSEL, iItem, 0 ) )
						ShowWindow( (HWND)SendDlgItemMessage( hDlg,
									IDC_SELECTLIST, LB_GETITEMDATA, 
									iItem, 0 ), SW_SHOW );
				}
				EndDialog( hDlg, TRUE );
				return( TRUE );
			}
			if( wParam == IDC_ALL )
			{
				int iEnd;
				TCHAR szText[ 16 ];

				GetDlgItemText( hDlg, IDC_ALL, szText, 16 );
				iEnd = SendDlgItemMessage( hDlg, IDC_SELECTLIST, LB_GETCOUNT,
										   0, 0 );
				if( iEnd > 0 )
				{
					if( ! wcscmp( szText, szSELECTALL ) )
					{
						SendDlgItemMessage( hDlg, IDC_SELECTLIST,
											LB_SELITEMRANGE, 1,
											MAKELONG( 0, iEnd - 1 ) );
						SetDlgItemText( hDlg, IDC_ALL, szUNSELECTALL );
					}
					else
					{
						SendDlgItemMessage( hDlg, IDC_SELECTLIST,
											LB_SELITEMRANGE, 0,
											MAKELONG( 0, iEnd - 1 ) );
						SetDlgItemText( hDlg, IDC_ALL, szSELECTALL );
					}
				}
				break;
			}
	}
	return( FALSE );
}

// ============================================================================

HFONT CreateSelectedFont( TCHAR *pszFont, int iSize, BOOL bBold )
{
	LOGFONT lf;

	memset( &lf, 0, sizeof(LOGFONT) );
	lf.lfHeight = iSize;
	if( ! bBold )
		lf.lfWeight = FW_NORMAL;
	else
		lf.lfWeight = FW_BOLD;

	wcscpy( lf.lfFaceName, pszFont );
	return( CreateFontIndirect( &lf ) );
}

// ============================================================================

BOOL WINAPI FontDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
		{
			HDC hDC;
			TCHAR szName[ 33 ];
			int iSize, iItem;
			BOOL bBold;


			CenterWindow( hDlg );
			hDC = GetDC( hDlg );
			EnumFontFamilies( hDC, NULL, (FONTENUMPROC)FindFontProc,
							  (LPARAM)GetDlgItem( hDlg, IDC_FONTLIST ) );
			ReleaseDC( hDlg, hDC );
			SendDlgItemMessage( hDlg, IDC_FONTLIST, CB_SETCURSEL, 0, 0 );
			SetDlgItemInt( hDlg, IDC_XSIZE, iDefXSize, TRUE );
			SetDlgItemInt( hDlg, IDC_YSIZE, iDefYSize, TRUE );
			
			iSize = GetFontSettings( szName, &bBold );
			if( bBold )
				SendDlgItemMessage( hDlg, IDC_BOLDFONT, BM_SETCHECK, 1, 0 );

			if( bDelConfirm )
				SendDlgItemMessage( hDlg, IDC_CONFIRM, BM_SETCHECK, 1, 0 );

			iItem = SendDlgItemMessage( hDlg, IDC_FONTLIST, CB_FINDSTRINGEXACT,
										-1, (LPARAM)szName );
			if( iItem != CB_ERR )
				SendDlgItemMessage( hDlg, IDC_FONTLIST, CB_SETCURSEL,
									iItem, 0 );
			SendMessage( hDlg, WM_COMMAND, 
						 MAKELONG( IDC_FONTLIST, CBN_SELCHANGE ),
						 (LPARAM)GetDlgItem( hDlg, IDC_FONTLIST ) );
			wsprintf( szName, L"%d", iSize );
			iItem = SendDlgItemMessage( hDlg, IDC_FONTSIZE, CB_FINDSTRINGEXACT,
										-1, (LPARAM)szName );
			if( iItem != CB_ERR )
				SendDlgItemMessage( hDlg, IDC_FONTSIZE, CB_SETCURSEL,
									iItem, 0 );

			for( iSize = 0; iSize < 16; iSize++ )
			{
				wsprintf( szName, L"%d", iSize );
				SendDlgItemMessage( hDlg, IDC_TEXTCOLOR, CB_ADDSTRING, 0,
									(LPARAM)szName );
				SendDlgItemMessage( hDlg, IDC_BKCOLOR, CB_ADDSTRING, 0,
									(LPARAM)szName );
			}
			SetDlgItemText( hDlg, IDC_FILEDIR, szOutputFilename );
			return( TRUE );
		}


		case WM_DRAWITEM:
		{
			LPDRAWITEMSTRUCT lpDs = (LPDRAWITEMSTRUCT)lParam;
			HBRUSH hBrush;
			HPEN hPen;
			RECT Rect;


			if( lpDs->CtlID == IDC_TEXTCOLOR )
				hBrush = CreateSolidBrush( dwTextColor );
			else
				hBrush = CreateSolidBrush( dwBkColor );

			GetClientRect( lpDs->hwndItem, &Rect );
			hPen = CreatePen( PS_SOLID, 1, RGB( 0, 0, 0 ) );
			hPen = SelectObject( lpDs->hDC, hPen );
			hBrush = SelectObject( lpDs->hDC, hBrush );
			Rectangle( lpDs->hDC, 0, 0, Rect.right, Rect.bottom );
			DeleteObject( SelectObject( lpDs->hDC, hBrush ) );
			DeleteObject( SelectObject( lpDs->hDC, hPen ) );
			return( TRUE );
		}


		case WM_COMMAND:
			if( wParam == IDCANCEL )
			{
				EndDialog( hDlg, FALSE );
				return( TRUE );
			}
			if( HIWORD( wParam ) == CBN_SELCHANGE && 
				LOWORD( wParam ) == IDC_FONTLIST )
			{
				TCHAR szName[ 32 ];
				int iItem, i;
				
				SendDlgItemMessage( hDlg, IDC_FONTSIZE, CB_RESETCONTENT,
									0, 0 );
				iItem = SendDlgItemMessage( hDlg, IDC_FONTLIST, CB_GETCURSEL,
											0, 0 );
				if( iItem == CB_ERR )
					break;
				SendDlgItemMessage( hDlg, IDC_FONTLIST, CB_GETLBTEXT, iItem,
									(LPARAM)szName );
				for( iItem = 8; iItem < 22; iItem += 2 )
				{
					wsprintf( szName, L"%d", iItem );
					i = SendDlgItemMessage( hDlg, IDC_FONTSIZE, CB_ADDSTRING,
											0, (LPARAM)szName );
					SendDlgItemMessage( hDlg, IDC_FONTSIZE, CB_SETITEMDATA,
										i, iItem );
				}
				SendDlgItemMessage( hDlg, IDC_FONTSIZE, CB_SETCURSEL, 0, 0 );
				break;
			}
			if( wParam == IDOK )
			{
				TCHAR szName[ 32 ];
				int iSize, iItem, iXSize, iYSize;
				BOOL bBold;


				iXSize = GetDlgItemInt( hDlg, IDC_XSIZE, &bBold, TRUE );
				iYSize = GetDlgItemInt( hDlg, IDC_YSIZE, &bBold, TRUE );
				if( iXSize < 10 || iXSize > GetSystemMetrics( SM_CXSCREEN ) ||
					iYSize < 10 || iYSize > GetSystemMetrics( SM_CYSCREEN ) )
					break;

				iItem = SendDlgItemMessage( hDlg, IDC_FONTLIST, CB_GETCURSEL,
											0, 0 );
				if( iItem == CB_ERR )
					break;
				SendDlgItemMessage( hDlg, IDC_FONTLIST, CB_GETLBTEXT, iItem,
									(LPARAM)szName );
				iItem = SendDlgItemMessage( hDlg, IDC_FONTSIZE, CB_GETCURSEL,
											0, 0 );
				if( iItem == CB_ERR )
					break;
				iSize = SendDlgItemMessage( hDlg, IDC_FONTSIZE, CB_GETITEMDATA,
											iItem, 0 );

				bBold = SendDlgItemMessage( hDlg, IDC_BOLDFONT, BM_GETCHECK,
											0, 0 );
				bDelConfirm = SendDlgItemMessage( hDlg, IDC_CONFIRM,
												  BM_GETCHECK, 0, 0 );

				if( hCurrentFont )
					DeleteObject( hCurrentFont );
				hCurrentFont = CreateSelectedFont( szName, iSize, bBold );
				EnumWindows( UpdateFontProc, (LPARAM)hCurrentFont );
				iDefXSize = iXSize;
				iDefYSize = iYSize;
				EnumWindows( UpdateSizeProc, MAKELONG( iXSize, iYSize ) );
				GetDlgItemText( hDlg, IDC_FILEDIR, szOutputFilename, 256 );
				SetFontSettings( szName, iSize, bBold );
				EndDialog( hDlg, TRUE );
				return( TRUE );
			}
			if( wParam == IDC_BROWSE )
			{
				OPENFILENAME ofn;
				TCHAR szFile[ 300 ];
				int iOffset;

				wcscpy( szFile, szOutputFilename );
				wcscat( szFile, L"\\output.txt" );
				memset( &ofn, 0, sizeof(OPENFILENAME) );
				ofn.lStructSize = sizeof(OPENFILENAME);
				ofn.hwndOwner = hDlg;
				ofn.lpstrFile = szFile;
				ofn.nMaxFile = 256;
				ofn.Flags = OFN_HIDEREADONLY;
				ofn.lpstrTitle = L"Select Note Folder";
				if( ! GetSaveFileName( &ofn ) )
					break;

				iOffset = wcslen( szFile );
				while( szFile[ iOffset ] != L'\\' && iOffset )
					--iOffset;

				szFile[ iOffset ] = L'\0';
				SetDlgItemText( hDlg, IDC_FILEDIR, szFile );
				break;
			}
			if( wParam == IDC_TEXTCOLOR || wParam == IDC_BKCOLOR )
			{
				POINT pt;
				RECT Rect;
				DWORD dwColor;


				if( wParam == IDC_TEXTCOLOR )
					GetWindowRect( GetDlgItem( hDlg, IDC_TEXTCOLOR ), &Rect );
				else
					GetWindowRect( GetDlgItem( hDlg, IDC_BKCOLOR ), &Rect );
				pt.x = Rect.right;
				pt.y = Rect.top;
				dwColor = DialogBoxParam( hInst,
										  MAKEINTRESOURCE( IDD_COLORDLG ),
										  hDlg, ColorDlgProc, (LPARAM)&pt );
				if( dwColor == 0xFFFFFFFF )
					break;

				if( wParam == IDC_TEXTCOLOR )
					dwTextColor = dwColor;
				else
				{
					dwBkColor = dwColor;
					DeleteObject( hYellowBrush );
					hYellowBrush = CreateSolidBrush( dwColor );
				}
				InvalidateRect( GetDlgItem( hDlg, IDC_TEXTCOLOR ), NULL,
								FALSE );
				InvalidateRect( GetDlgItem( hDlg, IDC_BKCOLOR ), NULL, FALSE );
				SetColorSettings();
				break;
			}
			if( wParam == IDC_HELP )
			{
				DoWinHelp( L"MGNotes_Settings.htp" );
				break;
			}
			break;
	}
	return( FALSE );
}

// ============================================================================

int CALLBACK FindFontProc( ENUMLOGFONT *lpElf, TEXTMETRIC *pTm, int iType,
						   LPARAM lParam )
{
	SendMessage( (HWND)lParam, CB_ADDSTRING, 0,
				 (LPARAM)lpElf->elfLogFont.lfFaceName );
	return( TRUE );
}

// ============================================================================

BOOL CALLBACK UpdateFontProc( HWND hWnd, LPARAM lParam )
{
	TCHAR szName[ 128 ];

	if( ! hWnd )
		return( FALSE );
	if( ! GetClassName( hWnd, szName, 128 ) )
		return( FALSE );
	if( ! wcscmp( szName, szWinName ) )
		SendDlgItemMessage( hWnd, 100, WM_SETFONT, lParam, TRUE );
	return( TRUE );
}

// ============================================================================

BOOL CALLBACK UpdateSizeProc( HWND hWnd, LPARAM lParam )
{
	TCHAR szName[ 128 ];

	if( ! hWnd )
		return( FALSE );
	if( ! GetClassName( hWnd, szName, 128 ) )
		return( FALSE );
	if( ! wcscmp( szName, szWinName ) )
	{
		SetWindowPos( hWnd, NULL, 0, 0, LOWORD( lParam ), HIWORD( lParam ),
					  SWP_NOMOVE | SWP_NOZORDER );
		SetWindowPos( GetDlgItem( hWnd, 100 ), NULL, 0, 0,
					  LOWORD( lParam ) - 2,
					  HIWORD( lParam ) - GetSystemMetrics( SM_CYCAPTION ) - 2,
					  SWP_NOMOVE | SWP_NOZORDER );
	}
	return( TRUE );
}

// ============================================================================

int CALLBACK FindSizeProc( ENUMLOGFONT *lpElf, TEXTMETRIC *pTm, int iType,
						   LPARAM lParam )
{
	TCHAR szStr[ 8 ];
	int iItem;

	wsprintf( szStr, L"%d", lpElf->elfLogFont.lfHeight );
	iItem = SendMessage( (HWND)lParam, CB_ADDSTRING, 0, (LPARAM)szStr );
	SendMessage( (HWND)lParam, CB_SETITEMDATA, iItem,
				 lpElf->elfLogFont.lfHeight );
	return( TRUE );
}

// ============================================================================

BOOL SetFontSettings( TCHAR *pszName, int iSize, BOOL bBold )
{
	LONG lResult;
	HKEY hKey;
	DWORD dwSize;

	lResult = RegCreateKeyEx( HKEY_CURRENT_USER, szROOTKEY, 0, NULL,
							  0, 0, NULL, &hKey, &dwSize );
	if( lResult != ERROR_SUCCESS )
		return( FALSE );

	RegSetValueEx( hKey, szFONTNAME, 0, REG_SZ, (LPBYTE)pszName,
				   ( wcslen( pszName ) * sizeof(TCHAR) ) + sizeof(TCHAR) );
	RegSetValueEx( hKey, szFONTSIZE, 0, REG_DWORD, (LPBYTE)&iSize,
				   sizeof(DWORD) );
	RegSetValueEx( hKey, szFONTBOLD, 0, REG_DWORD, (LPBYTE)&bBold,
				   sizeof(DWORD) );
	RegSetValueEx( hKey, szDEFXSIZE, 0, REG_DWORD, (LPBYTE)&iDefXSize,
				   sizeof(DWORD) );
	RegSetValueEx( hKey, szDEFYSIZE, 0, REG_DWORD, (LPBYTE)&iDefYSize,
				   sizeof(DWORD) );
	RegSetValueEx( hKey, L"DelConfirm", 0, REG_DWORD, (LPBYTE)&bDelConfirm,
				   sizeof(DWORD) );
	RegSetValueEx( hKey, L"OutDir", 0, REG_SZ, (LPBYTE)szOutputFilename,
				   ( wcslen( szOutputFilename ) * sizeof(TCHAR) ) + sizeof(TCHAR) );
	RegCloseKey( hKey );
	return( TRUE );
}

// ============================================================================

BOOL SetColorSettings( void )
{
	LONG lResult;
	HKEY hKey;
	DWORD dwSize;

	lResult = RegCreateKeyEx( HKEY_CURRENT_USER, szROOTKEY, 0, NULL,
							  0, 0, NULL, &hKey, &dwSize );
	if( lResult != ERROR_SUCCESS )
		return( FALSE );

	RegSetValueEx( hKey, L"BkColor", 0, REG_DWORD, (LPBYTE)&dwBkColor,
				   sizeof(DWORD) );
	RegSetValueEx( hKey, L"TextColor", 0, REG_DWORD, (LPBYTE)&dwTextColor,
				   sizeof(DWORD) );
	RegCloseKey( hKey );
	return( TRUE );
}

// ============================================================================

int GetFontSettings( TCHAR *pszName, BOOL *bBold )
{
	LONG lResult;
	HKEY hKey;
	DWORD dwSize, dwType;
	int iSize;


	lResult = RegCreateKeyEx( HKEY_CURRENT_USER, szROOTKEY, 0, NULL,
							  0, 0, NULL, &hKey, &dwSize );
	if( lResult != ERROR_SUCCESS )
		return( FALSE );

	dwSize = sizeof(TCHAR) * 33;
	lResult = RegQueryValueEx( hKey, szFONTNAME, NULL, &dwType,
							   (LPBYTE)pszName, &dwSize );
	if( lResult != ERROR_SUCCESS )
		wcscpy( pszName, L"Courier New" );

	dwSize = sizeof(int);
	lResult = RegQueryValueEx( hKey, szFONTSIZE, NULL, &dwType,
							   (LPBYTE)&iSize, &dwSize );
	if( lResult != ERROR_SUCCESS )
		iSize = 14;

	dwSize = sizeof(BOOL);
	lResult = RegQueryValueEx( hKey, szFONTBOLD, NULL, &dwType,
							   (LPBYTE)bBold, &dwSize );
	if( lResult != ERROR_SUCCESS )
		*bBold = FALSE;

	dwSize = sizeof(int);
	lResult = RegQueryValueEx( hKey, szDEFXSIZE, NULL, &dwType,
							   (LPBYTE)&iDefXSize, &dwSize );
	if( lResult != ERROR_SUCCESS )
		iDefXSize = 200;

	dwSize = sizeof(int);
	lResult = RegQueryValueEx( hKey, szDEFYSIZE, NULL, &dwType,
							   (LPBYTE)&iDefYSize, &dwSize );
	if( lResult != ERROR_SUCCESS )
		iDefYSize = 120;

	dwSize = sizeof(BOOL);
	lResult = RegQueryValueEx( hKey, L"DelConfirm", NULL, &dwType,
							   (LPBYTE)&bDelConfirm, &dwSize );
	if( lResult != ERROR_SUCCESS )
		bDelConfirm = TRUE;

	dwSize = 256 * sizeof(TCHAR);
	lResult = RegQueryValueEx( hKey, L"OutDir", NULL, &dwType,
							   (LPBYTE)szOutputFilename, &dwSize );
	if( lResult != ERROR_SUCCESS )
		wcscpy( szOutputFilename, L"\\" );

	RegCloseKey( hKey );
	return( iSize );
}

// ============================================================================

int GetColorSettings( void )
{
	LONG lResult;
	HKEY hKey;
	DWORD dwSize, dwType;


	lResult = RegCreateKeyEx( HKEY_CURRENT_USER, szROOTKEY, 0, NULL,
							  0, 0, NULL, &hKey, &dwSize );
	if( lResult != ERROR_SUCCESS )
	{
		dwTextColor = RGB( 0, 0, 0 );
		dwBkColor = RGB( 255, 255, 0 );
		return( FALSE );
	}

	dwSize = sizeof(int);
	lResult = RegQueryValueEx( hKey, L"TextColor", NULL, &dwType,
							   (LPBYTE)&dwTextColor, &dwSize );
	if( lResult != ERROR_SUCCESS )
		dwTextColor = RGB( 0, 0, 0 );

	dwSize = sizeof(int);
	lResult = RegQueryValueEx( hKey, L"BkColor", NULL, &dwType,
							   (LPBYTE)&dwBkColor, &dwSize );
	if( lResult != ERROR_SUCCESS )
		dwBkColor = RGB( 255, 255, 0 );

	RegCloseKey( hKey );
	return( 1 );
}

// ============================================================================

BOOL CenterWindow( HWND hWnd )
{
	int iXsize, iYsize;
	RECT Rect;

	iXsize = GetSystemMetrics( SM_CXSCREEN );
	iYsize = GetSystemMetrics( SM_CYSCREEN );
	GetWindowRect( hWnd, &Rect );
	Rect.right = Rect.right - Rect.left;
	Rect.bottom = Rect.bottom - Rect.top;
	Rect.left = ( iXsize - Rect.right ) / 2;
	Rect.top = ( iYsize - Rect.bottom ) / 2;
	SetWindowPos( hWnd, NULL, Rect.left, Rect.top, 0, 0,
				  SWP_NOSIZE | SWP_NOZORDER );
	return( TRUE );
}

// ============================================================================

BOOL CALLBACK SaveNotesProc( HWND hWnd, LPARAM lParam )
{
	TCHAR szName[ 130 ];


	if( ! hWnd )
		return( FALSE );

	if( ! GetClassName( hWnd, szName, 128 ) )
		return( FALSE );

	if( ! wcscmp( szName, szWinName ) )
		SaveSingleNote( hWnd );

	return( TRUE );
}


// ============================================================================
//	SaveSingleNote(): Saves the contents of a note window using it's caption
//				text as the registry key and it's edit contents as data. The
//				note window handle is passed as it's parameter.
// ============================================================================

BOOL SaveSingleNote( HWND hWnd )
{
	TCHAR szName[ 130 ], szFile[ 512 ], *pszText;
	char *pszStr;
	int iLen;
	HANDLE hNew;
	DWORD dwSize;
	FILETIME ft;


	if( ! GetWindowText( hWnd, szName, 128 ) )
		return( FALSE );

	if( ! SendDlgItemMessage( hWnd, 100, EM_GETMODIFY, 0, 0 ) )
		return( TRUE );

	iLen = SendDlgItemMessage( hWnd, 100, WM_GETTEXTLENGTH, 0, 0 );
	if( iLen )
	{
		pszText = malloc( ( iLen * sizeof(TCHAR) ) + 8 + ( iLen + 8 ) );
		if( ! pszText )
			return( FALSE );
		pszStr = (char *)pszText + ( iLen * sizeof(TCHAR) ) + 8;
		GetDlgItemText( hWnd, 100, pszText, iLen + 8 );
		UnicodeToChar( pszText, pszStr );
	}

retry_save:
	wcscpy( szFile, szOutputFilename );
	wcscat( szFile, L"\\" );
	wcscat( szFile, szName );
	wcscat( szFile, L".txt" );
	hNew = CreateFile( szFile, GENERIC_READ | GENERIC_WRITE, 0, NULL,
					   CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL );
	if( hNew == INVALID_HANDLE_VALUE )
	{
		if( MessageBox( hWnd, L"There was an error saving the note. Perhaps it was the name assigned to the note. Would you like to change the name now?",
						szWinName, MB_YESNO | MB_ICONQUESTION ) == IDNO )
			return( FALSE );

		if( ! DialogBoxParam( hInst, MAKEINTRESOURCE( IDD_NOTENAME ),
							  NULL, GetNameDlgProc, (LPARAM)szName ) )
			return( FALSE );
		
		SetWindowText( hWnd, szName );
		goto retry_save;
	}

	if( iLen )
		WriteFile( hNew, pszStr, strlen( pszStr ), &dwSize, NULL );

	GetFileTime( hNew, NULL, NULL, &ft );
	CloseHandle( hNew );

	SendDlgItemMessage( hWnd, 100, EM_SETMODIFY, 0, 0 );
	SetWindowLong( hWnd, 0, ft.dwLowDateTime );
	free( pszText );
	return( TRUE );
}

// ============================================================================
//   LoadAllNotes(): Retrieves all records from the MGQNotes database and
//		creates a window for each note.
// ============================================================================

BOOL LoadAllNotes( void )
{
	TCHAR *pszData, szFile[ 512 ];
	char *pszOut;
	DWORD dwSize, dwRead;
	HWND hWnd;
	HANDLE hFile, hOpen;
	WIN32_FIND_DATA wfd;
	int i;
	FILETIME ft;


	wcscpy( szFile, szOutputFilename );
	wcscat( szFile, L"\\*.txt" );
	hFile = FindFirstFile( szFile, &wfd );
	while( hFile != INVALID_HANDLE_VALUE )
	{
		wcscpy( szFile, szOutputFilename );
		wcscat( szFile, L"\\" );
		wcscat( szFile, wfd.cFileName );
		hOpen = CreateFile( szFile, GENERIC_READ, FILE_SHARE_READ,
							NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL,
							NULL );
		if( hOpen != INVALID_HANDLE_VALUE )
		{
			dwSize = GetFileSize( hOpen, NULL ) + 8;
			if( dwSize )
			{
				pszOut = malloc( dwSize );
				pszData = malloc( dwSize * sizeof(TCHAR) );
				if( pszOut && pszData )
				{
					memset( pszOut, 0, dwSize );
					memset( pszData, 0, dwSize * sizeof(TCHAR) );
					ReadFile( hOpen, pszOut, dwSize - 8, &dwRead, NULL );
					CharToUnicode( pszOut, pszData );

					wcscpy( szFile, wfd.cFileName );
					i = wcslen( szFile );
					while( szFile[ i ] != L'.' && i )
						--i;
					szFile[ i ] = L'\0';
					hWnd = CreateWindow( szWinName, szFile,
										 WS_BORDER | WS_POPUP |
										 WS_CAPTION | WS_SYSMENU,
										 CW_USEDEFAULT, CW_USEDEFAULT,
										 iDefXSize, iDefYSize,
										 NULL, NULL, hInst, NULL );
					if( hWnd )	
					{
						SendDlgItemMessage( hWnd, 100, WM_SETTEXT, 0,
											(LPARAM)pszData );
						SendDlgItemMessage( hWnd, 100, EM_SETMODIFY, 0, 0 );
						GetFileTime( hOpen, NULL, NULL, &ft );
						SetWindowLong( hWnd, 0, ft.dwLowDateTime );
					}
				}
				else
				{
					SendDlgItemMessage( hWnd, 100, EM_SETMODIFY, 0, 0 );
					GetFileTime( hOpen, NULL, NULL, &ft );
					SetWindowLong( hWnd, 0, ft.dwLowDateTime );
				}
				if( pszOut )
					free( pszOut );
				if( pszData )
					free( pszData );
			}
			CloseHandle( hOpen );
		}
		if( ! FindNextFile( hFile, &wfd ) )
			break;
	}

	FindClose( hFile );
	return( TRUE );
}



// ============================================================================
//	DeleteNote(): Deletes a note registry entry based on the handle of a note
//				  window, from which the title (and value key) is obtained.
// ============================================================================

BOOL DeleteNote( HWND hWnd )
{
	TCHAR szTitle[ 128 ], szFile[ 512 ];


	if( ! GetWindowText( hWnd, szTitle, 128 ) )
		return( FALSE );

	wcscpy( szFile, szOutputFilename );
	wcscat( szFile, L"\\" );
	wcscat( szFile, szTitle );
	wcscat( szFile, L".txt" );
	DeleteFile( szFile );
	return( TRUE );
}


// ============================================================================
//	EditSubProc(): Subclass proc for the note edit control.
// ============================================================================

LRESULT WINAPI EditSubProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	if( msg == WM_CHAR && wParam == 0x1B )
	{
		PostMessage( GetParent( hWnd ), WM_CLOSE, 0, 0 );
		return( FALSE );
	}

	if( ( msg == WM_KEYDOWN || msg == WM_KEYUP ) &&
		  ( wParam == 'D' || wParam == 'A' || wParam == 'S' || 
		    wParam == 'K' || wParam == 'X' || wParam == 'Q' ) )
	{
		if( ( GetKeyState( VK_LCONTROL ) || GetKeyState( VK_RCONTROL ) ) &&
			msg == WM_KEYDOWN )
		{
			if( wParam == 'D' )
			{
				SYSTEMTIME st;
				TCHAR szStr[ 32 ];
				int i;

				GetLocalTime( &st );
				wsprintf( szStr, L"%d-%d-%.4d %d:%.2d\n", st.wMonth, st.wDay,
						  st.wYear, st.wHour, st.wMinute );
				for( i = 0; i < (int)wcslen( szStr ); i++ )
					SendMessage( hWnd, WM_CHAR, (WPARAM)szStr[ i ], 0 );
			}
			if( wParam == 'A' )
				SendMessage( hWnd, EM_SETSEL, 0, -1 );
			if( wParam == 'S' )
				DialogBox( hInst, MAKEINTRESOURCE( IDD_SELECTNOTE ),
						   GetParent( hWnd ), SelectDlgProc );
			if( wParam == 'K' )
				DialogBox( hInst, MAKEINTRESOURCE( IDD_CLOSEDLG ),
						   GetParent( hWnd ), CloseDlgProc );
			if( wParam == 'X' )
				PostMessage( hCtrlWnd, WM_COMMAND, 1000, WM_LBUTTONDOWN );
			if( wParam == 'Q' )
				DoWinHelp( L"MGNotes_Note.htp" );
			return( FALSE );
		}
	}

	if( msg == WM_ERASEBKGND )
	{
		RECT Rect;

		GetClientRect( hWnd, &Rect );
		FillRect( (HDC)wParam, &Rect, hYellowBrush );
		return( TRUE );
	}

	return( CallWindowProc( lpfnOldEditProc, hWnd, msg, wParam, lParam ) );
}

// ============================================================================
//	SaveAllNotes(): Saves all notes by enumerating all note windows, each note
//					window saving it's own contents.
// ============================================================================

BOOL SaveAllNotes( HWND hWnd )
{
	EnumWindows( SaveNotesProc, 0 );
	return( TRUE );
}


// ============================================================================
//	CreateAndOpenDatabase(): Makes sure the registry entries are there.
// ============================================================================

BOOL CreateAndOpenDatabase( HWND hWnd )
{
	HKEY hKey;
	LONG lResult;
	DWORD dwSize;


	lResult = RegCreateKeyEx( HKEY_CURRENT_USER, szROOTKEY, 0,
							  NULL, 0, 0, NULL, &hKey, &dwSize );
	if( lResult != ERROR_SUCCESS )
		return( FALSE );
	RegCloseKey( hKey );
	return( FALSE );
}



// ============================================================================

BOOL WINAPI FindTextDlgProc( HWND hDlg, UINT msg, WPARAM wParam,
							 LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
			CenterWindow( hDlg );
			SendDlgItemMessage( hDlg, IDC_FIND, EM_LIMITTEXT, 64, 0 );
			SetDlgItemText( hDlg, IDC_FIND, szLastFind );
			SendDlgItemMessage( hDlg, IDC_HIDE, BM_SETCHECK, 1, 1 );
			return( TRUE );


		case WM_COMMAND:
			if( wParam == IDCANCEL )
			{
				EndDialog( hDlg, TRUE );
				return( TRUE );
			}
			if( wParam == IDOK )
			{
				if( SendDlgItemMessage( hDlg, IDC_FIND, WM_GETTEXTLENGTH,
										0, 0 ) )
				{
					GetDlgItemText( hDlg, IDC_FIND, szLastFind, 64 );
					FindTextInNotes( hDlg, szLastFind,
					 SendDlgItemMessage( hDlg, IDC_CASE, BM_GETCHECK, 0, 0 ),
					 SendDlgItemMessage( hDlg, IDC_HIDE, BM_GETCHECK, 0, 0 ) );


					EndDialog( hDlg, TRUE );
					return( TRUE );
				}
				break;
			}
			if( wParam == IDC_HELP )
			{
				DoWinHelp( L"MGNotes_Find.htp" );
				break;
			}
			break;
	}
	return( FALSE );
}

// ============================================================================

BOOL FindTextInNotes( HWND hDlg, TCHAR *pszFind, BOOL bCase, BOOL bHide )
{
	TCHAR *pszCaseFind;
	int iLen;
	FINDSTRUCT fs;


	iLen = wcslen( pszFind );
	pszCaseFind = (TCHAR *)malloc( iLen * sizeof(TCHAR) );
	if( ! pszCaseFind )
		return( FALSE );
	wcscpy( pszCaseFind, pszFind );

	if( ! bCase )
		_wcsupr( pszCaseFind );

	fs.pszFind = pszCaseFind;
	fs.bUseCase = bCase;
	fs.bHide = bHide;
	EnumWindows( FindTextProc, (LPARAM)&fs );

	free( pszCaseFind );
	return( TRUE );
}

// ============================================================================

BOOL CALLBACK FindTextProc( HWND hWnd, LPARAM lParam )
{
	PFINDSTRUCT pFs = (PFINDSTRUCT)lParam;
	TCHAR szName[ 128 ], *pszBuffer, *pszPtr;
	int iLen;


	if( ! hWnd )
		return( FALSE );
	if( ! GetClassName( hWnd, szName, 128 ) )
		return( FALSE );
	if( ! wcscmp( szName, szWinName ) )
	{
		iLen = SendDlgItemMessage( hWnd, 100, WM_GETTEXTLENGTH, 0, 0 );
		if( iLen )
		{
			pszBuffer = (TCHAR *)malloc( iLen * sizeof(TCHAR) );
			if( pszBuffer )
			{
				GetDlgItemText( hWnd, 100, pszBuffer, iLen );
				if( ! pFs->bUseCase )
					_wcsupr( pszBuffer );

				pszPtr = wcsstr( pszBuffer, pFs->pszFind );
				if( ! pszPtr && pFs->bHide )
					ShowWindow( hWnd, SW_HIDE );
				if( pszPtr )
				{
					ShowWindow( hWnd, SW_SHOW );
					SetForegroundWindow( hWnd );
				}
				free( pszBuffer );
			}
		}
		else
			ShowWindow( hWnd, SW_HIDE );
	}
	return( TRUE );
}

// ============================================================================

BOOL WINAPI ColorDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
		{
			POINT *ppt = (POINT *)lParam;
			RECT Rect;
			int iYMax;


			GetClientRect( hDlg, &Rect );
			iYMax = GetSystemMetrics( SM_CYSCREEN ) -
					GetSystemMetrics( SM_CYCAPTION ) - 8;
			if( ppt->y + Rect.bottom > iYMax )
				ppt->y = iYMax - Rect.bottom;
			SetWindowPos( hDlg, NULL, ppt->x, ppt->y, 0, 0,
						  SWP_NOSIZE | SWP_NOZORDER );
			return( TRUE );
		}


		case WM_DRAWITEM:
		{
			LPDRAWITEMSTRUCT lpDs = (LPDRAWITEMSTRUCT)lParam;
			HBRUSH hBrush;
			HPEN hPen;
			RECT Rect;
			POINT pt[ 2 ];

			GetClientRect( lpDs->hwndItem, &Rect );
			hPen = CreatePen( PS_SOLID, 1, RGB( 0, 0, 0 ) );
			hPen = SelectObject( lpDs->hDC, hPen );
			if( lpDs->CtlID == 2 )
			{
				hBrush = CreateSolidBrush( RGB( 255, 255, 255 ) );
				hBrush = SelectObject( lpDs->hDC, hBrush );
				Rectangle( lpDs->hDC, 0, 0, Rect.right, Rect.bottom );

				pt[ 0 ].x = 2;   pt[ 0 ].y = 2;
				pt[ 1 ].x = Rect.right - 2;  pt[ 1 ].y = Rect.bottom - 2;
				Polyline( lpDs->hDC, &pt[ 0 ], 2 );

				pt[ 0 ].x = Rect.right - 3;   pt[ 0 ].y = 2;
				pt[ 1 ].x = 1;  pt[ 1 ].y = Rect.bottom - 2;
				Polyline( lpDs->hDC, &pt[ 0 ], 2 );
			}
			else
			{
				hBrush = CreateSolidBrush( dwColorTable[ lpDs->CtlID - 100 ] );
				hBrush = SelectObject( lpDs->hDC, hBrush );
				Rectangle( lpDs->hDC, 0, 0, Rect.right, Rect.bottom );
			}
			DeleteObject( SelectObject( lpDs->hDC, hBrush ) );
			DeleteObject( SelectObject( lpDs->hDC, hPen ) );
			return( TRUE );
		}


		case WM_COMMAND:
			if( wParam == IDCANCEL )
			{
				EndDialog( hDlg, 0xFFFFFFFF );
				return( FALSE );
			}
			if( wParam > 99 && wParam < 116 )
			{
				EndDialog( hDlg, dwColorTable[ wParam - 100 ] );
				return( TRUE );
			}
			break;
	}
	return( FALSE );
}

// ============================================================================

BOOL UnicodeToChar( TCHAR *tcIn, char *pszOut )
{
	while( *tcIn )
		*pszOut++ = (char)*tcIn++;
	*pszOut = '\0';
	return( TRUE );
}

// ============================================================================

BOOL CharToUnicode( char *pszIn, TCHAR *tcOut )
{
	while( *pszIn )
		*tcOut++ = (TCHAR)*pszIn++;
	*tcOut = L'\0';
	return( TRUE );
}

// ============================================================================

BOOL SyncNotes( HWND hWnd )
{
	TCHAR *pszData, szFile[ 512 ], szNoteName[ 128 ];
	char *pszOut;
	DWORD dwSize, dwRead;
	HWND hNote;
	HANDLE hFile, hOpen;
	WIN32_FIND_DATA wfd;
	int i;
	FILETIME ft;


	#ifdef DO_EXPIRE
	SYSTEMTIME st;
	GetLocalTime( &st );
	if( st.wMonth >= EXPIRE_MONTH )
	{
		PostQuitMessage( 0 );
		return( FALSE );
	}
	#endif

	wcscpy( szFile, szOutputFilename );
	wcscat( szFile, L"\\*.txt" );
	hFile = FindFirstFile( szFile, &wfd );
	if( hFile != INVALID_HANDLE_VALUE )
	{
		do {
			wcscpy( szFile, szOutputFilename );
			wcscat( szFile, L"\\" );
			wcscat( szFile, wfd.cFileName );

			hOpen = CreateFile( szFile, GENERIC_READ, FILE_SHARE_READ,
								NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL,
								NULL );
			if( hOpen != INVALID_HANDLE_VALUE )
			{
				GetFileTime( hOpen, NULL, NULL, &ft );
				wcscpy( szNoteName, wfd.cFileName );
				i = wcslen( szNoteName );
				while( szNoteName[ i ] != L'.' && i )
					--i;
				szNoteName[ i ] = L'\0';
				hNote = FindWindow( NULL, szNoteName );
				if( ! hNote )
					hNote = CreateWindow( szWinName, szNoteName, WS_BORDER | WS_POPUP |
										  WS_CAPTION | WS_SYSMENU | WS_VISIBLE,
 										  CW_USEDEFAULT, CW_USEDEFAULT,
										  iDefXSize, iDefYSize,
										  NULL, NULL, hInst, NULL );
				if( hNote )
				{
					if( (DWORD)GetWindowLong( hNote, 0 ) != ft.dwLowDateTime )
					{
						dwSize = GetFileSize( hOpen, NULL );
						if( dwSize )
						{
							pszOut = malloc( ( dwSize * sizeof(TCHAR) ) + 8 + dwSize + 8 );
							if( pszOut )
							{
								memset( pszOut, 0, ( dwSize * sizeof(TCHAR) ) + dwSize + 16 );
								pszData = (TCHAR *)pszOut + dwSize + 8;
								ReadFile( hOpen, pszOut, dwSize, &dwRead, NULL );
								CharToUnicode( pszOut, pszData );
								SendDlgItemMessage( hNote, 100, WM_SETTEXT, 0,
													(LPARAM)pszData );
								free( pszOut );
							}
						}
						SendDlgItemMessage( hNote, 100, EM_SETMODIFY, 0, 0 );
						SetWindowLong( hNote, 0, ft.dwLowDateTime );
					}
				}
				CloseHandle( hOpen );
			}
		} while( FindNextFile( hFile, &wfd ) );
		FindClose( hFile );
	}
	return( TRUE );
}


BOOL DoWinHelp( TCHAR *pszFile )
{
	PROCESS_INFORMATION pi;
	STARTUPINFO si;

	memset( &si, 0, sizeof(STARTUPINFO) );
	si.cb = sizeof(STARTUPINFO);
	if( CreateProcess( L"peghelp.exe", pszFile, NULL, NULL,
					   FALSE, 0, NULL, NULL, &si, &pi ) )
	{
		CloseHandle( pi.hProcess );
		CloseHandle( pi.hThread );
	}
	return( TRUE );
}

