#include "windows.h"
#include "winsock.h"
#include "stdlib.h"
#include "resource.h"

// ============================================================================

BOOL WINAPI MainDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL WINAPI AboutDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL DoLookup( HWND );
BOOL CenterWindow( HWND );

// ============================================================================

HINSTANCE hInst;
HWND hMainWnd;

// ============================================================================

int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrev, LPWSTR lpCmd,
					  int nShow )
{
	MSG msg;


	hInst = hInstance;
	hMainWnd = CreateDialog( hInst, MAKEINTRESOURCE( 10000 ), NULL,
							 MainDlgProc );
	if( ! hMainWnd )
		return( FALSE );

	ShowWindow( hMainWnd, nShow );
	UpdateWindow( hMainWnd );
	while( GetMessage( &msg, NULL, 0, 0 ) )
	{
		if( IsDialogMessage( hMainWnd, &msg ) )
			continue;
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}
	return( FALSE );
}

// ============================================================================

BOOL WINAPI MainDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
		{
			WSADATA wsa;

			WSAStartup( 0x0101, &wsa );
			SendDlgItemMessage( hDlg, IDC_INPUT, EM_LIMITTEXT, 128, 0 );
			CheckRadioButton( hDlg, IDC_NAME, IDC_ADDR, IDC_NAME );
			CenterWindow( hDlg );
			return( TRUE );
		}


		case WM_COMMAND:
			if( wParam == IDCANCEL )
			{
				WSACleanup();
				DestroyWindow( hDlg );
				PostQuitMessage( 0 );
				break;
			}
			if( wParam == IDOK )
			{
				EnableWindow( GetDlgItem( hDlg, IDOK ), FALSE );
				EnableWindow( GetDlgItem( hDlg, IDCANCEL ), FALSE );
				EnableWindow( GetDlgItem( hDlg, IDC_ABOUT ), FALSE );
				EnableWindow( GetDlgItem( hDlg, IDC_INPUT ), FALSE );
				EnableWindow( GetDlgItem( hDlg, IDC_NAME ), FALSE );
				EnableWindow( GetDlgItem( hDlg, IDC_ADDR ), FALSE );
				DoLookup( hDlg );
				EnableWindow( GetDlgItem( hDlg, IDOK ), TRUE );
				EnableWindow( GetDlgItem( hDlg, IDCANCEL ), TRUE );
				EnableWindow( GetDlgItem( hDlg, IDC_ABOUT ), TRUE );
				EnableWindow( GetDlgItem( hDlg, IDC_INPUT ), TRUE );
				EnableWindow( GetDlgItem( hDlg, IDC_NAME ), TRUE );
				EnableWindow( GetDlgItem( hDlg, IDC_ADDR ), TRUE );
				break;
			}
			if( wParam == IDC_ABOUT )
			{
				DialogBox( hInst, MAKEINTRESOURCE( 10001 ), hDlg,
						   AboutDlgProc );
				break;
			}
			break;
	}
	return( FALSE );
}

// ============================================================================

int wctomb( TCHAR *szWide, char *szMByte )
{
	while( *szWide )
		*szMByte++ = (char)*szWide++;
	*szMByte = '\0';
	return( wcslen( szWide ) );
}

// ============================================================================

int mbtowc( char *szMByte, TCHAR *szWide )
{
	while( *szMByte )
		*szWide++ = (USHORT)( (BYTE)*szMByte++ & 0xFF );
	*szWide = L'\0';
	return( wcslen( szWide ) );
}

// ============================================================================

BOOL DoLookup( HWND hDlg )
{
	DWORD dwIP;
	char szAddr[ 256 ], *pszPtr;
	TCHAR tszAddr[ 256 ], *tszOutput;
	struct hostent *phost;
	int i;

	
	SetDlgItemText( hDlg, IDC_OUTPUT, L"\r\n" );

	if( SendDlgItemMessage( hDlg, IDC_ADDR, BM_GETCHECK, 0, 0 ) )
	{
		if( GetDlgItemText( hDlg, IDC_INPUT, tszAddr, 128 ) )
		{
			wctomb( tszAddr, szAddr );
			dwIP = inet_addr( szAddr );
			if( dwIP == INADDR_NONE )
			{
				SetDlgItemText( hDlg, IDC_OUTPUT,
								L"Unable to convert address!" );
				return( FALSE );
			}

			phost = gethostbyaddr( (char *)&dwIP, sizeof(DWORD), PF_INET );
			if( phost == NULL )
			{
				SetDlgItemText( hDlg, IDC_OUTPUT,
							L"Unable to get host info on this address!" );
				return( FALSE );
			}

			tszOutput = (TCHAR *)malloc( sizeof(TCHAR) * 2048 );
			if( tszOutput )
			{
				wcscpy( tszOutput, L"Official Name: " );
				mbtowc( phost->h_name, tszAddr );
				wcscat( tszOutput, tszAddr );
				wcscat( tszOutput, L"\r\n" );
				wcscat( tszOutput, L"Aliases:\r\n" );
				if( phost->h_aliases && *phost->h_aliases )
					for( i = 0; phost->h_aliases[ i ]; i++ )
						wsprintf( tszOutput + wcslen( tszOutput ),
								  L"%s\n", phost->h_aliases[ i ] );


				SetDlgItemText( hDlg, IDC_OUTPUT, tszOutput );
				free( tszOutput );
			}
		}
	}
	else
	{
		if( GetDlgItemText( hDlg, IDC_INPUT, tszAddr, 128 ) )
		{
			wctomb( tszAddr, szAddr );
			phost = gethostbyname( szAddr );
			if( phost == NULL )
				return( FALSE );

			tszOutput = (TCHAR *)malloc( sizeof(TCHAR) * 2048 );
			if( tszOutput )
			{
				*tszOutput = L'\0';
				if( phost->h_name && strcmp( szAddr, phost->h_name ) )
				{
					wcscat( tszOutput, L"Real Name: " );
					mbtowc( phost->h_name, tszAddr );
					wcscat( tszOutput, tszAddr );
					wcscat( tszOutput, L"\r\n" );
				}

				if( phost->h_aliases && 
					*phost->h_aliases &&
				    phost->h_aliases[ 1 ] )
				{
					wcscat( tszOutput, L"Aliases:\r\n" );
					for( i = 0; phost->h_aliases[ i ]; i++ )
					{
						mbtowc( phost->h_aliases[ i ], tszAddr );
						wcscat( tszOutput, tszAddr );
					}
					wcscat( tszOutput, L"\r\n" );
				}

				if( phost->h_addr_list == NULL || *phost->h_addr_list == NULL)
					wcscat( tszOutput, L"No IP address found\r\n" );
				else
				{
					if( phost->h_addr_list[ 1 ] == NULL )
					{
						wcscat( tszOutput, L"IP Address: " );
						pszPtr = inet_ntoa( *(struct in_addr *)phost->h_addr_list[ 0 ] );
						mbtowc( pszPtr, tszAddr );
						wcscat( tszOutput, tszAddr );
					}
					else
					{
						wcscat( tszOutput, L"IP Addresses: \r\n" );
						for( i = 0; phost->h_addr_list[ i ]; i++ )
						{
							pszPtr = inet_ntoa( *(struct in_addr *)phost->h_addr_list[ i ] );
							mbtowc( pszPtr, tszAddr );
							wcscat( tszOutput, tszAddr );
							wcscat( tszOutput, L"\r\n" );
						}
					}
				}

				SetDlgItemText( hDlg, IDC_OUTPUT, tszOutput );
				free( tszOutput );
			}
		}
	}
	return( TRUE );
}

// ============================================================================

BOOL CenterWindow( HWND hWnd )
{
	int iXsize, iYsize;
	RECT Rect;

	iXsize = GetSystemMetrics( SM_CXSCREEN );
	iYsize = GetSystemMetrics( SM_CYSCREEN );
	GetWindowRect( hWnd, &Rect );
	Rect.right = Rect.right - Rect.left;
	Rect.bottom = Rect.bottom - Rect.top;
	Rect.left = ( iXsize - Rect.right ) / 2;
	Rect.top = ( iYsize - Rect.bottom ) / 2;
	SetWindowPos( hWnd, NULL, Rect.left, Rect.top, 0, 0,
				  SWP_NOSIZE | SWP_NOZORDER );
	return( TRUE );
}

// ============================================================================

BOOL WINAPI AboutDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
			CenterWindow( hDlg );
			return( TRUE );


		case WM_COMMAND:
			if( wParam == IDCANCEL )
			{
				EndDialog( hDlg, TRUE );
				return( TRUE );
			}
			break;
	}
	return( FALSE );
}

// ============================================================================

