// Collection.h : Declaration of the CCollection

#ifndef __COLLECTION_H_
#define __COLLECTION_H_

#include "resource.h"       // main symbols

typedef struct _pdatastruct {
	struct _pdatastruct *pPrev;
	struct _pdatastruct *pNext;
	BSTR bName;
	VARIANT *pData;
} DATASTRUCT, *PDATASTRUCT;

/////////////////////////////////////////////////////////////////////////////
// CCollection
class ATL_NO_VTABLE CCollection : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CCollection, &CLSID_Collection>,
	public IDispatchImpl<ICollection, &IID_ICollection, &LIBID_MGCEDATALib>
{
public:
	CCollection()
	{
		memset( &DBase, 0, sizeof(DATASTRUCT) );
	}
	
	~CCollection()
	{
		PDATASTRUCT pds, pdn;

		pds = DBase.pPrev;
		while( pds ) {
			if( pds->bName )  SysFreeString( pds->bName );
			if( pds->pData ) {
				VariantClear( pds->pData );
				LocalFree( pds->pData );
			}
			pdn = pds->pNext;
			LocalFree( pds );
			pds = pdn;
		}
	}

DECLARE_REGISTRY_RESOURCEID(IDR_COLLECTION)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CCollection)
	COM_INTERFACE_ENTRY(ICollection)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()

// ICollection
public:
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(Search)(VARIANT *pvData, long lStart, long lType, long *lPos);
	STDMETHOD(get_TypeLength)(long lType, /*[out, retval]*/ long *pVal);
	STDMETHOD(get_TypeStart)(long lType, /*[out, retval]*/ long *pVal);
	STDMETHOD(Sort)();
	STDMETHOD(get_Name)(long lID, /*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_Name)(long lID, /*[in]*/ VARIANT *newVal);
	STDMETHOD(get_AllKeys)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(get_Count)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Data)(VARIANT *pvName, /*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_Data)(VARIANT *pvName, /*[in]*/ VARIANT *newVal);
private:
	DATASTRUCT DBase;
};

#endif //__COLLECTION_H_
