// Collection.cpp : Implementation of CCollection
#include "stdafx.h"
#include "MGCEData.h"
#include "Collection.h"

/////////////////////////////////////////////////////////////////////////////
// CCollection


STDMETHODIMP CCollection::get_Data(VARIANT *pvName, VARIANT *pVal)
{
	VARIANT v;
	PDATASTRUCT pds;
	UINT i;

	VariantInit( &v );
	VariantInit( pVal );
//	if( VariantChangeType( &v, pvName, 0, VT_BSTR ) != S_OK ) {
//		VariantClear( pvName );
//		VariantClear( pVal );
//		return E_INVALIDARG;
//	}

	if( pvName->vt != VT_BSTR && pvName->vt != VT_I2 ) {
		VariantClear( pvName );
		VariantClear( pVal );
		return E_INVALIDARG;
	}

	pds = DBase.pPrev;
	if( ! pds ) {
		V_VT( pVal ) = VT_EMPTY;
		return S_OK;
	}
	if( pvName->vt == VT_BSTR ) {
		while( pds ) {
			if( ! _wcsicmp( v.bstrVal, pds->bName ) ) {
				VariantCopy( pVal, pds->pData );
				break;
			}
			pds = pds->pNext;
		}
	} else {
		for( i = 1; i < pvName->uiVal; i++ ) {
			pds = pds->pNext;
			if( ! pds ) break;
		}
		if( ! pds ) {
			V_VT( pVal ) = VT_EMPTY;
			return S_OK;
		}
		VariantCopy( pVal, pds->pData );
	}
	return S_OK;
}

STDMETHODIMP CCollection::put_Data(VARIANT *pvName, VARIANT *newVal)
{
	VARIANT v;
	PDATASTRUCT pds;
	HRESULT hr;

	hr = E_FAIL;
	VariantInit( &v );
	if( VariantChangeType( &v, pvName, 0, VT_BSTR ) != S_OK ) {
		VariantClear( pvName );
		VariantClear( newVal );
		return E_INVALIDARG;
	}

	pds = DBase.pPrev;
	while( pds ) {
		if( ! _wcsicmp( v.bstrVal, pds->bName ) ) break;
		pds = pds->pNext;
	}

											    //  if setting value to Nothing
	if( newVal->vt == VT_DISPATCH && newVal->pdispVal == 0 ) {
		if( pds ) {	                            //  If the item actually exists
			if( pds->pPrev )  pds->pPrev->pNext = pds->pNext;
			if( pds->pNext )  pds->pNext->pPrev = pds->pPrev;
			if( DBase.pNext == pds )  DBase.pNext = pds->pPrev;
			if( DBase.pPrev == pds )  DBase.pPrev = pds->pNext;
			VariantClear( pds->pData );         //  Remove everything allocated
			SysFreeString( pds->bName );
			LocalFree( pds->pData );
			LocalFree( pds );
		}
	} else {
		if( pds ) {             //  If name was found, alter the attached value
			VariantClear( pds->pData );
			VariantCopy( pds->pData, newVal );
		} else {                               //  If not found, add a new item
			pds = (PDATASTRUCT)LocalAlloc( LPTR, sizeof(DATASTRUCT) );
			if( ! pds )  hr  = E_OUTOFMEMORY;
			else {
				pds->pData = (VARIANT *)LocalAlloc( LPTR, sizeof(VARIANT) );
				if( ! pds->pData ) {
					LocalFree( pds );
					hr = E_OUTOFMEMORY;
				} else {
					pds->bName = SysAllocString( v.bstrVal );
					VariantCopy( pds->pData, newVal );
					if( ! DBase.pPrev )
						DBase.pPrev = DBase.pNext = pds;
					else {
						pds->pPrev = DBase.pNext;
						pds->pPrev->pNext = pds;
						DBase.pNext = pds;
					}
				}
			}
		}
	}

	VariantClear( &v );
	VariantClear( pvName );
	VariantClear( newVal );
	return S_OK;
}

STDMETHODIMP CCollection::get_Count(long *pVal)
{
	PDATASTRUCT pds;

	*pVal = 0;
	pds = DBase.pPrev;
	while( pds ) {
		++*pVal;
		pds = pds->pNext;
	}
	return S_OK;
}

STDMETHODIMP CCollection::get_AllKeys(VARIANT *pVal)
{
	PDATASTRUCT pds;
	int i;
	SAFEARRAY *psa;
	VARIANT *pV;

	VariantInit( pVal );
	pds = DBase.pPrev;
	if( ! pds ) {
		V_VT( pVal ) = VT_EMPTY;
		return S_OK;
	}
	i = 0;
	while( pds ) {
		pds = pds->pNext;
		++i;
	}
	psa = SafeArrayCreateVector( VT_VARIANT, 1, i );
	if( ! psa )  return E_OUTOFMEMORY;
	pds = DBase.pPrev;
	pV = (VARIANT *)psa->pvData;
	while( pds ) {
		V_VT( pV ) = VT_BSTR;
		V_BSTR( pV ) = SysAllocString( pds->bName );
		++pV;
		pds = pds->pNext;
	}
	V_VT( pVal ) = VT_ARRAY | VT_VARIANT;
	V_ARRAY ( pVal ) = psa;
	return S_OK;
}

STDMETHODIMP CCollection::get_Name(long lID, VARIANT *pVal)
{
	PDATASTRUCT pds;

	pds = DBase.pPrev;
	if( ! pds )  return E_INVALIDARG;
	
	while( --lID && pds ) pds = pds->pNext;
	if( ! pds ) return E_INVALIDARG;
	VariantInit( pVal );
	V_VT( pVal ) = VT_BSTR;
	V_BSTR( pVal ) = SysAllocString( pds->bName );
	return S_OK;
}

STDMETHODIMP CCollection::put_Name(long lID, VARIANT *newVal)
{
	VARIANT v;
	PDATASTRUCT pds;

	pds = DBase.pPrev;
	if( ! pds ) {
		VariantClear( newVal );
		return E_INVALIDARG;
	}
	VariantInit( &v );
	if( VariantChangeType( &v, newVal, 0, VT_BSTR ) != S_OK ) {
		VariantClear( newVal );
		return E_INVALIDARG;
	}
	while( --lID && pds )  pds = pds->pNext;
	if( ! pds ) {
		VariantClear( &v );
		VariantClear( newVal );
		return E_INVALIDARG;
	}
	SysFreeString( pds->bName );
	pds->bName = SysAllocString( v.bstrVal );
	VariantClear( &v );
	VariantClear( newVal );
	return S_OK;
}

STDMETHODIMP CCollection::Sort()
{
	PDATASTRUCT pds;
	void *pTemp;
	VARIANT v1, v2;

	pds = DBase.pPrev;
	if( pds ) {
		while( pds->pNext ) {              //  First, sort according to VT type
			if( pds->pData->vt > pds->pNext->pData->vt ) {
				pTemp = pds->pData;
				pds->pData = pds->pNext->pData;
				pds->pNext->pData = (VARIANT *)pTemp;
				pTemp = pds->bName;
				pds->bName = pds->pNext->bName;
				pds->pNext->bName = (BSTR)pTemp;
				pds = DBase.pPrev;
			} else pds = pds->pNext;
		}
	}

	pds = DBase.pPrev;
	if( pds ) {                //  Now sort according to data within like types
		while( pds->pNext ) {
			if( pds->pData->vt == pds->pNext->pData->vt ) {
				if( pds->pData->vt == VT_BSTR ) {
					if( wcscmp( pds->pData->bstrVal, pds->pNext->pData->bstrVal ) > 0 ) {
						pTemp = pds->pData;
						pds->pData = pds->pNext->pData;
						pds->pNext->pData = (VARIANT *)pTemp;
						pTemp = pds->bName;
						pds->bName = pds->pNext->bName;
						pds->pNext->bName = (BSTR)pTemp;
						if( pds->pPrev )  pds = pds->pPrev;
						else              pds = DBase.pPrev;
						continue;
					}
				} else if( pds->pData->vt == VT_I2 ) {
					if( pds->pData->iVal > pds->pNext->pData->iVal ) {
						pTemp = pds->pData;
						pds->pData = pds->pNext->pData;
						pds->pNext->pData = (VARIANT *)pTemp;
						pTemp = pds->bName;
						pds->bName = pds->pNext->bName;
						pds->pNext->bName = (BSTR)pTemp;
						pds = DBase.pPrev;
						continue;
					}
				} else if( pds->pData->vt == VT_UI2 ) {
					if( pds->pData->uiVal > pds->pNext->pData->uiVal ) {
						pTemp = pds->pData;
						pds->pData = pds->pNext->pData;
						pds->pNext->pData = (VARIANT *)pTemp;
						pTemp = pds->bName;
						pds->bName = pds->pNext->bName;
						pds->pNext->bName = (BSTR)pTemp;
						pds = DBase.pPrev;
						continue;
					}
				} else if( pds->pData->vt == VT_I4 ) {
					if( pds->pData->lVal > pds->pNext->pData->lVal ) {
						pTemp = pds->pData;
						pds->pData = pds->pNext->pData;
						pds->pNext->pData = (VARIANT *)pTemp;
						pTemp = pds->bName;
						pds->bName = pds->pNext->bName;
						pds->pNext->bName = (BSTR)pTemp;
						pds = DBase.pPrev;
						continue;
					}
				} else if( pds->pData->vt == VT_UI4 ) {
					if( pds->pData->ulVal > pds->pNext->pData->ulVal ) {
						pTemp = pds->pData;
						pds->pData = pds->pNext->pData;
						pds->pNext->pData = (VARIANT *)pTemp;
						pTemp = pds->bName;
						pds->bName = pds->pNext->bName;
						pds->pNext->bName = (BSTR)pTemp;
						pds = DBase.pPrev;
						continue;
					}
				} else if( pds->pData->vt == VT_R8 ) {
					if( pds->pData->dblVal > pds->pNext->pData->dblVal ) {
						pTemp = pds->pData;
						pds->pData = pds->pNext->pData;
						pds->pNext->pData = (VARIANT *)pTemp;
						pTemp = pds->bName;
						pds->bName = pds->pNext->bName;
						pds->pNext->bName = (BSTR)pTemp;
						pds = DBase.pPrev;
						continue;
					}
				} else {
					VariantInit( &v1 );
					VariantInit( &v2 );
					if( VariantChangeType( &v1, pds->pData, 0, VT_BSTR ) == S_OK ) {
						if( VariantChangeType( &v2, pds->pNext->pData, 0, VT_BSTR ) == S_OK ) {
							if( wcscmp( v1.bstrVal, v2.bstrVal ) > 0 ) {
								pTemp = pds->pData;
								pds->pData = pds->pNext->pData;
								pds->pNext->pData = (VARIANT *)pTemp;
								pTemp = pds->bName;
								pds->bName = pds->pNext->bName;
								pds->pNext->bName = (BSTR)pTemp;
								pds = DBase.pPrev;
								VariantClear( &v1 );
								VariantClear( &v2 );
								continue;
							}
							VariantClear( &v2 );
						}
						VariantClear( &v1 );
					}
				}
			}
			pds = pds->pNext;
		}
	}
	return S_OK;
}

STDMETHODIMP CCollection::get_TypeStart(long lType, long *pVal)
{
	PDATASTRUCT pds;
	int iCount;

	pds = DBase.pPrev;
	iCount = *pVal = 0;
	while( pds ) {
		++iCount;
		if( pds->pData->vt == lType ) {
			*pVal = iCount;
			break;
		}
		pds = pds->pNext;
	}
	return S_OK;
}

STDMETHODIMP CCollection::get_TypeLength(long lType, long *pVal)
{
	PDATASTRUCT pds;
	int iCount;

	pds = DBase.pPrev;
	iCount = 0;
	while( pds ) {
		if( pds->pData->vt == lType ) break;
		pds = pds->pNext;
	}
	if( pds ) {
		while( pds->pData->vt == lType ) {
			++iCount;
			pds = pds->pNext;
			if( ! pds )  break;
		}
	}
	*pVal = iCount;
	return S_OK;
}

STDMETHODIMP CCollection::Search(VARIANT *pvData, long lStart, long lType, long *lPos)
{
	PDATASTRUCT pds;
	int iCount;
	VARIANT v1, v2;

	if( VariantChangeType( &v2, pvData, 0, VT_BSTR ) != S_OK ) {
		VariantClear( pvData );
		return E_INVALIDARG;
	}

	pds = DBase.pPrev;
	if( ! pds ) {
		VariantClear( pvData );
		VariantClear( &v2 );
		*lPos = 0;
		return S_OK;
	}

	iCount = 1;
	if( lStart ) {
		while( iCount < lStart ) {
			pds = pds->pNext;
			if( ! pds ) {
				VariantClear( pvData );
				VariantClear( &v2 );
				*lPos = 0;
				return S_OK;
			}
		}
	}

	while( pds ) {
		VariantInit( &v1 );
		if( lType == 0 || ( lType && pvData->vt == pds->pData->vt ) ) {
			if( VariantChangeType( &v1, pds->pData, 0, VT_BSTR ) == S_OK ) {
				if( ! wcscmp( v1.bstrVal, v2.bstrVal ) ) {
					VariantClear( &v1 );
					VariantClear( &v2 );
					VariantClear( pvData );
					*lPos = iCount;
					return S_OK;
				}
				VariantClear( &v1 );
			}
		}
		pds = pds->pNext;
		++iCount;
	}
	VariantClear( &v2 );
	VariantClear( pvData );
	*lPos = 0;
	return S_OK;
}

STDMETHODIMP CCollection::get_Version(long *pVal)
{
	*pVal = 100;
	return S_OK;
}
