// Database.h : Declaration of the CDatabase

#ifndef __DATABASE_H_
#define __DATABASE_H_

#include "resource.h"       // main symbols

/////////////////////////////////////////////////////////////////////////////
// CDatabase
class ATL_NO_VTABLE CDatabase : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CDatabase, &CLSID_Database>,
	public IDispatchImpl<IDatabase, &IID_IDatabase, &LIBID_MGCEDBASELib>
{
public:
	CDatabase()
	{
		hDBase = INVALID_HANDLE_VALUE;
		ceLastOID = 0;
	}

DECLARE_REGISTRY_RESOURCEID(IDR_DATABASE)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CDatabase)
	COM_INTERFACE_ENTRY(IDatabase)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()

// IDatabase
public:
	STDMETHOD(SeekRecord)(long lType, VARIANT *pVal, long *lRecID);
	STDMETHOD(get_LastID)(/*[out, retval]*/ long *pVal);
	STDMETHOD(GetDatabaseID)(BSTR bName, long *pVal);
	STDMETHOD(SetRecord)(long lID, VARIANT *pvTypes, VARIANT *pvData, long *pRet);
	STDMETHOD(GetFieldTypes)(VARIANT *pVal);
	STDMETHOD(GetRecord)(VARIANT *pVal);
	STDMETHOD(get_RecordCount)(long lID, /*[out, retval]*/ long *pVal);
	STDMETHOD(GetAllDatabases)(VARIANT *pRet);
	STDMETHOD(CloseDatabase)();
	STDMETHOD(OpenDatabase)(BSTR bName, long lSort, long lFlag, long *pRet);
	STDMETHOD(DeleteDatabase)(long lID);
	STDMETHOD(CreateDatabase)(BSTR bName, VARIANT *pSort, long *pRet);

private:
	CEOID ceLastOID;
	DWORD dwAutoIncrement;
	HANDLE hDBase;
};

#endif //__DATABASE_H_
