// Database.cpp : Implementation of CDatabase
#include "stdafx.h"
#include "MGCEDBase.h"
#include "Database.h"

/////////////////////////////////////////////////////////////////////////////
// CDatabase


STDMETHODIMP CDatabase::CreateDatabase(BSTR bName, VARIANT *pSort, long *pRet)
{
	CEOID ceDB;
	SORTORDERSPEC sos[ 4 ];
	DWORD dwLBound, dwUBound;
	int iElements, i;
	VARIANT *pArray, v1, v2;

	iElements = 0;
	if( pSort->vt != VT_ERROR ) {
		if( ( pSort->vt & VT_ARRAY ) == 0 )  return E_INVALIDARG;
		SafeArrayAccessData( V_ARRAY( pSort ), (void **)&pArray );
		SafeArrayGetLBound( V_ARRAY( pSort ), 1, (long *)&dwLBound );
		SafeArrayGetUBound( V_ARRAY( pSort ), 1, (long *)&dwUBound );
		iElements = (int)dwUBound - (int)dwLBound + 1;
		if( iElements < 2 || iElements > 8 ) {
			SafeArrayUnaccessData( V_ARRAY( pSort ) );
			SafeArrayDestroy( V_ARRAY( pSort ) );
			return E_INVALIDARG;
		}
		for( i = 0; i < iElements / 2; i++ ) {
			VariantInit( &v1 );
			VariantInit( &v2 );
			if( VariantChangeType( &v1, &pArray[ ( i * 2 ) ], 0, VT_I2 ) != S_OK )
				break;
			if( VariantChangeType( &v2, &pArray[ ( i * 2 ) + 1 ], 0, VT_I2 ) != S_OK )
				break;
			sos[ i ].propid = v1.intVal;
			sos[ i ].propid = v2.intVal;
		}
		SafeArrayUnaccessData( V_ARRAY( pSort ) );
		SafeArrayDestroy( V_ARRAY( pSort ) );
		if( i < iElements / 2 ) return E_INVALIDARG;
	}
	if( iElements )	ceDB = CeCreateDatabase( bName, 0, iElements / 2, sos );
	else ceDB = CeCreateDatabase( bName, 0, 0, NULL );
	SysFreeString( bName );
	*pRet = ceDB;
	ceLastOID = ceDB;
	if( ! ceDB )  return E_FAIL;
	return S_OK;
}


STDMETHODIMP CDatabase::DeleteDatabase(long lID)
{
	if( ! lID ) return E_INVALIDARG;
	if( ! CeDeleteDatabase( lID ) )  return E_FAIL;
	return S_OK;
}

STDMETHODIMP CDatabase::OpenDatabase(BSTR bName, long lSort, long lFlag, long *pRet )
{
	DWORD dwFlag;
	CEOID ceOID;

	if( hDBase != INVALID_HANDLE_VALUE )  return E_HANDLE;
	if( lFlag )  dwFlag = CEDB_AUTOINCREMENT;
	else         dwFlag = 0;
	dwAutoIncrement = dwFlag;
	ceOID = 0;
	hDBase = CeOpenDatabase( &ceOID, bName, lSort, dwFlag, NULL );
	SysFreeString( bName );
	if( hDBase == INVALID_HANDLE_VALUE ) return E_FAIL;
	ceLastOID = ceOID;
	*pRet = ceOID;
	return S_OK;
}

STDMETHODIMP CDatabase::CloseDatabase()
{
	if( hDBase != INVALID_HANDLE_VALUE )  CloseHandle( hDBase );
	hDBase = INVALID_HANDLE_VALUE;
	return S_OK;
}

STDMETHODIMP CDatabase::GetAllDatabases(VARIANT *pRet)
{
	HANDLE hFind;
	int iCount;
	CEOID ceID;
	SAFEARRAY *psa;
	CEOIDINFO coi;
	VARIANT *pV;

	hFind = CeFindFirstDatabase( 0 );
	if( hFind == INVALID_HANDLE_VALUE )  return E_HANDLE;
	iCount = 0;
	do {
		ceID = CeFindNextDatabase( hFind );
		if( ceID ) ++iCount;
	} while( ceID );
	CloseHandle( hFind );
	if( ! iCount )  return E_FAIL;

	psa = SafeArrayCreateVector( VT_VARIANT, 1, iCount );
	if( ! psa )  return E_OUTOFMEMORY;

	pV = (VARIANT *)psa->pvData;
	hFind = CeFindFirstDatabase( 0 );
	if( hFind == INVALID_HANDLE_VALUE ) {
		SafeArrayDestroy( psa );
		return E_HANDLE;
	}

	do {
		ceID = CeFindNextDatabase( hFind );
		if( ceID ) {
			if( CeOidGetInfo( ceID, &coi ) ) {			
				
				V_BSTR( pV ) = SysAllocString( coi.infDatabase.szDbaseName );
				V_VT( pV ) = VT_BSTR;
				++pV;
			}
		}
	} while( ceID );
	V_VT( pRet ) = VT_ARRAY | VT_VARIANT;
	V_ARRAY( pRet ) = psa;
	return S_OK;
}

STDMETHODIMP CDatabase::get_RecordCount(long lID, long *pVal)
{
	CEOIDINFO coi;

	if( ! CeOidGetInfo( lID, &coi ) )  return E_FAIL;
	*pVal = coi.infDatabase.wNumRecords;
	return S_OK;
}


STDMETHODIMP CDatabase::GetRecord(VARIANT *pVal)
{
	CEOID id;
	CEPROPVAL *pPropArray;
	USHORT usPropsRead, uCount;
	DWORD dwRead;
	SAFEARRAY *psa;
	VARIANT *pV;
	BOOL bPropOk;


	if( hDBase == INVALID_HANDLE_VALUE )   return E_FAIL;
	pPropArray = NULL;
	usPropsRead = 0;
	id = CeReadRecordProps( hDBase, CEDB_ALLOWREALLOC, &usPropsRead, NULL,
							(LPBYTE *)&pPropArray, &dwRead );
	if( ! id ) {
		if( pPropArray )  LocalFree( pPropArray );
		return E_FAIL;
	}

	if( pPropArray ) {
		psa = SafeArrayCreateVector( VT_VARIANT, 1, usPropsRead );
		if( ! psa ) {
			LocalFree( pPropArray );
			return E_FAIL;
		}
		pV = (VARIANT *)psa->pvData;

		for( uCount = 0; uCount < usPropsRead; uCount++ ) {
			bPropOk = FALSE;
			switch( LOWORD( pPropArray[ uCount ].propid ) ) {
				case CEVT_LPWSTR:
					V_BSTR( pV ) = SysAllocString( pPropArray[ uCount ].val.lpwstr );
					V_VT( pV ) = VT_BSTR;
					bPropOk = TRUE;
					break;

				case CEVT_I2:
				case CEVT_I4:
				case CEVT_UI2:
				case CEVT_UI4:
					V_UI4( pV ) = pPropArray[ uCount ].val.ulVal;
					V_VT( pV ) = VT_UI4;
					bPropOk = TRUE;
					break;

				case CEVT_FILETIME:
				{
					SYSTEMTIME st;
					double dblVal;

					FileTimeToSystemTime( &pPropArray[ uCount ].val.filetime, &st );
					SystemTimeToVariantTime( &st, &dblVal );
					V_DATE( pV ) = dblVal;
					V_VT( pV ) = VT_DATE;
					bPropOk = TRUE;
					break;
				}

				case CEVT_R8:
					V_R8( pV ) = pPropArray[ uCount ].val.dblVal;
					V_VT( pV ) = VT_R8;
					bPropOk = TRUE;

				default:
					V_BSTR( pV ) = SysAllocString( L"\0" );
					V_VT( pV ) = VT_BSTR;
					break;
			}
			++pV;
		}
		LocalFree( pPropArray );
	}
	V_VT( pVal ) = VT_ARRAY | VT_VARIANT;
	V_ARRAY( pVal ) = psa;
	ceLastOID = id;
	return S_OK;
}

STDMETHODIMP CDatabase::GetFieldTypes(VARIANT *pVal)
{
	CEOID id;
	CEPROPVAL *pPropArray;
	USHORT usPropsRead, uCount;
	DWORD dwRead;
	SAFEARRAY *psa;
	VARIANT *pV;

	if( hDBase == INVALID_HANDLE_VALUE )   return E_FAIL;
	pPropArray = NULL;
	usPropsRead = 0;
	id = CeReadRecordProps( hDBase, CEDB_ALLOWREALLOC, &usPropsRead, NULL,
							(LPBYTE *)&pPropArray, &dwRead );
	if( ! id ) {
		if( pPropArray )  LocalFree( pPropArray );
		return E_FAIL;
	}

	if( pPropArray ) {
		psa = SafeArrayCreateVector( VT_VARIANT, 1, usPropsRead );
		if( ! psa ) {
			LocalFree( pPropArray );
			return E_FAIL;
		}
		pV = (VARIANT *)psa->pvData;

		for( uCount = 0; uCount < usPropsRead; uCount++ ) {
			switch( LOWORD( pPropArray[ uCount ].propid ) ) {
				case CEVT_I2:
					V_I2( pV ) = 0;
					break;
				case CEVT_I4:
					V_I2( pV ) = 1;
					break;
				case CEVT_UI2:
					V_I2( pV ) = 2;
					break;
				case CEVT_UI4:
					V_I2( pV ) = 3;
					break;
				case CEVT_R8:
					V_I2( pV ) = 4;
					break;
				case CEVT_LPWSTR:
					V_I2( pV ) = 5;
					break;
				case CEVT_BOOL:
					V_I2( pV ) = 6;
					break;
				case CEVT_FILETIME:
					V_I2( pV ) = 7;
					break;
				case CEVT_BLOB:
					V_I2( pV ) = 8;
					break;
				default:
					V_I2( pV ) = -1;
					break;
			}
			V_VT( pV ) = VT_I2;
			++pV;
		}
		LocalFree( pPropArray );
	}
	if( dwAutoIncrement == CEDB_AUTOINCREMENT )
		CeSeekDatabase( hDBase, CEDB_SEEK_CEOID, id, &dwRead );

	V_VT( pVal ) = VT_ARRAY | VT_VARIANT;
	V_ARRAY( pVal ) = psa;
	return S_OK;
}


STDMETHODIMP CDatabase::SetRecord(long lID, VARIANT *pvTypes, VARIANT *pvData, long *pRet)
{
	VARIANT *pTypeArray, newVar, *pDataArray;
	DWORD dwLBound, dwUBound;
	int iTypes, *piTypeArray, i, iFields;
	CEPROPVAL *pProps;
	HRESULT hr;
	CEOID ceID;


	if( ( pvTypes->vt & VT_ARRAY ) == 0 || ( pvData->vt & VT_ARRAY ) == 0 ) return E_FAIL;

	SafeArrayAccessData( V_ARRAY( pvTypes ), (void **)&pTypeArray );
	SafeArrayGetLBound( V_ARRAY( pvTypes ), 1, (long *)&dwLBound );
	SafeArrayGetUBound( V_ARRAY( pvTypes ), 1, (long *)&dwUBound );
	iTypes = (int)dwUBound - (int)dwLBound + 1;

	SafeArrayAccessData( V_ARRAY( pvData ), (void **)&pDataArray );
	SafeArrayGetLBound( V_ARRAY( pvData ), 1, (long *)&dwLBound );
	SafeArrayGetUBound( V_ARRAY( pvData ), 1, (long *)&dwUBound );
	iFields = (int)dwUBound - (int)dwLBound + 1;

	if( ! iTypes || ! iFields || iFields != iTypes ) {
		SafeArrayUnaccessData( V_ARRAY( pvTypes ) );
		SafeArrayDestroy( V_ARRAY( pvTypes ) );
		SafeArrayUnaccessData( V_ARRAY( pvData ) );
		SafeArrayDestroy( V_ARRAY( pvData ) );
		return E_FAIL;
	}

	piTypeArray = (int *)LocalAlloc( LPTR, sizeof(int) * iTypes );
	pProps = (CEPROPVAL *)LocalAlloc( LPTR, sizeof(CEPROPVAL) * iTypes );

	if( ! piTypeArray || ! pProps ) {
		if( piTypeArray ) LocalFree( piTypeArray );
		if( pProps )      LocalFree( pProps );
		SafeArrayUnaccessData( V_ARRAY( pvTypes ) );
		SafeArrayDestroy( V_ARRAY( pvTypes ) );
		SafeArrayUnaccessData( V_ARRAY( pvData ) );
		SafeArrayDestroy( V_ARRAY( pvData ) );
		return E_FAIL;
	}

	for( i = 0; i < iTypes; i++ ) {
		VariantInit( &newVar );
		hr = VariantChangeType( &newVar, &pTypeArray[ i ], 0, VT_I4 );
		if( hr != S_OK ) break;
		*( piTypeArray + i ) = newVar.lVal;

		VariantInit( &newVar );
		switch( *( piTypeArray + i ) ) {
			case 0:
				hr = VariantChangeType( &newVar, &pDataArray[ i ], 0, VT_I2 );
				pProps[ i ].propid = MAKELONG( CEVT_I2, i );
				pProps[ i ].val.iVal = newVar.iVal;
				break;

			case 1:
				hr = VariantChangeType( &newVar, &pDataArray[ i ], 0, VT_I4 );
				pProps[ i ].propid = MAKELONG( CEVT_I4, i );
				pProps[ i ].val.lVal = newVar.lVal;
				break;

			case 2:
				hr = VariantChangeType( &newVar, &pDataArray[ i ], 0, VT_UI2 );
				pProps[ i ].propid = MAKELONG( CEVT_UI2, i );
				pProps[ i ].val.uiVal = newVar.uintVal;
				break;

			case 3:
				hr = VariantChangeType( &newVar, &pDataArray[ i ], 0, VT_UI4 );
				pProps[ i ].propid = MAKELONG( CEVT_UI4, i );
				pProps[ i ].val.ulVal = newVar.ulVal;
				break;

			case 4:
				hr = VariantChangeType( &newVar, &pDataArray[ i ], 0, VT_R8 );
				pProps[ i ].propid = MAKELONG( CEVT_R8, i );
				pProps[ i ].val.dblVal = newVar.dblVal;
				break;

			case 5:
				hr = VariantChangeType( &newVar, &pDataArray[ i ], 0, VT_BSTR );
				pProps[ i ].propid = MAKELONG( CEVT_LPWSTR, i );
				pProps[ i ].val.lpwstr = newVar.bstrVal;
				break;

			case 6:
				hr = VariantChangeType( &newVar, &pDataArray[ i ], 0, VT_I2 );
				pProps[ i ].propid = MAKELONG( CEVT_I2, i );
				pProps[ i ].val.uiVal = newVar.intVal;
				break;

			case 7:
			{
				SYSTEMTIME st;
				FILETIME ft;
				
				hr = VariantTimeToSystemTime( pDataArray[ i ].dblVal, &st );
				SystemTimeToFileTime( &st, &ft );
				hr = VariantChangeType( &newVar, &pDataArray[ i ], 0, VT_R8 );
				pProps[ i ].propid = MAKELONG( CEVT_FILETIME, i );
				pProps[ i ].val.filetime = ft;
				break;
			}

			case 8:
				hr = VariantChangeType( &newVar, &pDataArray[ i ], 0, VT_I2 );
				break;
		}
		if( hr != S_OK ) break;
	}

	if( hr != S_OK ) {
		SafeArrayUnaccessData( V_ARRAY( pvTypes ) );
		SafeArrayDestroy( V_ARRAY( pvTypes ) );
		SafeArrayUnaccessData( V_ARRAY( pvData ) );
		SafeArrayDestroy( V_ARRAY( pvData ) );
		return E_FAIL;
	}

	ceID = CeWriteRecordProps( hDBase, lID, iTypes, pProps );

	SafeArrayUnaccessData( V_ARRAY( pvTypes ) );
	SafeArrayDestroy( V_ARRAY( pvTypes ) );
	SafeArrayUnaccessData( V_ARRAY( pvData ) );
	SafeArrayDestroy( V_ARRAY( pvData ) );

	LocalFree( piTypeArray );
	LocalFree( pProps );

	*pRet = ceID;
	ceLastOID = ceID;
	if( ! ceID ) return E_FAIL;
	return S_OK;
}

STDMETHODIMP CDatabase::GetDatabaseID(BSTR bName, long *pVal)
{
	HANDLE hFind;
	CEOID ceID;
	CEOIDINFO coi;

	hFind = CeFindFirstDatabase( 0 );
	if( hFind == INVALID_HANDLE_VALUE ) return E_FAIL;
	do {
		ceID = CeFindNextDatabase( hFind );
		if( ceID ) {
			if( CeOidGetInfo( ceID, &coi ) ) {
				if( ! wcsicmp( bName, coi.infDatabase.szDbaseName ) ) {
					*pVal = ceID;
					ceLastOID = ceID;
					CloseHandle( hFind );
					SysFreeString( bName );
					return S_OK;
				}
			}
		}
	} while( ceID );
	CloseHandle( hFind );
	SysFreeString( bName );
	return E_FAIL;
}

STDMETHODIMP CDatabase::get_LastID(long *pVal)
{
	*pVal = ceLastOID;
	return S_OK;
}

STDMETHODIMP CDatabase::SeekRecord(long lType, VARIANT *pVal, long *lRecID)
{
	CEOID ceID;
	DWORD dwType, dwNil;
	VARIANT newVar;

	if( hDBase == INVALID_HANDLE_VALUE )  return E_HANDLE;
	if( lType == 0 || lType == 1 || lType == 2 || lType == 3 ) {
		if( pVal->vt != VT_ERROR ) {
			VariantInit( &newVar );
			if( VariantChangeType( &newVar, pVal, 0, VT_UI4 ) != S_OK )  return E_INVALIDARG;
		} else newVar.uiVal = 0;
		if( lType == 0 )  dwType = CEDB_SEEK_CEOID;
		if( lType == 1 )  dwType = CEDB_SEEK_BEGINNING;
		if( lType == 2 )  dwType = CEDB_SEEK_CURRENT;
		if( lType == 3 )  dwType = CEDB_SEEK_END;
		ceID = CeSeekDatabase( hDBase, dwType, newVar.uiVal, &dwNil );
		if( ! ceID )  return E_FAIL;
		ceLastOID = ceID;
		*lRecID = ceID;
		return S_OK;
	}
	return E_FAIL;
}

