#include "windows.h"
#include "commctrl.h"
#include "ole2.h"
#include "resource.h"


LRESULT WINAPI MainDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL GetObjectList( HWND );
int FindObjectProps( HWND, HTREEITEM, TCHAR * );
BOOL GetTypeDesc( ITypeInfo *, TYPEDESC *, TCHAR * );
BOOL GetParameterAttributes( PARAMDESC *, TCHAR * );
HTREEITEM AddItemToTree( HWND, HTREEITEM, HTREEITEM, BSTR, int, int );
int GetObjectProperties( HWND, HTREEITEM, ITypeInfo * );
int GetObjectMethods( HWND, HTREEITEM, ITypeInfo * );
int GetObjectVars( HWND, HTREEITEM, ITypeInfo *, BOOL );
int EnumInterface( HWND, HTREEITEM, ITypeLib *, UINT );
BOOL AppendVTType( TCHAR *, UINT );
BOOL GetUserDefinedType( ITypeInfo *, TYPEDESC *, HWND, HTREEITEM );

// ============================================================================

HINSTANCE hInst;
HIMAGELIST hImageList;
HWND hMainWnd;

// ============================================================================

int APIENTRY WinMain( HINSTANCE h1, HINSTANCE h2, LPTSTR lpCmd, int nShow )
{
	WNDCLASS wc;
	MSG msg;
	HWND hDlg;
	RECT Rect;

	hInst = h1;
	memset( &wc, 0, sizeof(WNDCLASS) );
	wc.hInstance = hInst;
	wc.hbrBackground = (HBRUSH)( COLOR_WINDOW + 1 );
	wc.lpszClassName = L"ObjBrowse";
	wc.lpfnWndProc = MainDlgProc;
	wc.hIcon = (HICON)LoadImage( hInst, MAKEINTRESOURCE( IDI_ICON4 ), IMAGE_ICON,
						  16, 16, 0 );
	if( ! RegisterClass( &wc ) )  return( 0 );
	InitCommonControls();
	hDlg = CreateDialog( hInst, MAKEINTRESOURCE( 10001 ), NULL, NULL );
	GetClientRect( hDlg, &Rect );
	Rect.left = ( GetSystemMetrics( SM_CXSCREEN ) - Rect.right ) / 2;
	Rect.top = ( GetSystemMetrics( SM_CYSCREEN ) - Rect.bottom ) / 2;
	SetWindowPos( hDlg, NULL, Rect.left, Rect.top, 0, 0,
				  SWP_NOSIZE | SWP_NOZORDER );	
	ShowWindow( hDlg, SW_SHOW );
	UpdateWindow( hDlg );

	hMainWnd = CreateWindow( L"ObjBrowse", L"Object Browser",
							 WS_VISIBLE | WS_OVERLAPPED | WS_SYSMENU,
							 0, 0, CW_USEDEFAULT, CW_USEDEFAULT,
							 NULL, NULL, hInst, NULL );
	if( ! hMainWnd )  return( 0 );
	DestroyWindow( hDlg );
	ShowWindow( hMainWnd, nShow );
	UpdateWindow( hMainWnd );
	while( GetMessage( &msg, NULL, 0, 0 ) ) {
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}							 
	return( 0 );
}

// ============================================================================

LRESULT WINAPI MainDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_CREATE:
		{
			RECT Rect;
			HICON hIcon;

			CoInitializeEx( NULL, COINIT_MULTITHREADED );          //  Initialize OLE

			hImageList = ImageList_Create( 16, 16, ILC_COLOR, 12, 0 );
			hIcon = (HICON)LoadImage( hInst, MAKEINTRESOURCE( IDI_ICON4 ), IMAGE_ICON,
							   16, 16, 0 );
			ImageList_AddIcon( hImageList, hIcon );
			hIcon = (HICON)LoadImage( hInst, MAKEINTRESOURCE( IDI_ICON1 ), IMAGE_ICON,
							   16, 16, 0 );
			ImageList_AddIcon( hImageList, hIcon );
			hIcon = (HICON)LoadImage( hInst, MAKEINTRESOURCE( IDI_ICON2 ), IMAGE_ICON,
							   16, 16, 0 );
			ImageList_AddIcon( hImageList, hIcon );
			hIcon = (HICON)LoadImage( hInst, MAKEINTRESOURCE( IDI_ICON3 ), IMAGE_ICON,
							   16, 16, 0 );
			ImageList_AddIcon( hImageList, hIcon );
			hIcon = (HICON)LoadImage( hInst, MAKEINTRESOURCE( IDI_ICON5 ), IMAGE_ICON,
							   16, 16, 0 );
			ImageList_AddIcon( hImageList, hIcon );
			hIcon = (HICON)LoadImage( hInst, MAKEINTRESOURCE( IDI_ICON6 ), IMAGE_ICON,
							   16, 16, 0 );
			ImageList_AddIcon( hImageList, hIcon );
			hIcon = (HICON)LoadImage( hInst, MAKEINTRESOURCE( IDI_ICON7 ), IMAGE_ICON,
							   16, 16, 0 );
			ImageList_AddIcon( hImageList, hIcon );
			hIcon = (HICON)LoadImage( hInst, MAKEINTRESOURCE( IDI_ICON8 ), IMAGE_ICON,
							   16, 16, 0 );
			ImageList_AddIcon( hImageList, hIcon );
			hIcon = (HICON)LoadImage( hInst, MAKEINTRESOURCE( IDI_ICON9 ), IMAGE_ICON,
							   16, 16, 0 );
			ImageList_AddIcon( hImageList, hIcon );
			hIcon = (HICON)LoadImage( hInst, MAKEINTRESOURCE( IDI_ICON10 ), IMAGE_ICON,
							   16, 16, 0 );
			ImageList_AddIcon( hImageList, hIcon );
			hIcon = (HICON)LoadImage( hInst, MAKEINTRESOURCE( IDI_ICON11 ), IMAGE_ICON,
							   16, 16, 0 );
			ImageList_AddIcon( hImageList, hIcon );
			hIcon = (HICON)LoadImage( hInst, MAKEINTRESOURCE( IDI_ICON12 ), IMAGE_ICON,
							   16, 16, 0 );
			ImageList_AddIcon( hImageList, hIcon );
			GetClientRect( hDlg, &Rect );
			CreateWindow( WC_TREEVIEW, NULL, WS_CHILD | WS_BORDER | WS_VISIBLE |
						  TVS_HASLINES | TVS_LINESATROOT | TVS_HASBUTTONS,
						  0, 0, Rect.right, Rect.bottom,
						  hDlg, (HMENU)101, hInst, NULL );
			TreeView_SetImageList( GetDlgItem( hDlg, 101 ), hImageList, TVSIL_NORMAL );
			GetObjectList( hDlg );    // Fill in tree with objects and their subparts
			SetFocus( GetDlgItem( hDlg, 101 ) );
			return( TRUE );
		}


		case WM_DESTROY:
			ImageList_Destroy( hImageList );
			CoUninitialize();                                 //  Uninitialize OLE
			PostQuitMessage( 0 );
			return( FALSE );


		default:
			return( DefWindowProc( hDlg, msg, wParam, lParam ) );
	}
	return( FALSE );
}

// ============================================================================

HTREEITEM AddItemToTree( HWND hTree, HTREEITEM hParent, HTREEITEM hPrev,
						 BSTR bText, int iImage, int iSelectedImage )
{
	TV_INSERTSTRUCT tvis;
	TV_ITEM tvi;

	memset( &tvis, 0, sizeof(TV_INSERTSTRUCT) );
	memset( &tvi, 0, sizeof(TV_ITEM) );

	tvi.pszText = bText;
	tvi.cchTextMax = wcslen( bText );
	tvi.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvi.iImage = iImage;
	tvi.iSelectedImage = iSelectedImage;
	tvis.hParent = hParent;
	tvis.hInsertAfter = hPrev;
	tvis.item = tvi;
	return( (HTREEITEM)SendMessage( hTree, TVM_INSERTITEM, 0, (LPARAM)&tvis ) );
}

// ============================================================================
//  GetObjectList(): This walks the object registry tree and attempts to create
//					 everything it finds and determine it's properties and
//					 methods. Ths function basically deals with the registry.
// ============================================================================

BOOL GetObjectList( HWND hDlg )
{
	HKEY hKey, hSubKey;
	LONG lStatus;
	DWORD dwSize, dwType, dwStatus;
	HTREEITEM hItem;
	int iKey;
	UINT uiType, uiCount, ui;
	TCHAR szName[ 256 ], szID[ 128 ], *pszEnd;
	HWND hTree;
	IDispatch *pDisp;
	ITypeInfo *ti;
	ITypeLib *tl;
	GUID guid;
	
		
	hKey = NULL;							//  Open CLSID part of HKEY_CLASSES_ROOT
	lStatus = RegOpenKeyEx( HKEY_CLASSES_ROOT, L"CLSID", 0, 0, &hKey );
	if( lStatus != ERROR_SUCCESS ) {
		MessageBox( hDlg, L"Unable to open CLSID key", L"Object Browser", MB_OK );
		return( FALSE );
	}

	iKey = 0;
	dwSize = 128;
	hItem = TVI_FIRST;                         //  Loop through all keys under CLSID
	memset( szName, 0, sizeof(szName) );
	hTree = GetDlgItem( hDlg, 101 );

	while( RegEnumKeyEx( hKey, iKey, szName, &dwSize, NULL, NULL, NULL,
						 NULL ) == ERROR_SUCCESS )
	{
		if( dwSize ) {
			hSubKey = NULL;                            //  If we open the {XXXX} key
			lStatus = RegOpenKeyEx( hKey, szName, 0, 0, &hSubKey );
			if( lStatus == ERROR_SUCCESS ) {
				dwSize = 128;                         //  And get it's default value
				lStatus = RegQueryValueEx( hSubKey, NULL, NULL, &dwType,
										   (unsigned char *)szID, &dwSize );
				if( lStatus == ERROR_SUCCESS ) {
					wcscat( szName, L" - " );     //  That value is the control name
					wcscat( szName, szID );                //  So add it to the tree
					hItem  = AddItemToTree( hTree, TVI_ROOT, hItem, szName, 0, 0 );
					pszEnd = wcschr( szName, L'}' );
					if( pszEnd ) {
						*( pszEnd + 1 ) = '\0';
						_wcsupr( szName );
						CLSIDFromString( szName, &guid );
						dwStatus = CoCreateInstance( guid, 0, CLSCTX_SERVER, IID_IDispatch,
													 (void **)&pDisp );
						if( dwStatus == S_OK ) {
							dwStatus = pDisp->GetTypeInfo( 0, 0, &ti );
							if( dwStatus == S_OK ) {
								dwStatus = ti->GetContainingTypeLib( &tl, &uiType );
								if( dwStatus == S_OK ) {
									uiCount = tl->GetTypeInfoCount();
									for( ui = 0; ui < uiCount; ui++ )
										EnumInterface( GetDlgItem( hDlg, 101 ), hItem, tl, ui );
									tl->Release();
								}
								ti->Release();
							}
							pDisp->Release();
						}
					}
				}
				RegCloseKey( hSubKey );          //  Done with object key...close it
			}
		}
		dwSize = 128;
		++iKey;
	}
	RegCloseKey( hKey );
	return( TRUE );
}                                                         //  End of GetObjectList()

// ============================================================================

int EnumInterface( HWND hTree, HTREEITEM hParent, ITypeLib *ptl, UINT uiNum )
{
	ITypeInfo *ti;
	DWORD dwStatus;
	BSTR bName;
	HTREEITEM hItem;

	dwStatus = ptl->GetTypeInfo( uiNum, &ti );
	if( dwStatus == S_OK ) {
		ti->GetDocumentation( -1, &bName, NULL, NULL, NULL );
		if( bName ) {
			hItem = AddItemToTree( hTree, hParent, TVI_FIRST, bName, 10, 10 );
			GetObjectProperties( hTree, hItem, ti );
			GetObjectMethods( hTree, hItem, ti );
			GetObjectVars( hTree, hItem, ti, TRUE );
			SysFreeString( bName );
		}
		ti->Release();
	}
	return 1;
}

// ============================================================================

int GetObjectProperties( HWND hTree, HTREEITEM hParent, ITypeInfo *pTi )
{
	int iCount, i, j, iImage;
	DWORD dwStatus;
	BSTR bInterface, bName;
	TYPEATTR *ta;
	TCHAR szInfo[ 512 ];
	FUNCDESC *fd;
	HTREEITEM hNew, hNewParent;


	hNewParent = AddItemToTree( hTree, hParent, TVI_FIRST, L"Properties", 8, 8 );

	hNew = TVI_FIRST;
	iCount = 0;
	pTi->GetDocumentation( -1, &bInterface, NULL, NULL, NULL );
	dwStatus = pTi->GetTypeAttr( &ta );
	if( dwStatus == S_OK ) {
		for( i = 0; i < ta->cFuncs; i++ ) {
			szInfo[ 0 ] = L'\0';
			dwStatus = pTi->GetFuncDesc( i, &fd );
			if( dwStatus == S_OK ) {
				dwStatus = pTi->GetDocumentation( fd->memid, &bName, NULL, NULL, NULL );
				switch( fd->invkind ) {
					case INVOKE_PROPERTYPUT:
						wsprintf( szInfo, L"[Put( %.8x )] ", fd->memid );
						iImage = 2;
						break;
					case INVOKE_PROPERTYGET:
						wsprintf( szInfo, L"[Get( %.8x )] ", fd->memid );
						iImage = 3;
						break;
					case INVOKE_PROPERTYPUTREF:
						wsprintf( szInfo, L"[PutRef( %.8x )] ", fd->memid );
						iImage = 2;
						break;
					default:
						continue;
				}
				if( ( fd->memid & 0xF0000000 ) == 0x60000000 ) iImage = 4;
				if( ( fd->memid & 0xFFFF0000 ) == 0xFFFF0000 ) {
					if( fd->invkind == INVOKE_PROPERTYGET ) iImage = 5;
					else iImage = 6;
				}
				wcscat( szInfo, bName );
				wcscat( szInfo, L"( " );

				for( j = 0; j < fd->cParams; j++ ) {
					GetTypeDesc( pTi, &fd->lprgelemdescParam[ j ].tdesc, szInfo );
					GetParameterAttributes( &fd->lprgelemdescParam[ j ].paramdesc, szInfo );
					if( j < fd->cParams - 1 ) wcscat( szInfo, L", " );
				}
				wcscat( szInfo, L" ) = " );

				GetTypeDesc( pTi, &fd->elemdescFunc.tdesc, szInfo );
				GetParameterAttributes( &fd->elemdescFunc.paramdesc, szInfo );

				++iCount;
				hNew = AddItemToTree( hTree, hNewParent, hNew, szInfo, iImage, iImage );
				if( fd->elemdescFunc.tdesc.vt == VT_USERDEFINED )
					GetUserDefinedType( pTi, &fd->elemdescFunc.tdesc, hTree, hNew );
				pTi->ReleaseFuncDesc( fd );  //  Release FUNCDESC memory
			}
			SysFreeString( bName );    //  Release function name memory
		}
	}
	SysFreeString( bInterface );      //  Release Interface name memory
	if( ! iCount )  TreeView_DeleteItem( hTree, hNewParent );
	return iCount;
}

// ============================================================================

int GetObjectMethods( HWND hTree, HTREEITEM hParent, ITypeInfo *pTi )
{
	int iCount, i, j, iImage;
	DWORD dwStatus;
	BSTR bInterface, bName;
	TYPEATTR *ta;
	TCHAR szInfo[ 512 ];
	FUNCDESC *fd;
	HTREEITEM hNew, hNewParent;

	hNewParent = AddItemToTree( hTree, hParent, TVI_FIRST, L"Methods", 7, 7 );

	hNew = TVI_FIRST;
	iCount = 0;
	pTi->GetDocumentation( -1, &bInterface, NULL, NULL, NULL );
	dwStatus = pTi->GetTypeAttr( &ta );
	if( dwStatus == S_OK ) {
		for( i = 0; i < ta->cFuncs; i++ ) {
			szInfo[ 0 ] = L'\0';
			dwStatus = pTi->GetFuncDesc( i, &fd );
			if( dwStatus == S_OK ) {
				dwStatus = pTi->GetDocumentation( fd->memid, &bName, NULL, NULL, NULL );
				switch( fd->invkind ) {
					case INVOKE_FUNC:
						wsprintf( szInfo, L"[( %.8x )] ", fd->memid );
						iImage = 1;
						break;
					default:
						continue;
				}
				if( ( fd->memid & 0xF0000000 ) == 0x60000000 ) continue; //iImage = 4;
				if( ( fd->memid & 0xFFFF0000 ) == 0xFFFF0000 ) {
					if( fd->invkind == INVOKE_PROPERTYGET ) iImage = 5;
					else iImage = 6;
				}
				wcscat( szInfo, bName );
				wcscat( szInfo, L"( " );
				for( j = 0; j < fd->cParams; j++ ) {
					GetTypeDesc( pTi, &fd->lprgelemdescParam[ j ].tdesc, szInfo );
					GetParameterAttributes( &fd->lprgelemdescParam[ j ].paramdesc, szInfo );
					if( j < fd->cParams - 1 ) wcscat( szInfo, L", " );
				}
				wcscat( szInfo, L" ) = " );
				GetTypeDesc( pTi, &fd->elemdescFunc.tdesc, szInfo );
				GetParameterAttributes( &fd->elemdescFunc.paramdesc, szInfo );

				++iCount;
				hNew = AddItemToTree( hTree, hNewParent, hNew, szInfo, iImage, iImage );
				if( fd->elemdescFunc.tdesc.vt == VT_USERDEFINED )
					GetUserDefinedType( pTi, &fd->elemdescFunc.tdesc, hTree, hNew );
				pTi->ReleaseFuncDesc( fd );  //  Release FUNCDESC memory
			}
			SysFreeString( bName );    //  Release function name memory
		}
	}
	SysFreeString( bInterface );      //  Release Interface name memory
	if( ! iCount )  TreeView_DeleteItem( hTree, hNewParent );
	return iCount;
}

// ============================================================================

int GetObjectVars( HWND hTree, HTREEITEM hParent, ITypeInfo *pTi, BOOL bAddVar )
{
	int iCount, i, iImage;
	DWORD dwStatus;
	BSTR bInterface, bName;
	TYPEATTR *ta;
	TCHAR szInfo[ 512 ];
	VARDESC *vd;
	HTREEITEM hNew, hNewParent;
	VARIANT val;
	ITypeInfo *nti;

	if( bAddVar ) hNewParent = AddItemToTree( hTree, hParent, TVI_FIRST, L"Variables", 11, 11 );
	else hNewParent = hParent;

	hNew = TVI_FIRST;
	iCount = 0;
	pTi->GetDocumentation( -1, &bInterface, NULL, NULL, NULL );
	dwStatus = pTi->GetTypeAttr( &ta );
	if( dwStatus == S_OK ) {
		for( i = 0; i < ta->cVars; i++ ) {
			szInfo[ 0 ] = L'\0';
			dwStatus = pTi->GetVarDesc( i, &vd );
			if( dwStatus == S_OK ) {
				dwStatus = pTi->GetDocumentation( vd->memid, &bName, NULL, NULL, NULL );
				wsprintf( szInfo, L"[( %.8x )] ", vd->memid );
				iImage = 1;
				if( ( vd->memid & 0xF0000000 ) == 0x60000000 ) continue;
				if( ( vd->memid & 0xFFFF0000 ) == 0xFFFF0000 ) iImage = 6;
				AppendVTType( szInfo, vd->elemdescVar.tdesc.vt );
				wcscat( szInfo, L" " );
				wcscat( szInfo, bName );
				wcscat( szInfo, L" = " );
				if( vd->varkind == VAR_STATIC ) wcscat( szInfo, L"Static " );
				if( vd->varkind == VAR_DISPATCH ) wcscat( szInfo, L"Dispatch " );
				if( vd->varkind == VAR_PERINSTANCE ) wcscat( szInfo, L"Per Inst " );
				nti = NULL;
				if( vd->varkind == VAR_CONST ) {
					wcscat( szInfo, L"Const " );
					VariantInit( &val );
					if( VariantChangeType( &val, vd->lpvarValue, 0, VT_BSTR ) == S_OK )
						wcscat( szInfo, val.bstrVal );
					else wcscat( szInfo, L"?" );
				} else {
					if( vd->elemdescVar.tdesc.vt == VT_USERDEFINED )
						pTi->GetRefTypeInfo( vd->elemdescVar.tdesc.hreftype, &nti );
					else wcscat( szInfo, L"?" );
				}

				++iCount;
				hNew = AddItemToTree( hTree, hNewParent, hNew, szInfo, iImage, iImage );
				if( nti ) {
					GetObjectProperties( hTree, hNew, nti );
					GetObjectMethods( hTree, hNew, nti );
					GetObjectVars( hTree, hNew, nti, FALSE );
					nti->Release();
				}
				pTi->ReleaseVarDesc( vd );  //  Release FUNCDESC memory
			}
			SysFreeString( bName );    //  Release function name memory
		}
	}
	SysFreeString( bInterface );      //  Release Interface name memory
	if( ! iCount )  TreeView_DeleteItem( hTree, hNewParent );
	return iCount;
}

// ============================================================================
//  GetTypeDesc(): This is a RECURSIVE function that determines what type of
//				   variables are being passed to and from functions. It basic-
//				   -ally picks apart a VARIANT union and adds the found type.
// ============================================================================

BOOL GetTypeDesc( ITypeInfo *pti, TYPEDESC *typeDesc, TCHAR *pszStr )
{
	if( typeDesc->vt == VT_PTR ) {
		wcscat( pszStr, L"*" );            //  It's a pointer, find out what it
		GetTypeDesc( pti, typeDesc->lptdesc, pszStr );      //  points to
		return( TRUE );
	}

	if( typeDesc->vt == VT_SAFEARRAY ) {              //  It's a SAFEARRAY type
		wcscat( pszStr, L"SAFEARRAY( " );    //  Find out what it's an array of
		GetTypeDesc( pti, typeDesc->lptdesc, pszStr );
		return( TRUE );
	}

	AppendVTType( pszStr, typeDesc->vt );
	return( TRUE );
}

// ============================================================================

BOOL GetUserDefinedType( ITypeInfo *pti, TYPEDESC *typeDesc, HWND hTree, HTREEITEM hNew )
{
	if( typeDesc->vt == VT_USERDEFINED ) {
		ITypeInfo *nti;
		pti->GetRefTypeInfo( typeDesc->hreftype, &nti );
		GetObjectProperties( hTree, hNew, nti );
		GetObjectMethods( hTree, hNew, nti );
		GetObjectVars( hTree, hNew, nti, FALSE );
		nti->Release();
	}
	return( TRUE );
}

BOOL AppendVTType( TCHAR *pszStr, UINT vt )
{
	switch( vt ) {
	    case VT_I2:
		{
			wcscat( pszStr, L"short" );
			break;
		}
		case VT_I4:
		{
			wcscat( pszStr, L"long" );
			break;
		}
	    case VT_R4:
		{
			wcscat( pszStr, L"float" );
			break;
		}
		case VT_R8:
		{
			wcscat( pszStr, L"double" );
			break;
		}
	    case VT_CY:
		{
			wcscat( pszStr, L"CY" );
			break;
		}
	    case VT_DATE:
		{
			wcscat( pszStr, L"DATE" );
			break;
		}
	    case VT_BSTR:
		{
			wcscat( pszStr, L"BSTR" );
			break;
		}
	    case VT_DISPATCH:
		{
			wcscat( pszStr, L"IDispatch*" );
			break;
		}
	    case VT_ERROR:
		{
			wcscat( pszStr, L"SCODE" );
			break;
		}
	    case VT_BOOL:
		{
			wcscat( pszStr, L"VARIANT_BOOL" );
			break;
		}
	    case VT_VARIANT:
		{
			wcscat( pszStr, L"VARIANT" );
			break;
		}
	    case VT_UNKNOWN:
		{
			wcscat( pszStr, L"IUnknown*" );
			break;
		}
	    case VT_UI1:
		{
			wcscat( pszStr, L"BYTE" );
			break;
		}
	    case VT_DECIMAL:
		{
			wcscat( pszStr, L"DECIMAL" );
			break;
		}
	    case VT_I1:
		{
			wcscat( pszStr, L"char" );
			break;
		}
	    case VT_UI2:
		{
			wcscat( pszStr, L"USHORT" );
			break;
		}
	    case VT_UI4:
		{
			wcscat( pszStr, L"ULONG" );
			break;
		}
	    case VT_I8:
		{
			wcscat( pszStr, L"__int64" );
			break;
		}
	    case VT_UI8:
		{
			wcscat( pszStr, L"unsigned __int64" );
			break;
		}
		case VT_INT:
		{
			wcscat( pszStr, L"int" );
			break;
		}
		case VT_UINT:
		{
			wcscat( pszStr, L"UINT" );
			break;
		}
	    case VT_HRESULT:
		{
			wcscat( pszStr, L"HRESULT" );
			break;
		}
	    case VT_VOID:
		{
			wcscat( pszStr, L"void" );
			break;
		}
	    case VT_LPSTR:
		{
			wcscat( pszStr, L"char*" );
			break;
		}
	    case VT_LPWSTR:
		{
			wcscat( pszStr, L"wchar_t*" );
			break;
		}
		case VT_USERDEFINED:
		{
			wcscat( pszStr, L"UserDef" );
			break;
		}
		case VT_PTR:
		{
			wcscat( pszStr, L"PTR" );
			break;
		}
		case VT_SAFEARRAY:
		{
			wcscat( pszStr, L"SafeArray" );
			break;
		}
		case VT_CARRAY:
		{
			wcscat( pszStr, L"Array" );
			break;
		}
		default:
		{
			TCHAR szType[ 8 ];

			wsprintf( szType, L"%d", vt );
			wcscat( pszStr, szType );
			break;
		}
    }
	return TRUE;
}

// ============================================================================
//  GetParameterAttributes(): This simply determines if a variable is an IN,
//							  OUT or whatever type. The PARAMDESC struct comes
//							  from &FUNCDESC->elemdescFunc.paramdesc.
// ============================================================================

BOOL GetParameterAttributes( PARAMDESC *ppd, TCHAR *pszStr )
{
	USHORT paramFlags = ppd->wParamFlags;
	DWORD bit;
	int numFlags;

	for( bit = 1; bit <= PARAMFLAG_FHASDEFAULT; bit <<= 1 )
        numFlags += ( paramFlags & bit ) ? 1 : 0;
        
	if( paramFlags & PARAMFLAG_FIN ) wcscat( pszStr, L" [IN]" );
	if( paramFlags & PARAMFLAG_FOUT ) wcscat( pszStr, L" [OUT]" );
	if( paramFlags & PARAMFLAG_FLCID ) wcscat( pszStr, L" [LCID]" );
	if( paramFlags & PARAMFLAG_FRETVAL ) wcscat( pszStr, L" [RetVal]" );
	if( paramFlags & PARAMFLAG_FOPT ) wcscat( pszStr, L" [OPT]" );
	if( paramFlags & PARAMFLAG_FHASDEFAULT ) wcscat( pszStr, L" [DEF]" );
	return( TRUE );
}
