// Tray.h : Declaration of the CTray

#ifndef __TRAY_H_
#define __TRAY_H_

#include "resource.h"       // main symbols
#include <atlctl.h>
#include "commctrl.h"
#include "MGCEWin32CP.h"


/////////////////////////////////////////////////////////////////////////////
// CTray
class ATL_NO_VTABLE CTray : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<ITray, &IID_ITray, &LIBID_MGCEWIN32Lib>,
	public CComControl<CTray>,
	public IPersistStreamInitImpl<CTray>,
	public IOleControlImpl<CTray>,
	public IOleObjectImpl<CTray>,
	public IOleInPlaceActiveObjectImpl<CTray>,
	public IViewObjectExImpl<CTray>,
	public IOleInPlaceObjectWindowlessImpl<CTray>,
	public IConnectionPointContainerImpl<CTray>,
	public IPersistStorageImpl<CTray>,
	public ISpecifyPropertyPagesImpl<CTray>,
	public IQuickActivateImpl<CTray>,
	public IDataObjectImpl<CTray>,
	public IProvideClassInfo2Impl<&CLSID_Tray, &DIID__ITrayEvents, &LIBID_MGCEWIN32Lib>,
	public IPropertyNotifySinkCP<CTray>,
	public CComCoClass<CTray, &CLSID_Tray>,
	public CProxy_ITrayEvents< CTray >
{
public:
	CTray()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_TRAY)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CTray)
	COM_INTERFACE_ENTRY(ITray)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()

BEGIN_PROP_MAP(CTray)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_CONNECTION_POINT_MAP(CTray)
	CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
	CONNECTION_POINT_ENTRY(DIID__ITrayEvents)
END_CONNECTION_POINT_MAP()

BEGIN_MSG_MAP(CTray)
	MESSAGE_HANDLER( WM_CREATE, OnCreate )
	MESSAGE_HANDLER( WM_DESTROY, OnDestroy )
	MESSAGE_HANDLER( WM_COMMAND, OnCommand )
	CHAIN_MSG_MAP(CComControl<CTray>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// ITray
public:
	STDMETHOD(get_Tag)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_Tag)(/*[in]*/ VARIANT *newVal);
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Image)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Image)(/*[in]*/ long newVal);
	STDMETHOD(RemoveImage)(long lImage);
	STDMETHOD(AddImage)(BSTR bFilename);

	HRESULT OnCreate( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		VariantInit( &vTag );
		hImageList = ImageList_Create( 16, 16, ILC_COLOR, 0, 32 );
		if( ! hImageList ) {
			bHandled = TRUE;
			return E_FAIL;
		}
		lIconAdded = 0;
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnCommand( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		if( wParam == 1000 && lParam == WM_LBUTTONDOWN ) {
			Fire_Click( lIconAdded );
			bHandled = TRUE;
		}
		bHandled = FALSE;
		return S_OK;
	}

	HRESULT OnDestroy( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		NOTIFYICONDATA nid;

		if( lIconAdded ) {
			memset( &nid, 0, sizeof(NOTIFYICONDATA) );
			nid.cbSize = sizeof(NOTIFYICONDATA);
			nid.hWnd = this->m_hWnd;
			nid.uID = 1000;
			nid.uCallbackMessage = WM_COMMAND;
			Shell_NotifyIcon( NIM_DELETE, &nid );
		}
		if( hImageList ) ImageList_Destroy( hImageList );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		return S_OK;
	}
private:
	VARIANT vTag;
	HIMAGELIST hImageList;
	long lIconAdded;
};

#endif //__TRAY_H_
