// Tray.cpp : Implementation of CTray

#include "stdafx.h"
#include "MGCEWin32.h"
#include "Tray.h"

/////////////////////////////////////////////////////////////////////////////
// CTray


STDMETHODIMP CTray::AddImage(BSTR bFilename)
{
	HBITMAP hBmp;
	int iAdd;

	hBmp = ::SHLoadDIBitmap( bFilename );
	SysFreeString( bFilename );
	if( ! hBmp ) {
		Error( L"Error loading specified image" );
		return E_FAIL;
	}
	iAdd = ::ImageList_Add( hImageList, hBmp, NULL );
	::DeleteObject( hBmp );
	if( iAdd == -1 ) {
		Error( L"Error adding image to image list" );
		return E_FAIL;
	}
	return S_OK;
}


STDMETHODIMP CTray::RemoveImage(long lImage)
{
	if( lImage < 1 ) {
		Error( L"Invalid image index specified" );
		return E_FAIL;
	}
	ImageList_Remove( hImageList, lImage - 1 );
	return S_OK;
}

STDMETHODIMP CTray::get_Image(long *pVal)
{
	*pVal = lIconAdded;
	return S_OK;
}

STDMETHODIMP CTray::put_Image(long newVal)
{
	NOTIFYICONDATA nid;
	HICON hIcon;
	int iCmd;

	if( ! newVal && ! lIconAdded ) return S_OK;

	if( ! newVal && lIconAdded ) {
		memset( &nid, 0, sizeof(NOTIFYICONDATA) );
		nid.cbSize = sizeof(NOTIFYICONDATA);
		nid.hWnd = this->m_hWnd;
		nid.uID = 1000;
		nid.uCallbackMessage = WM_COMMAND;
		Shell_NotifyIcon( NIM_DELETE, &nid );
		lIconAdded = 0;
		return S_OK;
	}

	hIcon = ::ImageList_GetIcon( hImageList, newVal - 1, ILD_NORMAL );
	if( ! hIcon ) {
		Error( L"Unable to retrieve image from image list" );
		return E_FAIL;
	}
	if( ! lIconAdded ) iCmd = NIM_ADD;
	else iCmd = NIM_MODIFY;
	memset( &nid, 0, sizeof(NOTIFYICONDATA) );
	nid.cbSize = sizeof(NOTIFYICONDATA);
	nid.hWnd = this->m_hWnd;
	nid.uID = 1000;
	nid.uFlags = NIF_ICON;
	nid.uCallbackMessage = WM_COMMAND;
	nid.hIcon = hIcon;
	Shell_NotifyIcon( iCmd, &nid );
	lIconAdded = newVal;
	return S_OK;
}


STDMETHODIMP CTray::get_Version(long *pVal)
{
	*pVal = 101;
	return S_OK;
}

STDMETHODIMP CTray::get_Tag(VARIANT *pVal)
{
	VariantCopy( pVal, &vTag );
	return S_OK;
}

STDMETHODIMP CTray::put_Tag(VARIANT *newVal)
{
	VariantClear( &vTag );
	VariantCopy( &vTag, newVal );
	VariantClear( newVal );
	return S_OK;
}
