// Timer.h : Declaration of the CTimer

#ifndef __TIMER_H_
#define __TIMER_H_

#include "resource.h"       // main symbols
#include <atlctl.h>
#include "MGCEWin32CP.h"


/////////////////////////////////////////////////////////////////////////////
// CTimer
class ATL_NO_VTABLE CTimer : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<ITimer, &IID_ITimer, &LIBID_MGCEWIN32Lib>,
	public CComControl<CTimer>,
	public IPersistStreamInitImpl<CTimer>,
	public IOleControlImpl<CTimer>,
	public IOleObjectImpl<CTimer>,
	public IOleInPlaceActiveObjectImpl<CTimer>,
	public IViewObjectExImpl<CTimer>,
	public IOleInPlaceObjectWindowlessImpl<CTimer>,
	public IConnectionPointContainerImpl<CTimer>,
	public IPersistStorageImpl<CTimer>,
	public ISpecifyPropertyPagesImpl<CTimer>,
	public IQuickActivateImpl<CTimer>,
	public IDataObjectImpl<CTimer>,
	public IProvideClassInfo2Impl<&CLSID_Timer, &DIID__ITimerEvents, &LIBID_MGCEWIN32Lib>,
	public IPropertyNotifySinkCP<CTimer>,
	public CComCoClass<CTimer, &CLSID_Timer>,
	public CProxy_ITimerEvents< CTimer >
{
public:
	CTimer()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_TIMER)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CTimer)
	COM_INTERFACE_ENTRY(ITimer)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()

BEGIN_PROP_MAP(CTimer)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_CONNECTION_POINT_MAP(CTimer)
	CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
	CONNECTION_POINT_ENTRY(DIID__ITimerEvents)
END_CONNECTION_POINT_MAP()

BEGIN_MSG_MAP(CTimer)
	MESSAGE_HANDLER( WM_CREATE, OnCreate )
	MESSAGE_HANDLER( WM_DESTROY, OnDestroy )
	MESSAGE_HANDLER( WM_TIMER, OnTimer )
	CHAIN_MSG_MAP(CComControl<CTimer>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// ITimer
public:
	STDMETHOD(get_Tag)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_Tag)(/*[in]*/ VARIANT *newVal);
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(Stop)();
	STDMETHOD(Start)();
	STDMETHOD(get_Interval)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Interval)(/*[in]*/ long newVal);

	HRESULT OnCreate( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		lInterval = 1000;
		bHandled = TRUE;
		VariantInit( &vTag );
		return S_OK;
	}

	HRESULT OnDestroy( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		KillTimer( 1 );
		bHandled = TRUE;
		VariantClear( &vTag );
		return S_OK;
	}

	HRESULT OnTimer( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		Fire_Interval();
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		return S_OK;
	}
private:
	VARIANT vTag;
	long lInterval;
};

#endif //__TIMER_H_
