// Timer.cpp : Implementation of CTimer

#include "stdafx.h"
#include "MGCEWin32.h"
#include "Timer.h"

/////////////////////////////////////////////////////////////////////////////
// CTimer


STDMETHODIMP CTimer::get_Interval(long *pVal)
{
	*pVal = lInterval;
	return S_OK;
}

STDMETHODIMP CTimer::put_Interval(long newVal)
{
	if( ! newVal ) {
		Error( L"Invalid interval specified" );
		return E_FAIL;
	}
	lInterval = newVal;
	return S_OK;
}

STDMETHODIMP CTimer::Start()
{
	SetTimer( 1, lInterval );
	return S_OK;
}

STDMETHODIMP CTimer::Stop()
{
	KillTimer( 1 );
	return S_OK;
}

STDMETHODIMP CTimer::get_Version(long *pVal)
{
	*pVal = 101;
	return S_OK;
}


STDMETHODIMP CTimer::get_Tag(VARIANT *pVal)
{
	VariantCopy( pVal, &vTag );
	return S_OK;
}

STDMETHODIMP CTimer::put_Tag(VARIANT *newVal)
{
	VariantClear( &vTag );
	VariantCopy( &vTag, newVal );
	VariantClear( newVal );
	return S_OK;
}
