// Registry.h : Declaration of the CRegistry

#ifndef __REGISTRY_H_
#define __REGISTRY_H_

#include "resource.h"       // main symbols
#include <atlctl.h>


/////////////////////////////////////////////////////////////////////////////
// CRegistry
class ATL_NO_VTABLE CRegistry : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<IRegistry, &IID_IRegistry, &LIBID_MGCEWIN32Lib>,
	public CComControl<CRegistry>,
	public IPersistStreamInitImpl<CRegistry>,
	public IOleControlImpl<CRegistry>,
	public IOleObjectImpl<CRegistry>,
	public IOleInPlaceActiveObjectImpl<CRegistry>,
	public IViewObjectExImpl<CRegistry>,
	public IOleInPlaceObjectWindowlessImpl<CRegistry>,
	public IPersistStorageImpl<CRegistry>,
	public ISpecifyPropertyPagesImpl<CRegistry>,
	public IQuickActivateImpl<CRegistry>,
	public IDataObjectImpl<CRegistry>,
	public IProvideClassInfo2Impl<&CLSID_Registry, NULL, &LIBID_MGCEWIN32Lib>,
	public CComCoClass<CRegistry, &CLSID_Registry>
{
public:
	CRegistry()
	{
		hKey = NULL;
		bPath = NULL;
		bName = NULL;
		dwType = 0;
		lType = 0;
	}

DECLARE_REGISTRY_RESOURCEID(IDR_REGISTRY)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CRegistry)
	COM_INTERFACE_ENTRY(IRegistry)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
END_COM_MAP()

BEGIN_PROP_MAP(CRegistry)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_MSG_MAP(CRegistry)
	CHAIN_MSG_MAP(CComControl<CRegistry>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// IRegistry
public:
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(GetValueName)(long lVal, BSTR *pRet);
	STDMETHOD(GetPathName)(long lVal, BSTR *pRet);
	STDMETHOD(DeleteValue)();
	STDMETHOD(get_Value)(/*[out, retval]*/ VARIANT  *pVal);
	STDMETHOD(put_Value)(/*[in]*/ VARIANT  *newVal);
	STDMETHOD(DeletePath)();
	STDMETHOD(CreatePath)();
	STDMETHOD(get_ValueType)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_ValueType)(/*[in]*/ long newVal);
	STDMETHOD(get_Name)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Name)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_Path)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Path)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_Key)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Key)(/*[in]*/ long newVal);

	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		return S_OK;
	}
private:
	HKEY hKey;
	BSTR bPath;
	DWORD dwType;
	BSTR bName;
	long lType;
	BOOL SaveSZ( VARIANT *pVar );
	BOOL SaveDWORD( VARIANT *pVar );
	BOOL SaveMultiSZ( VARIANT *pVar );
	BOOL SaveBinary( VARIANT *pVar );
};

#endif //__REGISTRY_H_
