// RAS.h : Declaration of the CRAS

#ifndef __RAS_H_
#define __RAS_H_

#include "resource.h"       // main symbols
#include <atlctl.h>
#include <ras.h>

/////////////////////////////////////////////////////////////////////////////
// CRAS
class ATL_NO_VTABLE CRAS : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<IRAS, &IID_IRAS, &LIBID_MGCEWIN32Lib>,
	public CComControl<CRAS>,
	public IPersistStreamInitImpl<CRAS>,
	public IOleControlImpl<CRAS>,
	public IOleObjectImpl<CRAS>,
	public IOleInPlaceActiveObjectImpl<CRAS>,
	public IViewObjectExImpl<CRAS>,
	public IOleInPlaceObjectWindowlessImpl<CRAS>,
	public IPersistStorageImpl<CRAS>,
	public ISpecifyPropertyPagesImpl<CRAS>,
	public IQuickActivateImpl<CRAS>,
	public IDataObjectImpl<CRAS>,
	public IProvideClassInfo2Impl<&CLSID_RAS, NULL, &LIBID_MGCEWIN32Lib>,
	public CComCoClass<CRAS, &CLSID_RAS>
{
public:
	CRAS()
	{
		memset( &rdp, 0, sizeof(RASDIALPARAMS) );
		rdp.dwSize = sizeof(RASDIALPARAMS);
		lPwdType = 0;
	}

DECLARE_REGISTRY_RESOURCEID(IDR_RAS)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CRAS)
	COM_INTERFACE_ENTRY(IRAS)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
END_COM_MAP()

BEGIN_PROP_MAP(CRAS)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_MSG_MAP(CRAS)
	CHAIN_MSG_MAP(CComControl<CRAS>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// IRAS
public:
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(DeleteEntry)(BSTR bName);
	STDMETHOD(get_AllConnections)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(get_Validate)(BSTR bName, /*[out, retval]*/ long *pVal);
	STDMETHOD(Clear)();
	STDMETHOD(RenameEntry)(BSTR bFrom, BSTR bTo);
	STDMETHOD(SetDialParams)();
	STDMETHOD(GetDialParams)();
	STDMETHOD(get_ConnectionStatus)(long lConn, /*[out, retval]*/ long *pVal);
	STDMETHOD(Disconnect)(long lConn);
	STDMETHOD(Connect)(/*[out,retval]*/ long *plConn);
	STDMETHOD(get_Domain)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Domain)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_Password)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Password)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_UserName)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_UserName)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_PhoneNumber)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_PhoneNumber)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_EntryName)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_EntryName)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_AllEntries)(/*[out, retval]*/ VARIANT *pVal);

	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		return S_OK;
	}
private:
	long lPwdType;
	RASDIALPARAMS rdp;
};

#endif //__RAS_H_
