// RAS.cpp : Implementation of CRAS

#include "stdafx.h"
#include <ras.h>
#include "MGCEWin32.h"
#include "RAS.h"

/////////////////////////////////////////////////////////////////////////////
// CRAS


STDMETHODIMP CRAS::get_AllEntries(VARIANT *pVal)
{
	LPRASENTRYNAME lprn;
	DWORD dwSize, dwEntries;
	SAFEARRAY *psa;
	VARIANT *pV;
	int i;

	dwEntries = 0;
	dwSize = sizeof(RASENTRYNAME) * 8;
	lprn = (LPRASENTRYNAME)LocalAlloc( LPTR, dwSize );
	if( ! lprn ) return E_OUTOFMEMORY;
	lprn->dwSize = sizeof(RASENTRYNAME);
	if( RasEnumEntries( NULL, NULL, lprn, &dwSize, &dwEntries ) ) {
		LocalFree( lprn );
		lprn = (LPRASENTRYNAME)LocalAlloc( LPTR, dwSize );
		if( ! lprn ) return E_OUTOFMEMORY;
		if( RasEnumEntries( NULL, NULL, lprn, &dwSize, &dwEntries ) ) {
			Error( L"Error retriving the number of entries" );
			LocalFree( lprn );
			return E_FAIL;
		}
	}
	if( ! dwEntries ) {
		V_VT( pVal ) = VT_EMPTY;
		LocalFree( lprn );
		return S_OK;
	}
	psa = SafeArrayCreateVector( VT_VARIANT, 1, dwEntries );
	if( ! psa ) {
		LocalFree( lprn );
		return E_OUTOFMEMORY;
	}

	pV = (VARIANT *)psa->pvData;
	for( i = 0; i < (int)dwEntries; i++ ) {
		V_BSTR( pV ) = SysAllocString( lprn[ i ].szEntryName );
		V_VT( pV ) = VT_BSTR;
		++pV;
	}
	LocalFree( lprn );
	V_VT( pVal ) = VT_VARIANT | VT_ARRAY;
	V_ARRAY( pVal ) = psa;
	return S_OK;
}

STDMETHODIMP CRAS::get_AllConnections(VARIANT *pVal)
{
	DWORD dwSize, dwEntries;
	LPRASCONN lpRasConn;
	SAFEARRAY *psa;
	VARIANT *pV;
	int i;

	dwEntries = 0;
	dwSize = sizeof(RASCONN) * 8;
	lpRasConn = (LPRASCONN)LocalAlloc( LPTR, dwSize );
	if( ! lpRasConn )  return E_OUTOFMEMORY;
	lpRasConn->dwSize = sizeof(RASCONN);
	if( RasEnumConnections( lpRasConn, &dwSize, &dwEntries ) ) {
		LocalFree( lpRasConn );
		lpRasConn = (LPRASCONN)LocalAlloc( LPTR, dwSize );
		if( ! lpRasConn ) return E_OUTOFMEMORY;
		lpRasConn->dwSize = sizeof(RASCONN);
		if( RasEnumConnections( lpRasConn, &dwSize, &dwEntries ) ) {
			LocalFree( lpRasConn );
			Error( L"Error enumerating RAS connections" );
			return E_FAIL;
		}
	}
	if( ! dwEntries ) {
		V_VT( pVal ) = VT_EMPTY;
		LocalFree( lpRasConn );
		return S_OK;
	}
	psa = SafeArrayCreateVector( VT_VARIANT, 1, dwEntries );
	if( ! psa ) {
		LocalFree( lpRasConn );
		return E_OUTOFMEMORY;
	}
	pV = (VARIANT *)psa->pvData;
	for( i = 0; i < (int)dwEntries; i++ ) {
		V_UI4( pV ) = (DWORD)lpRasConn[ i ].hrasconn;
		V_VT( pV ) = VT_UI4;
		++pV;
	}
	LocalFree( lpRasConn );
	V_VT( pVal ) = VT_VARIANT | VT_ARRAY;
	V_ARRAY( pVal ) = psa;
	return S_OK;
}

STDMETHODIMP CRAS::get_EntryName(BSTR *pVal)
{
	*pVal = SysAllocString( rdp.szEntryName );
	return S_OK;
}

STDMETHODIMP CRAS::put_EntryName(BSTR newVal)
{
	if( wcslen( newVal ) > RAS_MaxEntryName ) {
		Error( L"Specified entry name is too large" );
		return E_INVALIDARG;
	}
	wcscpy( rdp.szEntryName, newVal );
	SysFreeString( newVal );
	return S_OK;
}

STDMETHODIMP CRAS::get_PhoneNumber(BSTR *pVal)
{
	*pVal = SysAllocString( rdp.szPhoneNumber );
	return S_OK;
}

STDMETHODIMP CRAS::put_PhoneNumber(BSTR newVal)
{
	if( wcslen( newVal ) > RAS_MaxPhoneNumber ) {
		Error( L"Specified phone number is too large" );
		return E_INVALIDARG;
	}
	wcscpy( rdp.szPhoneNumber, newVal );
	SysFreeString( newVal );
	return S_OK;
}

STDMETHODIMP CRAS::get_UserName(BSTR *pVal)
{
	*pVal = SysAllocString( rdp.szUserName );
	return S_OK;
}

STDMETHODIMP CRAS::put_UserName(BSTR newVal)
{
	if( wcslen( newVal ) > UNLEN ) {
		Error( L"Specified user name is too large" );
		return E_INVALIDARG;
	}
	wcscpy( rdp.szUserName, newVal );
	SysFreeString( newVal );
	return S_OK;
}

STDMETHODIMP CRAS::get_Password(BSTR *pVal)
{
	*pVal = SysAllocString( rdp.szPassword );
	return S_OK;
}

STDMETHODIMP CRAS::put_Password(BSTR newVal)
{
	if( wcslen( newVal ) > PWLEN ) {
		Error( L"Specified password is too large" );
		return E_INVALIDARG;
	}
	wcscpy( rdp.szPassword, newVal );
	SysFreeString( newVal );
	return S_OK;
}

STDMETHODIMP CRAS::get_Domain(BSTR *pVal)
{
	*pVal = SysAllocString( rdp.szDomain );
	return S_OK;
}

STDMETHODIMP CRAS::put_Domain(BSTR newVal)
{
	if( wcslen( newVal ) > DNLEN ) {
		Error( L"Specified domain name is too large" );
		return E_INVALIDARG;
	}
	wcscpy( rdp.szDomain, newVal );
	SysFreeString( newVal );
	return S_OK;
}

STDMETHODIMP CRAS::Connect( long *plConn )
{
	DWORD dwStatus;
	HRASCONN hConn;

	hConn = NULL;
	dwStatus = RasDial( NULL, NULL, &rdp, NULL, NULL, &hConn );
	if( ! dwStatus ) {
		*plConn = (DWORD)hConn;
		return S_OK;
	}
	if( hConn )  RasHangUp( hConn );
	return E_FAIL;
}

STDMETHODIMP CRAS::Disconnect(long lConn)
{
	if( ! lConn ) {
		Error( L"The specified connection does not exist" );
		return E_INVALIDARG;
	}
	if( ! RasHangUp( (HRASCONN)lConn ) )  return S_OK;
	return E_FAIL;
}

STDMETHODIMP CRAS::get_ConnectionStatus(long lConn, long *pVal)
{
	DWORD dwStatus;
	RASCONNSTATUS rcs;

	memset( &rcs, 0, sizeof(RASCONNSTATUS) );
	rcs.dwSize = sizeof(RASCONNSTATUS);
	dwStatus = RasGetConnectStatus( (HRASCONN)lConn, &rcs );
	if( dwStatus ) {
		Error( L"Error retriving status of specified connection" );
		return E_FAIL;
	}
	*pVal = rcs.rasconnstate;
	return S_OK;
}

STDMETHODIMP CRAS::GetDialParams()
{
	DWORD dwStatus;

	dwStatus = RasGetEntryDialParams( NULL, &rdp, (int *)&lPwdType );
	if( ! dwStatus ) return S_OK;
	Error( L"Error retriving entry dialing parameters" );
	return E_FAIL;
}

STDMETHODIMP CRAS::SetDialParams()
{
	DWORD dwStatus;

	dwStatus = RasSetEntryDialParams( NULL, &rdp, (int)lPwdType );
	if( ! dwStatus ) return S_OK;
	Error( L"Error setting entry dialing parameters" );
	return E_FAIL;
}

STDMETHODIMP CRAS::RenameEntry(BSTR bFrom, BSTR bTo)
{
	DWORD dwStatus;

	dwStatus = RasRenameEntry( NULL, bFrom, bTo );
	SysFreeString( bFrom );
	SysFreeString( bTo );
	if( ! dwStatus ) return S_OK;
	Error( L"Error renaming entry" );
	return E_FAIL;
}

STDMETHODIMP CRAS::Clear()
{
	memset( &rdp, 0, sizeof(RASDIALPARAMS) );
	return S_OK;
}

STDMETHODIMP CRAS::get_Validate(BSTR bName, long *pVal)
{
	DWORD dwStatus;

	dwStatus = RasValidateEntryName( NULL, bName );
	SysFreeString( bName );
	if( ! dwStatus ) return S_OK;
	Error( L"Validation of entry failed" );
	return E_FAIL;
}


STDMETHODIMP CRAS::DeleteEntry(BSTR bName)
{
	DWORD dwStatus;

	dwStatus = RasDeleteEntry( NULL, bName );
	SysFreeString( bName );
	if( ! dwStatus ) return S_OK;
	Error( L"An error occurred deleting specified entry" );
	return E_FAIL;
}

STDMETHODIMP CRAS::get_Version(long *pVal)
{
	*pVal = 102;
	return S_OK;
}
