// MGCEWin32.cpp : Implementation of DLL Exports.


// Note: Proxy/Stub Information
//		To build a separate proxy/stub DLL, 
//		run nmake -f MGCEWin32ps.mk in the project directory.

#include "stdafx.h"
#include "resource.h"
#include "initguid.h"
#include "MGCEWin32.h"

#include "MGCEWin32_i.c"
#include "Tray.h"
#include "Registry.h"
#include "API.h"
#include "timer.h"
#include "ras.h"


CComModule _Module;


BEGIN_OBJECT_MAP(ObjectMap)
OBJECT_ENTRY(CLSID_Tray, CTray)
OBJECT_ENTRY(CLSID_Registry, CRegistry)
OBJECT_ENTRY(CLSID_API, CAPI)
OBJECT_ENTRY(CLSID_Timer, CTimer)
OBJECT_ENTRY(CLSID_RAS, CRAS)
END_OBJECT_MAP()

/////////////////////////////////////////////////////////////////////////////
// DLL Entry Point

extern "C"

BOOL WINAPI DllMain(HANDLE hInstance, DWORD dwReason, LPVOID /*lpReserved*/)
{
	if (dwReason == DLL_PROCESS_ATTACH)
	{
		_Module.Init(ObjectMap, (HINSTANCE)hInstance);
#ifndef UNDER_CE
		DisableThreadLibraryCalls((HINSTANCE)hInstance);
#endif
	}
	else if (dwReason == DLL_PROCESS_DETACH)
		_Module.Term();
	return TRUE;    // ok
}

/////////////////////////////////////////////////////////////////////////////
// Used to determine whether the DLL can be unloaded by OLE

STDAPI DllCanUnloadNow(void)
{
	return (_Module.GetLockCount()==0) ? S_OK : S_FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// Returns a class factory to create an object of the requested type

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
	return _Module.GetClassObject(rclsid, riid, ppv);
}

/////////////////////////////////////////////////////////////////////////////
// DllRegisterServer - Adds entries to the system registry

STDAPI DllRegisterServer(void)
{
	// registers object, typelib and all interfaces in typelib
	return _Module.RegisterServer(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
// DllUnregisterServer - Removes entries from the system registry

STDAPI DllUnregisterServer(void)
{
	_Module.UnregisterServer();
	return S_OK;
}


LRESULT WINAPI NotifyWndProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	if( msg == WM_HIBERNATE || msg == WM_SYSCOLORCHANGE ||
		msg == WM_FONTCHANGE || msg == WM_PALETTECHANGED ||
		msg == WM_SETTINGCHANGE ) {
		HWND hTarget = (HWND)::GetWindowLong( hWnd, 0 );
		::PostMessage( hTarget, msg, wParam, lParam );
	}
	
	return( ::DefWindowProc( hWnd, msg, wParam, lParam ) );
}


#include "Timer.h"
#include "RAS.h"
