// API.h : Declaration of the CAPI

#ifndef __API_H_
#define __API_H_

#include "resource.h"       // main symbols
#include <atlctl.h>
#include "MGCEWin32CP.h"

LRESULT WINAPI NotifyWndProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam );

/////////////////////////////////////////////////////////////////////////////
// CAPI
class ATL_NO_VTABLE CAPI : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<IAPI, &IID_IAPI, &LIBID_MGCEWIN32Lib>,
	public CComControl<CAPI>,
	public IPersistStreamInitImpl<CAPI>,
	public IOleControlImpl<CAPI>,
	public IOleObjectImpl<CAPI>,
	public IOleInPlaceActiveObjectImpl<CAPI>,
	public IViewObjectExImpl<CAPI>,
	public IOleInPlaceObjectWindowlessImpl<CAPI>,
	public IConnectionPointContainerImpl<CAPI>,
	public IPersistStorageImpl<CAPI>,
	public ISpecifyPropertyPagesImpl<CAPI>,
	public IQuickActivateImpl<CAPI>,
	public IDataObjectImpl<CAPI>,
	public IProvideClassInfo2Impl<&CLSID_API, &DIID__IAPIEvents, &LIBID_MGCEWIN32Lib>,
	public IPropertyNotifySinkCP<CAPI>,
	public CComCoClass<CAPI, &CLSID_API>,
	public CProxy_IAPIEvents< CAPI >
{
public:
	CAPI()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_API)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CAPI)
	COM_INTERFACE_ENTRY(IAPI)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()

BEGIN_PROP_MAP(CAPI)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_CONNECTION_POINT_MAP(CAPI)
	CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
	CONNECTION_POINT_ENTRY(DIID__IAPIEvents)
END_CONNECTION_POINT_MAP()

BEGIN_MSG_MAP(CAPI)
	MESSAGE_HANDLER( WM_CREATE, OnCreate )
	MESSAGE_HANDLER( WM_DESTROY, OnDestroy )
	MESSAGE_HANDLER( WM_HIBERNATE, OnHibernate )
	MESSAGE_HANDLER( WM_SYSCOLORCHANGE, OnColorChange )
	MESSAGE_HANDLER( WM_FONTCHANGE, OnFontChange )
	MESSAGE_HANDLER( WM_PALETTECHANGED, OnPaletteChange )
	MESSAGE_HANDLER( WM_SETTINGCHANGE, OnSettingChange )
	CHAIN_MSG_MAP(CComControl<CAPI>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// IAPI
public:
	STDMETHOD(get_WindowParent)(long lWnd, /*[out, retval]*/ long *pVal);
	STDMETHOD(put_WindowParent)(long lWnd, /*[in]*/ long newVal);
	STDMETHOD(get_LocalTime)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_LocalTime)(/*[in]*/ VARIANT *newVal);
	STDMETHOD(get_SystemTime)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_SystemTime)(/*[in]*/ VARIANT *newVal);
	STDMETHOD(get_Ticks)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_WindowLong)(long lWnd, long lPos, /*[out, retval]*/ long *pVal);
	STDMETHOD(put_WindowLong)(long lWnd, long lPos, /*[in]*/ long newVal);
	STDMETHOD(get_SystemVersion)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_CursorPos)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_ClipText)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_ClipText)(/*[in]*/ BSTR newVal);
	STDMETHOD(FindWindowByClass)(BSTR bClass, long *lRet);
	STDMETHOD(get_GetShortcutTarget)(BSTR bTarget, /*[out, retval]*/ BSTR *pVal);
	STDMETHOD(GetSpecialFolder)(long lType, BSTR *pRet);
	STDMETHOD(AddToRecent)(BSTR bPath);
	STDMETHOD(CreateShortcut)(BSTR bShortcut, BSTR bTarget);
	STDMETHOD(get_SystemParameters)(long lType, /*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_SystemParameters)(long lType, /*[in]*/ VARIANT *newVal);
	STDMETHOD(GetPowerStatus)(long lType, long *pRet);
	STDMETHOD(GetStorageStatus)(long lType, long *pRet);
	STDMETHOD(GetMemoryStatus)(long lType, long *pRet);
	STDMETHOD(SendKeys)(BSTR bText, long lSilent);
	STDMETHOD(GetAsyncKeyState)(long lKey, long *plRet);
	STDMETHOD(showWindow)(long lWnd, long lFlag);
	STDMETHOD(get_ClassName)(long lWnd, /*[out, retval]*/ BSTR *pVal);
	STDMETHOD(get_GetWindow)(long lWnd, long lType, /*[out, retval]*/ long *pVal);
	STDMETHOD(put_Topmost)(long lWnd, /*[in]*/ long newVal);
	STDMETHOD(get_SystemColor)(long lType, /*[out, retval]*/ long *pVal);
	STDMETHOD(put_SystemColor)(long lType, /*[in]*/ long newVal);
	STDMETHOD(get_WindowText)(long lWnd, /*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_WindowText)(long lWnd, /*[in]*/ BSTR newVal);
	STDMETHOD(get_EnableKeyboard)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_EnableKeyboard)(/*[in]*/ long newVal);
	STDMETHOD(get_Capture)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Capture)(/*[in]*/ long newVal);
	STDMETHOD(get_Focus)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Focus)(/*[in]*/ long newVal);
	STDMETHOD(get_ForegroundWindow)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_ForegroundWindow)(/*[in]*/ long newVal);
	STDMETHOD(PostMessage)(long lWnd, long lMsg, long wParam, long lParam, long *plRet);
	STDMETHOD(ChildWindowFromPoint)(long lWnd, long lXpos, long lYpos, long *plRet);
	STDMETHOD(WindowFromPoint)(long lXpos, long lYpos, long *plRet);
	STDMETHOD(SendMessageText)(long lWnd, long lMsg, long wParam, BSTR bText, long *plRet);
	STDMETHOD(SendMessage)(long lWnd, long lMsg, long wParam, long lParam, long *plRet);
	STDMETHOD(ReleaseCapture)();
	STDMETHOD(FindWindow)(BSTR bTitle, long *plRet);

	HRESULT OnCreate( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		WNDCLASS wc;

		memset( &wc, 0, sizeof(WNDCLASS) );
		wc.hInstance = _Module.m_hInst;
		wc.lpszClassName = L"MGCEAPINot";
		wc.hbrBackground = (HBRUSH)( COLOR_WINDOW + 1 );
		wc.lpfnWndProc = NotifyWndProc;
		wc.cbWndExtra = sizeof(DWORD);
		if( ! ::RegisterClass( &wc ) ) {
			bHandled = TRUE;
			return E_FAIL;
		}
		hNotify = ::CreateWindow( L"MGCEAPINot", NULL, WS_POPUP,
								  0, 0, 0, 0, NULL, NULL, _Module.m_hInst, NULL );
		if( hNotify ) ::SetWindowLong( hNotify, 0, (DWORD)this->m_hWnd );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnDestroy( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		if( hNotify ) ::DestroyWindow( hNotify );
		UnregisterClass( L"MGCEAPINot", _Module.m_hInst );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnHibernate( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		bHandled = TRUE;
		Fire_Hibernate();
		return S_OK;
	}

	HRESULT OnColorChange( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		bHandled = TRUE;
		Fire_ColorChange();
		return S_OK;
	}

	HRESULT OnFontChange( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		bHandled = TRUE;
		Fire_FontChange();
		return S_OK;
	}

	HRESULT OnPaletteChange( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		bHandled = TRUE;
		Fire_PaletteChange();
		return S_OK;
	}

	HRESULT OnSettingChange( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		bHandled = TRUE;
		Fire_SettingsChange( wParam );
		return S_OK;
	}

	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		return S_OK;
	}
private:
	HWND hNotify;
};

#endif //__API_H_
