// API.cpp : Implementation of CAPI

#include "stdafx.h"
#include "MGCEWin32.h"
#include "keybd.h"
#include "shlobj.h"
#include "API.h"

/////////////////////////////////////////////////////////////////////////////
// CAPI

STDMETHODIMP CAPI::FindWindow(BSTR bTitle, long *plRet)
{
	*plRet = (long)::FindWindow( NULL, bTitle );
	SysFreeString( bTitle );
	return S_OK;
}

STDMETHODIMP CAPI::ReleaseCapture()
{
	::ReleaseCapture();
	return S_OK;
}

STDMETHODIMP CAPI::SendMessage(long lWnd, long lMsg, long wParam, long lParam, long *plRet)
{
	if( ! ::IsWindow( (HWND)lWnd ) ) {
		Error( L"Specified window does not exist" );
		return E_FAIL;
	}
	*plRet = ::SendMessage( (HWND)lWnd, lMsg, wParam, lParam );
	return S_OK;
}

STDMETHODIMP CAPI::SendMessageText(long lWnd, long lMsg, long wParam, BSTR bText, long *plRet)
{
	if( ! ::IsWindow( (HWND)lWnd ) ) {
		Error( L"Specified window does not exist" );
		return E_FAIL;
	}
	*plRet = ::SendMessage( (HWND)lWnd, lMsg, wParam, (LPARAM)bText );
	SysFreeString( bText );
	return S_OK;
}

STDMETHODIMP CAPI::WindowFromPoint(long lXpos, long lYpos, long *plRet)
{
	POINT pt;

	pt.x = lXpos;
	pt.y = lYpos;
	*plRet = (LONG)::WindowFromPoint( pt );
	return S_OK;
}

STDMETHODIMP CAPI::ChildWindowFromPoint(long lWnd, long lXpos, long lYpos, long *plRet)
{
	POINT pt;

	if( ! ::IsWindow( (HWND)lWnd ) ) {
		Error( L"Specified window does not exist" );
		return E_FAIL;
	}
	pt.x = lXpos;
	pt.y = lYpos;
	*plRet = (LONG)::ChildWindowFromPoint( (HWND)lWnd, pt );
	return S_OK;
}

STDMETHODIMP CAPI::PostMessage(long lWnd, long lMsg, long wParam, long lParam, long *plRet)
{
	if( ! ::IsWindow( (HWND)lWnd ) ) {
		Error( L"Specified window does not exist" );
		return E_FAIL;
	}
	*plRet = ::PostMessage( (HWND)lWnd, lMsg, wParam, lParam );
	return S_OK;
}

STDMETHODIMP CAPI::get_ForegroundWindow(long *pVal)
{
	*pVal = (long)::GetForegroundWindow();
	return S_OK;
}

STDMETHODIMP CAPI::put_ForegroundWindow(long newVal)
{
	if( ! ::IsWindow( (HWND)newVal ) ) {
		Error( L"Specified window does not exist" );
		return E_FAIL;
	}
	::SetForegroundWindow( (HWND)newVal );
	return S_OK;
}

STDMETHODIMP CAPI::get_Focus(long *pVal)
{
	*pVal = (long)::GetFocus();
	return S_OK;
}

STDMETHODIMP CAPI::put_Focus(long newVal)
{
	if( ! ::IsWindow( (HWND)newVal ) ) {
		Error( L"Specified window does not exist" );
		return E_FAIL;
	}
	::SetFocus( (HWND)newVal );
	return S_OK;
}

STDMETHODIMP CAPI::get_Capture(long *pVal)
{
	*pVal = (long)::GetCapture();
	return S_OK;
}

STDMETHODIMP CAPI::put_Capture(long newVal)
{
	if( ! ::IsWindow( (HWND)newVal ) ) {
		Error( L"Specified window does not exist" );
		return E_FAIL;
	}
	::SetCapture( (HWND)newVal );
	return S_OK;
}

STDMETHODIMP CAPI::get_EnableKeyboard(long *pVal)
{
	DWORD dwVal;

	dwVal = ::GetKeyboardStatus();
	if( ! ( dwVal & KBDI_KEYBOARD_ENABLED ) )   *pVal = 0;
	else *pVal = 1;
	return S_OK;
}

STDMETHODIMP CAPI::put_EnableKeyboard(long newVal)
{
	::EnableHardwareKeyboard( newVal );
	return S_OK;
}


STDMETHODIMP CAPI::get_WindowText(long lWnd, BSTR *pVal)
{
	TCHAR szStr[ 256 ];

	if( ! ::IsWindow( (HWND)lWnd ) ) {
		Error( L"Specified window does not exist" );
		return E_FAIL;
	}
	::GetWindowText( (HWND)lWnd, szStr, 256 );
	*pVal = SysAllocString( szStr );
	return S_OK;
}

STDMETHODIMP CAPI::put_WindowText(long lWnd, BSTR newVal)
{
	if( ! ::IsWindow( (HWND)lWnd ) ) {
		Error( L"Specified window does not exist" );
		SysFreeString( newVal );
		return E_FAIL;
	}
	::SetWindowText( (HWND)lWnd, newVal );
	SysFreeString( newVal );
	return S_OK;
}

STDMETHODIMP CAPI::get_SystemColor(long lType, long *pVal)
{
	*pVal = ::GetSysColor( lType + 0x40000000 );
	return S_OK;
}

STDMETHODIMP CAPI::put_SystemColor(long lType, long newVal)
{
	lType += 0x40000000;
	::SetSysColors( 1, (const int *)&lType, (DWORD *)&newVal );
	return S_OK;
}

STDMETHODIMP CAPI::put_Topmost(long lWnd, long newVal)
{
	if( ! ::IsWindow( (HWND)lWnd ) ) {
		Error( L"Specified window does not exist" );
		return E_FAIL;
	}
	if( newVal )
		::SetWindowPos( (HWND)lWnd, HWND_TOPMOST, 0, 0, 0, 0,
						SWP_NOMOVE | SWP_NOSIZE );
	else
		::SetWindowPos( (HWND)lWnd, HWND_NOTOPMOST, 0, 0, 0, 0,
						SWP_NOMOVE | SWP_NOSIZE );
	return S_OK;
}

STDMETHODIMP CAPI::get_GetWindow(long lWnd, long lType, long *pVal)
{
	*pVal = (long)::GetWindow( (HWND)lWnd, lType );
	return S_OK;
}

STDMETHODIMP CAPI::get_ClassName(long lWnd, BSTR *pVal)
{
	TCHAR szStr[ 256 ];

	if( ! ::IsWindow( (HWND)lWnd ) ) {
		Error( L"Specified window does not exist" );
		return E_FAIL;
	}
	::GetClassName( (HWND)lWnd, szStr, 256 );
	*pVal = SysAllocString( szStr );
	return S_OK;
}


STDMETHODIMP CAPI::showWindow(long lWnd, long lFlag)
{
	if( ! ::IsWindow( (HWND)lWnd ) ) {
		Error( L"Specified window does not exist" );
		return E_FAIL;
	}
	::ShowWindow( (HWND)lWnd, lFlag );
	return S_OK;
}


STDMETHODIMP CAPI::GetAsyncKeyState(long lKey, long *plRet)
{
	*plRet = ::GetAsyncKeyState( lKey );
	return S_OK;
}


STDMETHODIMP CAPI::SendKeys(BSTR bText, long lSilent)
{
	int iLen, i;
	DWORD dwFlags, dwOrig;
	BYTE ch;
	MSG mmsg;
	BOOL bShift, bCtrl, bAlt;


	iLen = wcslen( bText );
	if( ! iLen ) {
		Error( L"Cannot send an empty string" );
		return E_FAIL;
	}
	if( lSilent )  dwOrig = KEYEVENTF_SILENT;
	else		   dwOrig = 0;
	bShift = bCtrl = bAlt = FALSE;

	for( i = 0; i < iLen; i++ ) {
		ch = (BYTE)*( bText + i );
		dwFlags = dwOrig;
		if( ch == 16 ) {
			if( bShift ) {
				bShift = FALSE;
				dwFlags |= KEYEVENTF_KEYUP;
			} else bShift = TRUE;
		}
		if( ch == 17 ) {
			if( bCtrl ) {
				bCtrl = FALSE;
				dwFlags |= KEYEVENTF_KEYUP;
			} else bCtrl = TRUE;
		}
		if( ch == 18 ) {
			if( bAlt ) {
				bAlt = FALSE;
				dwFlags |= KEYEVENTF_KEYUP;
			} else bAlt = TRUE;
		}
		keybd_event( ch, 0, dwFlags, 0 );

		while( ::PeekMessage( &mmsg, NULL, 0, 0, PM_NOREMOVE ) ) {
			::GetMessage( &mmsg, NULL, 0, 0 );
			::TranslateMessage( &mmsg );
			::DispatchMessage( &mmsg );
		}
	}
	return S_OK;
}

STDMETHODIMP CAPI::GetMemoryStatus(long lType, long *pRet)
{
	MEMORYSTATUS ms;

	if( lType > 7 ) {
		Error( L"Status type is out of range" );
		return E_FAIL;
	}
	GlobalMemoryStatus( &ms );
	if( lType == 0 )  *pRet = ms.dwTotalPhys;
	if( lType == 1 )  *pRet = ms.dwAvailPhys;
	if( lType == 2 )  *pRet = ms.dwTotalPageFile;
	if( lType == 3 )  *pRet = ms.dwAvailPageFile;
	if( lType == 4 )  *pRet = ms.dwTotalVirtual;
	if( lType == 5 )  *pRet = ms.dwAvailVirtual;
	if( lType == 6 )  *pRet = ms.dwMemoryLoad;
	return S_OK;
}

STDMETHODIMP CAPI::GetStorageStatus(long lType, long *pRet)
{
	STORE_INFORMATION si;

	if( lType > 1 ) {
		Error( L"Status type is out of range" );
		return E_FAIL;
	}
	GetStoreInformation( &si );
	if( lType == 0 ) *pRet = si.dwStoreSize;
	if( lType == 1 ) *pRet = si.dwFreeSize;
	return S_OK;
}

STDMETHODIMP CAPI::GetPowerStatus(long lType, long *pRet)
{
	SYSTEM_POWER_STATUS_EX sps;

	if( lType > 8 ) {
		Error( L"Status type is out of range" );
		return E_FAIL;
	}
	GetSystemPowerStatusEx( &sps, TRUE );
	if( lType == 0 )  *pRet = (long)sps.ACLineStatus;
	if( lType == 1 )  *pRet = (long)sps.BatteryFlag;
	if( lType == 2 )  *pRet = (long)sps.BatteryLifePercent;
	if( lType == 3 )  *pRet = (long)sps.BatteryLifeTime;
	if( lType == 4 )  *pRet = (long)sps.BatteryFullLifeTime;
	if( lType == 5 )  *pRet = (long)sps.BackupBatteryFlag;
	if( lType == 6 )  *pRet = (long)sps.BackupBatteryLifePercent;
	if( lType == 7 )  *pRet = (long)sps.BackupBatteryLifeTime;
	if( lType == 8 )  *pRet = (long)sps.BackupBatteryFullLifeTime;
	return S_OK;
}

STDMETHODIMP CAPI::get_SystemParameters(long lType, VARIANT *pVal)
{
	if( lType >= 0 && lType < 6 ) {
		if( lType == 0 ) lType = SPI_GETWORKAREA;
		if( lType == 1 ) lType = SPI_GETWAKEUPIDLETIMEOUT;
		if( lType == 2 ) lType = SPI_GETEXTERNALIDLETIMEOUT;
		if( lType == 3 ) lType = SPI_GETBATTERYIDLETIMEOUT;
		if( lType == 4 ) lType = SPI_GETPLATFORMTYPE;
		if( lType == 5 ) lType = SPI_GETOEMINFO;
		if( lType == SPI_GETPLATFORMTYPE || lType == SPI_GETOEMINFO ) {
			TCHAR szStr[ 256 ];
			SystemParametersInfo( lType, 256, szStr, 0 );
			V_VT( pVal ) = VT_BSTR;
			V_BSTR( pVal ) = SysAllocString( szStr );
			return S_OK;
		} else {
			DWORD dwVal;
			SystemParametersInfo( lType, 0, &dwVal, 0 );
			V_VT( pVal ) = VT_UI4;
			V_UI4( pVal ) = dwVal;
			return S_OK;
		}
	}
	Error( L"Status type is out of range" );
	return E_FAIL;
}

STDMETHODIMP CAPI::put_SystemParameters(long lType, VARIANT *newVal)
{
	if( lType >= 0 && lType < 4 ) {
		if( lType == 0 ) lType = SPI_SETWORKAREA;
		if( lType == 1 ) lType = SPI_SETWAKEUPIDLETIMEOUT;
		if( lType == 2 ) lType = SPI_SETEXTERNALIDLETIMEOUT;
		if( lType == 3 ) lType = SPI_SETBATTERYIDLETIMEOUT;
		SystemParametersInfo( lType, V_UI4( newVal ), NULL, 0 );
		return S_OK;
	}
	Error( L"Status type is out of range" );
	return E_FAIL;
}

STDMETHODIMP CAPI::CreateShortcut(BSTR bShortcut, BSTR bTarget)
{
	::SHCreateShortcut( bShortcut, bTarget );
	SysFreeString( bShortcut );
	SysFreeString( bTarget );
	return S_OK;
}

STDMETHODIMP CAPI::AddToRecent(BSTR bPath)
{
	::SHAddToRecentDocs( SHARD_PATH, bPath );
	SysFreeString( bPath );
	return S_OK;
}

STDMETHODIMP CAPI::GetSpecialFolder(long lType, BSTR *pRet)
{
	LPITEMIDLIST ppidl;
	LPMALLOC lm;
	TCHAR szPath[ MAX_PATH + 1 ];
	BOOL bStatus;


	SHGetSpecialFolderLocation( this->m_hWnd, lType, &ppidl );
	if( ! ppidl ) {
		Error( L"Unable to locate folder for specified type" );
		return E_FAIL;
	}
	SHGetMalloc( &lm );
	bStatus = SHGetPathFromIDList( ppidl, szPath );
	lm->Free( ppidl );
	if( ! bStatus ) {
		Error( L"Unable to match path to folder ID" );
		return E_FAIL;
	}
	*pRet = SysAllocString( szPath );
	return S_OK;
}


STDMETHODIMP CAPI::get_GetShortcutTarget(BSTR bTarget, BSTR *pVal)
{
	TCHAR szStr[ 300 ];
	
	szStr[ 0 ] = L'\0';
	if( ! ::SHGetShortcutTarget( bTarget, szStr, 300 ) ) {
		SysFreeString( bTarget );
		Error( L"Unable to locate specified shortcut" );
		return E_FAIL;
	}
	SysFreeString( bTarget );
	*pVal = SysAllocString( szStr );
	return S_OK;
}

STDMETHODIMP CAPI::FindWindowByClass(BSTR bClass, long *lRet)
{
	*lRet = (long)::FindWindow( bClass, NULL );
	SysFreeString( bClass );
	return S_OK;
}

STDMETHODIMP CAPI::get_ClipText(BSTR *pVal)
{
	HANDLE hData;
	BSTR pszData;
	HRESULT hr;

	hr = E_FAIL;
	if( ::OpenClipboard( this->m_hWnd ) ) {
		hData = ::GetClipboardData( CF_UNICODETEXT );
		if( hData ) {
			pszData = (BSTR)LocalLock( hData );
			if( pszData ) {
				*pVal = SysAllocString( pszData );
				LocalUnlock( hData );
				::CloseClipboard();
				hr = S_OK;
			}
		}
		::CloseClipboard();
	}
	return hr;
}

STDMETHODIMP CAPI::put_ClipText(BSTR newVal)
{
	HANDLE hData;
	BSTR pszData;

	if( ::OpenClipboard( this->m_hWnd ) ) {
		hData = LocalAlloc( LPTR, ( wcslen( newVal ) + 4 ) * sizeof(TCHAR) );
		if( hData ) {
			pszData = (BSTR)LocalLock( hData );
			if( pszData ) {
				wcscpy( pszData, newVal );
				LocalUnlock( hData );
				::EmptyClipboard();
				::SetClipboardData( CF_UNICODETEXT, hData );
				::CloseClipboard();
				SysFreeString( newVal );
				return S_OK;
			}
			LocalUnlock( hData );
			LocalFree( hData );
		}
		::CloseClipboard();
	}
	SysFreeString( newVal );
	return E_FAIL;
}


STDMETHODIMP CAPI::get_Version(long *pVal)
{
	*pVal = 105;
	return S_OK;
}

STDMETHODIMP CAPI::get_CursorPos(VARIANT *pVal)
{
	DWORD dwVal;
	SAFEARRAY *psa;
	VARIANT *pV;


	dwVal = ::GetMessagePos();
	psa = SafeArrayCreateVector( VT_VARIANT, 1, 2 );
	if( ! psa ) return E_OUTOFMEMORY;
	pV = (VARIANT *)psa->pvData;
	V_I4( pV ) = LOWORD( dwVal );
	V_VT( pV ) = VT_I4;
	++pV;
	V_I4( pV ) = HIWORD( dwVal );
	V_VT( pV ) = VT_I4;
	V_ARRAY( pVal ) = psa;
	V_VT( pVal ) = VT_VARIANT | VT_ARRAY;
	return S_OK;
}

STDMETHODIMP CAPI::get_SystemVersion(long *pVal)
{
	OSVERSIONINFO ovi;

	memset( &ovi, 0, sizeof(OSVERSIONINFO) );
	ovi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx( &ovi );
	*pVal = MAKELONG( LOWORD( ovi.dwMinorVersion ), LOWORD( ovi.dwMajorVersion ) );
	return S_OK;
}

STDMETHODIMP CAPI::get_WindowLong(long lWnd, long lPos, long *pVal)
{
	if( ! ::IsWindow( (HWND)lWnd ) ) {
		Error( L"Specified window does not exist" );
		return E_INVALIDARG;
	}
	*pVal = ::GetWindowLong( (HWND)lWnd, lPos );
	return S_OK;
}

STDMETHODIMP CAPI::put_WindowLong(long lWnd, long lPos, long newVal)
{
	if( ! ::IsWindow( (HWND)lWnd ) ) {
		Error( L"Specified window does not exist" );
		return E_INVALIDARG;
	}
	::SetWindowLong( (HWND)lWnd, lPos, newVal );
	return S_OK;
}

STDMETHODIMP CAPI::get_Ticks(long *pVal)
{
	*pVal = GetTickCount();
	return S_OK;
}

STDMETHODIMP CAPI::get_SystemTime(VARIANT *pVal)
{
	SYSTEMTIME st;

	VariantInit( pVal );
	GetSystemTime( &st );
	SystemTimeToVariantTime( &st, &pVal->dblVal );
	V_VT( pVal ) = VT_DATE;
	return S_OK;
}

STDMETHODIMP CAPI::put_SystemTime(VARIANT *newVal)
{
	SYSTEMTIME st;

	if( ! VariantTimeToSystemTime( newVal->dblVal, &st ) ) {
		Error( L"Invalid date or time specified" );
		return E_FAIL;
	}
	SetSystemTime( &st );
	VariantClear( newVal );
	return S_OK;
}

STDMETHODIMP CAPI::get_LocalTime(VARIANT *pVal)
{
	SYSTEMTIME st;

	VariantInit( pVal );
	GetLocalTime( &st );
	SystemTimeToVariantTime( &st, &pVal->dblVal );
	V_VT( pVal ) = VT_DATE;
	return S_OK;
}

STDMETHODIMP CAPI::put_LocalTime(VARIANT *newVal)
{
	SYSTEMTIME st;

	if( ! VariantTimeToSystemTime( newVal->dblVal, &st ) ) {
		Error( L"Invalid date or time specified" );
		return E_FAIL;
	}
	SetLocalTime( &st );
	VariantClear( newVal );
	return S_OK;
}

STDMETHODIMP CAPI::get_WindowParent(long lWnd, long *pVal)
{
	*pVal = (long)::GetParent( (HWND)lWnd );
	return S_OK;
}

STDMETHODIMP CAPI::put_WindowParent(long lWnd, long newVal)
{
	if( ! ::IsWindow( (HWND)lWnd ) ) {
		Error( L"Specified child window does not exist" );
		return E_FAIL;
	}
	if( ! ::IsWindow( (HWND)newVal ) ) {
		Error( L"Specified window does not exist" );
		return E_FAIL;
	}
	::SetParent( (HWND)lWnd, (HWND)newVal );
	return S_OK;
}
