// TreeView.h : Declaration of the CTreeView

#ifndef __TREEVIEW_H_
#define __TREEVIEW_H_

#include "resource.h"       // main symbols
#include <atlctl.h>
#include "commctrl.h"
#include "MGCETreeViewCP.h"

#define WM_EDITMSG   (WM_USER+4000)
#define WM_GETMENU   (WM_USER+4001)
#define WM_MENUITEM  (WM_USER+4002)
LRESULT WINAPI EditSubProc( HWND, UINT, WPARAM, LPARAM );
LRESULT WINAPI NewTreeProc( HWND, UINT, WPARAM, LPARAM );

/////////////////////////////////////////////////////////////////////////////
// CTreeView
class ATL_NO_VTABLE CTreeView : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<ITreeView, &IID_ITreeView, &LIBID_MGCETREEVIEWLib>,
	public CComControl<CTreeView>,
	public IPersistStreamInitImpl<CTreeView>,
	public IOleControlImpl<CTreeView>,
	public IOleObjectImpl<CTreeView>,
	public IOleInPlaceActiveObjectImpl<CTreeView>,
	public IViewObjectExImpl<CTreeView>,
	public IOleInPlaceObjectWindowlessImpl<CTreeView>,
	public IConnectionPointContainerImpl<CTreeView>,
	public IPersistStorageImpl<CTreeView>,
	public ISpecifyPropertyPagesImpl<CTreeView>,
	public IQuickActivateImpl<CTreeView>,
	public IDataObjectImpl<CTreeView>,
	public IProvideClassInfo2Impl<&CLSID_TreeView, &DIID__ITreeViewEvents, &LIBID_MGCETREEVIEWLib>,
	public IPropertyNotifySinkCP<CTreeView>,
	public CComCoClass<CTreeView, &CLSID_TreeView>,
	public CProxy_ITreeViewEvents< CTreeView >
{
public:
	CTreeView()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_TREEVIEW)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CTreeView)
	COM_INTERFACE_ENTRY(ITreeView)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()

BEGIN_PROP_MAP(CTreeView)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_CONNECTION_POINT_MAP(CTreeView)
	CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
	CONNECTION_POINT_ENTRY(DIID__ITreeViewEvents)
END_CONNECTION_POINT_MAP()

BEGIN_MSG_MAP(CTreeView)
	MESSAGE_HANDLER( WM_CREATE, OnCreate )
	MESSAGE_HANDLER( WM_DESTROY, OnDestroy )
	MESSAGE_HANDLER( WM_SETFOCUS, OnFocus )
	MESSAGE_HANDLER( WM_KILLFOCUS, OnFocus )
	MESSAGE_HANDLER( WM_NOTIFY, OnNotify )
	MESSAGE_HANDLER( WM_EDITMSG, OnEditMsg )
	MESSAGE_HANDLER( WM_GETMENU, OnGetMenu )
	MESSAGE_HANDLER( WM_MENUITEM, OnMenuItem )
	CHAIN_MSG_MAP(CComControl<CTreeView>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// ITreeView
public:
	STDMETHOD(get_hWnd)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Style)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Style)(/*[in]*/ long newVal);
	STDMETHOD(ClearContext)();
	STDMETHOD(RemoveContextItem)(long lIndex);
	STDMETHOD(AddContextItem)(BSTR bText);
	STDMETHOD(get_FontBold)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_FontBold)(/*[in]*/ long newVal);
	STDMETHOD(get_FontSize)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_FontSize)(/*[in]*/ long newVal);
	STDMETHOD(get_FontName)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_FontName)(/*[in]*/ BSTR newVal);
	STDMETHOD(EndEdit)(long lDeny);
	STDMETHOD(StartEdit)(long lItem, long *pEdit);
	STDMETHOD(get_TreePath)(long lItem, /*[out, retval]*/ BSTR *pVal);
	STDMETHOD(get_AutoExpand)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_AutoExpand)(/*[in]*/ long newVal);
	STDMETHOD(get_SelectionDisplay)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_SelectionDisplay)(/*[in]*/ long newVal);
	STDMETHOD(get_AllowEventAsDefault)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_AllowEventAsDefault)(/*[in]*/ long newVal);
	STDMETHOD(put_AllowEvent)(/*[in]*/ long newVal);
	STDMETHOD(Hide)();
	STDMETHOD(Show)();
	STDMETHOD(SetFocus)();
	STDMETHOD(get_Tabstop)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Tabstop)(/*[in]*/ long newVal);
	STDMETHOD(get_AllowEdit)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_AllowEdit)(/*[in]*/ long newVal);
	STDMETHOD(get_Select)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Select)(/*[in]*/ long newVal);
	STDMETHOD(get_FirstVisible)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_FirstVisible)(/*[in]*/ long newVal);
	STDMETHOD(get_PreviousVisible)(long lItem, /*[out, retval]*/ long *pVal);
	STDMETHOD(get_NextVisible)(long lItem, /*[out, retval]*/ long *pVal);
	STDMETHOD(get_PreviousSibling)(long lItem, /*[out, retval]*/ long *pVal);
	STDMETHOD(get_NextSibling)(long lItem, /*[out, retval]*/ long *pVal);
	STDMETHOD(get_Parent)(long lItem, /*[out, retval]*/ long *pVal);
	STDMETHOD(get_Child)(long lItem, /*[out, retval]*/ long *pVal);
	STDMETHOD(get_Indent)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Indent)(/*[in]*/ long newVal);
	STDMETHOD(get_ItemValue)(long lItem, /*[out, retval]*/ long *pVal);
	STDMETHOD(put_ItemValue)(long lItem, /*[in]*/ long newVal);
	STDMETHOD(get_ItemSelectedImage)(long lItem, /*[out, retval]*/ long *pVal);
	STDMETHOD(put_ItemSelectedImage)(long lItem, /*[in]*/ long newVal);
	STDMETHOD(get_ItemImage)(long lItem, /*[out, retval]*/ long *pVal);
	STDMETHOD(put_ItemImage)(long lItem, /*[in]*/ long newVal);
	STDMETHOD(get_ItemText)(long lItem, /*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_ItemText)(long lItem, /*[in]*/ BSTR newVal);
	STDMETHOD(get_FirstItem)(/*[out, retval]*/ long *pVal);
	STDMETHOD(MakeVisible)(long lItem);
	STDMETHOD(ToggleItem)(long lItem);
	STDMETHOD(CollapseItem)(long lItem);
	STDMETHOD(ExpandItem)(long lItem);
	STDMETHOD(get_RootLines)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_RootLines)(/*[in]*/ long newVal);
	STDMETHOD(DeleteItem)(long lItem);
	STDMETHOD(get_Count)(/*[out, retval]*/ long *pVal);
	STDMETHOD(Clear)();
	STDMETHOD(get_Border)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Border)(/*[in]*/ long newVal);
	STDMETHOD(get_HasButtons)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_HasButtons)(/*[in]*/ long newVal);
	STDMETHOD(get_HasLines)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_HasLines)(/*[in]*/ long newVal);
	STDMETHOD(AddItem)(long lParent, long lInsertAfter, BSTR bText, long lParam, long lImage, long lSelectedImage, long *pRet);
	STDMETHOD(get_UseSelectedImages)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_UseSelectedImages)(/*[in]*/ long newVal);
	STDMETHOD(get_UseImages)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_UseImages)(/*[in]*/ long newVal);
	STDMETHOD(RemoveImage)(long lIndex);
	STDMETHOD(AddImage)(BSTR bFilename);

	HRESULT OnCreate( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		RECT Rect;
		LOGFONT lf;

		GetClientRect( &Rect );
		InitCommonControls();
		hTreeView = ::CreateWindowEx( 0, WC_TREEVIEW, NULL, WS_TABSTOP | TVS_SHOWSELALWAYS |
									WS_VISIBLE | WS_CHILD | TVS_HASLINES |
									TVS_LINESATROOT | TVS_HASBUTTONS,
								    1, 1, Rect.right - 2, Rect.bottom - 2,
								    this->m_hWnd, NULL, _Module.m_hInst, NULL );
		hMenu = ::CreatePopupMenu();
		lLastMenuID = 1000;

		::SetWindowLong( hTreeView, GWL_WNDPROC, (DWORD)NewTreeProc );
		bFontName = SysAllocString( L"Arial" );
		lFontSize = 12;
		lFontBold = 0;
		memset( &lf, 0, sizeof(LOGFONT) );
		wcscpy( lf.lfFaceName, bFontName );
		lf.lfHeight = lFontSize;
		if( lFontBold ) lf.lfWeight = 700;
		else lf.lfWeight = 400;
		hFont = ::CreateFontIndirect( &lf );
		::SendMessage( hTreeView, WM_SETFONT, (WPARAM)hFont, FALSE );

		hImageList = ImageList_Create( 16, 16, ILC_COLOR, 0, 32 );
		lUseImages = lUseSelectedImages = lBorder = 1;
		lLastEventReturnValue = lDefaultEventReturnValue = 0;
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnDestroy( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		::DestroyWindow( hTreeView );
		ImageList_Destroy( hImageList );
		::DeleteObject( hFont );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		RECT Rect;
		HPEN hPen;

		GetClientRect( &Rect );
		if( lBorder ) {
			hPen = CreatePen( PS_SOLID, 1, RGB( 0, 0, 0 ) );
			hPen = (HPEN)::SelectObject( di.hdcDraw, hPen );
			::Rectangle( di.hdcDraw, 0, 0, Rect.right, Rect.bottom );
			::DeleteObject( (HPEN)::SelectObject( di.hdcDraw, hPen ) );
		}
		return S_OK;
	}

	HRESULT OnFocus( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		::SendMessage( hTreeView, msg, wParam, lParam );
		bHandled = TRUE;
		return S_OK;
	}


	HRESULT OnGetMenu( UINT msg, WPARAM wParam, LPARAM lParam, BOOL &bHandled )
	{
		bHandled = (BOOL)hMenu;
		return (DWORD)hMenu;
	}

	HRESULT OnMenuItem( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		MENUITEMINFO mmi;
		TV_HITTESTINFO hti;
		HTREEITEM hItem;
		TCHAR szStr[ 128 ];

		memset( &mmi, 0, sizeof(MENUITEMINFO) );
		mmi.cbSize = sizeof(MENUITEMINFO);
		mmi.fMask = MIIM_TYPE;
		mmi.dwTypeData = szStr;
		mmi.cch = 256;
		if( ::GetMenuItemInfo( hMenu, lParam, FALSE, &mmi ) ) {
			hti.pt.x = LOWORD( wParam );
			hti.pt.y = HIWORD( wParam );
			hItem = TreeView_HitTest( hTreeView, &hti );
			Fire_ContextMenu( (long)hItem, szStr );
		}
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnEditMsg( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		HTREEITEM hItem;
		LONG lRetVal;
		TCHAR szStr[ 300 ];
		TV_ITEM tvi;

		if( wParam == 13 ) {
			hItem = TreeView_GetSelection( hTreeView );
			::GetWindowText( (HWND)lParam, szStr, 300 );
			Fire_EndEdit( (long)hItem, SysAllocString( szStr ) );
			lRetVal = lLastEventReturnValue;
			lLastEventReturnValue = lDefaultEventReturnValue;
			if( ! lRetVal ) {
				TreeView_EndEditLabelNow( hTreeView, FALSE );
				tvi.mask = TVIF_TEXT;
				tvi.pszText = szStr;
				tvi.cchTextMax = wcslen( szStr );
				tvi.hItem = hItem;
				TreeView_SetItem( hTreeView, &tvi );
			}
			else TreeView_EndEditLabelNow( hTreeView, TRUE );
		} else TreeView_EndEditLabelNow( hTreeView, TRUE );
		bHandled = TRUE;
		return TRUE;
	}

	HRESULT OnNotify( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		NMHDR *pnm = (NMHDR *)lParam;

		if( pnm->code == TVN_SELCHANGING || pnm->code == TVN_SELCHANGED ) {
			NM_TREEVIEW *pntv = (NM_TREEVIEW *)lParam;
			long lRetVal;

			if( pntv->hdr.code == TVN_SELCHANGING )
				Fire_Changing( (long)pntv->itemOld.hItem, (long)pntv->itemNew.hItem );
			else
				Fire_Changed( (long)pntv->itemOld.hItem, (long)pntv->itemNew.hItem );
			lRetVal = lLastEventReturnValue;
			lLastEventReturnValue = lDefaultEventReturnValue;
			bHandled = lRetVal;
			return TRUE;
		}

		if( pnm->code == TVN_ITEMEXPANDING || pnm->code == TVN_ITEMEXPANDED ) {
			NM_TREEVIEW *pntv = (NM_TREEVIEW *)lParam;
			long lRetVal;

			if( pntv->hdr.code == TVN_ITEMEXPANDING && pntv->action == TVE_EXPAND )
				Fire_Expanding( (long)pntv->itemNew.hItem );
			if( pntv->hdr.code == TVN_ITEMEXPANDING && pntv->action == TVE_EXPAND )
				Fire_Expanded( (long)pntv->itemNew.hItem );
			if( pntv->hdr.code == TVN_ITEMEXPANDING && pntv->action == TVE_COLLAPSE )
				Fire_Collapsing( (long)pntv->itemNew.hItem );
			if( pntv->hdr.code == TVN_ITEMEXPANDING && pntv->action == TVE_COLLAPSE )
				Fire_Collapsed( (long)pntv->itemNew.hItem );
			lRetVal = lLastEventReturnValue;
			lLastEventReturnValue = lDefaultEventReturnValue;
			bHandled = lRetVal;
			return TRUE;
		}

		if( pnm->code == TVN_KEYDOWN ) {
			TV_KEYDOWN *ptk = (TV_KEYDOWN *)lParam;
			long lRetVal;

			Fire_Keypress( (long)ptk->wVKey );
			lRetVal = lLastEventReturnValue;
			lLastEventReturnValue = lDefaultEventReturnValue;
			bHandled = lRetVal;
			return TRUE;
		}
/*
		if( pnm->code == TVN_ENDLABELEDIT ) {
			TV_DISPINFO *pdi = (TV_DISPINFO *)lParam;
			long lRetVal;

			if( pdi->item.pszText ) {
				Fire_EndEdit( (long)pdi->item.hItem );
				lRetVal = lLastEventReturnValue;
				lLastEventReturnValue = lDefaultEventReturnValue;
				bHandled = lRetVal;
				return TRUE;
			}
			bHandled = FALSE;
			return TRUE;
		}
*/
		if( pnm->code == TVN_BEGINLABELEDIT ) {
			TV_DISPINFO *pdi = (TV_DISPINFO *)lParam;
			long lRetVal;

			Fire_StartEdit( (long)pdi->item.hItem );
			lRetVal = lLastEventReturnValue;
			lLastEventReturnValue = lDefaultEventReturnValue;
			if( ! lRetVal )
				::SetWindowLong( TreeView_GetEditControl( hTreeView ), GWL_WNDPROC,
								 (DWORD)EditSubProc );
			bHandled = lRetVal;
			return TRUE;
		}
		bHandled = FALSE;
		return S_OK;
	}

private:
	long lLastMenuID;
	HMENU hMenu;
	HFONT hFont;
	long lFontBold;
	long lFontSize;
	BSTR bFontName;
	long lLastEventReturnValue;
	long lDefaultEventReturnValue;
	long lUseSelectedImages;
	long lUseImages;
	HWND hTreeView;
	HIMAGELIST hImageList;
	long lBorder;
};

#endif //__TREEVIEW_H_
