// TreeView.cpp : Implementation of CTreeView

#include "stdafx.h"
#include "MGCETreeView.h"
#include "TreeView.h"

/////////////////////////////////////////////////////////////////////////////
// CTreeView


STDMETHODIMP CTreeView::AddImage(BSTR bFilename)
{
	HBITMAP hBmp;

	hBmp = SHLoadDIBitmap( bFilename );
	SysFreeString( bFilename );
	if( ! hBmp ) {
		Error( L"Specified image not found" );
		return E_FAIL;
	}
	if( ImageList_Add( hImageList, hBmp, NULL ) == -1 ) {
		DeleteObject( hBmp );
		Error( L"Error adding image to image list" );
		return E_FAIL;
	}
	return S_OK;
}

STDMETHODIMP CTreeView::RemoveImage(long lIndex)
{
	ImageList_Remove( hImageList, lIndex );
	return S_OK;
}

STDMETHODIMP CTreeView::get_UseImages(long *pVal)
{
	*pVal = lUseImages;
	return S_OK;
}

STDMETHODIMP CTreeView::put_UseImages(long newVal)
{
	lUseImages = newVal;
	if( lUseImages || lUseSelectedImages )
		TreeView_SetImageList( hTreeView, hImageList, TVSIL_NORMAL );
	else TreeView_SetImageList( hTreeView, NULL, TVSIL_NORMAL );
	return S_OK;
}

STDMETHODIMP CTreeView::get_UseSelectedImages(long *pVal)
{
	*pVal = lUseSelectedImages;
	return S_OK;
}

STDMETHODIMP CTreeView::put_UseSelectedImages(long newVal)
{
	lUseSelectedImages = newVal;
	if( lUseImages || lUseSelectedImages )
		TreeView_SetImageList( hTreeView, hImageList, TVSIL_NORMAL );
	else TreeView_SetImageList( hTreeView, NULL, TVSIL_NORMAL );
	return S_OK;
}

STDMETHODIMP CTreeView::get_HasLines(long *pVal)
{
	DWORD dwStyle;
	dwStyle = ::GetWindowLong( hTreeView, GWL_STYLE );
	if( ( dwStyle & TVS_HASLINES ) == TVS_HASLINES )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CTreeView::put_HasLines(long newVal)
{
	DWORD dwStyle;
	dwStyle = ::GetWindowLong( hTreeView, GWL_STYLE );
	if( newVal ) dwStyle |= TVS_HASLINES;
	else dwStyle &= ~TVS_HASLINES;
	::SetWindowLong( hTreeView, GWL_STYLE, dwStyle );
	::SetWindowPos( hTreeView, NULL, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER);
	return S_OK;
}

STDMETHODIMP CTreeView::get_RootLines(long *pVal)
{
	DWORD dwStyle;
	dwStyle = ::GetWindowLong( hTreeView, GWL_STYLE );
	if( ( dwStyle & TVS_LINESATROOT ) == TVS_LINESATROOT )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CTreeView::put_RootLines(long newVal)
{
	DWORD dwStyle;
	dwStyle = ::GetWindowLong( hTreeView, GWL_STYLE );
	if( newVal ) dwStyle |= TVS_LINESATROOT;
	else dwStyle &= ~TVS_LINESATROOT;
	::SetWindowLong( hTreeView, GWL_STYLE, dwStyle );
	::SetWindowPos( hTreeView, NULL, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER);
	return S_OK;
}

STDMETHODIMP CTreeView::get_HasButtons(long *pVal)
{
	DWORD dwStyle;
	dwStyle = ::GetWindowLong( hTreeView, GWL_STYLE );
	if( ( dwStyle & TVS_HASBUTTONS ) == TVS_HASBUTTONS )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CTreeView::put_HasButtons(long newVal)
{
	DWORD dwStyle;
	dwStyle = ::GetWindowLong( hTreeView, GWL_STYLE );
	if( newVal ) dwStyle |= TVS_HASBUTTONS;
	else dwStyle &= ~TVS_HASBUTTONS;
	::SetWindowLong( hTreeView, GWL_STYLE, dwStyle );
	::SetWindowPos( hTreeView, NULL, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER);
	return S_OK;
}

STDMETHODIMP CTreeView::get_Border(long *pVal)
{
	*pVal = lBorder;
	return S_OK;
}

STDMETHODIMP CTreeView::put_Border(long newVal)
{
	RECT Rect;
	GetClientRect( &Rect );
	lBorder = newVal;
	if( ! lBorder )
		::SetWindowPos( hTreeView, NULL, 0, 0, Rect.right, Rect.bottom,
						SWP_NOZORDER );
	else
		::SetWindowPos( hTreeView, NULL, 1, 1, Rect.right - 2, Rect.bottom - 2,
						SWP_NOZORDER );
	InvalidateRect( NULL, FALSE );
	return S_OK;
}

STDMETHODIMP CTreeView::AddItem(long lParent, long lInsertAfter, BSTR bText, long lParam, long lImage, long lSelectedImage, long *pRet)
{
	TVINSERTSTRUCT tvis;
	TVITEM tvi;
	HTREEITEM hItem;


	memset( &tvi, 0, sizeof(TV_ITEM) );
	memset( &tvis, 0, sizeof(TV_INSERTSTRUCT) );
	tvi.mask = TVIF_TEXT | TVIF_PARAM;
	if( lUseImages && lImage ) {
		tvi.mask |= TVIF_IMAGE;
		tvi.iImage = lImage - 1;
	} else tvi.iImage = I_IMAGECALLBACK;
	if( lUseSelectedImages && lSelectedImage ) {
		tvi.mask |= TVIF_SELECTEDIMAGE;
		tvi.iSelectedImage = lSelectedImage - 1;
	} else tvi.iSelectedImage = I_IMAGECALLBACK;
	tvi.pszText = bText;
	tvi.lParam = lParam;
	if( ! lParent ) tvis.hParent = TVI_ROOT;
	else            tvis.hParent = (HTREEITEM)lParent;
	if( ! lInsertAfter )  tvis.hInsertAfter = TVI_LAST;
	else                  tvis.hInsertAfter = (HTREEITEM)lInsertAfter;

	tvi.pszText = bText;
	tvi.cchTextMax = wcslen( tvi.pszText );
	tvis.item = tvi;
	hItem = TreeView_InsertItem( hTreeView, &tvis );
	SysFreeString( bText );
	if( ! hItem ) {
		Error( L"Error adding item to treeview" );
		return E_FAIL;
	}
	*pRet = (long)hItem;
	return S_OK;
}

STDMETHODIMP CTreeView::Clear()
{
	TreeView_DeleteAllItems( hTreeView );
	return S_OK;
}

STDMETHODIMP CTreeView::get_Count(long *pVal)
{
	*pVal = TreeView_GetCount( hTreeView );
	return S_OK;
}

STDMETHODIMP CTreeView::DeleteItem(long lItem)
{
	TreeView_DeleteItem( hTreeView, (HTREEITEM)lItem );
	return S_OK;
}


STDMETHODIMP CTreeView::ExpandItem(long lItem)
{
	::SendMessage( hTreeView, TVM_EXPAND, TVE_EXPAND, lItem );
	return S_OK;
}

STDMETHODIMP CTreeView::CollapseItem(long lItem)
{
	::SendMessage( hTreeView, TVM_EXPAND, TVE_COLLAPSE, lItem );
	return S_OK;
}

STDMETHODIMP CTreeView::ToggleItem(long lItem)
{
	::SendMessage( hTreeView, TVM_EXPAND, TVE_TOGGLE, lItem );
	return S_OK;
}

STDMETHODIMP CTreeView::MakeVisible(long lItem)
{
	TreeView_EnsureVisible( hTreeView, (HTREEITEM)lItem );
	return S_OK;
}

STDMETHODIMP CTreeView::get_FirstItem(long *pVal)
{
	*pVal = (long)TreeView_GetRoot( hTreeView );
	return S_OK;
}

STDMETHODIMP CTreeView::get_ItemText(long lItem, BSTR *pVal)
{
	TV_ITEM tvi;
	TCHAR szText[ 300 ];

	tvi.mask = TVIF_TEXT;
	tvi.pszText = szText;
	tvi.cchTextMax = 300;
	tvi.hItem = (HTREEITEM)lItem;
	if( ! TreeView_GetItem( hTreeView, &tvi ) ) {
		Error( L"Error retrieving item text" );
		return E_FAIL;
	}
	*pVal = SysAllocString( szText );
	return S_OK;
}

STDMETHODIMP CTreeView::put_ItemText(long lItem, BSTR newVal)
{
	TV_ITEM tvi;

	tvi.mask = TVIF_TEXT;
	tvi.pszText = newVal;
	tvi.cchTextMax = wcslen( newVal );
	tvi.hItem = (HTREEITEM)lItem;
	if( ! TreeView_SetItem( hTreeView, &tvi ) ) {
		SysFreeString( newVal );
		Error( L"Error setting item text" );
		return E_FAIL;
	}
	SysFreeString( newVal );
	return S_OK;
}

STDMETHODIMP CTreeView::get_ItemImage(long lItem, long *pVal)
{
	TV_ITEM tvi;
	tvi.mask = TVIF_IMAGE;
	tvi.hItem = (HTREEITEM)lItem;
	if( ! TreeView_GetItem( hTreeView, &tvi ) ) {
		Error( L"Error setting item image" );
		return E_FAIL;
	}
	*pVal = tvi.iImage;
	return S_OK;
}

STDMETHODIMP CTreeView::put_ItemImage(long lItem, long newVal)
{
	TV_ITEM tvi;
	tvi.mask = TVIF_IMAGE;
	tvi.iImage = newVal;
	tvi.hItem = (HTREEITEM)lItem;
	if( ! TreeView_SetItem( hTreeView, &tvi ) ) {
		Error( L"Error setting item image" );
		return E_FAIL;
	}
	return S_OK;
}

STDMETHODIMP CTreeView::get_ItemSelectedImage(long lItem, long *pVal)
{
	TV_ITEM tvi;
	tvi.mask = TVIF_SELECTEDIMAGE;
	tvi.hItem = (HTREEITEM)lItem;
	if( ! TreeView_GetItem( hTreeView, &tvi ) ) {
		Error( L"Error retriving item select image" );
		return E_FAIL;
	}
	*pVal = tvi.iSelectedImage;
	return S_OK;
}

STDMETHODIMP CTreeView::put_ItemSelectedImage(long lItem, long newVal)
{
	TV_ITEM tvi;
	tvi.mask = TVIF_SELECTEDIMAGE;
	tvi.iSelectedImage = newVal;
	tvi.hItem = (HTREEITEM)lItem;
	if( ! TreeView_SetItem( hTreeView, &tvi ) ) {
		Error( L"Error setting item select image" );
		return E_FAIL;
	}
	return S_OK;
}

STDMETHODIMP CTreeView::get_ItemValue(long lItem, long *pVal)
{
	TV_ITEM tvi;
	tvi.mask = TVIF_PARAM;
	tvi.hItem = (HTREEITEM)lItem;
	if( ! TreeView_GetItem( hTreeView, &tvi ) ) {
		Error( L"Error retriving item value" );
		return E_FAIL;
	}
	*pVal = tvi.lParam;
	return S_OK;
}

STDMETHODIMP CTreeView::put_ItemValue(long lItem, long newVal)
{
	TV_ITEM tvi;
	tvi.mask = TVIF_PARAM;
	tvi.lParam = newVal;
	tvi.hItem = (HTREEITEM)lItem;
	if( ! TreeView_SetItem( hTreeView, &tvi ) ) {
		Error( L"Error setting item value" );
		return E_FAIL;
	}
	return S_OK;
}

STDMETHODIMP CTreeView::get_Indent(long *pVal)
{
	*pVal = TreeView_GetIndent( hTreeView );
	return S_OK;
}

STDMETHODIMP CTreeView::put_Indent(long newVal)
{
	TreeView_SetIndent( hTreeView, newVal );
	return S_OK;
}

STDMETHODIMP CTreeView::get_Child(long lItem, long *pVal)
{
	*pVal = (long)TreeView_GetChild( hTreeView, (HTREEITEM)lItem );
	return S_OK;
}

STDMETHODIMP CTreeView::get_Parent(long lItem, long *pVal)
{
	*pVal = (long)TreeView_GetParent( hTreeView, (HTREEITEM)lItem );
	return S_OK;
}

STDMETHODIMP CTreeView::get_NextSibling(long lItem, long *pVal)
{
	*pVal = (long)TreeView_GetNextSibling( hTreeView, (HTREEITEM)lItem );
	return S_OK;
}

STDMETHODIMP CTreeView::get_PreviousSibling(long lItem, long *pVal)
{
	*pVal = (long)TreeView_GetPrevSibling( hTreeView, (HTREEITEM)lItem );
	return S_OK;
}

STDMETHODIMP CTreeView::get_NextVisible(long lItem, long *pVal)
{
	*pVal = (long)TreeView_GetNextVisible( hTreeView, (HTREEITEM)lItem );
	return S_OK;
}

STDMETHODIMP CTreeView::get_PreviousVisible(long lItem, long *pVal)
{
	*pVal = (long)TreeView_GetPrevVisible( hTreeView, (HTREEITEM)lItem );
	return S_OK;
}

STDMETHODIMP CTreeView::get_FirstVisible(long *pVal)
{
	*pVal = (long)TreeView_GetFirstVisible( hTreeView );
	return S_OK;
}

STDMETHODIMP CTreeView::put_FirstVisible(long newVal)
{
	TreeView_SelectSetFirstVisible( hTreeView, (HTREEITEM)newVal );
	return S_OK;
}

STDMETHODIMP CTreeView::get_Select(long *pVal)
{
	*pVal = (long)TreeView_GetSelection( hTreeView );
	return S_OK;
}

STDMETHODIMP CTreeView::put_Select(long newVal)
{
	TreeView_SelectItem( hTreeView, (HTREEITEM)newVal );
	return S_OK;
}

STDMETHODIMP CTreeView::get_AllowEdit(long *pVal)
{
	DWORD dwStyle;
	dwStyle = ::GetWindowLong( hTreeView, GWL_STYLE );
	if( ( dwStyle & TVS_EDITLABELS ) == TVS_EDITLABELS )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CTreeView::put_AllowEdit(long newVal)
{
	DWORD dwStyle;
	dwStyle = ::GetWindowLong( hTreeView, GWL_STYLE );
	if( newVal ) dwStyle |= TVS_EDITLABELS;
	else dwStyle &= ~TVS_EDITLABELS;
	::SetWindowLong( hTreeView, GWL_STYLE, dwStyle );
	::SetWindowPos( hTreeView, NULL, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER);
	return S_OK;
}

STDMETHODIMP CTreeView::get_Tabstop(long *pVal)
{
	if( GetWindowLong( GWL_STYLE ) & WS_TABSTOP ) *pVal = 1;
	else *pVal = 0;
//	if( ::GetWindowLong( hTreeView, GWL_STYLE ) & WS_TABSTOP )  *pVal = 1;
//	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CTreeView::put_Tabstop(long newVal)
{
	DWORD dwStyle;
//	dwStyle = ::GetWindowLong( hTreeView, GWL_STYLE );
	dwStyle = GetWindowLong( GWL_STYLE );
	if( newVal ) dwStyle |= WS_TABSTOP;
    else dwStyle &= ~WS_TABSTOP;
//	::SetWindowLong( hTreeView, GWL_STYLE, dwStyle );
	SetWindowLong( GWL_STYLE, dwStyle );
	return S_OK;
}

STDMETHODIMP CTreeView::SetFocus()
{
	::SetFocus( hTreeView );
	return S_OK;
}

STDMETHODIMP CTreeView::Show()
{
	ShowWindow( SW_SHOW );
	return S_OK;
}


STDMETHODIMP CTreeView::Hide()
{
	ShowWindow( SW_HIDE );
	return S_OK;
}

STDMETHODIMP CTreeView::put_AllowEvent(long newVal)
{
	if( ! newVal ) lLastEventReturnValue = 1;
	else lLastEventReturnValue = 0;
	return S_OK;
}

STDMETHODIMP CTreeView::get_AllowEventAsDefault(long *pVal)
{
	if( ! lDefaultEventReturnValue )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CTreeView::put_AllowEventAsDefault(long newVal)
{
	if( ! newVal )  lDefaultEventReturnValue = 1;
	else  lDefaultEventReturnValue = 0;
	return S_OK;
}

STDMETHODIMP CTreeView::get_SelectionDisplay(long *pVal)
{
	DWORD dwStyle;
	dwStyle = ::GetWindowLong( hTreeView, GWL_STYLE );
	if( ( dwStyle & TVS_SHOWSELALWAYS ) == TVS_SHOWSELALWAYS )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CTreeView::put_SelectionDisplay(long newVal)
{
	DWORD dwStyle;
	dwStyle = ::GetWindowLong( hTreeView, GWL_STYLE );
	if( newVal ) dwStyle |= TVS_SHOWSELALWAYS;
	else dwStyle &= ~TVS_SHOWSELALWAYS;
	::SetWindowLong( hTreeView, GWL_STYLE, dwStyle );
	::SetWindowPos( hTreeView, NULL, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER);
	return S_OK;
}

STDMETHODIMP CTreeView::get_AutoExpand(long *pVal)
{
	DWORD dwStyle;
	dwStyle = ::GetWindowLong( hTreeView, GWL_STYLE );
	if( ( dwStyle & TVS_SINGLEEXPAND ) == TVS_SINGLEEXPAND )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CTreeView::put_AutoExpand(long newVal)
{
	DWORD dwStyle;
	dwStyle = ::GetWindowLong( hTreeView, GWL_STYLE );
	if( newVal ) dwStyle |= TVS_SINGLEEXPAND;
	else dwStyle &= ~TVS_SINGLEEXPAND;
	::SetWindowLong( hTreeView, GWL_STYLE, dwStyle );
	::SetWindowPos( hTreeView, NULL, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER);
	return S_OK;
}

STDMETHODIMP CTreeView::get_TreePath(long lItem, BSTR *pVal)
{
	BYTE *pszBuffer, szStr[ 1024 ];
	TV_ITEM tvi;
	int iLen, iNewLen, iCount;

	pszBuffer = (BYTE *)malloc( 4096 * sizeof(TCHAR) );
	if( ! pszBuffer ) return E_OUTOFMEMORY;
	memset( pszBuffer, 0, 4096 * sizeof(TCHAR) );
	memset( &tvi, 0, sizeof(TV_ITEM) );
	tvi.mask = TVIF_TEXT;
	tvi.hItem = (HTREEITEM)lItem;
	tvi.pszText = (BSTR)szStr;
	tvi.cchTextMax = 512;
	iCount = 0;

	while( TreeView_GetItem( hTreeView, &tvi ) ) {
		if( iCount ) wcscat( (BSTR)szStr, L"\\" );
		iNewLen = wcslen( (BSTR)szStr ) * sizeof(TCHAR);
		if( wcslen( (BSTR)pszBuffer ) ) {
			iLen = ( wcslen( (BSTR)pszBuffer ) + 1 ) * sizeof(TCHAR);
			memmove( pszBuffer + iNewLen, pszBuffer, iLen );
		}
		memcpy( pszBuffer, szStr, iNewLen );
		tvi.hItem = TreeView_GetParent( hTreeView, tvi.hItem );
		++iCount;
	}
	*pVal = SysAllocString( (BSTR)pszBuffer );
	free( pszBuffer );
	return S_OK;
}

STDMETHODIMP CTreeView::StartEdit(long lItem, long *pEdit)
{
	TreeView_EditLabel( hTreeView, (HTREEITEM)lItem );
	*pEdit = (long)TreeView_GetEditControl( hTreeView );
	return S_OK;
}

STDMETHODIMP CTreeView::EndEdit(long lDeny)
{
	TreeView_EndEditLabelNow( hTreeView, lDeny );
	return S_OK;
}

STDMETHODIMP CTreeView::get_FontName(BSTR *pVal)
{
	*pVal = SysAllocString( bFontName );
	return S_OK;
}

STDMETHODIMP CTreeView::put_FontName(BSTR newVal)
{
	LOGFONT lf;

	memset( &lf, 0, sizeof(LOGFONT) );
	if( bFontName )  SysFreeString( bFontName );
	bFontName = newVal;
	wcscpy( lf.lfFaceName, bFontName );
	lf.lfHeight = lFontSize;
	if( lFontBold )  lf.lfWeight = 700;
	else lf.lfWeight = 400;
	::DeleteObject( hFont );
	hFont = ::CreateFontIndirect( &lf );
	::SendMessage( hTreeView, WM_SETFONT, (WPARAM)hFont, TRUE );
	return S_OK;
}

STDMETHODIMP CTreeView::get_FontSize(long *pVal)
{
	*pVal = lFontSize;
	return S_OK;
}

STDMETHODIMP CTreeView::put_FontSize(long newVal)
{
	LOGFONT lf;

	lFontSize = newVal;
	memset( &lf, 0, sizeof(LOGFONT) );
	wcscpy( lf.lfFaceName, bFontName );
	lf.lfHeight = lFontSize;
	if( lFontBold )  lf.lfWeight = 700;
	else lf.lfWeight = 400;
	::DeleteObject( hFont );
	hFont = ::CreateFontIndirect( &lf );
	::SendMessage( hTreeView, WM_SETFONT, (WPARAM)hFont, TRUE );
	return S_OK;
}

STDMETHODIMP CTreeView::get_FontBold(long *pVal)
{
	*pVal = lFontBold;
	return S_OK;
}

STDMETHODIMP CTreeView::put_FontBold(long newVal)
{
	LOGFONT lf;

	lFontBold = newVal;
	memset( &lf, 0, sizeof(LOGFONT) );
	wcscpy( lf.lfFaceName, bFontName );
	lf.lfHeight = lFontSize;
	if( lFontBold )  lf.lfWeight = 700;
	else lf.lfWeight = 400;
	::DeleteObject( hFont );
	hFont = ::CreateFontIndirect( &lf );
	::SendMessage( hTreeView, WM_SETFONT, (WPARAM)hFont, TRUE );
	return S_OK;
}

STDMETHODIMP CTreeView::AddContextItem(BSTR bText)
{
	if( *bText == L'-' ) AppendMenu( hMenu, MF_SEPARATOR, 0, NULL );
	else AppendMenu( hMenu, MF_STRING, lLastMenuID, bText );
	++lLastMenuID;
	SysFreeString( bText );
	return S_OK;
}

STDMETHODIMP CTreeView::RemoveContextItem(long lIndex)
{
	if( lIndex < 1 ) {
		Error( L"Invalid context index specified" );
		return E_FAIL;
	}
	::DeleteMenu( hMenu, lIndex - 1, MF_BYPOSITION );
	return S_OK;
}

STDMETHODIMP CTreeView::ClearContext()
{
	while( ::DeleteMenu( hMenu, 0, MF_BYPOSITION ) );
	return S_OK;
}

STDMETHODIMP CTreeView::get_Style(long *pVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hTreeView, GWL_EXSTYLE );
	if( ( dwStyle & WS_EX_CLIENTEDGE ) == WS_EX_CLIENTEDGE )  *pVal = 1;
	else
	if( ( dwStyle & WS_EX_WINDOWEDGE ) == WS_EX_WINDOWEDGE )  *pVal = 2;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CTreeView::put_Style(long newVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hTreeView, GWL_EXSTYLE );
	dwStyle = dwStyle & ~( WS_EX_CLIENTEDGE | WS_EX_STATICEDGE | WS_EX_WINDOWEDGE );
	if( newVal == 1 ) dwStyle |= WS_EX_CLIENTEDGE;
	if( newVal == 2 ) dwStyle |= WS_EX_WINDOWEDGE;
	::SetWindowLong( hTreeView, GWL_EXSTYLE, dwStyle );
	::SetWindowPos( hTreeView, NULL, 0, 0, 0, 0,
				    SWP_NOZORDER | SWP_NOSIZE | SWP_NOMOVE | SWP_FRAMECHANGED );
	return S_OK;
}

STDMETHODIMP CTreeView::get_Version(long *pVal)
{
	*pVal = 102;
	return S_OK;
}

STDMETHODIMP CTreeView::get_hWnd(long *pVal)
{
	*pVal = (long)m_hWnd;
	return S_OK;
}
