// MGCETreeView.cpp : Implementation of DLL Exports.


// Note: Proxy/Stub Information
//		To build a separate proxy/stub DLL, 
//		run nmake -f MGCETreeViewps.mk in the project directory.

#include "stdafx.h"
#include "resource.h"
#include "initguid.h"
#include "MGCETreeView.h"

#include "MGCETreeView_i.c"
#include "TreeView.h"


CComModule _Module;

BEGIN_OBJECT_MAP(ObjectMap)
OBJECT_ENTRY(CLSID_TreeView, CTreeView)
END_OBJECT_MAP()

/////////////////////////////////////////////////////////////////////////////
// DLL Entry Point

extern "C"
BOOL WINAPI DllMain(HANDLE hInstance, DWORD dwReason, LPVOID /*lpReserved*/)
{
	if (dwReason == DLL_PROCESS_ATTACH)
	{
		_Module.Init(ObjectMap, (HINSTANCE)hInstance);
#ifndef UNDER_CE
		DisableThreadLibraryCalls((HINSTANCE)hInstance);
#endif
	}
	else if (dwReason == DLL_PROCESS_DETACH)
		_Module.Term();
	return TRUE;    // ok
}

/////////////////////////////////////////////////////////////////////////////
// Used to determine whether the DLL can be unloaded by OLE

STDAPI DllCanUnloadNow(void)
{
	return (_Module.GetLockCount()==0) ? S_OK : S_FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// Returns a class factory to create an object of the requested type

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
	return _Module.GetClassObject(rclsid, riid, ppv);
}

/////////////////////////////////////////////////////////////////////////////
// DllRegisterServer - Adds entries to the system registry

STDAPI DllRegisterServer(void)
{
	// registers object, typelib and all interfaces in typelib
	return _Module.RegisterServer(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
// DllUnregisterServer - Removes entries from the system registry

STDAPI DllUnregisterServer(void)
{
	_Module.UnregisterServer();
	return S_OK;
}


LRESULT WINAPI EditSubProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	WNDCLASS wc;

	::GetClassInfo( NULL, L"EDIT", &wc );
	if( msg == WM_KEYUP && ( wParam == 13 || wParam == 27 ) )
		PostMessage( GetParent( GetParent( hWnd ) ), WM_USER + 4000, wParam,
					 (LPARAM)hWnd );
	if( msg == WM_KILLFOCUS )
		PostMessage( GetParent( GetParent( hWnd ) ), WM_USER + 4000, 0, 
					 (LPARAM)hWnd );
	return( CallWindowProc( wc.lpfnWndProc, hWnd, msg, wParam, lParam ) );
}

LRESULT WINAPI NewTreeProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	WNDCLASS wc;

	::GetClassInfo( NULL, WC_TREEVIEW, &wc );
	if( msg == WM_LBUTTONDOWN ) {
		short sKey;
		HMENU hMenu;
		MENUITEMINFO mmi;
		int iItem;


		sKey = ::GetAsyncKeyState( VK_MENU );
		if( sKey < 0 ) {
			hMenu = (HMENU)SendMessage( GetParent( hWnd ),
								 WM_USER + 4001, 0, 0 );
			if( hMenu ) {
				if( GetMenuItemInfo( hMenu, 0, TRUE, &mmi ) ) {
					iItem = TrackPopupMenu( hMenu, TPM_LEFTALIGN | TPM_TOPALIGN |
											TPM_RETURNCMD,
											LOWORD( lParam ), HIWORD( lParam ),
											0, hWnd, NULL );
					if( iItem )
						PostMessage( GetParent( hWnd ), WM_USER + 4002, lParam,
									 iItem );
				}
			}
			return TRUE;
		}
	}
	return( ::CallWindowProc( wc.lpfnWndProc, hWnd, msg, wParam, lParam ) );
}

