// RichInk.h : Declaration of the CRichInk

#ifndef __RICHINK_H_
#define __RICHINK_H_

#include "resource.h"       // main symbols
#include <atlctl.h>
#include "commctrl.h"

/////////////////////////////////////////////////////////////////////////////
// CRichInk
class ATL_NO_VTABLE CRichInk : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<IRichInk, &IID_IRichInk, &LIBID_MGCERICHINKLib>,
	public CComControl<CRichInk>,
	public IPersistStreamInitImpl<CRichInk>,
	public IOleControlImpl<CRichInk>,
	public IOleObjectImpl<CRichInk>,
	public IOleInPlaceActiveObjectImpl<CRichInk>,
	public IViewObjectExImpl<CRichInk>,
	public IOleInPlaceObjectWindowlessImpl<CRichInk>,
	public IPersistStorageImpl<CRichInk>,
	public ISpecifyPropertyPagesImpl<CRichInk>,
	public IQuickActivateImpl<CRichInk>,
	public IDataObjectImpl<CRichInk>,
	public IProvideClassInfo2Impl<&CLSID_RichInk, NULL, &LIBID_MGCERICHINKLib>,
	public CComCoClass<CRichInk, &CLSID_RichInk>
{
public:
	CRichInk()
	{
		lMode = 0;
		lHasToolbar = 1;
		lBorder = 1;
	}

DECLARE_REGISTRY_RESOURCEID(IDR_RICHINK)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CRichInk)
	COM_INTERFACE_ENTRY(IRichInk)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
END_COM_MAP()

BEGIN_PROP_MAP(CRichInk)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_MSG_MAP(CRichInk)
	MESSAGE_HANDLER( WM_CREATE, OnCreate )
	MESSAGE_HANDLER( WM_DESTROY, OnDestroy )
	MESSAGE_HANDLER( WM_SETFOCUS, OnFocus )
	MESSAGE_HANDLER( WM_KILLFOCUS, OnFocus )
	CHAIN_MSG_MAP(CComControl<CRichInk>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// IRichInk
public:
	STDMETHOD(get_hWnd)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Tabstop)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Tabstop)(/*[in]*/ long newVal);
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(LoadData)(BSTR bFilename);
	STDMETHOD(SaveData)(BSTR bFilename, long);
	STDMETHOD(get_Mode)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Mode)(/*[in]*/ long newVal);
	STDMETHOD(get_Data)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_Data)(/*[in]*/ VARIANT *newVal);
	STDMETHOD(get_Toolbar)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Toolbar)(/*[in]*/ long newVal);
	STDMETHOD(SetFocus)();
	STDMETHOD(Hide)();
	STDMETHOD(Show)();
	STDMETHOD(Clear)();
	STDMETHOD(get_Border)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Border)(/*[in]*/ long newVal);

	LRESULT OnCreate( UINT msg, WPARAM wParam, LPARAM lParam, BOOL &bHandled )
	{
		RECT Rect;
		int ( *pInitInkX )( void );

		::SetWindowLong( m_hWnd, GWL_STYLE, ::GetWindowLong( m_hWnd, GWL_STYLE ) + WS_TABSTOP );
		hLib = ::LoadLibrary( L"inkx.dll" );
		if( ! hLib ) return E_FAIL;
		pInitInkX = ::GetProcAddress( (HINSTANCE)hLib, L"InitInkX" );
		if( ! pInitInkX )  return E_FAIL;
		pInitInkX();
		GetClientRect( &Rect );
		lBorder = lHasToolbar = 1;
		hCtrl = ::CreateWindow( L"InkX", NULL, WS_VISIBLE | WS_CHILD,
								1, 1, Rect.right - 2, Rect.bottom - 2,
								this->m_hWnd, (HMENU)0, _Module.m_hInst, NULL );
		bHandled = TRUE;
		return S_OK;
	}

	LRESULT OnDestroy( UINT msg, WPARAM wParam, LPARAM lParam, BOOL &bHandled )
	{
		if( hCtrl ) ::DestroyWindow( hCtrl );
		bHandled = TRUE;
		return S_OK;
	}

	LRESULT OnFocus( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		bHandled = TRUE;
		return ::SendMessage( hCtrl, msg, wParam, lParam );
	}

	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		if( lBorder ) {
			RECT Rect;
			HPEN hPen;

			GetClientRect( &Rect );
			hPen = ::CreatePen( PS_SOLID, 0, RGB( 0, 0, 0 ) );
			hPen = (HPEN)::SelectObject( di.hdcDraw, hPen );
			::Rectangle( di.hdcDraw, 0, 0, Rect.right, Rect.bottom );
			::DeleteObject( ::SelectObject( di.hdcDraw, hPen ) );
		}
		return S_OK;
	}
private:
	long lMode;
	long lHasToolbar;
	HANDLE hLib;
	HWND hCtrl;
	long lBorder;
};

#endif //__RICHINK_H_
