// RichInk.cpp : Implementation of CRichInk

#include "stdafx.h"
#include "MGCERichInk.h"
#include "RichInk.h"

/////////////////////////////////////////////////////////////////////////////
// CRichInk


STDMETHODIMP CRichInk::get_Border(long *pVal)
{
	*pVal = lBorder;
	return S_OK;
}

STDMETHODIMP CRichInk::put_Border(long newVal)
{
	RECT Rect;
	lBorder = newVal;
	GetClientRect( &Rect );
	if( lBorder )
		::SetWindowPos( hCtrl, NULL, 1, 1, Rect.right - 2, Rect.bottom - 2,
						SWP_NOZORDER );
	else
		::SetWindowPos( hCtrl, NULL, 1, 1, Rect.right, Rect.bottom,
						SWP_NOZORDER );
	return S_OK;
}

STDMETHODIMP CRichInk::Clear()
{
	::SendMessage( hCtrl, WM_USER + 519, 0, 0 );
	lMode = 0;
	return S_OK;
}

STDMETHODIMP CRichInk::Show()
{
	ShowWindow( SW_SHOW );
	return S_OK;
}

STDMETHODIMP CRichInk::Hide()
{
	ShowWindow( SW_HIDE );
	return S_OK;
}

STDMETHODIMP CRichInk::SetFocus()
{
	::SetFocus( hCtrl );
	return S_OK;
}

STDMETHODIMP CRichInk::get_Toolbar(long *pVal)
{
	*pVal = lHasToolbar;
	return S_OK;
}

STDMETHODIMP CRichInk::put_Toolbar(long newVal)
{
	lHasToolbar = newVal;
	::SendMessage( hCtrl, WM_USER + 512, newVal, 0 );
	return S_OK;
}

STDMETHODIMP CRichInk::get_Data(VARIANT *pVal)
{
	int i;
	SAFEARRAY *psa;
	BYTE *pBuffer;

	i = ::SendMessage( hCtrl, WM_USER + 514, 0, 0 );
	if( ! i ) {
		V_VT( pVal ) = VT_EMPTY;
		return S_OK;
	}
	pBuffer = (BYTE *)LocalAlloc( LPTR, i + 8 );
	if( ! pBuffer ) return E_OUTOFMEMORY;

	psa = SafeArrayCreateVector( VT_UI1, 1, i );
	if( ! psa ) {
		LocalFree( pBuffer );
		return E_OUTOFMEMORY;
	}
	::SendMessage( hCtrl, WM_USER + 515, i, (LPARAM)pBuffer );
	psa->pvData = pBuffer;
	V_VT( pVal ) = VT_UI1 | VT_ARRAY;
	V_ARRAY( pVal ) = psa;
	return S_OK;
}

STDMETHODIMP CRichInk::put_Data(VARIANT *newVal)
{
	SAFEARRAY *psa;
	long lLBound, lUBound, lElements;
	VARIANT *pArray;

	psa = V_ARRAY( newVal );
	if( SafeArrayGetLBound( psa, 1, &lLBound ) != S_OK ) return E_INVALIDARG;
	if( SafeArrayGetUBound( psa, 1, &lUBound ) != S_OK ) return E_INVALIDARG;
	if( SafeArrayAccessData( psa, (void **)&pArray ) != S_OK ) return E_INVALIDARG;
	lElements = lUBound - lLBound + 1;
	::SendMessage( hCtrl, WM_USER + 516, lElements, (LPARAM)psa->pvData );
	VariantClear( pArray );
	SafeArrayUnaccessData( psa );
	VariantClear( newVal );
	return S_OK;
}

STDMETHODIMP CRichInk::get_Mode(long *pVal)
{
	*pVal = lMode;
	return S_OK;
}

STDMETHODIMP CRichInk::put_Mode(long newVal)
{
	if( newVal ) ::SendMessage( hCtrl, WM_COMMAND, 0x66, 0x000C0000 );
	else ::SendMessage( hCtrl, WM_COMMAND, 0x67, 0x000C0000 );
	lMode = newVal;
	return S_OK;
}

STDMETHODIMP CRichInk::SaveData(BSTR bFilename, long lOverwrite)
{
	int i;
	LPBYTE pBuffer;
	HRESULT hr;
	HANDLE hFile;
	DWORD dwOut;

	hr = E_FAIL;
	i = ::SendMessage( hCtrl, WM_USER + 514, 0, 0 );
	if( i ) {
		pBuffer = (LPBYTE)LocalAlloc( LPTR, i + 4 );
		if( pBuffer ) {
			::SendMessage( hCtrl, WM_USER + 515, i, (LPARAM)pBuffer );
			if( lOverwrite )
				hFile = CreateFile( bFilename, GENERIC_READ | GENERIC_WRITE, 0, NULL,
									CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL );
			else
				hFile = CreateFile( bFilename, GENERIC_READ | GENERIC_WRITE, 0, NULL,
									CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL );
			if( hFile != INVALID_HANDLE_VALUE ) {
				WriteFile( hFile, pBuffer, i, &dwOut, NULL );
				CloseHandle( hFile );
				hr = S_OK;
			} else {
				Error( L"Unable to create specified file" );
				hr = E_HANDLE;
			}
			LocalFree( pBuffer );
		} else hr = E_OUTOFMEMORY;
	} else hr = E_FAIL;
	SysFreeString( bFilename );
	return S_OK;
}

STDMETHODIMP CRichInk::LoadData(BSTR bFilename)
{
	HANDLE hFile;
	DWORD dwSize, dwRead;
	LPBYTE pBuffer;
	HRESULT hr;

	hr = E_FAIL;
	hFile = CreateFile( bFilename, GENERIC_READ | GENERIC_WRITE, 0, NULL,
						OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL );
	if( hFile != INVALID_HANDLE_VALUE ) {
		dwSize = GetFileSize( hFile, NULL );
		if( dwSize ) {
			pBuffer = (LPBYTE)LocalAlloc( LPTR, dwSize + 4 );
			if( pBuffer ) {
				ReadFile( hFile, pBuffer, dwSize, &dwRead, NULL );
				::SendMessage( hCtrl, WM_USER + 516, dwSize, (LPARAM)pBuffer );
				LocalFree( pBuffer );
				hr = S_OK;
			} else hr = E_OUTOFMEMORY;
		} else {
			Error( L"Empty file" );
			hr = E_INVALIDARG;
		}
		CloseHandle( hFile );
	} else {
		Error( L"Unable to load specified file" );
		hr = E_HANDLE;
	}
	SysFreeString( bFilename );
	return hr;
}

STDMETHODIMP CRichInk::get_Version(long *pVal)
{
	*pVal = 101;
	return S_OK;
}

STDMETHODIMP CRichInk::get_Tabstop(long *pVal)
{
	if( ( ::GetWindowLong( m_hWnd, GWL_STYLE ) & WS_TABSTOP ) == WS_TABSTOP )
		*pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CRichInk::put_Tabstop(long newVal)
{
	DWORD dwStyle;
	dwStyle = ::GetWindowLong( m_hWnd, GWL_STYLE );
	if( newVal )  dwStyle |= WS_TABSTOP;
	else dwStyle &= ~WS_TABSTOP;
	::SetWindowLong( m_hWnd, GWL_STYLE, dwStyle );
	return S_OK;
}


STDMETHODIMP CRichInk::get_hWnd(long *pVal)
{
	*pVal = (long)m_hWnd;
	return S_OK;
}
