// RichEdit.h : Declaration of the CRichEdit

#ifndef __RICHEDIT_H_
#define __RICHEDIT_H_

#include "resource.h"       // main symbols
#include <atlctl.h>
#include "riched.h"
#include "MGCERichEditCP.h"



DWORD CALLBACK RTFSaveStream( DWORD dwCookie, LPBYTE lpBuffer, LONG lSize, LONG *plRead );
DWORD CALLBACK RTFLoadStream( DWORD dwCookie, LPBYTE lpBuffer, LONG lSize, LONG *plRead );

/////////////////////////////////////////////////////////////////////////////
// CRichEdit
class ATL_NO_VTABLE CRichEdit : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<IRichEdit, &IID_IRichEdit, &LIBID_MGCERICHEDITLib>,
	public CComControl<CRichEdit>,
	public IPersistStreamInitImpl<CRichEdit>,
	public IOleControlImpl<CRichEdit>,
	public IOleObjectImpl<CRichEdit>,
	public IOleInPlaceActiveObjectImpl<CRichEdit>,
	public IViewObjectExImpl<CRichEdit>,
	public IOleInPlaceObjectWindowlessImpl<CRichEdit>,
	public IConnectionPointContainerImpl<CRichEdit>,
	public IPersistStorageImpl<CRichEdit>,
	public ISpecifyPropertyPagesImpl<CRichEdit>,
	public IQuickActivateImpl<CRichEdit>,
	public IDataObjectImpl<CRichEdit>,
	public IProvideClassInfo2Impl<&CLSID_RichEdit, &DIID__IRichEditEvents, &LIBID_MGCERICHEDITLib>,
	public IPropertyNotifySinkCP<CRichEdit>,
	public CComCoClass<CRichEdit, &CLSID_RichEdit>,
	public CProxy_IRichEditEvents< CRichEdit >
{
public:
	CRichEdit()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_RICHEDIT)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CRichEdit)
	COM_INTERFACE_ENTRY(IRichEdit)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()

BEGIN_PROP_MAP(CRichEdit)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_CONNECTION_POINT_MAP(CRichEdit)
	CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
	CONNECTION_POINT_ENTRY(DIID__IRichEditEvents)
END_CONNECTION_POINT_MAP()

BEGIN_MSG_MAP(CRichEdit)
	MESSAGE_HANDLER( WM_CREATE, OnCreate )
	MESSAGE_HANDLER( WM_DESTROY, OnDestroy )
	MESSAGE_HANDLER( WM_SETFOCUS, OnFocus )
	MESSAGE_HANDLER( WM_KILLFOCUS, OnFocus )
	MESSAGE_HANDLER( WM_COMMAND, OnCommand )
	MESSAGE_HANDLER( WM_NOTIFY, OnNotify )
	CHAIN_MSG_MAP(CComControl<CRichEdit>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// IRichEdit
public:
	STDMETHOD(get_RTFText)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_RTFText)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_Caption)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Caption)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_Border)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Border)(/*[in]*/ long newVal);
	STDMETHOD(get_Scrollbars)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Scrollbars)(/*[in]*/ long newVal);
	STDMETHOD(get_Multiline)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Multiline)(/*[in]*/ long newVal);
	STDMETHOD(get_FontStrikeout)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_FontStrikeout)(/*[in]*/ long newVal);
	STDMETHOD(get_FontUnderline)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_FontUnderline)(/*[in]*/ long newVal);
	STDMETHOD(get_FontItalic)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_FontItalic)(/*[in]*/ long newVal);
	STDMETHOD(get_FontBold)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_FontBold)(/*[in]*/ long newVal);
	STDMETHOD(get_FontSize)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_FontSize)(/*[in]*/ long newVal);
	STDMETHOD(get_ForeColor)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_ForeColor)(/*[in]*/ long newVal);
	STDMETHOD(get_FontName)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_FontName)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_BackColor)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_BackColor)(/*[in]*/ long newVal);

	LRESULT OnCreate( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		RECT Rect;

		GetClientRect( &Rect );
		lBorder = 1;
		lSetStart = lSelLength = 0;
		hCtrl = ::CreateWindowEx( 0, L"RICHEDIT20W", NULL,
								  WS_VISIBLE | WS_TABSTOP | WS_CHILD,
							      1, 1, Rect.right - 2, Rect.bottom - 2,
						          this->m_hWnd, (HMENU)1000, _Module.m_hInst, NULL );
		::SendMessage( hCtrl, EM_SETEVENTMASK, 0, ENM_SELCHANGE );
		dwBackColor = ::GetSysColor( COLOR_WINDOW );
		SetWindowLong( GWL_STYLE, GetWindowLong( GWL_STYLE ) | WS_TABSTOP );
		bHandled = TRUE;
		return TRUE;
	}

	LRESULT OnDestroy( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		if( hCtrl ) ::DestroyWindow( hCtrl );
		bHandled = TRUE;
		return TRUE;
	}

	LRESULT OnFocus( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		::SendMessage( hCtrl, msg, wParam, lParam );
		if( msg == WM_SETFOCUS ) ::SetFocus( hCtrl );
		bHandled = TRUE;
		return S_OK;
	}

	LRESULT OnCommand( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		if( HIWORD( wParam ) == EN_SETFOCUS )   Fire_GotFocus();
		if( HIWORD( wParam ) == EN_KILLFOCUS )	Fire_LostFocus();
		bHandled = TRUE;
		return S_OK;
	}

	LRESULT OnNotify( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		NMHDR *pn = (NMHDR *)lParam;

		if( pn->code == EN_SELCHANGE ) {
			SELCHANGE *psc = (SELCHANGE *)lParam;
			CHARFORMATW cf;
			DWORD dwVal;

			memset( &cf, 0, sizeof(CHARFORMATW) );
			cf.cbSize = sizeof(CHARFORMATW);
			cf.dwMask = CFM_STRIKEOUT | CFM_UNDERLINE | CFM_BOLD | CFM_ITALIC;
			::SendMessage( hCtrl, EM_GETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
			dwVal = 0;
			if( ( cf.dwEffects & CFE_BOLD ) == CFE_BOLD )  dwVal += 1;
			if( ( cf.dwEffects & CFE_ITALIC ) == CFE_ITALIC )  dwVal += 2;
			if( ( cf.dwEffects & CFE_UNDERLINE ) == CFE_UNDERLINE )  dwVal += 4;
			if( ( cf.dwEffects & CFE_STRIKEOUT ) == CFE_STRIKEOUT )  dwVal += 8;
			Fire_SelectionChange( psc->chrg.cpMin, psc->chrg.cpMax - psc->chrg.cpMin,
								  dwVal );
		}
		bHandled = TRUE;
		return S_OK;
	}


	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		HPEN hPen;
		RECT Rect;

		if( lBorder ) {
			GetClientRect( &Rect );
			hPen = (HPEN)::CreatePen( PS_SOLID, 1, RGB( 0, 0, 0 ) );
			hPen = (HPEN)::SelectObject( di.hdcDraw, hPen );
			::Rectangle( di.hdcDraw, 0, 0, Rect.right, Rect.bottom );
			::DeleteObject( (HPEN)::SelectObject( di.hdcDraw, hPen ) );
		}
		return S_OK;
	}
private:
	long lSetStart;
	long lSelLength;
	void WToA( TCHAR *bBuffer, char *pszBuffer );
	void AToW( char *pszBuffer, TCHAR *bBuffer );
	long lBorder;
	DWORD dwBackColor;
	HWND hCtrl;
public:
	STDMETHOD(get_SelStart)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_SelStart)(/*[in]*/ long newVal);
	STDMETHOD(get_hWnd)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_SelectionFontFlags)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_SelectionFontFlags)(/*[in]*/ long newVal);
	STDMETHOD(get_Tabstop)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Tabstop)(/*[in]*/ long newVal);
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(SetTabstops)(VARIANT *pVar);
	STDMETHOD(get_RightMargin)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_RightMargin)(/*[in]*/ long newVal);
	STDMETHOD(get_LeftMargin)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_LeftMargin)(/*[in]*/ long newVal);
	STDMETHOD(LineScroll)(long lXScroll, long lYScroll);
	STDMETHOD(LineChar)(long lLine, long *pRet);
	STDMETHOD(CharLine)(long lIndex, long *pRet);
	STDMETHOD(GetTextRange)(long lStart, long lLength, BSTR *pRet);
	STDMETHOD(FindText)(long lType, long lStart, long lLength, BSTR bText, long *pRet);
	STDMETHOD(get_SelectionFontOffset)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_SelectionFontOffset)(/*[in]*/ long newVal);
	STDMETHOD(get_FontOffset)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_FontOffset)(/*[in]*/ long newVal);
	STDMETHOD(get_Modify)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Modify)(/*[in]*/ long newVal);
	STDMETHOD(Load)(BSTR bFilename, long *pRet);
	STDMETHOD(Save)(BSTR bFilename, long lOverWrite, long *pRet);
	STDMETHOD(get_LineCount)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_SelLength)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_SelLength)(/*[in]*/ long newVal);
	STDMETHOD(get_SetStart)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_SetStart)(/*[in]*/ long newVal);
	STDMETHOD(ReplaceSelection)(BSTR bText);
	STDMETHOD(Paste)();
	STDMETHOD(Copy)();
	STDMETHOD(Cut)();
	STDMETHOD(EmptyUndo)();
	STDMETHOD(get_ReadOnly)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_ReadOnly)(/*[in]*/ long newVal);
	STDMETHOD(get_SelectionDisplay)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_SelectionDisplay)(/*[in]*/ long newVal);
	STDMETHOD(Redo)();
	STDMETHOD(Undo)();
	STDMETHOD(get_SelectionFontStrikeout)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_SelectionFontStrikeout)(/*[in]*/ long newVal);
	STDMETHOD(get_SelectionFontUnderline)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_SelectionFontUnderline)(/*[in]*/ long newVal);
	STDMETHOD(get_SelectionFontItalic)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_SelectionFontItalic)(/*[in]*/ long newVal);
	STDMETHOD(get_SelectionFontBold)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_SelectionFontBold)(/*[in]*/ long newVal);
	STDMETHOD(get_SelectionFontSize)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_SelectionFontSize)(/*[in]*/ long newVal);
	STDMETHOD(get_SelectionForeColor)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_SelectionForeColor)(/*[in]*/ long newVal);
	STDMETHOD(get_SelectionFontName)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_SelectionFontName)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_MaxLength)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_MaxLength)(/*[in]*/ long newVal);
	STDMETHOD(SetFocus)();
	STDMETHOD(Hide)();
	STDMETHOD(Show)();
	STDMETHOD(get_Style)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Style)(/*[in]*/ long newVal);
	long lReadTo;
	char *pContentBuffer;
};

#endif //__RICHEDIT_H_
