// RichEdit.cpp : Implementation of CRichEdit

#include "stdafx.h"
#include "MGCERichEdit.h"
#include "RichEdit.h"

/////////////////////////////////////////////////////////////////////////////
// CRichEdit


STDMETHODIMP CRichEdit::get_BackColor(long *pVal)
{
	*pVal = (long)dwBackColor;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_BackColor(long newVal)
{
	dwBackColor = (DWORD)newVal;
	::SendMessage( hCtrl, EM_SETBKGNDCOLOR, FALSE, dwBackColor );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_FontName(BSTR *pVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_FACE;
	::SendMessage( hCtrl, EM_GETCHARFORMAT, 0, (LPARAM)&cf );
	*pVal = SysAllocString( cf.szFaceName );
	return S_OK;
}

STDMETHODIMP CRichEdit::put_FontName(BSTR newVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_FACE;
	wcscpy( cf.szFaceName, newVal );
	::SendMessage( hCtrl, EM_SETCHARFORMAT, 0, (LPARAM)&cf );
	SysFreeString( newVal );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_ForeColor(long *pVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_COLOR;
	::SendMessage( hCtrl, EM_GETCHARFORMAT, 0, (LPARAM)&cf );
	*pVal = cf.crTextColor;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_ForeColor(long newVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_COLOR;
	cf.crTextColor = newVal;
	::SendMessage( hCtrl, EM_SETCHARFORMAT, 0, (LPARAM)&cf );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_FontSize(long *pVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_SIZE;
	::SendMessage( hCtrl, EM_GETCHARFORMAT, 0, (LPARAM)&cf );
	*pVal = cf.yHeight;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_FontSize(long newVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_SIZE;
	cf.yHeight = newVal;
	::SendMessage( hCtrl, EM_SETCHARFORMAT, 0, (LPARAM)&cf );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_FontBold(long *pVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_BOLD;
	::SendMessage( hCtrl, EM_GETCHARFORMAT, 0, (LPARAM)&cf );
	if( ( cf.dwEffects & CFE_BOLD ) == CFE_BOLD )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_FontBold(long newVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_BOLD;
	if( newVal )  cf.dwEffects = CFE_BOLD;
	::SendMessage( hCtrl, EM_SETCHARFORMAT, 0, (LPARAM)&cf );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_FontItalic(long *pVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_ITALIC;
	::SendMessage( hCtrl, EM_GETCHARFORMAT, 0, (LPARAM)&cf );
	if( ( cf.dwEffects & CFE_ITALIC ) == CFE_ITALIC )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_FontItalic(long newVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_ITALIC;
	if( newVal )  cf.dwEffects = CFE_ITALIC;
	::SendMessage( hCtrl, EM_SETCHARFORMAT, 0, (LPARAM)&cf );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_FontUnderline(long *pVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_UNDERLINE;
	::SendMessage( hCtrl, EM_GETCHARFORMAT, 0, (LPARAM)&cf );
	if( ( cf.dwEffects & CFE_UNDERLINE ) == CFE_UNDERLINE )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_FontUnderline(long newVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_UNDERLINE;
	if( newVal )  cf.dwEffects = CFE_UNDERLINE;
	::SendMessage( hCtrl, EM_SETCHARFORMAT, 0, (LPARAM)&cf );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_FontStrikeout(long *pVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_STRIKEOUT;
	::SendMessage( hCtrl, EM_GETCHARFORMAT, 0, (LPARAM)&cf );
	if( ( cf.dwEffects & CFE_STRIKEOUT ) == CFE_STRIKEOUT )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_FontStrikeout(long newVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_STRIKEOUT;
	if( newVal )  cf.dwEffects = CFE_STRIKEOUT;
	::SendMessage( hCtrl, EM_SETCHARFORMAT, 0, (LPARAM)&cf );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_Multiline(long *pVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hCtrl, GWL_STYLE );
	if( ( dwStyle & ES_MULTILINE ) == ES_MULTILINE ) *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_Multiline(long newVal)
{
	DWORD dwStyle, dwLen, dwEvents, dwLimit;
	CHARFORMAT cf;
	GETTEXTLENGTHEX tl;
	GETTEXTEX gt;
	BSTR bBuffer;
	RECT Rect;

	dwStyle = ::GetWindowLong( hCtrl, GWL_STYLE );
	dwStyle &= ~ES_MULTILINE;
	dwStyle &= ~ES_WANTRETURN;
	memset( &cf, 0, sizeof(CHARFORMAT) );
	cf.cbSize = sizeof(CHARFORMAT);
	cf.dwMask = 0xFFFFFFFF;
	::SendMessage( hCtrl, EM_GETCHARFORMAT, 0, (LPARAM)&cf );
	bBuffer = NULL;
	tl.flags = GTL_NUMBYTES;
	dwLen = ::SendMessage( hCtrl, EM_GETTEXTLENGTHEX, (WPARAM)&tl, 0 );
	dwEvents = ::SendMessage( hCtrl, EM_GETEVENTMASK, 0, 0 );
	dwLimit = ::SendMessage( hCtrl, EM_GETLIMITTEXT, 0, 0 );
	if( dwLen ) {
		bBuffer = (BSTR)LocalAlloc( LPTR, dwLen + 16 );
		if( ! bBuffer ) return E_OUTOFMEMORY;

		memset( &gt, 0, sizeof(GETTEXTEX) );
		gt.cb = dwLen + 16;
		gt.flags = GT_DEFAULT;
		gt.codepage = 1200;
		::SendMessage( hCtrl, EM_GETTEXTEX, (WPARAM)&gt, (LPARAM)bBuffer );
	}
	GetClientRect( &Rect );
	::DestroyWindow( hCtrl );
	if( newVal )  dwStyle = dwStyle + ES_MULTILINE + ES_WANTRETURN;
	hCtrl = CreateWindow( L"RICHEDIT20W", NULL, dwStyle | WS_CHILD,
						  0, 0, Rect.right, Rect.bottom,
					      this->m_hWnd, (HMENU)1000, _Module.m_hInst, NULL );
	
	::SendMessage( hCtrl, EM_SETCHARFORMAT, 0, (LPARAM)&cf );
	::SendMessage( hCtrl, EM_SETBKGNDCOLOR, 0, dwBackColor );
	::SendMessage( hCtrl, EM_SETEVENTMASK, 0, dwEvents );
	::SendMessage( hCtrl, EM_LIMITTEXT, dwLimit, 0 );

	if( bBuffer ) {
		::SendMessage( hCtrl, EM_SETTEXTMODE, TM_RICHTEXT, 0 );
		::SendMessage( hCtrl, WM_SETTEXT, 0, (LPARAM)bBuffer );
		LocalFree( bBuffer );
	}
	return S_OK;
}

STDMETHODIMP CRichEdit::get_Scrollbars(long *pVal)
{
	DWORD dwStyle;

	dwStyle = ::SendMessage( hCtrl, EM_GETOPTIONS, 0, 0 );
	*pVal = 0;
	if( ( dwStyle & ECO_AUTOHSCROLL ) == ECO_AUTOHSCROLL )
		*pVal += 1;
	if( ( dwStyle & ECO_AUTOVSCROLL ) == ECO_AUTOVSCROLL )
		*pVal += 2;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_Scrollbars(long newVal)
{
	DWORD dwStyle;

	dwStyle = ::SendMessage( hCtrl, EM_GETOPTIONS, 0, 0 );
	dwStyle = dwStyle & ~( ECO_AUTOVSCROLL | ECO_AUTOHSCROLL );
	if( newVal == 1 ) dwStyle |= ECO_AUTOHSCROLL;
	if( newVal == 2 ) dwStyle |= ECO_AUTOVSCROLL;
	if( newVal == 3 ) dwStyle = dwStyle | ECO_AUTOHSCROLL | ECO_AUTOVSCROLL;
	::SendMessage( hCtrl, EM_SETOPTIONS, ECOOP_SET, dwStyle );
	dwStyle = ::GetWindowLong( hCtrl, GWL_STYLE );
	dwStyle = dwStyle & ~( WS_VSCROLL | WS_HSCROLL );
	if( newVal == 1 )  dwStyle |= WS_HSCROLL;
	if( newVal == 2 )  dwStyle |= WS_VSCROLL;
	if( newVal == 3 )  dwStyle |= ( WS_HSCROLL | WS_VSCROLL );
	::SetWindowLong( hCtrl, GWL_STYLE, dwStyle );
	::SetWindowPos( hCtrl, NULL, 0, 0, 0, 0,
					SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER | SWP_FRAMECHANGED );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_Border(long *pVal)
{
	*pVal = lBorder;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_Border(long newVal)
{
	RECT Rect;

	GetClientRect( &Rect );
	lBorder = newVal;
	if( lBorder )
		::SetWindowPos( hCtrl, NULL, 1, 1, Rect.right - 2, Rect.bottom - 2,
						SWP_NOZORDER );
	else
		::SetWindowPos( hCtrl, NULL, 0, 0, Rect.right, Rect.bottom,	SWP_NOZORDER );
	return S_OK;
}


STDMETHODIMP CRichEdit::get_Caption(BSTR *pVal)
{
	BSTR bBuffer;
	DWORD dwLen;

	dwLen = ::SendMessage( hCtrl, WM_GETTEXTLENGTH, 0, 0 );
	if( dwLen ) {
		bBuffer = (BSTR)LocalAlloc( LPTR, ( dwLen + 8 ) * sizeof(TCHAR) );
		if( ! bBuffer ) return E_OUTOFMEMORY;
		::SendMessage( hCtrl, WM_GETTEXT, dwLen + 1, (LPARAM)bBuffer );
		*pVal = bBuffer;
	} else *pVal = SysAllocString( L"\0" );
	return S_OK;
}

STDMETHODIMP CRichEdit::put_Caption(BSTR newVal)
{
	::SendMessage( hCtrl, WM_SETTEXT, 0, (LPARAM)newVal );
	SysFreeString( newVal );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_RTFText(BSTR *pVal)
{
	EDITSTREAM es;
	BSTR pBuffer;

	pContentBuffer = NULL;
	es.dwError = 0;
	es.dwCookie = (DWORD)this;
	es.pfnCallback = (EDITSTREAMCALLBACK)RTFSaveStream;
	SendMessage( hCtrl, EM_STREAMOUT, SF_RTF, (LPARAM)&es );
	if( ! pContentBuffer ) {
		Error( L"An error occurred retrieving RTF text" );
		return E_FAIL;
	}
	pBuffer = (BSTR)LocalAlloc( LPTR, ( strlen( pContentBuffer ) + 8 ) * sizeof(TCHAR) );
	if( ! pBuffer ) {
		LocalFree( pContentBuffer );
		pContentBuffer = NULL;
		return E_OUTOFMEMORY;
	}
	AToW( pContentBuffer, pBuffer );
	*pVal = SysAllocString( pBuffer );
	LocalFree( pBuffer );
//	*pVal = pBuffer;
	LocalFree( pContentBuffer );
	pContentBuffer = NULL;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_RTFText(BSTR newVal)
{
	EDITSTREAM es;

	pContentBuffer = (char *)LocalAlloc( LPTR, wcslen( newVal ) + 4 );
	if( ! pContentBuffer )  return E_FAIL;
	WToA( newVal, pContentBuffer );
	SysFreeString( newVal );
	es.dwError = 0;
	es.dwCookie = (DWORD)this;
	es.pfnCallback = (EDITSTREAMCALLBACK)RTFLoadStream;
	lReadTo = 0;
	SendMessage( hCtrl, EM_STREAMIN, SF_RTF, (LPARAM)&es );
	return S_OK;
}


void CRichEdit::AToW(char *pszBuffer, TCHAR *bBuffer)
{
	while( *pszBuffer )
		*bBuffer++ = (TCHAR)*pszBuffer++;
	*bBuffer = L'\0';
}

void CRichEdit::WToA(TCHAR *bBuffer, char *pszBuffer)
{
	while( *bBuffer )
		*pszBuffer++ = (char)*bBuffer++;
	*pszBuffer = '\0';
}


STDMETHODIMP CRichEdit::get_Style(long *pVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hCtrl, GWL_EXSTYLE );
	if( ( dwStyle & WS_EX_CLIENTEDGE ) == WS_EX_CLIENTEDGE )  *pVal = 1;
	else
	if( ( dwStyle & WS_EX_WINDOWEDGE ) == WS_EX_WINDOWEDGE )  *pVal = 2;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_Style(long newVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hCtrl, GWL_EXSTYLE );
	dwStyle = dwStyle & ~( WS_EX_CLIENTEDGE | WS_EX_STATICEDGE | WS_EX_WINDOWEDGE );
	if( newVal == 1 ) dwStyle |= WS_EX_CLIENTEDGE;
	if( newVal == 2 ) dwStyle |= WS_EX_WINDOWEDGE;
	::SetWindowLong( hCtrl, GWL_EXSTYLE, dwStyle );
	::SetWindowPos( hCtrl, NULL, 0, 0, 0, 0,
				    SWP_NOZORDER | SWP_NOSIZE | SWP_NOMOVE | SWP_FRAMECHANGED );
	return S_OK;
}

STDMETHODIMP CRichEdit::Show()
{
	ShowWindow( SW_SHOW );
	return S_OK;
}

STDMETHODIMP CRichEdit::Hide()
{
	ShowWindow( SW_HIDE );
	return S_OK;
}

STDMETHODIMP CRichEdit::SetFocus()
{
	::SetFocus( hCtrl );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_MaxLength(long *pVal)
{
	*pVal = ::SendMessage( hCtrl, EM_GETLIMITTEXT, 0, 0 );
	return S_OK;
}

STDMETHODIMP CRichEdit::put_MaxLength(long newVal)
{
	::SendMessage( hCtrl, EM_EXLIMITTEXT, 0, newVal );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_SelectionFontName(BSTR *pVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_FACE;
	::SendMessage( hCtrl, EM_GETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
	*pVal = SysAllocString( cf.szFaceName );
	return S_OK;
}

STDMETHODIMP CRichEdit::put_SelectionFontName(BSTR newVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_FACE;
	wcscpy( cf.szFaceName, newVal );
	::SendMessage( hCtrl, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
	SysFreeString( newVal );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_SelectionForeColor(long *pVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_COLOR;
	::SendMessage( hCtrl, EM_GETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
	*pVal = cf.crTextColor;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_SelectionForeColor(long newVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_COLOR;
	cf.crTextColor = newVal;
	::SendMessage( hCtrl, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_SelectionFontSize(long *pVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_SIZE;
	::SendMessage( hCtrl, EM_GETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
	*pVal = cf.yHeight;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_SelectionFontSize(long newVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_SIZE;
	cf.yHeight = newVal;
	::SendMessage( hCtrl, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_SelectionFontBold(long *pVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_BOLD;
	::SendMessage( hCtrl, EM_GETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
	if( ( cf.dwEffects & CFE_BOLD ) == CFE_BOLD )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_SelectionFontBold(long newVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_BOLD;
	if( newVal )  cf.dwEffects = CFE_BOLD;
	::SendMessage( hCtrl, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_SelectionFontItalic(long *pVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_ITALIC;
	::SendMessage( hCtrl, EM_GETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
	if( ( cf.dwEffects & CFE_ITALIC ) == CFE_ITALIC )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_SelectionFontItalic(long newVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_ITALIC;
	if( newVal )  cf.dwEffects = CFE_ITALIC;
	::SendMessage( hCtrl, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_SelectionFontUnderline(long *pVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_UNDERLINE;
	::SendMessage( hCtrl, EM_GETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
	if( ( cf.dwEffects & CFE_UNDERLINE ) == CFE_UNDERLINE )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_SelectionFontUnderline(long newVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_UNDERLINE;
	if( newVal )  cf.dwEffects = CFE_UNDERLINE;
	::SendMessage( hCtrl, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_SelectionFontStrikeout(long *pVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_STRIKEOUT;
	::SendMessage( hCtrl, EM_GETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
	if( ( cf.dwEffects & CFE_STRIKEOUT ) == CFE_STRIKEOUT )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_SelectionFontStrikeout(long newVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_STRIKEOUT;
	if( newVal )  cf.dwEffects = CFE_STRIKEOUT;
	::SendMessage( hCtrl, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
	return S_OK;
}

STDMETHODIMP CRichEdit::Undo()
{
	::SendMessage( hCtrl, EM_UNDO, 0, 0 );
	return S_OK;
}

STDMETHODIMP CRichEdit::Redo()
{
	::SendMessage( hCtrl, EM_REDO, 0, 0 );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_SelectionDisplay(long *pVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hCtrl, GWL_STYLE );
	if( ( dwStyle & ES_NOHIDESEL ) == ES_NOHIDESEL )  *pVal = 1;
	else pVal = 0;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_SelectionDisplay(long newVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hCtrl, GWL_STYLE );
	if( newVal )  dwStyle |= ES_NOHIDESEL;
	else dwStyle &= ~ES_NOHIDESEL;
	::SetWindowLong( hCtrl, GWL_STYLE, dwStyle );
	dwStyle = ::SendMessage( hCtrl, EM_GETOPTIONS, 0, 0 );
	if( newVal ) dwStyle |= ECO_NOHIDESEL;
	else  dwStyle &= ~ECO_NOHIDESEL;
	::SendMessage( hCtrl, EM_SETOPTIONS, ECOOP_SET, dwStyle );
	::SetWindowPos( hCtrl, NULL, 0, 0, 0, 0,
					SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER | SWP_FRAMECHANGED );
	return S_OK;
}


STDMETHODIMP CRichEdit::get_ReadOnly(long *pVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hCtrl, GWL_STYLE );
	if( ( dwStyle & ES_READONLY ) == ES_READONLY )  *pVal = 1;
	else pVal = 0;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_ReadOnly(long newVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hCtrl, GWL_STYLE );
	if( newVal )  dwStyle |= ES_READONLY;
	else dwStyle &= ~ES_READONLY;
	::SetWindowLong( hCtrl, GWL_STYLE, dwStyle );
	dwStyle = ::SendMessage( hCtrl, EM_GETOPTIONS, 0, 0 );
	if( newVal ) dwStyle |= ECO_READONLY;
	else  dwStyle &= ~ECO_READONLY;
	::SendMessage( hCtrl, EM_SETOPTIONS, ECOOP_SET, dwStyle );
	::SetWindowPos( hCtrl, NULL, 0, 0, 0, 0,
					SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER | SWP_FRAMECHANGED );
	return S_OK;
}

STDMETHODIMP CRichEdit::EmptyUndo()
{
	::SendMessage( hCtrl, EM_EMPTYUNDOBUFFER, 0, 0 );
	return S_OK;
}

STDMETHODIMP CRichEdit::Cut()
{
	::SendMessage( hCtrl, WM_CUT, 0, 0 );
	return S_OK;
}

STDMETHODIMP CRichEdit::Copy()
{
	::SendMessage( hCtrl, WM_COPY, 0, 0 );
	return S_OK;
}

STDMETHODIMP CRichEdit::Paste()
{
	::SendMessage( hCtrl, WM_PASTE, 0, 0 );
	return S_OK;
}

STDMETHODIMP CRichEdit::ReplaceSelection(BSTR bText)
{
	::SendMessage( hCtrl, EM_REPLACESEL, TRUE, (LPARAM)bText );
	SysFreeString( bText );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_SetStart(long *pVal)
{
	CHARRANGE cr;

	::SendMessage( hCtrl, EM_EXGETSEL, 0, (LPARAM)&cr );
	*pVal = cr.cpMin;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_SetStart(long newVal)
{
	CHARRANGE cr;

	lSetStart = newVal;
	cr.cpMin = lSetStart;
	cr.cpMax = lSetStart + lSelLength;
	::SendMessage( hCtrl, EM_EXSETSEL, 0, (LPARAM)&cr );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_SelLength(long *pVal)
{
	CHARRANGE cr;

	::SendMessage( hCtrl, EM_EXGETSEL, 0, (LPARAM)&cr );
	*pVal = cr.cpMax - cr.cpMin;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_SelLength(long newVal)
{
	CHARRANGE cr;

	lSelLength = newVal;
	cr.cpMin = lSetStart;
	cr.cpMax = lSetStart + lSelLength;
	::SendMessage( hCtrl, EM_EXSETSEL, 0, (LPARAM)&cr );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_LineCount(long *pVal)
{
	*pVal = ::SendMessage( hCtrl, EM_GETLINECOUNT, 0, 0 );
	return S_OK;
}

STDMETHODIMP CRichEdit::Save(BSTR bFilename, long lOverWrite, long *pRet)
{
	EDITSTREAM es;
	DWORD dwOut;
	HANDLE hFile;

	pContentBuffer = NULL;
	es.dwError = 0;
	es.dwCookie = (DWORD)this;
	es.pfnCallback = (EDITSTREAMCALLBACK)RTFSaveStream;
	SendMessage( hCtrl, EM_STREAMOUT, SF_RTF, (LPARAM)&es );
	if( ! pContentBuffer ) {
		Error( L"Error retrieving RTF text" );
		SysFreeString( bFilename );
		return E_FAIL;
	}
	if( ! lOverWrite )
		hFile = CreateFile( bFilename, GENERIC_WRITE, 0, NULL, CREATE_NEW,
							FILE_ATTRIBUTE_NORMAL, NULL );
	else
		hFile = CreateFile( bFilename, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS,
							FILE_ATTRIBUTE_NORMAL, NULL );
	if( hFile == INVALID_HANDLE_VALUE ) {
		LocalFree( pContentBuffer );
		SysFreeString( bFilename );
		Error( L"Unable to create specified file" );
		return E_FAIL;
	}

	WriteFile( hFile, pContentBuffer, strlen( pContentBuffer ), &dwOut, NULL );
	CloseHandle( hFile );
	LocalFree( pContentBuffer );
	pContentBuffer = NULL;
	*pRet = (long)dwOut;
	SysFreeString( bFilename );
	return S_OK;
}



STDMETHODIMP CRichEdit::Load(BSTR bFilename, long *pRet)
{
	EDITSTREAM es;
	DWORD dwLen, dwIn;
	HANDLE hFile;


	hFile = CreateFile( bFilename, GENERIC_READ, 0, NULL, OPEN_EXISTING,
						FILE_ATTRIBUTE_NORMAL, NULL );
	if( hFile == INVALID_HANDLE_VALUE ) {
		Error( L"Unable to open specified file" );
		SysFreeString( bFilename );
		return E_FAIL;
	}
	dwLen = GetFileSize( hFile, NULL );
	if( ! dwLen ) {
		CloseHandle( hFile );
		*pRet = 0;
		SysFreeString( bFilename );
		return S_OK;
	}

	pContentBuffer = (char *)LocalAlloc( LPTR, dwLen + 1 );
	if( ! pContentBuffer ) {
		CloseHandle( hFile );
		SysFreeString( bFilename );
		return E_OUTOFMEMORY;
	}

	ReadFile( hFile, pContentBuffer, dwLen, &dwIn, NULL );
	CloseHandle( hFile );
	es.dwError = 0;
	es.dwCookie = (DWORD)this;
	es.pfnCallback = (EDITSTREAMCALLBACK)RTFLoadStream;
	lReadTo = 0;
	SendMessage( hCtrl, EM_STREAMIN, SF_RTF, (LPARAM)&es );
	LocalFree( pContentBuffer );
	*pRet = dwIn;
	return S_OK;
}

STDMETHODIMP CRichEdit::get_Modify(long *pVal)
{
	*pVal = ::SendMessage( hCtrl, EM_GETMODIFY, 0, 0 );
	return S_OK;
}

STDMETHODIMP CRichEdit::put_Modify(long newVal)
{
	::SendMessage( hCtrl, EM_SETMODIFY, newVal, 0 );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_FontOffset(long *pVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_OFFSET;
	::SendMessage( hCtrl, EM_GETCHARFORMAT, 0, (LPARAM)&cf );
	*pVal = cf.yOffset;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_FontOffset(long newVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_OFFSET;
	cf.yOffset = newVal;
	::SendMessage( hCtrl, EM_SETCHARFORMAT, 0, (LPARAM)&cf );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_SelectionFontOffset(long *pVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_OFFSET;
	::SendMessage( hCtrl, EM_GETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
	*pVal = cf.yOffset;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_SelectionFontOffset(long newVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_OFFSET;
	cf.yOffset = newVal;
	::SendMessage( hCtrl, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
	return S_OK;
}


STDMETHODIMP CRichEdit::FindText(long lType, long lStart, long lLength, BSTR bText, long *pRet)
{
	FINDTEXT ft;
	long lVal;

	if( ! lType )  lType = 1;
	if( ! lLength ) lLength = ::SendMessage( hCtrl, WM_GETTEXTLENGTH, 0, 0 );
	ft.chrg.cpMin = lStart;
	ft.chrg.cpMax = lStart + lLength;
	ft.lpstrText = bText;
	lVal = ::SendMessage( hCtrl, EM_FINDTEXT, lType, (LPARAM)&ft );
	SysFreeString( bText );
	*pRet = lVal;
	return S_OK;
}

STDMETHODIMP CRichEdit::GetTextRange(long lStart, long lLength, BSTR *pRet)
{
	TCHAR *pBuffer;
	TEXTRANGE tr;

	pBuffer = (BSTR)LocalAlloc( LPTR, ( lLength + 1 ) * 2 );
	tr.chrg.cpMin = lStart;
	tr.chrg.cpMax = lStart + lLength;
	tr.lpstrText = pBuffer;
	::SendMessage( hCtrl, EM_GETTEXTRANGE, 0, (LPARAM)&tr );
	*pRet = pBuffer;
	return S_OK;
}

STDMETHODIMP CRichEdit::CharLine(long lIndex, long *pRet)
{
	*pRet = ::SendMessage( hCtrl, EM_LINEFROMCHAR, lIndex, 0 );
	return S_OK;
}

STDMETHODIMP CRichEdit::LineChar(long lLine, long *pRet)
{
	*pRet = ::SendMessage( hCtrl, EM_LINEINDEX, lLine, 0 );
	return S_OK;
}

STDMETHODIMP CRichEdit::LineScroll(long lXScroll, long lYScroll)
{
	::SendMessage( hCtrl, EM_LINESCROLL, lXScroll, lYScroll );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_LeftMargin(long *pVal)
{
	DWORD dwVal;
	dwVal = ::SendMessage( hCtrl, EM_GETMARGINS, 0, 0 );
	*pVal = (long)LOWORD( dwVal );
	return S_OK;
}

STDMETHODIMP CRichEdit::put_LeftMargin(long newVal)
{
	DWORD dwVal;
	dwVal = ::SendMessage( hCtrl, EM_GETMARGINS, 0, 0 );
	dwVal = MAKELONG( (WORD)newVal, HIWORD( dwVal ) );
	::SendMessage( hCtrl, EM_SETMARGINS, EC_LEFTMARGIN | EC_RIGHTMARGIN, dwVal );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_RightMargin(long *pVal)
{
	DWORD dwVal;
	dwVal = ::SendMessage( hCtrl, EM_GETMARGINS, 0, 0 );
	*pVal = (long)( HIWORD( dwVal ) >> 16 );
	return S_OK;
}

STDMETHODIMP CRichEdit::put_RightMargin(long newVal)
{
	DWORD dwVal;
	dwVal = ::SendMessage( hCtrl, EM_GETMARGINS, 0, 0 );
	dwVal = MAKELONG( LOWORD( dwVal ), (WORD)newVal );
	::SendMessage( hCtrl, EM_SETMARGINS, EC_LEFTMARGIN | EC_RIGHTMARGIN, dwVal );
	return S_OK;
}

STDMETHODIMP CRichEdit::SetTabstops(VARIANT *pVar)
{
	VARIANT nVar, *pArray;
	int *piArray, i, iElements;
	DWORD dwUBound, dwLBound;

	if( ( pVar->vt & VT_ARRAY ) == 0 ) {
		if( FAILED( VariantChangeType( &nVar, pVar, 0, VT_I4 ) ) ) return E_FAIL;
		::SendMessage( hCtrl, EM_SETTABSTOPS, 1, (LPARAM)&nVar.lVal );
	} else {
		SafeArrayAccessData( V_ARRAY( pVar ), (void **)&pArray );
		SafeArrayGetLBound( V_ARRAY( pVar ), 1, (long *)&dwLBound );
		SafeArrayGetUBound( V_ARRAY( pVar ), 1, (long *)&dwUBound );
		iElements = (int)dwUBound - (int)dwLBound + 1;
		piArray = (int *)LocalAlloc( LPTR, sizeof(int) * iElements );
		if( ! piArray ) {
			SafeArrayUnaccessData( V_ARRAY( pVar ) );
			SafeArrayDestroy( V_ARRAY( pVar ) );
			return E_FAIL;
		}
		for( i = 0; i < iElements; i++ ) {
			VariantInit( &nVar );
			if( FAILED( VariantChangeType( &nVar, &pArray[ i ], 0, VT_I4 ) ) )
				return E_FAIL;
			*( piArray + i ) = nVar.lVal;
		}
		::SendMessage( hCtrl, EM_SETTABSTOPS, iElements, (LPARAM)piArray );
		LocalFree( piArray );
		SafeArrayUnaccessData( V_ARRAY( pVar ) );
		SafeArrayDestroy( V_ARRAY( pVar ) );
	}
	return S_OK;
}

STDMETHODIMP CRichEdit::get_Version(long *pVal)
{
	*pVal = 102;
	return S_OK;
}

STDMETHODIMP CRichEdit::get_Tabstop(long *pVal)
{
	if( GetWindowLong( GWL_STYLE ) & WS_TABSTOP )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_Tabstop(long newVal)
{
	if( newVal ) SetWindowLong( GWL_STYLE, GetWindowLong( GWL_STYLE ) | WS_TABSTOP );
	else SetWindowLong( GWL_STYLE, GetWindowLong( GWL_STYLE ) & ~WS_TABSTOP );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_SelectionFontFlags(long *pVal)
{
	CHARFORMATW cf;
	DWORD dwVal;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_STRIKEOUT | CFM_UNDERLINE | CFM_BOLD | CFM_ITALIC;
	::SendMessage( hCtrl, EM_GETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
	dwVal = 0;
	if( ( cf.dwEffects & CFE_BOLD ) == CFE_BOLD )  dwVal += 1;
	if( ( cf.dwEffects & CFE_ITALIC ) == CFE_ITALIC )  dwVal += 2;
	if( ( cf.dwEffects & CFE_UNDERLINE ) == CFE_UNDERLINE )  dwVal += 4;
	if( ( cf.dwEffects & CFE_STRIKEOUT ) == CFE_STRIKEOUT )  dwVal += 8;
	*pVal = dwVal;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_SelectionFontFlags(long newVal)
{
	CHARFORMATW cf;

	memset( &cf, 0, sizeof(CHARFORMATW) );
	cf.cbSize = sizeof(CHARFORMATW);
	cf.dwMask = CFM_BOLD | CFM_ITALIC | CFM_UNDERLINE | CFM_STRIKEOUT;
	if( ( newVal & 1 ) == 1 )  cf.dwEffects |= CFE_BOLD;
	if( ( newVal & 2 ) == 2 )  cf.dwEffects |= CFE_ITALIC;
	if( ( newVal & 4 ) == 4 )  cf.dwEffects |= CFE_UNDERLINE;
	if( ( newVal & 8 ) == 8 )  cf.dwEffects |= CFE_STRIKEOUT;
	::SendMessage( hCtrl, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf );
	return S_OK;
}

STDMETHODIMP CRichEdit::get_hWnd(long *pVal)
{
	*pVal = (long)m_hWnd;
	return S_OK;
}

STDMETHODIMP CRichEdit::get_SelStart(long *pVal)
{
	CHARRANGE cr;

	::SendMessage( hCtrl, EM_EXGETSEL, 0, (LPARAM)&cr );
	*pVal = cr.cpMin;
	return S_OK;
}

STDMETHODIMP CRichEdit::put_SelStart(long newVal)
{
	CHARRANGE cr;

	lSetStart = newVal;
	cr.cpMin = lSetStart;
	cr.cpMax = lSetStart + lSelLength;
	::SendMessage( hCtrl, EM_EXSETSEL, 0, (LPARAM)&cr );
	return S_OK;
}