// MGCERichEdit.cpp : Implementation of DLL Exports.


// Note: Proxy/Stub Information
//		To build a separate proxy/stub DLL, 
//		run nmake -f MGCERichEditps.mk in the project directory.

#include "stdafx.h"
#include "resource.h"
#include "initguid.h"
#include "MGCERichEdit.h"

#include "MGCERichEdit_i.c"
#include "RichEdit.h"


CComModule _Module;
HANDLE hREditLib;

BEGIN_OBJECT_MAP(ObjectMap)
OBJECT_ENTRY(CLSID_RichEdit, CRichEdit)
END_OBJECT_MAP()

/////////////////////////////////////////////////////////////////////////////
// DLL Entry Point

extern "C"
BOOL WINAPI DllMain(HANDLE hInstance, DWORD dwReason, LPVOID /*lpReserved*/)
{
	if (dwReason == DLL_PROCESS_ATTACH)
	{
		_Module.Init(ObjectMap, (HINSTANCE)hInstance);
		hREditLib = LoadLibrary( L"RICHED20.DLL" );
#ifndef UNDER_CE
		DisableThreadLibraryCalls((HINSTANCE)hInstance);
#endif
	}
	else if (dwReason == DLL_PROCESS_DETACH) {
		if( hREditLib ) FreeLibrary( (HINSTANCE)hREditLib );
		_Module.Term();
	}
	return TRUE;    // ok
}

/////////////////////////////////////////////////////////////////////////////
// Used to determine whether the DLL can be unloaded by OLE

STDAPI DllCanUnloadNow(void)
{
	return (_Module.GetLockCount()==0) ? S_OK : S_FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// Returns a class factory to create an object of the requested type

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
	return _Module.GetClassObject(rclsid, riid, ppv);
}

/////////////////////////////////////////////////////////////////////////////
// DllRegisterServer - Adds entries to the system registry

STDAPI DllRegisterServer(void)
{
	// registers object, typelib and all interfaces in typelib
	return _Module.RegisterServer(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
// DllUnregisterServer - Removes entries from the system registry

STDAPI DllUnregisterServer(void)
{
	_Module.UnregisterServer();
	return S_OK;
}

DWORD CALLBACK RTFSaveStream( DWORD dwCookie, LPBYTE lpBuffer, LONG lSize, LONG *plRead )
{
	CRichEdit *pThis;
	DWORD dwSize;
	char *pBuffer;

	if( ! lSize )  return 1;
	pThis = (CRichEdit *)dwCookie;
	if( ! pThis->pContentBuffer ) {
		pThis->pContentBuffer = (char *)LocalAlloc( LPTR, lSize + 2 );
		if( ! pThis->pContentBuffer ) return 1;
	} else {
		dwSize = LocalSize( pThis->pContentBuffer );
		pBuffer = (char *)LocalAlloc( LPTR, dwSize + lSize + 2 );
		if( ! pBuffer ) {
			LocalFree( pThis->pContentBuffer );
			pThis->pContentBuffer = NULL;
			return 1;
		}
		memcpy( pBuffer, pThis->pContentBuffer, dwSize );
		LocalFree( pThis->pContentBuffer );
		pThis->pContentBuffer = pBuffer;
	}
	strncat( pThis->pContentBuffer, (char *)lpBuffer, lSize );
	*plRead = lSize;
	return 0;
}

DWORD CALLBACK RTFLoadStream( DWORD dwCookie, LPBYTE lpBuffer, LONG lSize, LONG *plRead )
{
	CRichEdit *pThis;

	if( ! lSize )  return 1;
	pThis = (CRichEdit *)dwCookie;
	strncpy( (char *)lpBuffer, pThis->pContentBuffer + pThis->lReadTo, lSize );
	pThis->lReadTo += lSize;
	if( (long)strlen( pThis->pContentBuffer ) < lSize )
		*plRead = strlen( pThis->pContentBuffer );
	else
		*plRead = lSize;
	return 0;
}

