// Mail.h : Declaration of the CMail

#ifndef __MAIL_H_
#define __MAIL_H_

#include "resource.h"       // main symbols

#define DEBUGOUT(x) ::SendMessage(::FindWindow(L"MGDebug",NULL),WM_COMMAND,0,(LPARAM)x)

/////////////////////////////////////////////////////////////////////////////
// CMail
class ATL_NO_VTABLE CMail : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CMail, &CLSID_Mail>,
	public IDispatchImpl<IMail, &IID_IMail, &LIBID_MGCEMAILLib>
{
public:
	CMail()
	{
		bService = bMessage = bSubject = bBCC = bCC = bFrom = bTo = NULL;
		dwFolder = 0;
		hMail = NULL;
		memset( &ftDate, 0, sizeof(FILETIME) );
	}

DECLARE_REGISTRY_RESOURCEID(IDR_MAIL)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CMail)
	COM_INTERFACE_ENTRY(IMail)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()

// IMail
public:
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(Move)(long lID);
	STDMETHOD(get_AllServices)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(DeleteMessage)(long lID);
	STDMETHOD(WriteMessage)(long *plID);
	STDMETHOD(ReadMessage)(long lID);
	STDMETHOD(Clear)();
	STDMETHOD(DeleteFolder)(long lID);
	STDMETHOD(CreateFolder)(BSTR bName, long *plRet);
	STDMETHOD(get_Error)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_ErrorMsg)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(get_Date)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_Date)(/*[in]*/ VARIANT *newVal);
	STDMETHOD(get_Folder)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Folder)(/*[in]*/ long newVal);
	STDMETHOD(get_Service)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_Service)(/*[in]*/ VARIANT *newVal);
	STDMETHOD(get_Message)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_Message)(/*[in]*/ VARIANT *newVal);
	STDMETHOD(get_Subject)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_Subject)(/*[in]*/ VARIANT *newVal);
	STDMETHOD(get_BCC)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_BCC)(/*[in]*/ VARIANT *newVal);
	STDMETHOD(get_CC)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_CC)(/*[in]*/ VARIANT *newVal);
	STDMETHOD(get_Sender)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_Sender)(/*[in]*/ VARIANT *newVal);
	STDMETHOD(get_Recipient)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_Recipient)(/*[in]*/ VARIANT *newVal);
	STDMETHOD(get_FolderMessages)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(get_FolderName)(long lID, /*[out, retval]*/ BSTR *pVal);
	STDMETHOD(get_AllFolders)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(Close)();
	STDMETHOD(Open)();
private:
	void ClearFields();
	BSTR bService;
	FILETIME ftDate;
	BSTR bMessage;
	BSTR bSubject;
	BSTR bBCC;
	BSTR bCC;
	BSTR bFrom;
	BSTR bTo;
	DWORD dwFolder;
	HANDLE hMail;
};

#endif //__MAIL_H_
