// Mail.cpp : Implementation of CMail
#include "stdafx.h"
#include "msgstore.h"
#include "MGCEMail.h"
#include "Mail.h"

/////////////////////////////////////////////////////////////////////////////
// CMail


STDMETHODIMP CMail::Open()
{
	BOOL bStatus;

	if( hMail ) {
		Error( L"The mail service is already open" );
		return E_HANDLE;
	}
	bStatus = MailOpen( &hMail, FALSE );
	if( ! bStatus ) {
		MailClose( hMail );
		hMail = NULL;
		Error( L"Unable to open mail service" );
		return E_FAIL;
	}
	return S_OK;
}


STDMETHODIMP CMail::Close()
{
	if( hMail )  MailClose( hMail );
	hMail = NULL;
	return S_OK;
}

STDMETHODIMP CMail::get_AllFolders(VARIANT *pVal)
{
	int iID, iLen, iCount, i;
	SAFEARRAY *psa;
	TCHAR szName[ 64 ];
	BOOL bStatus;
	VARIANT *pV;

	if( ! hMail ) {
		Error( L"Mail service is not open" );
		return E_HANDLE;
	}
	iCount = 0;
	for( i = 0; i < 256; i++ ) {
		iID = i;
		iLen = 64;
		bStatus = MailGetFolderName( hMail, &iID, &iLen, szName );
		if( bStatus ) ++iCount;
	}
	if( ! iCount ) {
		V_VT( pVal ) = VT_EMPTY;
		return S_OK;
	}
	psa = SafeArrayCreateVector( VT_VARIANT, 1, iCount );
	if( ! psa )  return E_OUTOFMEMORY;
	pV = (VARIANT *)psa->pvData;
	for( i = 0; i < 256; i++ ) {
		iID = i;
		iLen = 64;
		bStatus = MailGetFolderName( hMail, &iID, &iLen, szName );
		if( bStatus ) {
			V_I4( pV ) = i;
			V_VT( pV ) = VT_I4;
			++pV;
		}
	}
	V_VT( pVal ) = VT_ARRAY | VT_VARIANT;
	V_ARRAY( pVal ) = psa;
	return S_OK;
}

STDMETHODIMP CMail::get_FolderName(long lID, BSTR *pVal)
{
	int iLen;
	BOOL bStatus;
	TCHAR szName[ 64 ];

	if( ! hMail ) {
		Error( L"Mail service is not open" );
		return E_HANDLE;
	}
	iLen = 64;
	lID &= 255;
	bStatus = MailGetFolderName( hMail, (int *)&lID, &iLen, szName );
	if( ! bStatus ) {
		Error( L"Error retrieving mail folder" );
		return E_FAIL;
	}
	*pVal = SysAllocString( szName );
	return S_OK;
}

STDMETHODIMP CMail::get_FolderMessages(VARIANT *pVal)
{
	MailMsg mm;
	int iCount;
	BOOL bStatus;
	SAFEARRAY *psa;
	VARIANT *pV;

	if( ! hMail ) {
		Error( L"Mail service is not open" );
		return E_HANDLE;
	}
	memset( &mm, 0, sizeof(MailMsg) );
	mm.dwFlags = dwFolder + MAIL_GET_FLAGS;
	iCount = 0;
	bStatus = MailFirst( hMail, &mm );
	while( bStatus ) {
		++iCount;
		bStatus = MailNext( hMail, &mm );
	}
	if( ! iCount ) {
		V_VT( pVal ) = VT_EMPTY;
		return S_OK;
	}
	psa = SafeArrayCreateVector( VT_VARIANT, 1, iCount );
	if( ! psa )  return E_OUTOFMEMORY;
	pV = (VARIANT *)psa->pvData;
	memset( &mm, 0, sizeof(MailMsg) );
	mm.dwFlags = dwFolder + MAIL_GET_FLAGS;
	bStatus = MailFirst( hMail, &mm );
	while( iCount && bStatus ) {
		V_I4( pV ) = mm.oid;
		V_VT( pV ) = VT_I4;
		++pV;
		--iCount;
		bStatus = MailNext( hMail, &mm );
	}
	V_VT( pVal ) = VT_ARRAY | VT_VARIANT;
	V_ARRAY( pVal ) = psa;
	return S_OK;
}

STDMETHODIMP CMail::get_Recipient(VARIANT *pVal)
{
	if( bTo ) V_BSTR( pVal ) = SysAllocString( bTo );
	else V_BSTR( pVal ) = SysAllocString( L"\0" );
	V_VT( pVal ) = VT_BSTR;
	return S_OK;
}

STDMETHODIMP CMail::put_Recipient(VARIANT *newVal)
{
	VARIANT v;

	VariantInit( &v );
	if( VariantChangeType( &v, newVal, 0, VT_BSTR ) != S_OK )
		return E_INVALIDARG;
	if( bTo ) SysFreeString( bTo );
	if( wcslen( v.bstrVal ) ) bTo = SysAllocString( v.bstrVal );
	else bTo = NULL;
	VariantClear( &v );
	VariantClear( newVal );
	return S_OK;
}

STDMETHODIMP CMail::get_Sender(VARIANT *pVal)
{
	if( bFrom ) V_BSTR( pVal ) = SysAllocString( bFrom );
	else        V_BSTR( pVal ) = SysAllocString( L"\0" );
	V_VT( pVal ) = VT_BSTR;
	return S_OK;
}

STDMETHODIMP CMail::put_Sender(VARIANT *newVal)
{
	VARIANT v;

	VariantInit( &v );
	if( VariantChangeType( &v, newVal, 0, VT_BSTR ) != S_OK )
		return E_INVALIDARG;
	if( bFrom ) SysFreeString( bFrom );
	if( wcslen( v.bstrVal ) ) bFrom = SysAllocString( v.bstrVal );
	else bFrom = NULL;
	VariantClear( &v );
	VariantClear( newVal );
	return S_OK;
}

STDMETHODIMP CMail::get_CC(VARIANT *pVal)
{
	if( bCC ) V_BSTR( pVal ) = SysAllocString( bCC );
	else      V_BSTR( pVal ) = SysAllocString( L"\0" );
	V_VT( pVal ) = VT_BSTR;
	return S_OK;
}

STDMETHODIMP CMail::put_CC(VARIANT *newVal)
{
	VARIANT v;

	VariantInit( &v );
	if( VariantChangeType( &v, newVal, 0, VT_BSTR ) != S_OK )
		return E_INVALIDARG;
	if( bCC ) SysFreeString( bCC );
	if( wcslen( v.bstrVal ) ) bCC = SysAllocString( v.bstrVal );
	else bCC = NULL;
	VariantClear( &v );
	VariantClear( newVal );
	return S_OK;
}

STDMETHODIMP CMail::get_BCC(VARIANT *pVal)
{
	if( bBCC ) V_BSTR( pVal ) = SysAllocString( bBCC );
	else       V_BSTR( pVal ) = SysAllocString( L"\0" );
	V_VT( pVal ) = VT_BSTR;
	return S_OK;
}

STDMETHODIMP CMail::put_BCC(VARIANT *newVal)
{
	VARIANT v;

	VariantInit( &v );
	if( VariantChangeType( &v, newVal, 0, VT_BSTR ) != S_OK )
		return E_INVALIDARG;
	if( bBCC ) SysFreeString( bBCC );
	if( wcslen( v.bstrVal ) ) bBCC = SysAllocString( v.bstrVal );
	else bBCC = NULL;
	VariantClear( &v );
	VariantClear( newVal );
	return S_OK;
}

STDMETHODIMP CMail::get_Subject(VARIANT *pVal)
{
	if( bSubject ) V_BSTR( pVal ) = SysAllocString( bSubject );
	else           V_BSTR( pVal ) = SysAllocString( L"\0" );
	V_VT( pVal ) = VT_BSTR;
	return S_OK;
}

STDMETHODIMP CMail::put_Subject(VARIANT *newVal)
{
	VARIANT v;

	VariantInit( &v );
	if( VariantChangeType( &v, newVal, 0, VT_BSTR ) != S_OK )
		return E_INVALIDARG;
	if( bSubject ) SysFreeString( bSubject );
	if( wcslen( v.bstrVal ) ) bSubject = SysAllocString( v.bstrVal );
	else bSubject = NULL;
	VariantClear( &v );
	VariantClear( newVal );
	return S_OK;
}

STDMETHODIMP CMail::get_Message(VARIANT *pVal)
{
	if( bMessage ) V_BSTR( pVal ) = SysAllocString( bMessage );
	else           V_BSTR( pVal ) = SysAllocString( L"\0" );
	V_VT( pVal ) = VT_BSTR;
	return S_OK;
}

STDMETHODIMP CMail::put_Message(VARIANT *newVal)
{
	VARIANT v;

	VariantInit( &v );
	if( VariantChangeType( &v, newVal, 0, VT_BSTR ) != S_OK )
		return E_INVALIDARG;
	if( bMessage ) SysFreeString( bMessage );
	if( wcslen( v.bstrVal ) ) bMessage = SysAllocString( v.bstrVal );
	else bMessage = NULL;
	VariantClear( &v );
	VariantClear( newVal );
	return S_OK;
}

STDMETHODIMP CMail::get_Service(VARIANT *pVal)
{
	if( bService ) V_BSTR( pVal ) = SysAllocString( bService );
	else           V_BSTR( pVal ) = SysAllocString( L"\0" );
	V_VT( pVal ) = VT_BSTR;
	return S_OK;
}

STDMETHODIMP CMail::put_Service(VARIANT *newVal)
{
	VARIANT v;

	VariantInit( &v );
	if( VariantChangeType( &v, newVal, 0, VT_BSTR ) != S_OK )
		return E_INVALIDARG;
	if( bService ) SysFreeString( bService );
	if( wcslen( v.bstrVal ) ) bService = SysAllocString( v.bstrVal );
	else bService = NULL;
	VariantClear( &v );
	VariantClear( newVal );
	return S_OK;
}

STDMETHODIMP CMail::get_Folder(long *pVal)
{
	*pVal = dwFolder;
	return S_OK;
}

STDMETHODIMP CMail::put_Folder(long newVal)
{
	dwFolder = ( newVal & 255 );
	return S_OK;
}

STDMETHODIMP CMail::get_Date(VARIANT *pVal)
{
	double dblVal;
	SYSTEMTIME st;

	if( ! FileTimeToSystemTime( &ftDate, &st ) ) {
		Error( L"Unable to convert DATE to system time" );
		return E_FAIL;
	}
	if( ! SystemTimeToVariantTime( &st, &dblVal ) ) {
		Error( L"Invalid date" );
		return E_FAIL;
	}
	VariantInit( pVal );
	V_DATE( pVal ) = dblVal;
	V_VT( pVal ) = VT_DATE;
	return S_OK;
}

STDMETHODIMP CMail::put_Date(VARIANT *newVal)
{
	SYSTEMTIME st;

	if( newVal->vt != VT_DATE ) {
		Error( L"Data is not a DATE type" );
		return E_INVALIDARG;
	}
	if( ! VariantTimeToSystemTime( newVal->dblVal, &st ) ) {
		Error( L"Invalid date" );
		return E_INVALIDARG;
	}
	if( ! SystemTimeToFileTime( &st, &ftDate ) ) {
		Error( L"Unable to convert system time to DATE" );
		return E_INVALIDARG;
	}
	return S_OK;
}

STDMETHODIMP CMail::get_ErrorMsg(BSTR *pVal)
{
	TCHAR szStr[ 200 ];
	int iLine;

	if( ! hMail ) {
		Error( L"Mail service is not open" );
		return E_HANDLE;
	}
	MailErrorMsg( hMail, szStr, 200, &iLine );
	*pVal = SysAllocString( szStr );
	return S_OK;
}

STDMETHODIMP CMail::get_Error(long *pVal)
{
	if( ! hMail ) {
		Error( L"Mail service is not open" );
		return E_HANDLE;
	}
	*pVal = MailError( hMail );
	return S_OK;
}

STDMETHODIMP CMail::CreateFolder(BSTR bName, long *plRet)
{
	int i, iID, iLen;
	BOOL bStatus;
	TCHAR szName[ 64 ];

	if( ! hMail ) {
		Error( L"Mail service is not open" );
		return E_HANDLE;
	}
	if( ! wcslen( bName ) ) return E_INVALIDARG;
	for( i = 0; i < 250; i++ ) {
		iID = i;
		iLen = 64;
		bStatus = MailGetFolderName( hMail, &iID, &iLen, szName );
		if( ! bStatus ) {
			bStatus = MailPutFolder( hMail, (BYTE)i, bName );
			*plRet = i;
			SysFreeString( bName );
			return S_OK;
		}
	}
	SysFreeString( bName );
	return E_FAIL;
}

STDMETHODIMP CMail::DeleteFolder(long lID)
{
	BOOL bStatus;

	if( ! hMail ) {
		Error( L"Mail service is not open" );
		return E_HANDLE;
	}
	bStatus = MailPutFolder( hMail, (BYTE)lID, NULL );
	if( ! bStatus ) return E_INVALIDARG;
	return S_OK;
}


void CMail::ClearFields()
{
	if( bBCC ) SysFreeString( bBCC );
	if( bCC ) SysFreeString( bCC );
	if( bFrom ) SysFreeString( bFrom );
	if( bMessage ) SysFreeString( bMessage );
	if( bService ) SysFreeString( bService );
	if( bSubject ) SysFreeString( bSubject );
	if( bTo ) SysFreeString( bTo );
	bBCC = NULL;
	bCC = NULL;
	bFrom = NULL;
	bMessage = NULL;
	bService = NULL;
	bSubject = NULL;
	bTo = NULL;
	dwFolder = 0;
	memset( &ftDate, 0, sizeof(FILETIME) );
}

STDMETHODIMP CMail::Clear()
{
	ClearFields();
	return S_OK;
}

STDMETHODIMP CMail::ReadMessage(long lID)
{
	MailMsg mm;
	BSTR bPtr;

	if( ! hMail ) {
		Error( L"Mail service is not open" );
		return E_HANDLE;
	}
	memset( &mm, 0, sizeof(MailMsg) );
	mm.dwFlags = dwFolder + MAIL_GET_BODY;
	mm.oid = lID;
	if( ! MailGet( hMail, &mm ) ) {
		Error( L"Error reading specified message" );
		return E_FAIL;
	}
	ClearFields();
	bPtr = MailGetField( &mm, L"To", FALSE );
	if( bPtr ) bTo = SysAllocString( bPtr );
	bPtr = MailGetField( &mm, L"From", FALSE );
	if( bPtr ) bFrom = SysAllocString( bPtr );
	bPtr = MailGetField( &mm, L"CC", FALSE );
	if( bPtr ) bCC = SysAllocString( bPtr );
	bPtr = MailGetField( &mm, L"BCC", FALSE );
	if( bPtr ) bBCC = SysAllocString( bPtr );
	bPtr = MailGetField( &mm, L"Subject", FALSE );
	if( bPtr ) bSubject = SysAllocString( bPtr );
	memcpy( &ftDate, &mm.ftDate, sizeof(FILETIME) );
	dwFolder = mm.dwFlags & 255;
	if( mm.szSvcNam ) bService = SysAllocString( mm.szSvcNam );
	if( mm.szBody ) bMessage = SysAllocString( mm.szBody );
	MailFree( &mm );
	return S_OK;
}

STDMETHODIMP CMail::WriteMessage(long *plID)
{
	MailMsg mm;
	BOOL bStatus;

	if( ! hMail ) {
		Error( L"Mail service is not open" );
		return E_HANDLE;
	}
	memset( &mm, 0, sizeof(MailMsg) );
	mm.dwFlags = dwFolder;
	if( bTo ) if( wcslen( bTo ) ) MailSetField( &mm, L"To", bTo );
	if( bFrom ) if( wcslen( bFrom ) ) MailSetField( &mm, L"From", bFrom );
	if( bCC ) if( wcslen( bCC ) ) MailSetField( &mm, L"CC", bCC );
	if( bBCC ) if( wcslen( bBCC ) ) MailSetField( &mm, L"BCC", bBCC );
	if( bSubject ) if( wcslen( bSubject ) ) MailSetField( &mm, L"Subject", bSubject );
	if( bMessage ) if( wcslen( bMessage ) ) mm.szBody = bMessage;
	if( bService ) if( wcslen( bService ) ) mm.szSvcNam = bService;
	memcpy( &mm.ftDate, &ftDate, sizeof(FILETIME) );
	bStatus = MailPut( hMail, &mm );
	if( ! bStatus ) {
		Error( L"Error writing specified message" );
		return E_FAIL;
	}
	*plID = mm.oid;
	return S_OK;
}

STDMETHODIMP CMail::DeleteMessage(long lID)
{
	MailMsg mm;
	
	if( ! hMail ) {
		Error( L"Mail service is not open" );
		return E_HANDLE;
	}
	memset( &mm, 0, sizeof(MailMsg) );
	mm.oid = lID;
	if( ! MailDelete( hMail, &mm ) ) return E_FAIL;
	return S_OK;
}

STDMETHODIMP CMail::get_AllServices(VARIANT *pVal)
{
	SAFEARRAY *psa;
	VARIANT *pV;
	HKEY hKey;
	long lResult;
	DWORD dwCount, dwSize;
	TCHAR szStr[ 128 ];
	
	dwCount = 0;
	lResult = RegOpenKeyEx( HKEY_LOCAL_MACHINE, L"PMail\\ServiceInfo", 0, 0, &hKey );
	if( lResult == ERROR_SUCCESS ) {
		while( lResult == ERROR_SUCCESS ) {
			dwSize = sizeof(TCHAR) * 128;
			lResult = RegEnumKeyEx( hKey, dwCount, szStr, &dwSize, NULL, NULL, NULL, NULL );
			if( lResult == ERROR_SUCCESS ) ++dwCount;
		}
	}
	if( ! dwCount ) {
		RegCloseKey( hKey );
		Error( L"There are no mail keys in HKLM\\PMail\\ServiceInfo" );
		return E_FAIL;
	}
	psa = SafeArrayCreateVector( VT_VARIANT, 1, dwCount );
	if( ! psa ) {
		RegCloseKey( hKey );
		return E_OUTOFMEMORY;
	}
	dwCount = 0;
	pV = (VARIANT *)psa->pvData;
	lResult = ERROR_SUCCESS;
	while( lResult == ERROR_SUCCESS ) {
		dwSize = sizeof(TCHAR) * 128;
		lResult = RegEnumKeyEx( hKey, dwCount, szStr, &dwSize, NULL, NULL, NULL, NULL );
		if( lResult == ERROR_SUCCESS ) {
			V_BSTR( pV ) = SysAllocString( szStr );
			V_VT( pV ) = VT_BSTR;
			++dwCount;
			++pV;
		}
	}
	RegCloseKey( hKey );
	V_VT( pVal ) = VT_ARRAY | VT_VARIANT;
	V_ARRAY( pVal ) = psa;
	return S_OK;
}

STDMETHODIMP CMail::Move(long lID)
{
	MailMsg mm;
	BOOL bStatus;

	if( ! hMail ) {
		Error( L"Mail service is not open" );
		return E_HANDLE;
	}
	memset( &mm, 0, sizeof(MailMsg) );
	mm.dwFlags = dwFolder + MAIL_FOLDER_TARGET;
	mm.oid = lID;
	bStatus = MailUpdate( hMail, &mm, FALSE );
	if( ! bStatus ) return E_FAIL;
	return S_OK;
}

STDMETHODIMP CMail::get_Version(long *pVal)
{
	*pVal = 101;
	return S_OK;
}
