// VUMeter.h : Declaration of the CVUMeter

#ifndef __VUMETER_H_
#define __VUMETER_H_

#include "resource.h"       // main symbols
#include <atlctl.h>


/////////////////////////////////////////////////////////////////////////////
// CVUMeter
class ATL_NO_VTABLE CVUMeter : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<IVUMeter, &IID_IVUMeter, &LIBID_MGCEMCTRLLib>,
	public CComControl<CVUMeter>,
	public IPersistStreamInitImpl<CVUMeter>,
	public IOleControlImpl<CVUMeter>,
	public IOleObjectImpl<CVUMeter>,
	public IOleInPlaceActiveObjectImpl<CVUMeter>,
	public IViewObjectExImpl<CVUMeter>,
	public IOleInPlaceObjectWindowlessImpl<CVUMeter>,
	public IPersistStorageImpl<CVUMeter>,
	public ISpecifyPropertyPagesImpl<CVUMeter>,
	public IQuickActivateImpl<CVUMeter>,
	public IDataObjectImpl<CVUMeter>,
	public IProvideClassInfo2Impl<&CLSID_VUMeter, NULL, &LIBID_MGCEMCTRLLib>,
	public CComCoClass<CVUMeter, &CLSID_VUMeter>
{
public:
	CVUMeter()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_VUMETER)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CVUMeter)
	COM_INTERFACE_ENTRY(IVUMeter)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
END_COM_MAP()

BEGIN_PROP_MAP(CVUMeter)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_MSG_MAP(CVUMeter)
	MESSAGE_HANDLER( WM_CREATE, OnCreate )
	MESSAGE_HANDLER( WM_DESTROY, OnDestroy )
	CHAIN_MSG_MAP(CComControl<CVUMeter>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// IVUMeter
public:
	STDMETHOD(get_hWnd)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(Hide)();
	STDMETHOD(Show)();
	STDMETHOD(get_Orientation)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Orientation)(/*[in]*/ long newVal);
	STDMETHOD(get_Segments)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Segments)(/*[in]*/ long newVal);
	STDMETHOD(get_HighColor)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_HighColor)(/*[in]*/ long newVal);
	STDMETHOD(get_LowColor)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_LowColor)(/*[in]*/ long newVal);
	STDMETHOD(get_Value)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Value)(/*[in]*/ long newVal);
	STDMETHOD(get_Max)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Max)(/*[in]*/ long newVal);
	STDMETHOD(get_Min)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Min)(/*[in]*/ long newVal);

	HRESULT OnCreate( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		RECT Rect;

		GetClientRect( &Rect );
		if( Rect.right > Rect.bottom )  lOrient = 0;
		else lOrient = 1;
		lLowColor = 0;
		lHighColor = 8421504;
		lValue = 0;
		lMin = 0;
		lMax = 100;
		lSegments = 10;
		bHandled = TRUE;
		hPen = ::CreatePen( PS_SOLID, 1, RGB( 0, 0, 0 ) );
		hLowColor = ::CreateSolidBrush( lLowColor );
		hHighColor = ::CreateSolidBrush( lHighColor );
		return S_OK;
	}

	HRESULT OnDestroy( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		::DeleteObject( hPen );
		::DeleteObject( hHighColor );
		::DeleteObject( hLowColor );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		ForcePaint();
		return S_OK;
	}
private:
	void ForcePaint();
	double dSegValue;
	double dSegWidth;
	HPEN hPen;
	HBRUSH hLowColor;
	HBRUSH hHighColor;
	long lOrient;
	long lSegments;
	long lHighColor;
	long lLowColor;
	long lValue;
	long lMax;
	long lMin;
};

#endif //__VUMETER_H_
