// VUMeter.cpp : Implementation of CVUMeter

#include "stdafx.h"
#include "MGCEMCtrl.h"
#include "VUMeter.h"

/////////////////////////////////////////////////////////////////////////////
// CVUMeter


STDMETHODIMP CVUMeter::get_Min(long *pVal)
{
	*pVal = lMin;
	return S_OK;
}

STDMETHODIMP CVUMeter::put_Min(long newVal)
{
	if( newVal > lMax ) newVal = lMax - 1;
	lMin = newVal;
	ForcePaint();
	return S_OK;
}

STDMETHODIMP CVUMeter::get_Max(long *pVal)
{
	*pVal = lMax;
	return S_OK;
}

STDMETHODIMP CVUMeter::put_Max(long newVal)
{
	if( newVal < lMin )  newVal = lMin + 1;
	lMax = newVal;
	ForcePaint();
	return S_OK;
}

STDMETHODIMP CVUMeter::get_Value(long *pVal)
{
	*pVal = lValue;
	return S_OK;
}

STDMETHODIMP CVUMeter::put_Value(long newVal)
{
	if( newVal < lMin ) newVal = lMin;
	if( newVal > lMax ) newVal = lMax;
	lValue = newVal;
	ForcePaint();
	return S_OK;
}

STDMETHODIMP CVUMeter::get_LowColor(long *pVal)
{
	*pVal = lLowColor;
	return S_OK;
}

STDMETHODIMP CVUMeter::put_LowColor(long newVal)
{
	lLowColor = newVal;
	::DeleteObject( hLowColor );
	hLowColor = ::CreateSolidBrush( newVal );
	ForcePaint();
	return S_OK;
}

STDMETHODIMP CVUMeter::get_HighColor(long *pVal)
{
	*pVal = lHighColor;
	return S_OK;
}

STDMETHODIMP CVUMeter::put_HighColor(long newVal)
{
	lHighColor = newVal;
	::DeleteObject( hHighColor );
	hHighColor = ::CreateSolidBrush( newVal );
	ForcePaint();
	return S_OK;
}

STDMETHODIMP CVUMeter::get_Segments(long *pVal)
{
	*pVal = lSegments;
	return S_OK;
}

STDMETHODIMP CVUMeter::put_Segments(long newVal)
{
	if( newVal == 0 ) {
		Error( L"Cannot specify zero segments" );
		return E_FAIL;
	}
	lSegments = newVal;
	ForcePaint();
	return S_OK;
}

STDMETHODIMP CVUMeter::get_Orientation(long *pVal)
{
	*pVal = lOrient;
	return S_OK;
}

STDMETHODIMP CVUMeter::put_Orientation(long newVal)
{
	lOrient = newVal;
	ForcePaint();
	return S_OK;
}

STDMETHODIMP CVUMeter::Show()
{
	ShowWindow( SW_SHOW );
	return S_OK;
}

STDMETHODIMP CVUMeter::Hide()
{
	ShowWindow( SW_HIDE );
	return S_OK;
}


void CVUMeter::ForcePaint()
{
	RECT Rect;
	int i, iHigh, iTotal;
	double iSegWidth, iSegValue;
	HPEN hOldPen;
	HBRUSH hOldBrush;
	HDC hDC;

	hDC = GetDC();
	this->GetClientRect( &Rect );
	if( lOrient ) iSegWidth = (double)Rect.bottom / (double)lSegments;
	else iSegWidth = (double)Rect.right / (double)lSegments;
	iSegValue = (double)( lMax - lMin ) / (double)lSegments;

	hOldPen = (HPEN)::SelectObject( hDC, hPen );
	hOldBrush = (HBRUSH)::SelectObject( hDC, hHighColor );
	iHigh = 0;
	iTotal = lMin;

	for( i = 0; i < (int)lSegments; i++ ) {
		if( iTotal >= lValue && ! iHigh ) {
			::SelectObject( hDC, hLowColor );
			iHigh = 1;
		}
		if( lOrient )
			::Rectangle( hDC, 0, 
						 Rect.bottom - (long)( iSegWidth * (double)i ),
						 Rect.right,
						 Rect.bottom - (long)( ( iSegWidth * (double)i ) + iSegWidth ) );
		else
			::Rectangle( hDC, (long)( iSegWidth * (double)i ), 0, 
						 (long)( ( iSegWidth * (double)i ) + iSegWidth ),
						 Rect.bottom );
		iTotal += (int)iSegValue;
	}

	::SelectObject( hDC, hOldPen );
	::SelectObject( hDC, hOldBrush );
	ReleaseDC( hDC );
}

STDMETHODIMP CVUMeter::get_Version(long *pVal)
{
	*pVal = 101;
	return S_OK;
}

STDMETHODIMP CVUMeter::get_hWnd(long *pVal)
{
	*pVal = (long)m_hWnd;
	return S_OK;
}
