// Trackbar.h : Declaration of the CTrackbar

#ifndef __TRACKBAR_H_
#define __TRACKBAR_H_

#include "resource.h"       // main symbols
#include <atlctl.h>
#include "commctrl.h"
#include "MGCEMCtrlCP.h"

/////////////////////////////////////////////////////////////////////////////
// CTrackbar
class ATL_NO_VTABLE CTrackbar : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<ITrackbar, &IID_ITrackbar, &LIBID_MGCEMCTRLLib>,
	public CComControl<CTrackbar>,
	public IPersistStreamInitImpl<CTrackbar>,
	public IOleControlImpl<CTrackbar>,
	public IOleObjectImpl<CTrackbar>,
	public IOleInPlaceActiveObjectImpl<CTrackbar>,
	public IViewObjectExImpl<CTrackbar>,
	public IOleInPlaceObjectWindowlessImpl<CTrackbar>,
	public IConnectionPointContainerImpl<CTrackbar>,
	public IPersistStorageImpl<CTrackbar>,
	public ISpecifyPropertyPagesImpl<CTrackbar>,
	public IQuickActivateImpl<CTrackbar>,
	public IDataObjectImpl<CTrackbar>,
	public IProvideClassInfo2Impl<&CLSID_Trackbar, &DIID__ITrackbarEvents, &LIBID_MGCEMCTRLLib>,
	public IPropertyNotifySinkCP<CTrackbar>,
	public CComCoClass<CTrackbar, &CLSID_Trackbar>,
	public CProxy_ITrackbarEvents< CTrackbar >
{
public:
	CTrackbar()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_TRACKBAR)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CTrackbar)
	COM_INTERFACE_ENTRY(ITrackbar)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()

BEGIN_PROP_MAP(CTrackbar)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_CONNECTION_POINT_MAP(CTrackbar)
	CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
	CONNECTION_POINT_ENTRY(DIID__ITrackbarEvents)
END_CONNECTION_POINT_MAP()

BEGIN_MSG_MAP(CTrackbar)
	MESSAGE_HANDLER( WM_VSCROLL, OnVScroll )
	MESSAGE_HANDLER( WM_HSCROLL, OnVScroll )
	MESSAGE_HANDLER( WM_CREATE, OnCreate )
	MESSAGE_HANDLER( WM_SETFOCUS, OnFocus )
	MESSAGE_HANDLER( WM_KILLFOCUS, OnFocus )
	CHAIN_MSG_MAP(CComControl<CTrackbar>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// ITrackbar
public:
	STDMETHOD(get_hWnd)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Style)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Style)(/*[in]*/ long newVal);
	STDMETHOD(get_Ticks)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Ticks)(/*[in]*/ long newVal);
	STDMETHOD(get_Tabstop)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Tabstop)(/*[in]*/ long newVal);
	STDMETHOD(SetFocus)();
	STDMETHOD(Hide)();
	STDMETHOD(Show)();
	STDMETHOD(get_Orientation)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Orientation)(/*[in]*/ long newVal);
	STDMETHOD(get_Enabled)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Enabled)(/*[in]*/ long newVal);
	STDMETHOD(get_PageSize)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_PageSize)(/*[in]*/ long newVal);
	STDMETHOD(get_LineSize)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_LineSize)(/*[in]*/ long newVal);
	STDMETHOD(get_TickFreq)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_TickFreq)(/*[in]*/ long newVal);
	STDMETHOD(get_Value)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Value)(/*[in]*/ long newVal);
	STDMETHOD(get_Max)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Max)(/*[in]*/ long newVal);
	STDMETHOD(get_Min)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Min)(/*[in]*/ long newVal);

	HRESULT OnVScroll( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		long lOldPos = lPos;

		switch( LOWORD( wParam ) ) {
			case SB_TOP:
				lPos = lMin;
				break;

			case SB_BOTTOM:
				lPos = lMax;
				break;

			case SB_THUMBTRACK:
			case SB_THUMBPOSITION:
				lPos = HIWORD( wParam );
				break;

			case SB_LINEUP:
				lPos -= lLineSize;
				if( lPos < lMin )   lPos = lMin;
				break;

			case SB_LINEDOWN:
				lPos += lLineSize;
				if( lPos > lMax )   lPos = lMax;
				break;

			case SB_PAGEUP:
				lPos -= lPageSize;
				if( lPos < lMin )   lPos = lMin;
				break;

			case SB_PAGEDOWN:
				lPos += lPageSize;
				if( lPos > lMax )   lPos = lMax;
				break;
		}
		if( lPos != lOldPos )  Fire_Change( lPos );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnCreate( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		RECT Rect;


		SetWindowLong( GWL_STYLE, GetWindowLong( GWL_STYLE ) | WS_TABSTOP );
		GetClientRect( &Rect );
		InitCommonControls();
		if( Rect.right > Rect.bottom )
			hCtrl = ::CreateWindow( L"msctls_trackbar32", NULL,
									WS_CHILD | WS_VISIBLE | TBS_HORZ | TBS_AUTOTICKS | WS_TABSTOP,
									0, 0, Rect.right, Rect.bottom,
									this->m_hWnd, NULL, _Module.m_hInst, NULL );
		else
			hCtrl = ::CreateWindow( L"msctls_trackbar32", NULL,
									WS_CHILD | WS_VISIBLE | TBS_VERT | TBS_AUTOTICKS | WS_TABSTOP,
									0, 0, Rect.right, Rect.bottom,
									this->m_hWnd, NULL, _Module.m_hInst, NULL );
		lMin = lPos = 0;
		lMax = 100;
		lLineSize = 1;
		lPageSize = 10;
		lTick = 10;
		::SendMessage( hCtrl, TBM_SETLINESIZE, 0, 1 );
		::SendMessage( hCtrl, TBM_SETPAGESIZE, 0, 10 );
		::SendMessage( hCtrl, TBM_SETTICFREQ, 10, 0 ); 
		::SendMessage( hCtrl, TBM_SETRANGEMIN, FALSE, lMin );
		::SendMessage( hCtrl, TBM_SETRANGEMAX, FALSE, lMax );
		::SendMessage( hCtrl, TBM_SETPOS, TRUE, lPos );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnFocus( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		::SendMessage( hCtrl, msg, wParam, lParam );
		if( msg == WM_SETFOCUS ) ::SetFocus( hCtrl );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		return S_OK;
	}
private:
	long lTick;
	long lLineSize;
	long lPageSize;
	long lPos;
	long lMax;
	long lMin;
	HWND hCtrl;
};

#endif //__TRACKBAR_H_
