// Trackbar.cpp : Implementation of CTrackbar

#include "stdafx.h"
#include "MGCEMCtrl.h"
#include "Trackbar.h"

/////////////////////////////////////////////////////////////////////////////
// CTrackbar


STDMETHODIMP CTrackbar::get_Min(long *pVal)
{
	*pVal = lMin;
	return S_OK;
}

STDMETHODIMP CTrackbar::put_Min(long newVal)
{
	if( newVal > lMax ) newVal = lMax;
	lMin = newVal;
	::SendMessage( hCtrl, TBM_SETRANGEMIN, TRUE, lMin );
	return S_OK;
}

STDMETHODIMP CTrackbar::get_Max(long *pVal)
{
	*pVal = lMax;
	return S_OK;
}

STDMETHODIMP CTrackbar::put_Max(long newVal)
{
	if( newVal < lMin ) newVal = lMin;
	lMax = newVal;
	::SendMessage( hCtrl, TBM_SETRANGEMAX, TRUE, lMax );
	return S_OK;
}

STDMETHODIMP CTrackbar::get_Value(long *pVal)
{
	*pVal = lPos;
	return S_OK;
}

STDMETHODIMP CTrackbar::put_Value(long newVal)
{
	if( newVal < lMin ) newVal = lMin;
	if( newVal > lMax ) newVal = lMax;
	lPos = newVal;
	::SendMessage( hCtrl, TBM_SETPOS, TRUE, lPos );
	return S_OK;
}

STDMETHODIMP CTrackbar::get_TickFreq(long *pVal)
{
	*pVal = lTick;
	return S_OK;
}

STDMETHODIMP CTrackbar::put_TickFreq(long newVal)
{
	if( newVal > ( lMax - lMin ) ) newVal = lMax;
	lTick = newVal;
	::SendMessage( hCtrl, TBM_SETTICFREQ, newVal, 0 ); 
	return S_OK;
}

STDMETHODIMP CTrackbar::get_LineSize(long *pVal)
{
	*pVal = lLineSize;
	return S_OK;
}

STDMETHODIMP CTrackbar::put_LineSize(long newVal)
{
	if( newVal > ( lMax - lMin ) )  newVal = lMax;
	lLineSize = newVal;
	::SendMessage( hCtrl, TBM_SETLINESIZE, 0, newVal );
	return S_OK;
}

STDMETHODIMP CTrackbar::get_PageSize(long *pVal)
{
	*pVal = lPageSize;
	return S_OK;
}

STDMETHODIMP CTrackbar::put_PageSize(long newVal)
{
	if( newVal > ( lMax - lMin ) ) {
		Error( L"PageSize is greater than Min//Max range" );
		return E_FAIL;
	}
	lPageSize = newVal;
	::SendMessage( hCtrl, TBM_SETPAGESIZE, 0, newVal );
	return S_OK;
}

STDMETHODIMP CTrackbar::get_Enabled(long *pVal)
{
	*pVal = ::IsWindowEnabled( hCtrl );
	return S_OK;
}

STDMETHODIMP CTrackbar::put_Enabled(long newVal)
{
	::EnableWindow( hCtrl, newVal );
	return S_OK;
}

STDMETHODIMP CTrackbar::get_Orientation(long *pVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hCtrl, GWL_STYLE );
	if( dwStyle & TBS_VERT )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CTrackbar::put_Orientation(long newVal)
{
	RECT Rect;
	DWORD dwStyle;

	::DestroyWindow( hCtrl );
	GetClientRect( &Rect );
	dwStyle = WS_CHILD | WS_VISIBLE | TBS_AUTOTICKS;
	if( GetWindowLong( GWL_STYLE ) & WS_TABSTOP ) dwStyle |= WS_TABSTOP;
	else dwStyle = 0;
	if( newVal )
		hCtrl = ::CreateWindow( L"msctls_trackbar32", NULL,
								dwStyle | TBS_VERT,
								0, 0, Rect.right, Rect.bottom,
								this->m_hWnd, NULL, _Module.m_hInst, NULL );
	else
		hCtrl = ::CreateWindow( L"msctls_trackbar32", NULL,
								dwStyle | TBS_HORZ,
								0, 0, Rect.right, Rect.bottom,
								this->m_hWnd, NULL, _Module.m_hInst, NULL );
	::SendMessage( hCtrl, TBM_SETRANGEMIN, 0, lMin );
	::SendMessage( hCtrl, TBM_SETRANGEMAX, 0, lMax );
	::SendMessage( hCtrl, TBM_SETLINESIZE, 0, lLineSize );
	::SendMessage( hCtrl, TBM_SETPAGESIZE, 0, lPageSize );
	::SendMessage( hCtrl, TBM_SETTICFREQ, lTick, 0 ); 
	::SendMessage( hCtrl, TBM_SETPOS, TRUE, lPos );
	return S_OK;
}

STDMETHODIMP CTrackbar::Show()
{
	ShowWindow( SW_SHOW );
	return S_OK;
}

STDMETHODIMP CTrackbar::Hide()
{
	ShowWindow( SW_HIDE );
	return S_OK;
}

STDMETHODIMP CTrackbar::SetFocus()
{
	::SetFocus( hCtrl );
	return S_OK;
}

STDMETHODIMP CTrackbar::get_Tabstop(long *pVal)
{
	if( GetWindowLong( GWL_STYLE ) & WS_TABSTOP )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CTrackbar::put_Tabstop(long newVal)
{
	if( newVal ) SetWindowLong( GWL_STYLE, GetWindowLong( GWL_STYLE ) | WS_TABSTOP );
	else SetWindowLong( GWL_STYLE, GetWindowLong( GWL_STYLE ) & ~WS_TABSTOP );
	return S_OK;
}

STDMETHODIMP CTrackbar::get_Ticks(long *pVal)
{
	if( ::GetWindowLong( hCtrl, GWL_STYLE ) & TBS_NOTICKS )		*pVal = 0;
	else *pVal = 1;
	return S_OK;
}

STDMETHODIMP CTrackbar::put_Ticks(long newVal)
{
	if( ! newVal ) ::SetWindowLong( hCtrl, GWL_STYLE, ::GetWindowLong( hCtrl, GWL_STYLE ) | TBS_NOTICKS );
	else ::SetWindowLong( hCtrl, GWL_STYLE, ::GetWindowLong( hCtrl, GWL_STYLE ) & ~TBS_NOTICKS );
	return S_OK;
}

STDMETHODIMP CTrackbar::get_Style(long *pVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hCtrl, GWL_EXSTYLE );
	if( ( dwStyle & WS_EX_CLIENTEDGE ) == WS_EX_CLIENTEDGE )  *pVal = 1;
	else
	if( ( dwStyle & WS_EX_WINDOWEDGE ) == WS_EX_WINDOWEDGE )  *pVal = 2;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CTrackbar::put_Style(long newVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hCtrl, GWL_EXSTYLE );
	dwStyle = dwStyle & ~( WS_EX_CLIENTEDGE | WS_EX_STATICEDGE | WS_EX_WINDOWEDGE );
	if( newVal == 1 ) dwStyle |= WS_EX_CLIENTEDGE;
	if( newVal == 2 ) dwStyle |= WS_EX_WINDOWEDGE;
	::SetWindowLong( hCtrl, GWL_EXSTYLE, dwStyle );
	::SetWindowPos( hCtrl, NULL, 0, 0, 0, 0,
				    SWP_NOZORDER | SWP_NOSIZE | SWP_NOMOVE | SWP_FRAMECHANGED );
	return S_OK;
}

STDMETHODIMP CTrackbar::get_Version(long *pVal)
{
	*pVal = 101;
	return S_OK;
}

STDMETHODIMP CTrackbar::get_hWnd(long *pVal)
{
	*pVal = (long)m_hWnd;
	return S_OK;
}
