// StatusBar.h : Declaration of the CStatusBar

#ifndef __STATUSBAR_H_
#define __STATUSBAR_H_

#include "resource.h"       // main symbols
#include <atlctl.h>
#include "commctrl.h"


/////////////////////////////////////////////////////////////////////////////
// CStatusBar
class ATL_NO_VTABLE CStatusBar : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<IStatusBar, &IID_IStatusBar, &LIBID_MGCEMCTRLLib>,
	public CComControl<CStatusBar>,
	public IPersistStreamInitImpl<CStatusBar>,
	public IOleControlImpl<CStatusBar>,
	public IOleObjectImpl<CStatusBar>,
	public IOleInPlaceActiveObjectImpl<CStatusBar>,
	public IViewObjectExImpl<CStatusBar>,
	public IOleInPlaceObjectWindowlessImpl<CStatusBar>,
	public IPersistStorageImpl<CStatusBar>,
	public ISpecifyPropertyPagesImpl<CStatusBar>,
	public IQuickActivateImpl<CStatusBar>,
	public IDataObjectImpl<CStatusBar>,
	public IProvideClassInfo2Impl<&CLSID_StatusBar, NULL, &LIBID_MGCEMCTRLLib>,
	public CComCoClass<CStatusBar, &CLSID_StatusBar>
{
public:
	CStatusBar()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_STATUSBAR)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CStatusBar)
	COM_INTERFACE_ENTRY(IStatusBar)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
END_COM_MAP()

BEGIN_PROP_MAP(CStatusBar)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_MSG_MAP(CStatusBar)
	MESSAGE_HANDLER( WM_CREATE, OnCreate )
	CHAIN_MSG_MAP(CComControl<CStatusBar>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// IStatusBar
public:
	STDMETHOD(get_hWnd)(/*[out, retval]*/ long *pVal);
	STDMETHOD(Hide)();
	STDMETHOD(Show)();
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Caption)(long lItem, /*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Caption)(long lItem, /*[in]*/ BSTR newVal);
	STDMETHOD(get_Sections)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_Sections)(/*[in]*/ VARIANT *newVal);

	LRESULT OnCreate( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		RECT Rect;

		InitCommonControls();
		GetClientRect( &Rect );
		hCtrl = ::CreateWindow( STATUSCLASSNAME, NULL,
								WS_VISIBLE | WS_CHILD,
								0, 0, Rect.right, Rect.bottom,
								this->m_hWnd, (HMENU)0, _Module.m_hInst, NULL );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		return S_OK;
	}
private:
	HWND hCtrl;
};

#endif //__STATUSBAR_H_
