// StatusBar.cpp : Implementation of CStatusBar

#include "stdafx.h"
#include "MGCEMCtrl.h"
#include "StatusBar.h"

/////////////////////////////////////////////////////////////////////////////
// CStatusBar

STDMETHODIMP CStatusBar::get_Sections(VARIANT *pVal)
{
	long lCount, i;
	int *piArray;
	VARIANT *pV;
	SAFEARRAY *psa;

	lCount = ::SendMessage( hCtrl, SB_GETPARTS, 0, NULL );
	if( ! lCount ) {
		Error( L"No sections in status bar" );
		return E_FAIL;
	}
	piArray = (int *)LocalAlloc( LPTR, lCount * sizeof(int) );
	if( ! piArray )return E_OUTOFMEMORY;
	::SendMessage( hCtrl, SB_GETPARTS, lCount, (LPARAM)piArray );
	psa = SafeArrayCreateVector( VT_VARIANT, 1, lCount );
	if( ! psa ) {
		LocalFree( piArray );
		return E_OUTOFMEMORY;
	}
	pV = (VARIANT *)psa->pvData;
	for( i = 0; i < lCount; i++ ) {
		V_I4( pV ) = *( piArray + i );
		V_VT( pV ) = VT_I4;
		++pV;
	}
	LocalFree( piArray );
	V_VT( pVal ) = VT_ARRAY | VT_VARIANT;
	V_ARRAY( pVal ) = psa;
	return S_OK;
}

STDMETHODIMP CStatusBar::put_Sections(VARIANT *newVal)
{
	long lLBound, lUBound, lCount, i;
	VARIANT *pArray, var;
	int *piArray;
	HRESULT hr;

	hr = E_FAIL;
	if( ( newVal->vt & VT_ARRAY ) == VT_ARRAY ) {
		if( FAILED( SafeArrayAccessData( V_ARRAY( newVal ), (void **)&pArray ) ) )
			goto exit_put_sec;
		SafeArrayGetLBound( V_ARRAY( newVal ), 1, &lLBound );
		SafeArrayGetUBound( V_ARRAY( newVal ), 1, &lUBound );
		lCount = lUBound - lLBound + 1;

		piArray = (int *)LocalAlloc( LPTR, sizeof(int) * lCount );
		if( ! piArray )  goto exit_put_sec;

		for( i = 0; i < lCount; i++ ) {
			VariantInit( &var );
			if( FAILED( VariantChangeType( &var, &pArray[ i ], 0, VT_I4 ) ) ) {
				Error( L"Invalid width specified" );
				goto exit_put_sec_with_free;
			}
			*( piArray + i ) = var.lVal;
		}
		::SendMessage( hCtrl, SB_SETPARTS, lCount, (LPARAM)piArray );
		hr = S_OK;
exit_put_sec_with_free:
		LocalFree( piArray );
exit_put_sec:
		SafeArrayUnaccessData( V_ARRAY( newVal ) );
		SafeArrayDestroy( V_ARRAY( newVal ) );
	}
	return hr;
}

STDMETHODIMP CStatusBar::get_Caption(long lItem, BSTR *pVal)
{
	int iLen;
	BSTR bVal;

	if( lItem < 1 ) {
		Error( L"Section is out of range" );
		return E_FAIL;
	}
	iLen = ::SendMessage( hCtrl, SB_GETTEXTLENGTH, lItem - 1, 0 ) + 1;
	bVal = (BSTR)LocalAlloc( LPTR, iLen * sizeof(TCHAR) );
	if( ! bVal )  return E_OUTOFMEMORY;
	::SendMessage( hCtrl, SB_GETTEXT, lItem - 1, (LPARAM)bVal );
	*pVal = SysAllocString( bVal );
	LocalFree( bVal );
	return S_OK;
}

STDMETHODIMP CStatusBar::put_Caption(long lItem, BSTR newVal)
{
	if( lItem < 1 ) {
		Error( L"Section is out of range" );
		SysFreeString( newVal );
		return E_FAIL;
	}
	::SendMessage( hCtrl, SB_SETTEXT, lItem - 1, (LPARAM)newVal );
	SysFreeString( newVal );
	return S_OK;
}

STDMETHODIMP CStatusBar::get_Version(long *pVal)
{
	*pVal = 101;
	return S_OK;
}

STDMETHODIMP CStatusBar::Show()
{
	ShowWindow( SW_SHOW );
	return S_OK;
}

STDMETHODIMP CStatusBar::Hide()
{
	ShowWindow( SW_HIDE );
	return S_OK;
}

STDMETHODIMP CStatusBar::get_hWnd(long *pVal)
{
	*pVal = (long)m_hWnd;
	return S_OK;
}
