// Scrollbar.h : Declaration of the CScrollbar

#ifndef __SCROLLBAR_H_
#define __SCROLLBAR_H_

#include "resource.h"       // main symbols
#include <atlctl.h>
#include "MGCEMCtrlCP.h"


/////////////////////////////////////////////////////////////////////////////
// CScrollbar
class ATL_NO_VTABLE CScrollbar : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<IScrollbar, &IID_IScrollbar, &LIBID_MGCEMCTRLLib>,
	public CComControl<CScrollbar>,
	public IPersistStreamInitImpl<CScrollbar>,
	public IOleControlImpl<CScrollbar>,
	public IOleObjectImpl<CScrollbar>,
	public IOleInPlaceActiveObjectImpl<CScrollbar>,
	public IViewObjectExImpl<CScrollbar>,
	public IOleInPlaceObjectWindowlessImpl<CScrollbar>,
	public IConnectionPointContainerImpl<CScrollbar>,
	public IPersistStorageImpl<CScrollbar>,
	public ISpecifyPropertyPagesImpl<CScrollbar>,
	public IQuickActivateImpl<CScrollbar>,
	public IDataObjectImpl<CScrollbar>,
	public IProvideClassInfo2Impl<&CLSID_Scrollbar, &DIID__IScrollbarEvents, &LIBID_MGCEMCTRLLib>,
	public IPropertyNotifySinkCP<CScrollbar>,
	public CComCoClass<CScrollbar, &CLSID_Scrollbar>,
	public CProxy_IScrollbarEvents< CScrollbar >
{
public:
	CScrollbar()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_SCROLLBAR)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CScrollbar)
	COM_INTERFACE_ENTRY(IScrollbar)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()

BEGIN_PROP_MAP(CScrollbar)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_CONNECTION_POINT_MAP(CScrollbar)
	CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
	CONNECTION_POINT_ENTRY(DIID__IScrollbarEvents)
END_CONNECTION_POINT_MAP()

BEGIN_MSG_MAP(CScrollbar)
	MESSAGE_HANDLER( WM_CREATE, OnCreate )
	MESSAGE_HANDLER( WM_VSCROLL, OnVScroll )
	MESSAGE_HANDLER( WM_HSCROLL, OnVScroll )
	MESSAGE_HANDLER( WM_SETFOCUS, OnFocus )
	MESSAGE_HANDLER( WM_KILLFOCUS, OnFocus )
	CHAIN_MSG_MAP(CComControl<CScrollbar>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// IScrollbar
public:
	STDMETHOD(get_hWnd)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Style)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Style)(/*[in]*/ long newVal);
	STDMETHOD(get_Tabstop)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Tabstop)(/*[in]*/ long newVal);
	STDMETHOD(get_Value)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Value)(/*[in]*/ long newVal);
	STDMETHOD(SetFocus)();
	STDMETHOD(Hide)();
	STDMETHOD(Show)();
	STDMETHOD(get_Orientation)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Orientation)(/*[in]*/ long newVal);
	STDMETHOD(get_Enabled)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Enabled)(/*[in]*/ long newVal);
	STDMETHOD(get_PageSize)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_PageSize)(/*[in]*/ long newVal);
	STDMETHOD(get_Max)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Max)(/*[in]*/ long newVal);
	STDMETHOD(get_Min)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Min)(/*[in]*/ long newVal);

	HRESULT OnVScroll( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		long lOldPos = lPos;

		switch( LOWORD( wParam ) ) {
			case SB_TOP:
				lPos = lMin;
				break;

			case SB_BOTTOM:
				lPos = lMax;
				break;

			
			case SB_THUMBTRACK:
			case SB_THUMBPOSITION:
				lPos = HIWORD( wParam );
				if( lPos > lMax ) lPos = lMax;
				if( lPos < lMin ) lPos = lMin;
				break;

			case SB_LINEUP:
				--lPos;
				if( lPos < lMin )   lPos = lMin;
				break;

			case SB_LINEDOWN:
				++lPos;
				if( lPos > lMax )   lPos = lMax;
				break;

			case SB_PAGEUP:
				lPos -= lPage;
				if( lPos < lMin )   lPos = lMin;
				break;

			case SB_PAGEDOWN:
				lPos += lPage;
				if( lPos > lMax )   lPos = lMax;
				break;
		}
		if( lPos != lOldPos )  Fire_Change( lPos );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnCreate( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		RECT Rect;
		SCROLLINFO si;

		SetWindowLong( GWL_STYLE, GetWindowLong( GWL_STYLE ) + WS_TABSTOP );
		GetClientRect( &Rect );
		if( Rect.right > Rect.bottom )
			hCtrl = ::CreateWindow( L"Scrollbar", NULL, WS_VISIBLE | WS_CHILD | SBS_HORZ | WS_TABSTOP,
									0, 0, Rect.right, Rect.bottom, this->m_hWnd, NULL,
									_Module.m_hInst, NULL );
		else
			hCtrl = ::CreateWindow( L"Scrollbar", NULL, WS_VISIBLE | WS_CHILD | SBS_VERT | WS_TABSTOP,
									0, 0, Rect.right, Rect.bottom, this->m_hWnd, NULL,
									_Module.m_hInst, NULL );
		lMin = 0;
		lMax = 100;
		lPos = 0;
		lPage = 10;
		si.cbSize = sizeof(SCROLLINFO);
		si.fMask = SIF_RANGE | SIF_POS;
		si.nMax = lMax;
		si.nMin = lMin;
		si.nPos = lPos;
		::SetScrollInfo( hCtrl, SB_CTL, &si, TRUE );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnFocus( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		::SendMessage( hCtrl, msg, wParam, lParam );
		if( msg == WM_SETFOCUS )  ::SetFocus( hCtrl );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		return S_OK;
	}
private:
	long lPage;
	long lPos;
	long lMax;
	long lMin;
	HWND hCtrl;
};

#endif //__SCROLLBAR_H_
