// Scrollbar.cpp : Implementation of CScrollbar

#include "stdafx.h"
#include "MGCEMCtrl.h"
#include "Scrollbar.h"

/////////////////////////////////////////////////////////////////////////////
// CScrollbar


STDMETHODIMP CScrollbar::get_Min(long *pVal)
{
	*pVal = lMin;
	return S_OK;
}

STDMETHODIMP CScrollbar::put_Min(long newVal)
{
	SCROLLINFO si;
	if( newVal > lMax ) {
		Error( L"Min is greater than Max" );
		return E_FAIL;
	}
	lMin = newVal;
	if( lMax != -1 && lMin != -1 ) {
		si.cbSize = sizeof(SCROLLINFO);
		si.fMask = SIF_RANGE;
		si.nMax = lMax;
		si.nMin = lMin;
		::SetScrollInfo( hCtrl, SB_CTL, &si, TRUE );
	}
	return S_OK;
}

STDMETHODIMP CScrollbar::get_Max(long *pVal)
{
	*pVal = lMax;
	return S_OK;
}

STDMETHODIMP CScrollbar::put_Max(long newVal)
{
	SCROLLINFO si;
	if( newVal < lMin ) {
		Error( L"Max is less than Min" );
		return E_FAIL;
	}
	lMax = newVal;
	if( lMax != -1 && lMin != -1 ) {
		si.cbSize = sizeof(SCROLLINFO);
		si.fMask = SIF_RANGE;
		si.nMax = lMax;
		si.nMin = lMin;
		::SetScrollInfo( hCtrl, SB_CTL, &si, TRUE );
	}
	return S_OK;
}

STDMETHODIMP CScrollbar::get_PageSize(long *pVal)
{
	*pVal = lPage;
	return S_OK;
}

STDMETHODIMP CScrollbar::put_PageSize(long newVal)
{
	if( newVal > ( lMax - lMin ) ) {
		Error( L"PageSize is larger than Min//Max range" );
		return E_FAIL;
	}
	lPage = newVal;
	return S_OK;
}

STDMETHODIMP CScrollbar::get_Enabled(long *pVal)
{
	*pVal = ::IsWindowEnabled( hCtrl );
	return S_OK;
}

STDMETHODIMP CScrollbar::put_Enabled(long newVal)
{
	::EnableWindow( hCtrl, newVal );
	return S_OK;
}

STDMETHODIMP CScrollbar::get_Orientation(long *pVal)
{
	if( ::GetWindowLong( hCtrl, GWL_STYLE ) & SBS_VERT )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CScrollbar::put_Orientation(long newVal)
{
	RECT Rect;
	SCROLLINFO si;
	DWORD dwStyle;

	GetClientRect( &Rect );
	::DestroyWindow( hCtrl );
	dwStyle = WS_VISIBLE | WS_CHILD;
	if( GetWindowLong( GWL_STYLE ) & WS_TABSTOP ) dwStyle |= WS_TABSTOP;
	if( newVal )   dwStyle |= SBS_VERT;
	else           dwStyle |= SBS_HORZ;
	hCtrl = ::CreateWindow( L"Scrollbar", NULL, dwStyle,
							0, 0, Rect.right, Rect.bottom, this->m_hWnd, NULL,
							_Module.m_hInst, NULL );
	if( lMax != -1 && lMin != -1 ) {
		si.cbSize = sizeof(SCROLLINFO);
		si.fMask = SIF_RANGE | SIF_POS;
		si.nMax = lMax;
		si.nMin = lMin;
		si.nPos = lPos;
		::SetScrollInfo( hCtrl, SB_CTL, &si, TRUE );
	}
	return S_OK;
}

STDMETHODIMP CScrollbar::Show()
{
	ShowWindow( SW_SHOW );
	return S_OK;
}

STDMETHODIMP CScrollbar::Hide()
{
	ShowWindow( SW_HIDE );
	return S_OK;
}

STDMETHODIMP CScrollbar::SetFocus()
{
	::SetFocus( hCtrl );
	return S_OK;
}

STDMETHODIMP CScrollbar::get_Value(long *pVal)
{
	*pVal = lPos;
	return S_OK;
}

STDMETHODIMP CScrollbar::put_Value(long newVal)
{
	SCROLLINFO si;
	if( newVal < lMin || newVal > lMax ) return E_FAIL;
	lPos = newVal;
	si.cbSize = sizeof(SCROLLINFO);
	si.fMask = SIF_POS;
	si.nPos = newVal;
	::SetScrollInfo( hCtrl, SB_CTL, &si, TRUE );
	return S_OK;
}

STDMETHODIMP CScrollbar::get_Tabstop(long *pVal)
{
	if( GetWindowLong( GWL_STYLE ) & WS_TABSTOP )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CScrollbar::put_Tabstop(long newVal)
{
	if( newVal ) SetWindowLong( GWL_STYLE, GetWindowLong( GWL_STYLE ) | WS_TABSTOP );
	else SetWindowLong( GWL_STYLE, GetWindowLong( GWL_STYLE ) & ~WS_TABSTOP );
	return S_OK;
}

STDMETHODIMP CScrollbar::get_Style(long *pVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hCtrl, GWL_EXSTYLE );
	if( ( dwStyle & WS_EX_CLIENTEDGE ) == WS_EX_CLIENTEDGE )  *pVal = 1;
	else
	if( ( dwStyle & WS_EX_WINDOWEDGE ) == WS_EX_WINDOWEDGE )  *pVal = 2;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CScrollbar::put_Style(long newVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hCtrl, GWL_EXSTYLE );
	dwStyle = dwStyle & ~( WS_EX_CLIENTEDGE | WS_EX_STATICEDGE | WS_EX_WINDOWEDGE );
	if( newVal == 1 ) dwStyle |= WS_EX_CLIENTEDGE;
	if( newVal == 2 ) dwStyle |= WS_EX_WINDOWEDGE;
	::SetWindowLong( hCtrl, GWL_EXSTYLE, dwStyle );
	::SetWindowPos( hCtrl, NULL, 0, 0, 0, 0,
				    SWP_NOZORDER | SWP_NOSIZE | SWP_NOMOVE | SWP_FRAMECHANGED );
	return S_OK;
}

STDMETHODIMP CScrollbar::get_Version(long *pVal)
{
	*pVal = 101;
	return S_OK;
}

STDMETHODIMP CScrollbar::get_hWnd(long *pVal)
{
	*pVal = (long)m_hWnd;
	return S_OK;
}
