// Progress.h : Declaration of the CProgress

#ifndef __PROGRESS_H_
#define __PROGRESS_H_

#include "resource.h"       // main symbols
#include <atlctl.h>
#include "commctrl.h"


/////////////////////////////////////////////////////////////////////////////
// CProgress
class ATL_NO_VTABLE CProgress : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<IProgress, &IID_IProgress, &LIBID_MGCEMCTRLLib>,
	public CComControl<CProgress>,
	public IPersistStreamInitImpl<CProgress>,
	public IOleControlImpl<CProgress>,
	public IOleObjectImpl<CProgress>,
	public IOleInPlaceActiveObjectImpl<CProgress>,
	public IViewObjectExImpl<CProgress>,
	public IOleInPlaceObjectWindowlessImpl<CProgress>,
	public IPersistStorageImpl<CProgress>,
	public ISpecifyPropertyPagesImpl<CProgress>,
	public IQuickActivateImpl<CProgress>,
	public IDataObjectImpl<CProgress>,
	public IProvideClassInfo2Impl<&CLSID_Progress, NULL, &LIBID_MGCEMCTRLLib>,
	public CComCoClass<CProgress, &CLSID_Progress>
{
public:
	CProgress()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_PROGRESS)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CProgress)
	COM_INTERFACE_ENTRY(IProgress)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
END_COM_MAP()

BEGIN_PROP_MAP(CProgress)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_MSG_MAP(CProgress)
	MESSAGE_HANDLER( WM_CREATE, OnCreate )
	CHAIN_MSG_MAP(CComControl<CProgress>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// IProgress
public:
	STDMETHOD(Size)(long lXS, long lYS);
	STDMETHOD(Move)(long lX, long lY);
	STDMETHOD(get_Height)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Height)(/*[in]*/ long newVal);
	STDMETHOD(get_Width)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Width)(/*[in]*/ long newVal);
	STDMETHOD(get_Top)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Top)(/*[in]*/ long newVal);
	STDMETHOD(get_Left)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Left)(/*[in]*/ long newVal);
	STDMETHOD(get_hWnd)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Style)(/*[out, retval]*/ ProgressStyle *pVal);
	STDMETHOD(put_Style)(/*[in]*/ ProgressStyle newVal);
	STDMETHOD(DoStep)();
	STDMETHOD(Hide)();
	STDMETHOD(Show)();
	STDMETHOD(get_Border)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Border)(/*[in]*/ long newVal);
	STDMETHOD(get_Smooth)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Smooth)(/*[in]*/ long newVal);
	STDMETHOD(get_Step)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Step)(/*[in]*/ long newVal);
	STDMETHOD(get_Value)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Value)(/*[in]*/ long newVal);
	STDMETHOD(get_Max)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Max)(/*[in]*/ long newVal);
	STDMETHOD(get_Min)(/*[out, retval]*/ long *pRet);
	STDMETHOD(put_Min)(/*[in]*/ long newVal);

	HRESULT OnCreate( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		RECT Rect;

		InitCommonControls();
		GetClientRect( &Rect );
		hCtrl = ::CreateWindow( PROGRESS_CLASSW, NULL,
								WS_CHILD | WS_VISIBLE | WS_BORDER,
								0, 0, Rect.right, Rect.bottom,
								this->m_hWnd, NULL, _Module.m_hInst, NULL );
		lMin = lPos = lSmooth = 0;
		lMax = 100;
		lStep = 10;
		lBorder = 1;
		::SendMessage( hCtrl, PBM_SETRANGE, 0, MAKELPARAM( lMin, lMax ) );
		::SendMessage( hCtrl, PBM_SETPOS, lPos, 0 );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		return S_OK;
	}
private:
	long lSmooth;
	long lBorder;
	long lStep;
	long lPos;
	long lMax;
	long lMin;
	HWND hCtrl;
};

#endif //__PROGRESS_H_
