// Progress.cpp : Implementation of CProgress

#include "stdafx.h"
#include "MGCEMCtrl.h"
#include "Progress.h"

/////////////////////////////////////////////////////////////////////////////
// CProgress


STDMETHODIMP CProgress::get_Min(long *pRet)
{
	*pRet = (short)lMin;
	return S_OK;
}

STDMETHODIMP CProgress::put_Min(long newVal)
{
	if( newVal > lMax ) {
		Error( L"Min is greater than Max" );
		return E_FAIL;
	}
	lMin = newVal;
	if( lMin != -1 && lMax != -1 )
		::SendMessage( hCtrl, PBM_SETRANGE, 0, MAKELPARAM( lMin, lMax ) );
	return S_OK;
}

STDMETHODIMP CProgress::get_Max(long *pVal)
{
	*pVal = lMax;
	return S_OK;
}

STDMETHODIMP CProgress::put_Max(long newVal)
{
	if( newVal < lMin ) {
		Error( L"Max is less than Min" );
		return E_FAIL;
	}
	lMax = newVal;
	if( lMin != -1 && lMax != -1 )
		::SendMessage( hCtrl, PBM_SETRANGE, 0, MAKELPARAM( lMin, lMax ) );
	return S_OK;
}

STDMETHODIMP CProgress::get_Value(long *pVal)
{
	*pVal = lPos;
	return S_OK;
}

STDMETHODIMP CProgress::put_Value(long newVal)
{
	if( newVal < lMin || newVal > lMax ) {
		Error( L"Value is out of Man//Max range" );
		return E_FAIL;
	}
	lPos = newVal;
	::SendMessage( hCtrl, PBM_SETPOS, newVal, 0 );
	return S_OK;
}

STDMETHODIMP CProgress::get_Step(long *pVal)
{
	*pVal = lStep;
	return S_OK;
}

STDMETHODIMP CProgress::put_Step(long newVal)
{
	if( newVal > ( lMax - lMin ) ) {
		Error( L"Step is larger than Min//Max range" );
		return E_FAIL;
	}
	lStep = newVal;
	::SendMessage( hCtrl, PBM_SETSTEP, newVal, 0 );
	return S_OK;
}

STDMETHODIMP CProgress::get_Smooth(long *pVal)
{
	*pVal = lSmooth;
	return S_OK;
}

STDMETHODIMP CProgress::put_Smooth(long newVal)
{
	LONG lStyle;
	RECT Rect;

	lSmooth = newVal;
	lStyle = WS_CHILD | WS_VISIBLE;
	if( lSmooth )  lStyle |= PBS_SMOOTH;
	if( lBorder )  lStyle |= WS_BORDER;
	::DestroyWindow( hCtrl );
	GetClientRect( &Rect );
	hCtrl = ::CreateWindow( PROGRESS_CLASSW, NULL, lStyle,
							0, 0, Rect.right, Rect.bottom,
							this->m_hWnd, NULL, _Module.m_hInst, NULL );
	::SendMessage( hCtrl, PBM_SETSTEP, lStep, 0 );
	::SendMessage( hCtrl, PBM_SETRANGE, 0, MAKELPARAM( lMin, lMax ) );
	::SendMessage( hCtrl, PBM_SETPOS, lPos, 0 );
	return S_OK;
}

STDMETHODIMP CProgress::get_Border(long *pVal)
{
	*pVal = lBorder;
	return S_OK;
}

STDMETHODIMP CProgress::put_Border(long newVal)
{
	long lStyle;

	lBorder = newVal;
	lStyle = WS_CHILD | WS_VISIBLE;
	if( lSmooth )  lStyle |= PBS_SMOOTH;
	if( lBorder )  lStyle |= WS_BORDER;
	::SetWindowLong( hCtrl, GWL_STYLE, lStyle );
	return S_OK;
}

STDMETHODIMP CProgress::Show()
{
	ShowWindow( SW_SHOW );
	return S_OK;
}

STDMETHODIMP CProgress::Hide()
{
	ShowWindow( SW_HIDE );
	return S_OK;
}

STDMETHODIMP CProgress::DoStep()
{
	::SendMessage( hCtrl, PBM_STEPIT, 0, 0 );
	lPos = ::SendMessage( hCtrl, PBM_GETPOS, 0, 0 );
	return S_OK;
}

STDMETHODIMP CProgress::get_Style(ProgressStyle *pVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hCtrl, GWL_EXSTYLE );
	if( ( dwStyle & WS_EX_CLIENTEDGE ) == WS_EX_CLIENTEDGE )  *pVal = CLIENTEDGE;
	else if( ( dwStyle & WS_EX_WINDOWEDGE ) == WS_EX_WINDOWEDGE )  *pVal = WINDOWEDGE;
		 else *pVal = NOEDGE;
	return S_OK;
}

STDMETHODIMP CProgress::put_Style(ProgressStyle newVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hCtrl, GWL_EXSTYLE );
	dwStyle = dwStyle & ~( WS_EX_CLIENTEDGE | WS_EX_STATICEDGE | WS_EX_WINDOWEDGE );
	if( newVal == CLIENTEDGE ) dwStyle |= WS_EX_CLIENTEDGE;
	if( newVal == WINDOWEDGE ) dwStyle |= WS_EX_WINDOWEDGE;
	::SetWindowLong( hCtrl, GWL_EXSTYLE, dwStyle );
	::SetWindowPos( hCtrl, NULL, 0, 0, 0, 0,
				    SWP_NOZORDER | SWP_NOSIZE | SWP_NOMOVE | SWP_FRAMECHANGED );
	return S_OK;
}

STDMETHODIMP CProgress::get_Version(long *pVal)
{
	*pVal = 101;
	return S_OK;
}

STDMETHODIMP CProgress::get_hWnd(long *pVal)
{
	*pVal = (long)m_hWnd;
	return S_OK;
}

STDMETHODIMP CProgress::get_Left(long *pVal)
{
	RECT Rect;
	GetWindowRect( &Rect );
	::ScreenToClient( GetParent(), (LPPOINT)&Rect );
	*pVal = Rect.left;
	return S_OK;
}

STDMETHODIMP CProgress::put_Left(long newVal)
{
	RECT Rect;
	GetWindowRect( &Rect );
	::ScreenToClient( GetParent(), (LPPOINT)&Rect );
	Rect.left = newVal;
	SetWindowPos( NULL, Rect.left, Rect.top, 0, 0, SWP_NOSIZE | SWP_NOZORDER );
	return S_OK;
}

STDMETHODIMP CProgress::get_Top(long *pVal)
{
	RECT Rect;
	GetWindowRect( &Rect );
	::ScreenToClient( GetParent(), (LPPOINT)&Rect );
	*pVal = Rect.top;
	return S_OK;
}

STDMETHODIMP CProgress::put_Top(long newVal)
{
	RECT Rect;
	GetWindowRect( &Rect );
	::ScreenToClient( GetParent(), (LPPOINT)&Rect );
	Rect.top = newVal;
	SetWindowPos( NULL, Rect.left, Rect.top, 0, 0, SWP_NOSIZE | SWP_NOZORDER );
	return S_OK;
}

STDMETHODIMP CProgress::get_Width(long *pVal)
{
	RECT Rect;
	GetWindowRect( &Rect );
	*pVal = Rect.right - Rect.left;
	return S_OK;
}

STDMETHODIMP CProgress::put_Width(long newVal)
{
	RECT Rect;
	GetWindowRect( &Rect );
	SetWindowPos( NULL, 0, 0, newVal, Rect.bottom - Rect.top, SWP_NOMOVE | SWP_NOZORDER );
	::SetWindowPos( hCtrl, NULL, 0, 0, newVal, Rect.bottom - Rect.top,
					SWP_NOMOVE | SWP_NOZORDER );
	return S_OK;
}

STDMETHODIMP CProgress::get_Height(long *pVal)
{
	RECT Rect;
	GetWindowRect( &Rect );
	*pVal = Rect.bottom - Rect.top;
	return S_OK;
}

STDMETHODIMP CProgress::put_Height(long newVal)
{
	RECT Rect;
	GetWindowRect( &Rect );
	SetWindowPos( NULL, 0, 0, Rect.right - Rect.left, newVal, SWP_NOMOVE | SWP_NOZORDER );
	::SetWindowPos( hCtrl, NULL, 0, 0, Rect.right - Rect.left, newVal,
				    SWP_NOMOVE | SWP_NOZORDER );
	return S_OK;
}

STDMETHODIMP CProgress::Move(long lX, long lY)
{
	SetWindowPos( NULL, lX, lY, 0, 0, SWP_NOSIZE | SWP_NOZORDER );
	return S_OK;
}

STDMETHODIMP CProgress::Size(long lXS, long lYS)
{
	SetWindowPos( NULL, 0, 0, lXS, lYS, SWP_NOMOVE | SWP_NOZORDER );
	::SetWindowPos( hCtrl, NULL, 0, 0, lXS, lYS, SWP_NOMOVE | SWP_NOZORDER );
	return S_OK;
}
