// PopupMenu.h : Declaration of the CPopupMenu

#ifndef __POPUPMENU_H_
#define __POPUPMENU_H_

#include "resource.h"       // main symbols
#include <atlctl.h>
#include "MGCEMCtrlCP.h"


/////////////////////////////////////////////////////////////////////////////
// CPopupMenu
class ATL_NO_VTABLE CPopupMenu : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<IPopupMenu, &IID_IPopupMenu, &LIBID_MGCEMCTRLLib>,
	public CComControl<CPopupMenu>,
	public IPersistStreamInitImpl<CPopupMenu>,
	public IOleControlImpl<CPopupMenu>,
	public IOleObjectImpl<CPopupMenu>,
	public IOleInPlaceActiveObjectImpl<CPopupMenu>,
	public IViewObjectExImpl<CPopupMenu>,
	public IOleInPlaceObjectWindowlessImpl<CPopupMenu>,
	public IConnectionPointContainerImpl<CPopupMenu>,
	public IPersistStorageImpl<CPopupMenu>,
	public ISpecifyPropertyPagesImpl<CPopupMenu>,
	public IQuickActivateImpl<CPopupMenu>,
	public IDataObjectImpl<CPopupMenu>,
	public IProvideClassInfo2Impl<&CLSID_PopupMenu, &DIID__IPopupMenuEvents, &LIBID_MGCEMCTRLLib>,
	public IPropertyNotifySinkCP<CPopupMenu>,
	public CComCoClass<CPopupMenu, &CLSID_PopupMenu>,
	public CProxy_IPopupMenuEvents< CPopupMenu >
{
public:
	CPopupMenu()
	{
		hMainMenu = NULL;
		lLastID = 100;
	}

DECLARE_REGISTRY_RESOURCEID(IDR_POPUPMENU)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CPopupMenu)
	COM_INTERFACE_ENTRY(IPopupMenu)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()

BEGIN_PROP_MAP(CPopupMenu)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_CONNECTION_POINT_MAP(CPopupMenu)
	CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
	CONNECTION_POINT_ENTRY(DIID__IPopupMenuEvents)
END_CONNECTION_POINT_MAP()

BEGIN_MSG_MAP(CPopupMenu)
	MESSAGE_HANDLER( WM_DESTROY, OnDestroy )
	MESSAGE_HANDLER( WM_COMMAND, OnCommand )
	CHAIN_MSG_MAP(CComControl<CPopupMenu>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// IPopupMenu
public:
	STDMETHOD(Insert)(long lPos, BSTR bText);
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(Remove)(long lItem);
	STDMETHOD(get_Checked)(long lItem, /*[out, retval]*/ long *pVal);
	STDMETHOD(put_Checked)(long lItem, /*[in]*/ long newVal);
	STDMETHOD(get_Enabled)(long lItem, /*[out, retval]*/ long *pVal);
	STDMETHOD(put_Enabled)(long lItem, /*[in]*/ long newVal);
	STDMETHOD(Show)(long lFlags, long xpos, long ypos);
	STDMETHOD(RemoveAll)();
	STDMETHOD(Add)(BSTR bText);

	HRESULT OnDestroy( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandler )
	{
		if( hMainMenu )  ::DestroyMenu( hMainMenu );
		return S_OK;
	}

	HRESULT OnCommand( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		if( wParam > 99 ) {
			MENUITEMINFO mii;
			TCHAR szText[ 256 ];


			memset( &mii, 0, sizeof(MENUITEMINFO) );
			mii.cbSize = sizeof(MENUITEMINFO);
			mii.fMask = MIIM_TYPE;
			mii.dwTypeData = szText;
			mii.cch = 256;
			if( GetMenuItemInfo( hMainMenu, wParam, FALSE, &mii ) )
				Fire_Click( szText );
		}
		return S_OK;
	}

	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		return S_OK;
	}
private:
	HMENU hMainMenu;
	long lLastID;
};

#endif //__POPUPMENU_H_
