// PopupMenu.cpp : Implementation of CPopupMenu

#include "stdafx.h"
#include "MGCEMCtrl.h"
#include "PopupMenu.h"

/////////////////////////////////////////////////////////////////////////////
// CPopupMenu


STDMETHODIMP CPopupMenu::Add(BSTR bText)
{
	if( ! hMainMenu ) hMainMenu = ::CreatePopupMenu();
	if( hMainMenu ) {
		if( wcslen( bText ) ) {
			if( *bText == L'-' ) ::AppendMenu( hMainMenu, MF_SEPARATOR, 0, NULL );
			else ::AppendMenu( hMainMenu, MF_STRING, lLastID, bText );
		} else ::AppendMenu( hMainMenu, MF_SEPARATOR, 0, NULL );
		++lLastID;
	}
	SysFreeString( bText );
	if( hMainMenu ) return S_OK;
	Error( L"PopupMenu.Add failure" );
	return E_FAIL;
}

STDMETHODIMP CPopupMenu::Insert(long lPos, BSTR bText)
{
	if( lPos < 0 )  return E_INVALIDARG;
	if( ! lPos ) lPos = 1;
	--lPos;
	if( ! hMainMenu ) hMainMenu = ::CreatePopupMenu();
	if( hMainMenu ) {
		if( wcslen( bText ) ) {
			if( *bText == L'-' ) ::InsertMenu( hMainMenu, lPos,
											   MF_SEPARATOR + MF_BYPOSITION, 0, NULL );
			else ::InsertMenu( hMainMenu, lPos, MF_STRING + MF_BYPOSITION, lLastID, bText );
		} else ::InsertMenu( hMainMenu, lPos, MF_BYPOSITION + MF_SEPARATOR, 0, NULL );
		++lLastID;
	}
	SysFreeString( bText );
	if( hMainMenu ) return S_OK;
	Error( L"PopupMenu.Insert failure" );
	return E_FAIL;
}

STDMETHODIMP CPopupMenu::RemoveAll()
{
	if( hMainMenu ) {
		::DestroyMenu( hMainMenu );
		hMainMenu = ::CreatePopupMenu();
		lLastID = 100;
	}
	return S_OK;
}

STDMETHODIMP CPopupMenu::Show(long lFlags, long xpos, long ypos)
{
	::TrackPopupMenu( hMainMenu, lFlags, xpos, ypos, 0,
					  this->m_hWnd, NULL );
	return S_OK;
}


STDMETHODIMP CPopupMenu::get_Enabled(long lItem, long *pVal)
{
	MENUITEMINFO mmi;

	if( lItem < 1 ) {
		Error( L"Specified menu item is out of range" );
		return E_FAIL;
	}
	mmi.cbSize = sizeof(MENUITEMINFO);
	mmi.fMask = MIIM_STATE;
	if( ! GetMenuItemInfo( hMainMenu, lItem - 1, 0, &mmi ) ) {
		Error( L"Error obtaining specified menu item" );
		return E_FAIL;
	}
	if( ( mmi.fState & MF_GRAYED ) == MF_GRAYED )  *pVal = 0;
	else *pVal = 1;
	return S_OK;
}

STDMETHODIMP CPopupMenu::put_Enabled(long lItem, long newVal)
{
	if( lItem < 1 ) {
		Error( L"Specified menu item is out of range" );
		return E_FAIL;
	}
	if( ! newVal )
		EnableMenuItem( hMainMenu, lItem - 1, MF_GRAYED | MF_BYPOSITION );
	else
		EnableMenuItem( hMainMenu, lItem - 1, MF_ENABLED | MF_BYPOSITION );
	return S_OK;
}

STDMETHODIMP CPopupMenu::get_Checked(long lItem, long *pVal)
{
	MENUITEMINFO mmi;

	if( lItem < 1 ) {
		Error( L"Specified menu item is out of range" );
		return E_FAIL;
	}
	mmi.cbSize = sizeof(MENUITEMINFO);
	mmi.fMask = MIIM_STATE;
	if( ! GetMenuItemInfo( hMainMenu, lItem - 1, 0, &mmi ) )
		return E_FAIL;
	if( ( mmi.fState & MF_CHECKED ) == MF_CHECKED )  *pVal = 0;
	else *pVal = 1;
	return S_OK;
}

STDMETHODIMP CPopupMenu::put_Checked(long lItem, long newVal)
{
	if( lItem < 1 ) {
		Error( L"Specified menu item is out of range" );
		return E_FAIL;
	}
	if( newVal ) CheckMenuItem( hMainMenu, lItem - 1, MF_BYPOSITION | MF_CHECKED );
	else if( newVal ) CheckMenuItem( hMainMenu, lItem - 1, MF_BYPOSITION | MF_UNCHECKED );
	return S_OK;
}

STDMETHODIMP CPopupMenu::Remove(long lItem)
{
	if( lItem < 1 ) {
		Error( L"Specified menu item is out of range" );
		return E_FAIL;
	}
	DeleteMenu( hMainMenu, lItem - 1, MF_BYPOSITION );
	return S_OK;
}

STDMETHODIMP CPopupMenu::get_Version(long *pVal)
{
	*pVal = 101;
	return S_OK;
}

