// ListView.h : Declaration of the CListView

#ifndef __LISTVIEW_H_
#define __LISTVIEW_H_

#include "resource.h"       // main symbols
#include "commctrl.h"
#include <atlctl.h>
#include "MGCELViewCP.h"

// extern HINSTANCE g_hInst;

#define WM_GETMENU  (WM_USER+4001)
#define WM_MENUITEM (WM_USER+4002)
LRESULT WINAPI ListSubProc( HWND, UINT, WPARAM, LPARAM );

/////////////////////////////////////////////////////////////////////////////
// CListView
class ATL_NO_VTABLE CListView : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<IListView, &IID_IListView, &LIBID_MGCELVIEWLib>,
	public CComControl<CListView>,
	public IPersistStreamInitImpl<CListView>,
	public IOleControlImpl<CListView>,
	public IOleObjectImpl<CListView>,
	public IOleInPlaceActiveObjectImpl<CListView>,
	public IViewObjectExImpl<CListView>,
	public IOleInPlaceObjectWindowlessImpl<CListView>,
	public IConnectionPointContainerImpl<CListView>,
	public IPersistStorageImpl<CListView>,
	public ISpecifyPropertyPagesImpl<CListView>,
	public IQuickActivateImpl<CListView>,
	public IDataObjectImpl<CListView>,
	public IProvideClassInfo2Impl<&CLSID_ListView, &DIID__IListViewEvents, &LIBID_MGCELVIEWLib>,
	public IPropertyNotifySinkCP<CListView>,
	public CComCoClass<CListView, &CLSID_ListView>,
	public CProxy_IListViewEvents< CListView >
{
public:
	CListView()
	{
		hListView = NULL;
		hSmallImageList = hLargeImageList = NULL;
		lBorder = 1;
		lImagesInUse = 0;
		lDefaultEventReturnValue = 0;
		lLastEventReturnValue = 0;
		bFontName = SysAllocString( L"Arial" );
		lFontSize = 12;
		lFontBold = 0;
	}

DECLARE_REGISTRY_RESOURCEID(IDR_LISTVIEW)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CListView)
	COM_INTERFACE_ENTRY(IListView)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()

BEGIN_PROP_MAP(CListView)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_CONNECTION_POINT_MAP(CListView)
	CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
	CONNECTION_POINT_ENTRY(DIID__IListViewEvents)
END_CONNECTION_POINT_MAP()

BEGIN_MSG_MAP(CListView)
	MESSAGE_HANDLER( WM_CREATE, OnCreate )
	MESSAGE_HANDLER( WM_DESTROY, OnDestroy )
	MESSAGE_HANDLER( WM_NOTIFY, OnNotify )
	MESSAGE_HANDLER( WM_SETFOCUS, OnFocus )
	MESSAGE_HANDLER( WM_KILLFOCUS, OnFocus )
	MESSAGE_HANDLER( WM_GETMENU, OnGetMenu )
	MESSAGE_HANDLER( WM_MENUITEM, OnMenuItem )
	MESSAGE_HANDLER( WM_COMMAND+1024, OnPostClick )
	CHAIN_MSG_MAP(CComControl<CListView>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// IListView
public:
	STDMETHOD(get_hWnd)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_TopIndex)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_RowsPerPage)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_ColumnCount)(/*[out, retval]*/ long *pVal);
	STDMETHOD(Hide)();
	STDMETHOD(Show)();
	STDMETHOD(EnsureVisible)(long lItem);
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(ClearContext)();
	STDMETHOD(RemoveContextItem)(long lIndex);
	STDMETHOD(AddContextItem)(BSTR bText);
	STDMETHOD(put_AllowEvent)(/*[in]*/ long newVal);
	STDMETHOD(get_AllowEventAsDefault)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_AllowEventAsDefault)(/*[in]*/ long newVal);
	STDMETHOD(get_Style)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Style)(/*[in]*/ long newVal);
	STDMETHOD(get_FontBold)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_FontBold)(/*[in]*/ long newVal);
	STDMETHOD(get_FontSize)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_FontSize)(/*[in]*/ long newVal);
	STDMETHOD(get_FontName)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_FontName)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_Tabstop)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Tabstop)(/*[in]*/ long newVal);
	STDMETHOD(SetFocus)();
	STDMETHOD(get_ItemValue)(long lItem, long lSubItem, /*[out, retval]*/ long *pVal);
	STDMETHOD(put_ItemValue)(long lItem, long lSubItem, /*[in]*/ long newVal);
	STDMETHOD(get_ItemImage)(long lItem, long lSubItem, /*[out, retval]*/ long *pVal);
	STDMETHOD(put_ItemImage)(long lItem, long lSubItem, /*[in]*/ long newVal);
	STDMETHOD(get_ItemText)(long lItem, long lSubItem, /*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_ItemText)(long lItem, long lSubItem, /*[in]*/ BSTR newVal);
	STDMETHOD(get_ColumnImage)(long lIndex, /*[out, retval]*/ long *pVal);
	STDMETHOD(put_ColumnImage)(long lIndex, /*[in]*/ long newVal);
	STDMETHOD(get_ColumnText)(long lIndex, /*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_ColumnText)(long lIndex, /*[in]*/ BSTR newVal);
	STDMETHOD(Arrange)(long lType);
	STDMETHOD(FindText)(long lStart, BSTR bFind, long *pRet);
	STDMETHOD(get_EditItems)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_EditItems)(/*[in]*/ long newVal);
	STDMETHOD(get_ColumnOrder)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_ColumnOrder)(/*[in]*/ VARIANT *newVal);
	STDMETHOD(SetColumn)(long lCol, BSTR bText, long lWidth, long lImg);
	STDMETHOD(get_Checked)(long lItem, /*[out, retval]*/ long *pVal);
	STDMETHOD(get_ColumnWidth)(long lColumn, /*[out, retval]*/ long *pVal);
	STDMETHOD(put_ColumnWidth)(long lColumn, /*[in]*/ long newVal);
	STDMETHOD(get_TextColor)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_TextColor)(/*[in]*/ long newVal);
	STDMETHOD(get_BackColor)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_BackColor)(/*[in]*/ long newVal);
	STDMETHOD(get_SelectedCount)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Select)(long lSelect, /*[out, retval]*/ long *pVal);
	STDMETHOD(put_Select)(long lSelect, /*[in]*/ long newVal);
	STDMETHOD(get_Count)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Count)(/*[in]*/ long newVal);
	STDMETHOD(get_SubItemImages)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_SubItemImages)(/*[in]*/ long newVal);
	STDMETHOD(get_GridLines)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_GridLines)(/*[in]*/ long newVal);
	STDMETHOD(get_FullRowSelect)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_FullRowSelect)(/*[in]*/ long newVal);
	STDMETHOD(get_Checkboxes)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Checkboxes)(/*[in]*/ long newVal);
	STDMETHOD(get_Sort)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Sort)(/*[in]*/ long newVal);
	STDMETHOD(get_SelectionDisplay)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_SelectionDisplay)(/*[in]*/ long newVal);
	STDMETHOD(get_Selection)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Selection)(/*[in]*/ long newVal);
	STDMETHOD(DeleteColumn)(long lColumn);
	STDMETHOD(DeleteItem)(long lItem);
	STDMETHOD(Clear)();
	STDMETHOD(get_ImageLists)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_ImageLists)(/*[in]*/ long newVal);
	STDMETHOD(InsertItem)(long lItem, BSTR bText, long lImg, long lValue, long *plItem);
	STDMETHOD(SetItem)(long lItem, long lSubItem, BSTR bText, long lImg, long lValue);
	STDMETHOD(InsertColumn)(long lCol, BSTR bName, long lWidth, long lImg);
	STDMETHOD(get_View)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_View)(/*[in]*/ long newVal);
	STDMETHOD(get_Border)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Border)(/*[in]*/ long newVal);
	STDMETHOD(get_LgImageCount)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_SmImageCount)(/*[out, retval]*/ long *pVal);
	STDMETHOD(RemoveLgImage)(long lIndex);
	STDMETHOD(RemoveSmImage)(long lIndex);
	STDMETHOD(AddLgImage)(BSTR bFilename);
	STDMETHOD(AddSmImage)(BSTR bFilename);

	HRESULT OnCreate( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		RECT Rect;
		LOGFONT lf;
											  //  Set container control tabstop
		SetWindowLong( GWL_STYLE, GetWindowLong( GWL_STYLE ) + WS_TABSTOP );
		GetClientRect( &Rect );
		InitCommonControls();        //  Init common controls & create listview
		hListView = ::CreateWindow( WC_LISTVIEW, NULL, WS_VISIBLE | WS_CHILD |
									LVS_NOLABELWRAP | WS_TABSTOP,
								    1, 1, Rect.right - 2, Rect.bottom - 2,
								    this->m_hWnd, NULL, _Module.m_hInst, NULL );
		if( ! hListView )   return E_FAIL;               //  Create image lists
		hSmallImageList = ImageList_Create( 16, 16, ILC_COLOR, 0, 4 );
		hLargeImageList = ImageList_Create( 32, 32, ILC_COLOR, 0, 4 );
		if( ! hSmallImageList || ! hLargeImageList ) {
			if( hSmallImageList ) ImageList_Destroy( hSmallImageList );
			if( hLargeImageList ) ImageList_Destroy( hLargeImageList );
			::DestroyWindow( hListView );
			return E_FAIL;
		}
                               //  Subclass listview for context menu operation
		::SetWindowLong( hListView, GWL_WNDPROC, (DWORD)ListSubProc );
		hMenu = ::CreatePopupMenu();                      //  Create popup menu
		lLastMenuID = 1000;
		memset( &lf, 0, sizeof(LOGFONT) );
		wcscpy( lf.lfFaceName, bFontName );        //  Initialize listview font
		lf.lfHeight = lFontSize;
		if( lFontBold )  lf.lfWeight = 700;
		else lf.lfWeight = 400;
		hFont = CreateFontIndirect( &lf );
		::SendMessage( hListView, WM_SETFONT, (WPARAM)hFont, TRUE );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnDestroy( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		if( hListView )  ::DestroyWindow( hListView );
		if( hSmallImageList )  ImageList_Destroy( hSmallImageList );
		if( hLargeImageList )  ImageList_Destroy( hLargeImageList );
		DeleteObject( hFont );
		DestroyMenu( hMenu );
		SysFreeString( bFontName );
		bHandled = TRUE;
		return S_OK;
	}
                                       //  OnGetMenu triggered by subclass proc
	HRESULT OnGetMenu( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		bHandled = (BOOL)hMenu;
		return (long)hMenu;
	}

	HRESULT OnMenuItem( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		MENUITEMINFO mmi;
		LV_HITTESTINFO hti;
		int iItem;
		TCHAR szStr[ 128 ];

		memset( &mmi, 0, sizeof(MENUITEMINFO) );
		mmi.cbSize = sizeof(MENUITEMINFO);
		mmi.fMask = MIIM_TYPE;
		mmi.dwTypeData = szStr;
		mmi.cch = 256;
		if( ::GetMenuItemInfo( hMenu, lParam, FALSE, &mmi ) ) {
			hti.pt.x = LOWORD( wParam );
			hti.pt.y = HIWORD( wParam );
			iItem = ListView_HitTest( hListView, &hti ) + 1;
			Fire_ContextMenu( iItem, szStr );
		}
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnNotify( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		NM_LISTVIEW *pnlv;

		pnlv = (NM_LISTVIEW *)lParam;
		if( pnlv->hdr.code == LVN_COLUMNCLICK )
			Fire_ColumnClick( pnlv->iSubItem + 1 );
		if( pnlv->hdr.code == LVN_ITEMACTIVATE )
			Fire_ItemActivate( pnlv->iItem + 1, pnlv->iSubItem + 1 );
		if( pnlv->hdr.code == NM_CLICK ) {
			PostMessage( WM_COMMAND + 1024, pnlv->iItem + 1, pnlv->iSubItem + 1 );
			Fire_ItemClick( pnlv->iItem + 1, pnlv->iSubItem + 1 );
		}
		if( pnlv->hdr.code == LVN_KEYDOWN ) {
			LV_KEYDOWN *lk = (LV_KEYDOWN *)lParam;
			Fire_Keypress( (LONG)lk->wVKey );
		}

		if( pnlv->hdr.code == LVN_BEGINLABELEDIT )
		{
			LV_DISPINFO *pdi = (LV_DISPINFO *)lParam;
			long lRetVal;

			Fire_StartEdit( pdi->item.iItem + 1 );
			lRetVal = lLastEventReturnValue;
			lLastEventReturnValue = lDefaultEventReturnValue;
			bHandled = lRetVal;
			return lRetVal;
		}

		if( pnlv->hdr.code == LVN_ENDLABELEDIT ) {
			LV_DISPINFO *pdi = (LV_DISPINFO *)lParam;
			long lRetVal;

			Fire_EndEdit( pdi->item.iItem + 1, pdi->item.iSubItem + 1,
						  SysAllocString( pdi->item.pszText ) );
			if( lLastEventReturnValue ) lRetVal = 0;
			else lRetVal = 1;
			bHandled = lRetVal;
			return lRetVal;
		}

		if( pnlv->hdr.code == LVN_MARQUEEBEGIN ) {
			long lRetVal;

			Fire_StartDragSelect();
			lRetVal = lLastEventReturnValue;
			lLastEventReturnValue = lDefaultEventReturnValue;
			bHandled = lRetVal;
			return lRetVal;
		}

		if( pnlv->hdr.code == HDN_TRACK ) {
			NMHEADER *pnh = (NMHEADER *)lParam;

			Fire_HeaderDrag( pnh->iItem + 1 );
			bHandled = TRUE;
			return TRUE;
		}

		if( pnlv->hdr.code == HDN_ENDTRACK ) {
			NMHEADER *pnh = (NMHEADER *)lParam;

			Fire_EndHeaderDrag( pnh->iItem + 1 );
			bHandled = TRUE;
			return TRUE;
		}

		bHandled = 0;
		return S_OK;
	}
                //  OnPostClick triggered by PostMessage in OnNotify's NM_CLICK
	            //  So checkboxes can be accurately polled from within an event
	HRESULT OnPostClick( UINT msg, WPARAM wParam, LPARAM lParam, BOOL &bHandled )
	{
		Fire_PostClick( wParam, lParam );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnFocus( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		::SendMessage( hListView, msg, wParam, lParam );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		RECT Rect;
		HPEN hPen;

		GetClientRect( &Rect );
		if( lBorder ) {
			hPen = CreatePen( PS_SOLID, 1, RGB( 0, 0, 0 ) );
			hPen = (HPEN)::SelectObject( di.hdcDraw, hPen );
			::Rectangle( di.hdcDraw, 0, 0, Rect.right, Rect.bottom );
			::DeleteObject( (HPEN)::SelectObject( di.hdcDraw, hPen ) );
		}
		return S_OK;
	}
private:
	long lLastMenuID;
	HMENU hMenu;
	long lLastEventReturnValue;
	long lDefaultEventReturnValue;
	HFONT hFont;
	long lFontBold;
	long lFontSize;
	BSTR bFontName;
	long lImagesInUse;
	long lBorder;
	HIMAGELIST hLargeImageList;
	HIMAGELIST hSmallImageList;
	HWND hListView;
};

#endif //__LISTVIEW_H_
