// ListView.cpp : Implementation of CListView

#include "stdafx.h"
#include "MGCELView.h"
#include "ListView.h"

/////////////////////////////////////////////////////////////////////////////
// CListView


STDMETHODIMP CListView::AddSmImage(BSTR bFilename)
{
	HBITMAP hBmp;

	hBmp = ::SHLoadDIBitmap( bFilename );
	SysFreeString( bFilename );
	if( ! hBmp ) {
		Error( L"Unable to load specified image" );
		return E_FAIL;
	}
	if( ImageList_Add( hSmallImageList, hBmp, NULL ) == -1 ) {
		DeleteObject( hBmp );
		Error( L"Unable to add image to image list" );
		return E_FAIL;
	}
	return S_OK;
}

STDMETHODIMP CListView::AddLgImage(BSTR bFilename)
{
	HBITMAP hBmp;

	hBmp = ::SHLoadDIBitmap( bFilename );
	SysFreeString( bFilename );
	if( ! hBmp ) {
		Error( L"Unable to load specified image" );
		return E_FAIL;
	}
	if( ImageList_Add( hLargeImageList, hBmp, NULL ) == -1 ) {
		DeleteObject( hBmp );
		Error( L"Unable to add image to image list" );
		return E_FAIL;
	}
	return S_OK;
}

STDMETHODIMP CListView::RemoveSmImage(long lIndex)
{
	ImageList_Remove( hSmallImageList, lIndex );
	return S_OK;
}

STDMETHODIMP CListView::RemoveLgImage(long lIndex)
{
	ImageList_Remove( hLargeImageList, lIndex );
	return S_OK;
}

STDMETHODIMP CListView::get_SmImageCount(long *pVal)
{
	*pVal = ImageList_GetImageCount( hSmallImageList );
	return S_OK;
}

STDMETHODIMP CListView::get_LgImageCount(long *pVal)
{
	*pVal = ImageList_GetImageCount( hLargeImageList );
	return S_OK;
}

STDMETHODIMP CListView::get_Border(long *pVal)
{
	*pVal = lBorder;
	return S_OK;
}

STDMETHODIMP CListView::put_Border(long newVal)
{
	RECT Rect;

	lBorder = newVal;
	GetClientRect( &Rect );
	if( lBorder )
		::SetWindowPos( hListView, NULL, 1, 1, Rect.right - 2, Rect.bottom - 2,
					  SWP_NOZORDER );
	else
		::SetWindowPos( hListView, NULL, 0, 0, Rect.right, Rect.bottom,
					  SWP_NOZORDER );
	return S_OK;
}

STDMETHODIMP CListView::get_View(long *pVal)
{
	*pVal = ::GetWindowLong( hListView, GWL_STYLE ) & 3;
	return S_OK;
}

STDMETHODIMP CListView::put_View(long newVal)
{
	DWORD dwStyle;
	
	dwStyle = ::GetWindowLong( hListView, GWL_STYLE ) & 0xFFFFFFFC;
	dwStyle += newVal;
	::SetWindowLong( hListView, GWL_STYLE, dwStyle );
	return S_OK;
}

STDMETHODIMP CListView::InsertColumn(long lCol, BSTR bName, long lWidth, long lImg)
{
	LV_COLUMN lc;
	int iStatus;

	if( lCol < 0 ) {
		Error( L"Column is less than zero" );
		return E_FAIL;
	}
	if( ! lCol ) ++lCol;
	if( ! lWidth ) lWidth = 80;
	memset( &lc, 0, sizeof(LV_COLUMN) );
	lc.mask = LVCF_TEXT | LVCF_WIDTH;
	if( lImg ) lc.mask |= LVCF_IMAGE;
	lc.iImage = lImg - 1;
	lc.cx = lWidth;
	lc.pszText = bName;
	iStatus = ListView_InsertColumn( hListView, lCol - 1, &lc );
	SysFreeString( bName );
	if( iStatus != -1 )  return S_OK;
	Error( L"Error inserting column into listview" );
	return E_FAIL;
}


STDMETHODIMP CListView::InsertItem(long lItem, BSTR bText, long lImg, long lValue, long *plItem )
{
	LV_ITEM li;
	int iStatus;

	if( lItem < 0 ) {
		Error( L"Item is less than zero" );
		SysFreeString( bText );
		return E_FAIL;
	}
	if( ! lItem ) ++lItem;
	memset( &li, 0, sizeof(LV_ITEM) );
	li.mask = LVIF_TEXT | LVIF_PARAM;
	li.iItem = lItem - 1;
	if( lImg > 0 ) li.mask |= LVIF_IMAGE;
	li.iImage = lImg - 1;
	li.pszText = bText;
	li.lParam = lValue;
	iStatus = ListView_InsertItem( hListView, &li );
	*plItem = iStatus + 1;
	SysFreeString( bText );
	if( iStatus != -1 )  return S_OK;
	Error( L"Error inserting item into listview" );
	return E_FAIL;
}

STDMETHODIMP CListView::SetItem(long lItem, long lSubItem, BSTR bText, long lImg, long lValue)
{
	LV_ITEM li;
	int iStatus;

	if( lItem < 0 ) {
		Error( L"Item is less than zero" );
		SysFreeString( bText );
		return E_FAIL;
	}
	if( ! lItem ) ++lItem;
	memset( &li, 0, sizeof(LV_ITEM) );
	li.mask = LVIF_TEXT;
	if( lValue == 1 ) li.mask |= LVIF_PARAM;
	if( lImg > 0 ) li.mask |= LVIF_IMAGE;
	li.iImage = lImg - 1;
	li.iItem = lItem - 1;
	if( lSubItem ) li.iSubItem = lSubItem - 1;
	else li.iSubItem = 0;
	li.pszText = bText;
	li.lParam = lValue;
	iStatus = ListView_SetItem( hListView, &li );
	SysFreeString( bText );
	if( iStatus )  return S_OK;
	Error( L"Error setting item in listview" );
	return E_FAIL;
}

STDMETHODIMP CListView::get_ImageLists(long *pVal)
{
	*pVal = lImagesInUse;
	return S_OK;
}

STDMETHODIMP CListView::put_ImageLists(long newVal)
{
	lImagesInUse = newVal;
	if( newVal & 1 ) ListView_SetImageList( hListView, hSmallImageList, LVSIL_SMALL );
	if( newVal & 2 ) ListView_SetImageList( hListView, hLargeImageList, LVSIL_NORMAL );
	if( newVal & 4 ) ListView_SetImageList( hListView, hSmallImageList, LVSIL_HEADER );
	return S_OK;
}

STDMETHODIMP CListView::Clear()
{
	ListView_DeleteAllItems( hListView );
	return S_OK;
}

STDMETHODIMP CListView::DeleteItem(long lItem)
{
	if( lItem < 0 ) {
		Error( L"Item is less than zero" );
		return E_FAIL;
	}
	if( lItem )	ListView_DeleteItem( hListView, lItem - 1 );
	else ListView_DeleteItem( hListView, 0 );
	return S_OK;
}


STDMETHODIMP CListView::DeleteColumn(long lColumn)
{
	if( lColumn < 0 ) {
		Error( L"Item is less than zero" );
		return E_FAIL;
	}
	if( lColumn ) ListView_DeleteColumn( hListView, lColumn - 1 );
	ListView_DeleteColumn( hListView, 0 );
	return S_OK;
}


STDMETHODIMP CListView::get_Selection(long *pVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hListView, GWL_STYLE );
	if( dwStyle & LVS_SINGLESEL )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CListView::put_Selection(long newVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hListView, GWL_STYLE );
	if( newVal )  dwStyle |=  LVS_SINGLESEL;
	else dwStyle = dwStyle & ~LVS_SINGLESEL;
	::SetWindowLong( hListView, GWL_STYLE, dwStyle );
	return S_OK;
}

STDMETHODIMP CListView::get_SelectionDisplay(long *pVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hListView, GWL_STYLE );
	if( dwStyle & LVS_SHOWSELALWAYS )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CListView::put_SelectionDisplay(long newVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hListView, GWL_STYLE );
	if( newVal )  dwStyle |=  LVS_SHOWSELALWAYS;
	else dwStyle = dwStyle & ~LVS_SHOWSELALWAYS;
	::SetWindowLong( hListView, GWL_STYLE, dwStyle );
	return S_OK;
}

STDMETHODIMP CListView::get_Sort(long *pVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hListView, GWL_STYLE );
	if( dwStyle & LVS_SORTASCENDING )  *pVal = 1;
	else if( dwStyle & LVS_SORTDESCENDING )  *pVal = -1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CListView::put_Sort(long newVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hListView, GWL_STYLE ) & 0xFFFFFFCF;
	if( newVal == 1 )  dwStyle |= LVS_SORTASCENDING;
	if( newVal == -1 )  dwStyle |= LVS_SORTDESCENDING;
	::SetWindowLong( hListView, GWL_STYLE, dwStyle );
	return S_OK;
}


STDMETHODIMP CListView::get_Checkboxes(long *pVal)
{
	DWORD dwStyle;

	dwStyle = ListView_GetExtendedListViewStyle( hListView );
	if( dwStyle & LVS_EX_CHECKBOXES )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CListView::put_Checkboxes(long newVal)
{
	DWORD dwStyle;

	dwStyle = ListView_GetExtendedListViewStyle( hListView );
	dwStyle = dwStyle & ~LVS_EX_CHECKBOXES;
	if( newVal ) dwStyle |= LVS_EX_CHECKBOXES;
	ListView_SetExtendedListViewStyle( hListView, dwStyle );
	return S_OK;
}

STDMETHODIMP CListView::get_FullRowSelect(long *pVal)
{
	DWORD dwStyle;

	dwStyle = ListView_GetExtendedListViewStyle( hListView );
	if( dwStyle & LVS_EX_FULLROWSELECT )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CListView::put_FullRowSelect(long newVal)
{
	DWORD dwStyle;

	dwStyle = ListView_GetExtendedListViewStyle( hListView );
	dwStyle = dwStyle & ~LVS_EX_FULLROWSELECT;
	if( newVal ) dwStyle |= LVS_EX_FULLROWSELECT;
	ListView_SetExtendedListViewStyle( hListView, dwStyle );
	return S_OK;
}

STDMETHODIMP CListView::get_GridLines(long *pVal)
{
	DWORD dwStyle;

	dwStyle = ListView_GetExtendedListViewStyle( hListView );
	if( dwStyle & LVS_EX_GRIDLINES )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CListView::put_GridLines(long newVal)
{
	DWORD dwStyle;

	dwStyle = ListView_GetExtendedListViewStyle( hListView );
	dwStyle = dwStyle & ~LVS_EX_GRIDLINES;
	if( newVal ) dwStyle |= LVS_EX_GRIDLINES;
	ListView_SetExtendedListViewStyle( hListView, dwStyle );
	return S_OK;
}

STDMETHODIMP CListView::get_SubItemImages(long *pVal)
{
	DWORD dwStyle;

	dwStyle = ListView_GetExtendedListViewStyle( hListView );
	if( dwStyle & LVS_EX_SUBITEMIMAGES )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CListView::put_SubItemImages(long newVal)
{
	DWORD dwStyle;

	dwStyle = ListView_GetExtendedListViewStyle( hListView );
	dwStyle = dwStyle & ~LVS_EX_SUBITEMIMAGES;
	if( newVal ) dwStyle |= LVS_EX_SUBITEMIMAGES;
	ListView_SetExtendedListViewStyle( hListView, dwStyle );
	return S_OK;
}

STDMETHODIMP CListView::get_Count(long *pVal)
{
	*pVal = ListView_GetItemCount( hListView );
	return S_OK;
}

STDMETHODIMP CListView::put_Count(long newVal)
{
	ListView_SetItemCount( hListView, newVal );
	return S_OK;
}

STDMETHODIMP CListView::get_Select(long lSelect, long *pVal)
{
	DWORD dwState;

	if( lSelect < 1 ) {
		Error( L"Item is less than one" );
		return E_FAIL;
	}
	dwState = ListView_GetItemState( hListView, lSelect - 1, LVIS_SELECTED );
	if( dwState )  *pVal = 1;  else  *pVal = 0;
	return S_OK;
}

STDMETHODIMP CListView::put_Select(long lSelect, long newVal)
{
	if( lSelect < 1 ) {
		Error( L"Item is less than one" );
		return E_FAIL;
	}
	if( newVal ) { ListView_SetItemState( hListView, lSelect - 1, LVIS_SELECTED, LVIS_SELECTED ); }
	else ListView_SetItemState( hListView, lSelect - 1, 0, LVIS_SELECTED );
	return S_OK;
}

STDMETHODIMP CListView::get_SelectedCount(long *pVal)
{
	*pVal = ListView_GetSelectedCount( hListView );
	return S_OK;
}

STDMETHODIMP CListView::get_BackColor(long *pVal)
{
	*pVal = ListView_GetTextBkColor( hListView );
	return S_OK;
}

STDMETHODIMP CListView::put_BackColor(long newVal)
{
	int iLast;

	ListView_SetTextBkColor( hListView, newVal );
	iLast = ListView_GetItemCount( hListView );
	ListView_RedrawItems( hListView, 0, iLast - 1 );
	return S_OK;
}

STDMETHODIMP CListView::get_TextColor(long *pVal)
{
	*pVal = ListView_GetTextColor( hListView );
	return S_OK;
}

STDMETHODIMP CListView::put_TextColor(long newVal)
{
	int iLast;

	ListView_SetTextColor( hListView, newVal );
	iLast = ListView_GetItemCount( hListView );
	ListView_RedrawItems( hListView, 0, iLast - 1 );
	return S_OK;
}

STDMETHODIMP CListView::get_ColumnWidth(long lColumn, long *pVal)
{
	if( lColumn < 1 ) {
		Error( L"Column is less than one" );
		return E_FAIL;
	}
	*pVal = ListView_GetColumnWidth( hListView, lColumn - 1 );
	return S_OK;
}

STDMETHODIMP CListView::put_ColumnWidth(long lColumn, long newVal)
{
	if( lColumn < 1 ) {
		Error( L"Column is less than one" );
		return E_FAIL;
	}
	ListView_SetColumnWidth( hListView, lColumn - 1, newVal );
	return S_OK;
}

STDMETHODIMP CListView::get_Checked(long lItem, long *pVal)
{
	if( lItem < 1 ) {
		Error( L"Item is less than one" );
		return E_FAIL;
	}
	*pVal = ListView_GetCheckState( hListView, lItem - 1 );
	return S_OK;
}

STDMETHODIMP CListView::SetColumn(long lCol, BSTR bText, long lWidth, long lImg)
{
	LV_COLUMN lc;
	int iStatus;

	if( lCol < 0 ) {
		Error( L"Column is less than one" );
		return E_FAIL;
	}
	if( ! lCol ) ++lCol;
	memset( &lc, 0, sizeof(LV_COLUMN) );
	lc.mask = LVCF_TEXT | LVCF_WIDTH;
	if( lImg ) lc.mask |= LVCF_IMAGE;
	lc.iImage = lImg - 1;

	lc.cx = lWidth;
	lc.pszText = bText;
	iStatus = ListView_SetColumn( hListView, lCol - 1, &lc );
	SysFreeString( bText );
	if( iStatus != -1 )  return S_OK;
	Error( L"Error setting column data" );
	return E_FAIL;
}


STDMETHODIMP CListView::get_ColumnOrder(VARIANT *pVal)
{
	int iColCount, *iColArray, i, iVal;
	LV_COLUMN lvc;
	SAFEARRAY *psa;
	VARIANT *pV;

	iColCount = 0;
	memset( &lvc, 0, sizeof(LV_COLUMN) );
	lvc.mask = LVCF_ORDER;
	while( ListView_GetColumn( hListView, iColCount, &lvc ) )
		++iColCount;
	
	if( ! iColCount ) {
		Error( L"No columns to retrieve" );
		return E_FAIL;
	}
	iColArray = (int *)malloc( iColCount * sizeof(int) );
	if( ! iColArray )   return E_OUTOFMEMORY;
	if( ! ListView_GetColumnOrderArray( hListView, iColCount, iColArray ) ) {
		free( iColArray );
		Error( L"Error retrieving column array from listview" );
		return E_FAIL;
	}

	psa = SafeArrayCreateVector( VT_VARIANT, 1, iColCount );
	if( ! psa ) {
		free( iColArray );
		return E_OUTOFMEMORY;
	}
	pV = (VARIANT *)psa->pvData;
	for( i = 0; i < iColCount; i++ ) {
		iVal = *( iColArray + i );
		++iVal;
		V_I2( pV ) = iVal;
		V_VT( pV ) = VT_I2;
		++pV;
	}
	free( iColArray );
	V_VT( pVal ) = VT_ARRAY | VT_VARIANT;
	V_ARRAY( pVal ) = psa;
	return S_OK;
}

STDMETHODIMP CListView::put_ColumnOrder(VARIANT *newVal)
{
	DWORD dwLBound, dwUBound;
	int iElements, *iColArray, i, iVal;
	VARIANT *pArray;

	if( ( newVal->vt & VT_ARRAY ) == 0 ) {
		Error( L"An array of values was not specified" );
		return E_FAIL;
	}

	SafeArrayAccessData( V_ARRAY( newVal ), (void **)&pArray );
	SafeArrayGetLBound( V_ARRAY( newVal ), 1, (long *)&dwLBound );
	SafeArrayGetUBound( V_ARRAY( newVal ), 1, (long *)&dwUBound );
	iElements = (int)dwUBound - (int)dwLBound + 1;
	if( ! iElements ) {
		SafeArrayUnaccessData( V_ARRAY( newVal ) );
		SafeArrayDestroy( V_ARRAY( newVal ) );
		Error( L"There were no array items" );
		return E_FAIL;
	}

	iColArray = (int *)malloc( sizeof(int) * iElements );
	if( ! iColArray ) {
		SafeArrayUnaccessData( V_ARRAY( newVal ) );
		SafeArrayDestroy( V_ARRAY( newVal ) );
		return E_OUTOFMEMORY;
	}

	for( i = 0; i < iElements; i++ ) {
		iVal = V_I2( &pArray[ i ] );
		--iVal;
		*( iColArray + i ) = iVal;
	}
	ListView_SetColumnOrderArray( hListView, iElements, iColArray );

	free( iColArray );
	SafeArrayUnaccessData( V_ARRAY( newVal ) );
	SafeArrayDestroy( V_ARRAY( newVal ) );
	::InvalidateRect( hListView, NULL, TRUE );
	return S_OK;
}

STDMETHODIMP CListView::get_EditItems(long *pVal)
{	
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hListView, GWL_STYLE );
	if( dwStyle & LVS_EDITLABELS )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CListView::put_EditItems(long newVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hListView, GWL_STYLE ) & 0xFFFFFDFF;
	if( newVal )  dwStyle |= LVS_EDITLABELS;
	::SetWindowLong( hListView, GWL_STYLE, dwStyle );
	return S_OK;
}

STDMETHODIMP CListView::FindText(long lStart, BSTR bFind, long *pRet)
{
	LV_FINDINFO lf;

	memset( &lf, 0, sizeof(LV_FINDINFO) );
	lf.flags = LVFI_PARTIAL;
	lf.psz = bFind;
	if( ! lStart ) ++lStart;
	*pRet = ListView_FindItem( hListView, lStart - 1, &lf ) + 1;
	SysFreeString( bFind );
	return S_OK;
}

STDMETHODIMP CListView::Arrange(long lType)
{
	ListView_Arrange( hListView, lType );
	return S_OK;
}

STDMETHODIMP CListView::get_ColumnText(long lIndex, BSTR *pVal)
{
	LV_COLUMN lc;
	TCHAR szText[ 300 ];

	memset( &lc, 0, sizeof(LV_COLUMN) );
	lc.mask = LVCF_TEXT;
	lc.pszText = szText;
	lc.cchTextMax = 300;
	if( ! ListView_GetColumn( hListView, lIndex - 1, &lc ) ) {
		Error( L"Error retrieving column text" );
		return E_FAIL;
	}
	*pVal = SysAllocString( szText );
	return S_OK;
}

STDMETHODIMP CListView::put_ColumnText(long lIndex, BSTR newVal)
{
	LV_COLUMN lc;

	memset( &lc, 0, sizeof(LV_COLUMN) );
	lc.mask = LVCF_TEXT;
	lc.pszText = newVal;
	if( ! ListView_SetColumn( hListView, lIndex - 1, &lc ) ) {
		Error( L"Error setting column text" );
		SysFreeString( newVal );
		return E_FAIL;
	}
	SysFreeString( newVal );
	return S_OK;
}

STDMETHODIMP CListView::get_ColumnImage(long lIndex, long *pVal)
{
	LV_COLUMN lc;

	memset( &lc, 0, sizeof(LV_COLUMN) );
	lc.mask = LVCF_IMAGE;
	if( ! ListView_GetColumn( hListView, lIndex - 1, &lc ) ) {
		Error( L"Error retrieving column image" );
		return E_FAIL;
	}
	*pVal = lc.iImage;
	return S_OK;
}

STDMETHODIMP CListView::put_ColumnImage(long lIndex, long newVal)
{
	LV_COLUMN lc;

	memset( &lc, 0, sizeof(LV_COLUMN) );
	lc.mask = LVCF_IMAGE;
	lc.iImage = newVal;
	if( ! ListView_SetColumn( hListView, lIndex - 1, &lc ) ) {
		Error( L"Error setting column image" );
		return E_FAIL;
	}
	return S_OK;
}

STDMETHODIMP CListView::get_ItemText(long lItem, long lSubItem, BSTR *pVal)
{
	LV_ITEM li;
	TCHAR szStr[ 300 ];

	if( lItem < 1 || lSubItem < 1 )  return E_INVALIDARG;
	memset( &li, 0, sizeof(LV_ITEM) );
	li.mask = LVIF_TEXT;
	li.pszText = szStr;
	li.cchTextMax = 300;
	li.iItem = lItem - 1;
	li.iSubItem = lSubItem - 1;
	if( ! ListView_GetItem( hListView, &li ) ) {
		Error( L"Error retrieving item text" );
		return E_FAIL;
	}
	*pVal = SysAllocString( szStr );
	return S_OK;
}

STDMETHODIMP CListView::put_ItemText(long lItem, long lSubItem, BSTR newVal)
{
	LV_ITEM li;

	if( lItem < 1 || lSubItem < 1 )  return E_INVALIDARG;
	memset( &li, 0, sizeof(LV_ITEM) );
	li.mask = LVIF_TEXT;
	li.pszText = newVal;
	li.iItem = lItem - 1;
	li.iSubItem = lSubItem - 1;
	if( ! ListView_SetItem( hListView, &li ) ) {
		SysFreeString( newVal );
		Error( L"Error setting item text" );
		return E_FAIL;
	}
	SysFreeString( newVal );
	return S_OK;
}

STDMETHODIMP CListView::get_ItemImage(long lItem, long lSubItem, long *pVal)
{
	LV_ITEM li;

	if( lItem < 1 || lSubItem < 1 ) {
		Error( L"Item or subitem is out of range" );
		return E_INVALIDARG;
	}
	memset( &li, 0, sizeof(LV_ITEM) );
	li.mask = LVIF_IMAGE;
	if( ! ListView_GetItem( hListView, &li ) ) {
		Error( L"Error retrieving item image" );
		return E_FAIL;
	}
	*pVal = li.iImage;
	return S_OK;
}

STDMETHODIMP CListView::put_ItemImage(long lItem, long lSubItem, long newVal)
{
	LV_ITEM li;

	if( lItem < 1 || lSubItem < 1 ) {
		Error( L"Item or subitem is out of range" );
		return E_INVALIDARG;
	}
	memset( &li, 0, sizeof(LV_ITEM) );
	li.mask = LVIF_IMAGE;
	li.iImage = newVal;
	li.iItem = lItem - 1;
	li.iSubItem = lSubItem - 1;
	if( ! ListView_SetItem( hListView, &li ) ) {
		Error( L"Error setting item image" );
		return E_FAIL;
	}
	return S_OK;
}

STDMETHODIMP CListView::get_ItemValue(long lItem, long lSubItem, long *pVal)
{
	LV_ITEM li;

	if( lItem < 1 || lSubItem < 1 ) {
		Error( L"Item or subitem is out of range" );
		return E_INVALIDARG;
	}
	memset( &li, 0, sizeof(LV_ITEM) );
	li.mask = LVIF_PARAM;
	li.iItem = lItem - 1;
	li.iSubItem = lSubItem - 1;
	if( ! ListView_GetItem( hListView, &li ) ) {
		Error( L"Error retrieving item value" );
		return E_FAIL;
	}
	*pVal = li.lParam;
	return S_OK;
}

STDMETHODIMP CListView::put_ItemValue(long lItem, long lSubItem, long newVal)
{
	LV_ITEM li;

	if( lItem < 1 || lSubItem < 1 ) {
		Error( L"Item or subitem is out of range" );
		return E_INVALIDARG;
	}
	memset( &li, 0, sizeof(LV_ITEM) );
	li.mask = LVIF_PARAM;
	li.lParam = newVal;
	li.iItem = lItem - 1;
	li.iSubItem = lSubItem - 1;
	if( ! ListView_SetItem( hListView, &li ) ) {
		Error( L"Error setting item value" );
		return E_FAIL;
	}
	return S_OK;
}

STDMETHODIMP CListView::SetFocus()
{
	::SetFocus( hListView );
	return S_OK;
}

STDMETHODIMP CListView::get_Tabstop(long *pVal)
{
	if( GetWindowLong( GWL_STYLE ) & WS_TABSTOP )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CListView::put_Tabstop(long newVal)
{
	if( newVal ) SetWindowLong( GWL_STYLE, GetWindowLong( GWL_STYLE ) | WS_TABSTOP );
	else SetWindowLong( GWL_STYLE, GetWindowLong( GWL_STYLE ) & ~WS_TABSTOP );
	return S_OK;
}

STDMETHODIMP CListView::get_FontName(BSTR *pVal)
{
	*pVal = SysAllocString( bFontName );
	return S_OK;
}

STDMETHODIMP CListView::put_FontName(BSTR newVal)
{
	LOGFONT lf;

	SysFreeString( bFontName );
	bFontName = newVal;
	memset( &lf, 0, sizeof(LOGFONT) );
	wcscpy( lf.lfFaceName, bFontName );
	lf.lfHeight = lFontSize;
	if( lFontBold )  lf.lfWeight = 700;
	else lf.lfWeight = 400;
	DeleteObject( hFont );
	hFont = CreateFontIndirect( &lf );
	::SendMessage( hListView, WM_SETFONT, (WPARAM)hFont, TRUE );
	return S_OK;
}

STDMETHODIMP CListView::get_FontSize(long *pVal)
{
	*pVal = lFontSize;
	return S_OK;
}

STDMETHODIMP CListView::put_FontSize(long newVal)
{
	LOGFONT lf;

	lFontSize = newVal;
	memset( &lf, 0, sizeof(LOGFONT) );
	wcscpy( lf.lfFaceName, bFontName );
	lf.lfHeight = lFontSize;
	if( lFontBold )  lf.lfWeight = 700;
	else lf.lfWeight = 400;
	DeleteObject( hFont );
	hFont = CreateFontIndirect( &lf );
	::SendMessage( hListView, WM_SETFONT, (WPARAM)hFont, TRUE );
	return S_OK;
}

STDMETHODIMP CListView::get_FontBold(long *pVal)
{
	*pVal = lFontBold;
	return S_OK;
}

STDMETHODIMP CListView::put_FontBold(long newVal)
{
	LOGFONT lf;

	lFontBold = newVal;
	memset( &lf, 0, sizeof(LOGFONT) );
	wcscpy( lf.lfFaceName, bFontName );
	lf.lfHeight = lFontSize;
	if( lFontBold )  lf.lfWeight = 700;
	else lf.lfWeight = 400;
	DeleteObject( hFont );
	hFont = CreateFontIndirect( &lf );
	::SendMessage( hListView, WM_SETFONT, (WPARAM)hFont, TRUE );
	return S_OK;
}

STDMETHODIMP CListView::get_Style(long *pVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hListView, GWL_EXSTYLE );
	if( ( dwStyle & WS_EX_CLIENTEDGE ) == WS_EX_CLIENTEDGE )  *pVal = 1;
	else
	if( ( dwStyle & WS_EX_WINDOWEDGE ) == WS_EX_WINDOWEDGE )  *pVal = 2;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CListView::put_Style(long newVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hListView, GWL_EXSTYLE );
	dwStyle = dwStyle & ~( WS_EX_CLIENTEDGE | WS_EX_STATICEDGE | WS_EX_WINDOWEDGE );
	if( newVal == 1 ) dwStyle |= WS_EX_CLIENTEDGE;
	if( newVal == 2 ) dwStyle |= WS_EX_WINDOWEDGE;
	::SetWindowLong( hListView, GWL_EXSTYLE, dwStyle );
	::SetWindowPos( hListView, NULL, 0, 0, 0, 0,
				    SWP_NOZORDER | SWP_NOSIZE | SWP_NOMOVE | SWP_FRAMECHANGED );
	return S_OK;
}

STDMETHODIMP CListView::get_AllowEventAsDefault(long *pVal)
{
	if( ! lDefaultEventReturnValue ) *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CListView::put_AllowEventAsDefault(long newVal)
{
	if( ! newVal ) lDefaultEventReturnValue = 1;
	else lDefaultEventReturnValue = 0;
	return S_OK;
}

STDMETHODIMP CListView::put_AllowEvent(long newVal)
{
	if( ! newVal ) lLastEventReturnValue = 1;
	else lLastEventReturnValue = 0;
	return S_OK;
}

STDMETHODIMP CListView::AddContextItem(BSTR bText)
{
	if( *bText == L'-' ) AppendMenu( hMenu, MF_SEPARATOR, 0, NULL );
	else AppendMenu( hMenu, MF_STRING, lLastMenuID, bText );
	++lLastMenuID;
	SysFreeString( bText );
	return S_OK;
}

STDMETHODIMP CListView::RemoveContextItem(long lIndex)
{
	if( lIndex < 1 ) {
		Error( L"Menu item is out of range" );
		return E_FAIL;
	}
	::DeleteMenu( hMenu, lIndex - 1, MF_BYPOSITION );
	return S_OK;
}

STDMETHODIMP CListView::ClearContext()
{
	while( ::DeleteMenu( hMenu, 0, MF_BYPOSITION ) );
	return S_OK;
}

STDMETHODIMP CListView::get_Version(long *pVal)
{
	*pVal = 106;
	return S_OK;
}

STDMETHODIMP CListView::EnsureVisible(long lItem)
{
	if( lItem < 1 ) {
		Error( L"Item is out of range" );
		return E_FAIL;
	}
	::SendMessage( hListView, LVM_ENSUREVISIBLE, lItem - 1, FALSE );
	return S_OK;
}

STDMETHODIMP CListView::Show()
{
	ShowWindow( SW_SHOW );
	return S_OK;
}

STDMETHODIMP CListView::Hide()
{
	ShowWindow( SW_HIDE );
	return S_OK;
}

STDMETHODIMP CListView::get_ColumnCount(long *pVal)
{
	int iColCount;
	LV_COLUMN lvc;

	iColCount = 0;
	memset( &lvc, 0, sizeof(LV_COLUMN) );
	lvc.mask = LVCF_WIDTH;
	while( ListView_GetColumn( hListView, iColCount, &lvc ) )
		++iColCount;
	*pVal = iColCount;
	return S_OK;
}

STDMETHODIMP CListView::get_RowsPerPage(long *pVal)
{
	*pVal = ListView_GetCountPerPage( hListView );
	return S_OK;
}

STDMETHODIMP CListView::get_TopIndex(long *pVal)
{
	*pVal = ListView_GetTopIndex( hListView );
	return S_OK;
}

STDMETHODIMP CListView::get_hWnd(long *pVal)
{
	*pVal = (long)m_hWnd;
	return S_OK;
}
