// MGCEHCtrl.cpp : Implementation of DLL Exports.


// Note: Proxy/Stub Information
//		To build a separate proxy/stub DLL, 
//		run nmake -f MGCEHCtrlps.mk in the project directory.

#include "stdafx.h"
#include "resource.h"
#include "initguid.h"
#include "MGCEHCtrl.h"

#include "MGCEHCtrl_i.c"
#include "IPAddress.h"
#include "HTML.h"


CComModule _Module;
WNDPROC lpOldProc;

BEGIN_OBJECT_MAP(ObjectMap)
OBJECT_ENTRY(CLSID_IPAddress, CIPAddress)
OBJECT_ENTRY(CLSID_HTML, CHTML)
END_OBJECT_MAP()

/////////////////////////////////////////////////////////////////////////////
// DLL Entry Point

extern "C"
BOOL WINAPI DllMain(HANDLE hInstance, DWORD dwReason, LPVOID /*lpReserved*/)
{
	if (dwReason == DLL_PROCESS_ATTACH)
	{
		_Module.Init(ObjectMap, (HINSTANCE)hInstance);
#ifndef UNDER_CE
		DisableThreadLibraryCalls((HINSTANCE)hInstance);
#endif
	}
	else if (dwReason == DLL_PROCESS_DETACH)
		_Module.Term();
	return TRUE;    // ok
}

/////////////////////////////////////////////////////////////////////////////
// Used to determine whether the DLL can be unloaded by OLE

STDAPI DllCanUnloadNow(void)
{
	return (_Module.GetLockCount()==0) ? S_OK : S_FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// Returns a class factory to create an object of the requested type

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
	return _Module.GetClassObject(rclsid, riid, ppv);
}

/////////////////////////////////////////////////////////////////////////////
// DllRegisterServer - Adds entries to the system registry

STDAPI DllRegisterServer(void)
{
	// registers object, typelib and all interfaces in typelib
	return _Module.RegisterServer(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
// DllUnregisterServer - Removes entries from the system registry

STDAPI DllUnregisterServer(void)
{
	_Module.UnregisterServer();
	return S_OK;
}


LRESULT WINAPI EditSubProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	if( msg == WM_CHAR || msg == WM_KEYDOWN || msg == WM_KEYUP ) {
		LONG lResult;
		unsigned short szStr[ 4 ];
		int iID, iVal;
		BOOL bJunk;

		if( (char)wParam >= '0' && (char)wParam <= '9' && msg == WM_CHAR ) {
			lResult = CallWindowProc( lpOldProc, hWnd, msg, wParam, lParam );
			if( GetWindowText( hWnd, szStr, 4 ) + 1 == 4 ) {
				iVal = GetDlgItemInt( GetParent( hWnd ),
							GetWindowLong( hWnd, GWL_ID ), &bJunk, TRUE );
				if( iVal > 255 ) SendMessage( hWnd, EM_SETSEL, -1, 0 );
				else {
					iID = GetWindowLong( hWnd, GWL_ID );
					if( iID < 1003 )  ++iID;
					SetFocus( GetDlgItem( GetParent( hWnd ), iID ) );
					if( ::GetWindowTextLength( GetDlgItem( GetParent( hWnd ), iID ) ) )
						::SendMessage( GetDlgItem( GetParent( hWnd ), iID ), EM_SETSEL, -1, 0 );
				}
			}
			return( lResult );
		}

		if( (char)wParam == '.' && msg == WM_CHAR ) {
			int iID;

			iID = GetWindowLong( hWnd, GWL_ID );
			if( iID < 1003 ) {
				++iID;
				SetFocus( GetDlgItem( GetParent( hWnd ), iID ) );
				if( ::GetWindowTextLength( GetDlgItem( GetParent( hWnd ), iID ) ) )
					::SendMessage( GetDlgItem( GetParent( hWnd ), iID ), EM_SETSEL, -1, 0 );
			}
			return( TRUE );
		}

		if( (char)wParam == 8 && msg == WM_CHAR ) {
			int iID;
			unsigned short szStr[ 4 ];

			iID = GetWindowLong( hWnd, GWL_ID );
			if( ! GetWindowText( hWnd, szStr, 3 ) ) {
				if( iID > 1000 ) {
					--iID;
					SetFocus( GetDlgItem( GetParent( hWnd ), iID ) );
				}
			} else return( CallWindowProc( lpOldProc, hWnd, msg, wParam, lParam ) );
			return( TRUE );
		}

		if( wParam == VK_LEFT || wParam == VK_RIGHT || wParam == VK_DELETE )
			return( CallWindowProc( lpOldProc, hWnd, msg, wParam, lParam ) );

		return( TRUE );
	}
	return( CallWindowProc( lpOldProc, hWnd, msg, wParam, lParam ) );
}

