// IPAddress.h : Declaration of the CIPAddress

#ifndef __IPADDRESS_H_
#define __IPADDRESS_H_

#include "resource.h"       // main symbols
#include <atlctl.h>

extern WNDPROC lpOldProc;
LRESULT WINAPI EditSubProc( HWND, UINT, WPARAM, LPARAM );

/////////////////////////////////////////////////////////////////////////////
// CIPAddress
class ATL_NO_VTABLE CIPAddress : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<IIPAddress, &IID_IIPAddress, &LIBID_MGCEHCTRLLib>,
	public CComControl<CIPAddress>,
	public IPersistStreamInitImpl<CIPAddress>,
	public IOleControlImpl<CIPAddress>,
	public IOleObjectImpl<CIPAddress>,
	public IOleInPlaceActiveObjectImpl<CIPAddress>,
	public IViewObjectExImpl<CIPAddress>,
	public IOleInPlaceObjectWindowlessImpl<CIPAddress>,
	public IPersistStorageImpl<CIPAddress>,
	public ISpecifyPropertyPagesImpl<CIPAddress>,
	public IQuickActivateImpl<CIPAddress>,
	public IDataObjectImpl<CIPAddress>,
	public IProvideClassInfo2Impl<&CLSID_IPAddress, NULL, &LIBID_MGCEHCTRLLib>,
	public CComCoClass<CIPAddress, &CLSID_IPAddress>
{
public:
	CIPAddress()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_IPADDRESS)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CIPAddress)
	COM_INTERFACE_ENTRY(IIPAddress)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
END_COM_MAP()

BEGIN_PROP_MAP(CIPAddress)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_MSG_MAP(CIPAddress)
	MESSAGE_HANDLER( WM_CTLCOLOREDIT, OnCtlColorEdit )
	MESSAGE_HANDLER( WM_CTLCOLORMSGBOX, OnCtlColorEdit )
	MESSAGE_HANDLER( WM_DESTROY, OnDestroy )
	MESSAGE_HANDLER( WM_CREATE, OnCreate )
	MESSAGE_HANDLER( WM_SETFONT, OnSetFont )
	MESSAGE_HANDLER( WM_GETFONT, OnGetFont )
	MESSAGE_HANDLER( WM_SETFOCUS, OnFocus )
	MESSAGE_HANDLER( WM_KILLFOCUS, OnFocus )
	CHAIN_MSG_MAP(CComControl<CIPAddress>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// IIPAddress
public:
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Tabstop)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Tabstop)(/*[in]*/ long newVal);
	STDMETHOD(SetFocus)();
	STDMETHOD(Hide)();
	STDMETHOD(Show)();
	STDMETHOD(get_FontBold)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_FontBold)(/*[in]*/ long newVal);
	STDMETHOD(get_FontSize)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_FontSize)(/*[in]*/ long newVal);
	STDMETHOD(get_FontName)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_FontName)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_ForeColor)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_ForeColor)(/*[in]*/ long newVal);
	STDMETHOD(get_BackColor)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_BackColor)(/*[in]*/ long newVal);
	STDMETHOD(get_Enabled)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Enabled)(/*[in]*/ long newVal);
	STDMETHOD(get_Border)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Border)(/*[in]*/ long newVal);
	STDMETHOD(get_Value)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Value)(/*[in]*/ BSTR newVal);

	HRESULT OnCreate( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		RECT Rect;
		int i, iPer;
		HWND hEdit;
		LOGFONT lf;

		SetWindowLong( GWL_STYLE, GetWindowLong( GWL_STYLE ) + WS_TABSTOP );
		dwBackColor = GetSysColor( COLOR_WINDOW );
		dwTextColor = GetSysColor( COLOR_WINDOWTEXT );
		hBkBrush = CreateSolidBrush( dwBackColor );
		lBorder = 1;
		bFontName = L"Arial";
		lFontSize = 14;
		lFontBold = 0;
		memset( &lf, 0, sizeof(LOGFONT) );
		lf.lfHeight = 0 - lFontSize;
		wcscpy( lf.lfFaceName, bFontName );
		if( lFontBold )  lf.lfWeight = 700;
		else             lf.lfWeight = 400;
		hFont = CreateFontIndirect( &lf );

		this->GetClientRect( &Rect );
		Rect.left++;
		Rect.top++;
		Rect.right -= 2;
		Rect.bottom -= 2;
		iPer = ( Rect.right - 15 ) / 4;
		for( i = 0; i < 4; i++ ) {
			hEdit = CreateWindow( L"edit", NULL, WS_VISIBLE | WS_CHILD | ES_CENTER | WS_TABSTOP,
								  ( iPer * i ) + ( 5 * i ) + 1, 1, iPer, Rect.bottom,
								  this->m_hWnd, (HMENU)( 1000 + i ), _Module.m_hInst, NULL );
			lpOldProc = (WNDPROC)::GetWindowLong( hEdit, GWL_WNDPROC );
			::SetWindowLong( hEdit, GWL_WNDPROC, (DWORD)EditSubProc );
			::SendMessage( hEdit, EM_LIMITTEXT, 3, 0 );
		}
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnDestroy( UINT msg, WPARAM wParam, LPARAM lParam, BOOL &bHandled )
	{
		::DestroyWindow( ::GetDlgItem( this->m_hWnd, 1000 ) );
		::DestroyWindow( ::GetDlgItem( this->m_hWnd, 1001 ) );
		::DestroyWindow( ::GetDlgItem( this->m_hWnd, 1002 ) );
		::DestroyWindow( ::GetDlgItem( this->m_hWnd, 1003 ) );
		::DeleteObject( hBkBrush );
		::DeleteObject( hFont );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnCtlColorEdit( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		::SetTextColor( (HDC)wParam, dwTextColor );
		::SetBkColor( (HDC)wParam, dwBackColor );
		bHandled = (BOOL)hBkBrush;
		return (long)hBkBrush;
	}

	HRESULT OnSetFont( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		::SendDlgItemMessage( this->m_hWnd, 1000, msg, wParam, lParam );
		::SendDlgItemMessage( this->m_hWnd, 1001, msg, wParam, lParam );
		::SendDlgItemMessage( this->m_hWnd, 1002, msg, wParam, lParam );
		::SendDlgItemMessage( this->m_hWnd, 1003, msg, wParam, lParam );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnGetFont( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		bHandled = (BOOL)::SendDlgItemMessage( this->m_hWnd, 1000, msg, wParam, lParam );
		return S_OK;
	}

	HRESULT OnFocus( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		SendDlgItemMessage( 1000, msg, wParam, lParam );
		::SetFocus( GetDlgItem( 1000 ) );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		RECT Rect;
		int i;
		HPEN hPen;
		HBRUSH hBrush;
		HWND hEdit;

		GetClientRect( &Rect );

		if( lBorder ) hPen = ::CreatePen( PS_SOLID, 1, RGB( 0, 0, 0 ) );
		else hPen = ::CreatePen( PS_SOLID, 1, dwBackColor );
		hPen = (HPEN)::SelectObject( di.hdcDraw, hPen );
		hBrush = (HBRUSH)::SelectObject( di.hdcDraw, hBkBrush );
		::Rectangle( di.hdcDraw, 0, 0, Rect.right, Rect.bottom );
		::SelectObject( di.hdcDraw, hBrush );
		DeleteObject( (HPEN)::SelectObject( di.hdcDraw, hPen ) );

		for( i = 0; i < 3; i++ ) {
			hEdit = GetDlgItem( 1000 + i );
			::GetClientRect( hEdit, &Rect );
			::ClientToScreen( hEdit, (LPPOINT)&Rect );
			::ScreenToClient( this->m_hWnd, (LPPOINT)&Rect );
			::SetPixel( di.hdcDraw, Rect.left + Rect.right + 1, Rect.bottom - 3, dwTextColor );
			::SetPixel( di.hdcDraw, Rect.left + Rect.right + 2, Rect.bottom - 3, dwTextColor );
			::SetPixel( di.hdcDraw, Rect.left + Rect.right + 1, Rect.bottom - 2, dwTextColor );
			::SetPixel( di.hdcDraw, Rect.left + Rect.right + 2, Rect.bottom - 2, dwTextColor );
		}
		return S_OK;
	}
private:
	DWORD dwBackColor;
	DWORD dwTextColor;
	HBRUSH hBkBrush;
	BSTR bFontName;
	long lFontSize;
	HFONT hFont;
	long lFontBold;
	long lBorder;
};

#endif //__IPADDRESS_H_
