// IPAddress.cpp : Implementation of CIPAddress

#include "stdafx.h"
#include "MGCEHCtrl.h"
#include "IPAddress.h"

/////////////////////////////////////////////////////////////////////////////
// CIPAddress


STDMETHODIMP CIPAddress::get_Value(BSTR *pVal)
{
	unsigned short szVal[ 24 ], szItem[ 4 ];

	szVal[ 0 ] = L'\0';
	::GetDlgItemText( this->m_hWnd, 1000, szItem, 4 );
	wcscat( szVal, szItem );
	wcscat( szVal, L"." );
	::GetDlgItemText( this->m_hWnd, 1001, szItem, 4 );
	wcscat( szVal, szItem );
	wcscat( szVal, L"." );
	::GetDlgItemText( this->m_hWnd, 1002, szItem, 4 );
	wcscat( szVal, szItem );
	wcscat( szVal, L"." );
	::GetDlgItemText( this->m_hWnd, 1003, szItem, 4 );
	wcscat( szVal, szItem );
	*pVal = SysAllocString( szVal );
	return S_OK;
}

STDMETHODIMP CIPAddress::put_Value(BSTR newVal)
{
	unsigned short szStr[ 24 ], *pszStart, *pszEnd;

	wcscpy( szStr, newVal );
	pszStart = szStr;
	pszEnd = wcschr( pszStart, L'.' );
	if( pszEnd )  *pszEnd = L'\0';
	this->SendDlgItemMessage( 1000, WM_SETTEXT, 0, (LPARAM)pszStart );
	if( pszEnd ) {
		pszStart = pszEnd + 1;
		pszEnd = wcschr( pszStart, L'.' );
		if( pszEnd )  *pszEnd = L'\0';
		this->SendDlgItemMessage( 1001, WM_SETTEXT, 0, (LPARAM)pszStart );
		if( pszEnd ) {
			pszStart = pszEnd + 1;
			pszEnd = wcschr( pszStart, L'.' );
			if( pszEnd ) *pszEnd = L'\0';
			this->SendDlgItemMessage( 1002, WM_SETTEXT, 0, (LPARAM)pszStart );
			if( pszEnd ) {
				pszStart = pszEnd + 1;
				this->SendDlgItemMessage( 1003, WM_SETTEXT, 0, (LPARAM)pszStart );
			}
		}
	}
	SysFreeString( newVal );
	return S_OK;
}

STDMETHODIMP CIPAddress::get_Border(long *pVal)
{
	*pVal = lBorder;
	return S_OK;
}

STDMETHODIMP CIPAddress::put_Border(long newVal)
{
	lBorder = newVal;
	::InvalidateRect( this->m_hWnd, NULL, TRUE );
	return S_OK;
}

STDMETHODIMP CIPAddress::get_Enabled(long *pVal)
{
	*pVal = ::IsWindowEnabled( this->GetDlgItem( 1000 ) );
	return S_OK;
}

STDMETHODIMP CIPAddress::put_Enabled(long newVal)
{
	::EnableWindow( this->GetDlgItem( 1000 ), newVal );
	::EnableWindow( this->GetDlgItem( 1001 ), newVal );
	::EnableWindow( this->GetDlgItem( 1002 ), newVal );
	::EnableWindow( this->GetDlgItem( 1003 ), newVal );
	return S_OK;
}

STDMETHODIMP CIPAddress::Show()
{
	this->ShowWindow( SW_SHOW );
	return S_OK;
}

STDMETHODIMP CIPAddress::Hide()
{
	this->ShowWindow( SW_HIDE );
	return S_OK;
}

STDMETHODIMP CIPAddress::SetFocus()
{
	::SetFocus( this->GetDlgItem( 1000 ) );
	return S_OK;
}

STDMETHODIMP CIPAddress::get_BackColor(long *pVal)
{
	*pVal = dwBackColor;
	return S_OK;
}

STDMETHODIMP CIPAddress::put_BackColor(long newVal)
{
	dwBackColor = newVal;
	::DeleteObject( hBkBrush );
	hBkBrush = CreateSolidBrush( newVal );
	this->InvalidateRect( NULL, TRUE );
	return S_OK;
}

STDMETHODIMP CIPAddress::get_ForeColor(long *pVal)
{
	*pVal = dwTextColor;
	return S_OK;
}

STDMETHODIMP CIPAddress::put_ForeColor(long newVal)
{
	dwTextColor = newVal;
	this->InvalidateRect( NULL, TRUE );
	return S_OK;
}

STDMETHODIMP CIPAddress::get_FontName(BSTR *pVal)
{
	*pVal = SysAllocString( bFontName );
	return S_OK;
}

STDMETHODIMP CIPAddress::put_FontName(BSTR newVal)
{
	LOGFONT lf;

	memset( &lf, 0, sizeof(LOGFONT) );
	lf.lfHeight = 0 - lFontSize;
	wcscpy( lf.lfFaceName, newVal );
	SysFreeString( newVal );
	if( lFontBold ) lf.lfWeight = 700;
	else            lf.lfWeight = 400;
	::DeleteObject( hFont );
	hFont = CreateFontIndirect( &lf );
	::SendDlgItemMessage( this->m_hWnd, 1000, WM_SETFONT, (WPARAM)hFont, 1 );
	::SendDlgItemMessage( this->m_hWnd, 1001, WM_SETFONT, (WPARAM)hFont, 1 );
	::SendDlgItemMessage( this->m_hWnd, 1002, WM_SETFONT, (WPARAM)hFont, 1 );
	::SendDlgItemMessage( this->m_hWnd, 1003, WM_SETFONT, (WPARAM)hFont, 1 );
	InvalidateRect( NULL, TRUE );
	return S_OK;
}

STDMETHODIMP CIPAddress::get_FontSize(long *pVal)
{
	*pVal = lFontSize;
	return S_OK;
}

STDMETHODIMP CIPAddress::put_FontSize(long newVal)
{
	LOGFONT lf;

	lFontSize = newVal;
	memset( &lf, 0, sizeof(LOGFONT) );
	lf.lfHeight = 0 - lFontSize;
	wcscpy( lf.lfFaceName, bFontName );
	if( lFontBold ) lf.lfWeight = 700;
	else            lf.lfWeight = 400;
	::DeleteObject( hFont );
	hFont = CreateFontIndirect( &lf );
	::SendDlgItemMessage( this->m_hWnd, 1000, WM_SETFONT, (WPARAM)hFont, 1 );
	::SendDlgItemMessage( this->m_hWnd, 1001, WM_SETFONT, (WPARAM)hFont, 1 );
	::SendDlgItemMessage( this->m_hWnd, 1002, WM_SETFONT, (WPARAM)hFont, 1 );
	::SendDlgItemMessage( this->m_hWnd, 1003, WM_SETFONT, (WPARAM)hFont, 1 );
	InvalidateRect( NULL, TRUE );
	return S_OK;
}

STDMETHODIMP CIPAddress::get_FontBold(long *pVal)
{
	*pVal = lFontBold;
	return S_OK;
}

STDMETHODIMP CIPAddress::put_FontBold(long newVal)
{
	LOGFONT lf;

	lFontBold = newVal;
	memset( &lf, 0, sizeof(LOGFONT) );
	lf.lfHeight = 0 - lFontSize;
	wcscpy( lf.lfFaceName, bFontName );
	if( lFontBold ) lf.lfWeight = 700;
	else            lf.lfWeight = 400;
	::DeleteObject( hFont );
	hFont = CreateFontIndirect( &lf );
	::SendDlgItemMessage( this->m_hWnd, 1000, WM_SETFONT, (WPARAM)hFont, 1 );
	::SendDlgItemMessage( this->m_hWnd, 1001, WM_SETFONT, (WPARAM)hFont, 1 );
	::SendDlgItemMessage( this->m_hWnd, 1002, WM_SETFONT, (WPARAM)hFont, 1 );
	::SendDlgItemMessage( this->m_hWnd, 1003, WM_SETFONT, (WPARAM)hFont, 1 );
	InvalidateRect( NULL, TRUE );
	return S_OK;
}

STDMETHODIMP CIPAddress::get_Tabstop(long *pVal)
{
	if( GetWindowLong( GWL_STYLE ) & WS_TABSTOP )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CIPAddress::put_Tabstop(long newVal)
{
	if( newVal ) SetWindowLong( GWL_STYLE, GetWindowLong( GWL_STYLE ) | WS_TABSTOP );
	else SetWindowLong( GWL_STYLE, GetWindowLong( GWL_STYLE ) & ~WS_TABSTOP );
	return S_OK;
}

STDMETHODIMP CIPAddress::get_Version(long *pVal)
{
	*pVal = 101;
	return S_OK;
}
