// HTML.h : Declaration of the CHTML

#ifndef __HTML_H_
#define __HTML_H_

#include "resource.h"       // main symbols
#include <atlctl.h>
#include "htmlctrl.h"
#include "MGCEHCtrlCP.h"


/////////////////////////////////////////////////////////////////////////////
// CHTML
class ATL_NO_VTABLE CHTML : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<IHTML, &IID_IHTML, &LIBID_MGCEHCTRLLib>,
	public CComControl<CHTML>,
	public IPersistStreamInitImpl<CHTML>,
	public IOleControlImpl<CHTML>,
	public IOleObjectImpl<CHTML>,
	public IOleInPlaceActiveObjectImpl<CHTML>,
	public IViewObjectExImpl<CHTML>,
	public IOleInPlaceObjectWindowlessImpl<CHTML>,
	public IConnectionPointContainerImpl<CHTML>,
	public IPersistStorageImpl<CHTML>,
	public ISpecifyPropertyPagesImpl<CHTML>,
	public IQuickActivateImpl<CHTML>,
	public IDataObjectImpl<CHTML>,
	public IProvideClassInfo2Impl<&CLSID_HTML, &DIID__IHTMLEvents, &LIBID_MGCEHCTRLLib>,
	public IPropertyNotifySinkCP<CHTML>,
	public CComCoClass<CHTML, &CLSID_HTML>,
	public CProxy_IHTMLEvents< CHTML >
{
public:
	typedef struct tagNM_HTMLVIEWW { 
	    NMHDR	hdr; 
	  	unsigned short *szTarget;
		unsigned short *szData;
		DWORD	dwCookie;
	} NM_HTMLVIEWW;

	CHTML()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_HTML)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CHTML)
	COM_INTERFACE_ENTRY(IHTML)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()

BEGIN_PROP_MAP(CHTML)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_CONNECTION_POINT_MAP(CHTML)
	CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
	CONNECTION_POINT_ENTRY(DIID__IHTMLEvents)
END_CONNECTION_POINT_MAP()

BEGIN_MSG_MAP(CHTML)
	MESSAGE_HANDLER( WM_CREATE, OnCreate )
	MESSAGE_HANDLER( WM_NOTIFY, OnNotify )
	MESSAGE_HANDLER( WM_SETFOCUS, OnFocus )
	MESSAGE_HANDLER( WM_KILLFOCUS, OnFocus )
	CHAIN_MSG_MAP(CComControl<CHTML>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// IHTML
public:
	STDMETHOD(get_hWnd)(/*[out, retval]*/ long *pVal);
	STDMETHOD(Copy)();
	STDMETHOD(get_Version)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Style)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Style)(/*[in]*/ long newVal);
	STDMETHOD(SetFocus)();
	STDMETHOD(get_Tabstop)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Tabstop)(/*[in]*/ long newVal);
	STDMETHOD(get_ForceFit)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_ForceFit)(/*[in]*/ long newVal);
	STDMETHOD(SelectAll)();
	STDMETHOD(TextDone)();
	STDMETHOD(ToAnchor)(BSTR bName);
	STDMETHOD(get_Border)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Border)(/*[in]*/ long newVal);
	STDMETHOD(SetTextFromFile)(BSTR bFilename);
	STDMETHOD(AddTextFromFile)(BSTR bFilename);
	STDMETHOD(SetText)(BSTR bText);
	STDMETHOD(AddText)(BSTR bText);
	STDMETHOD(Hide)();
	STDMETHOD(Show)();
	STDMETHOD(Clear)();

	HRESULT OnCreate( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		RECT Rect;

		SetWindowLong( GWL_STYLE, GetWindowLong( GWL_STYLE ) + WS_TABSTOP );
		this->GetClientRect( &Rect );
		InitHTMLControl( _Module.m_hInst );
		hCtrl = CreateWindow( DISPLAYCLASS, NULL, WS_CHILD | WS_VISIBLE | WS_TABSTOP,
							  1, 1, Rect.right - 2, Rect.bottom - 2, this->m_hWnd,
							  (HMENU)1000, _Module.m_hInst, NULL );
		lShrink = 0;
		bHandled = TRUE;
		lBorder = 1;
		return S_OK;
	}

	HRESULT OnNotify( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		NM_HTMLVIEWW *phv = (NM_HTMLVIEWW *)lParam;
		BSTR bTarget, bData;

		if( phv->hdr.code == NM_HOTSPOT ) {
			if( phv->szTarget )  bTarget = SysAllocString( phv->szTarget );
			else bTarget = SysAllocString( L"\0" );
			if( phv->szData )  bData = SysAllocString( phv->szData );
			else bData = SysAllocString( L"\0" );
			Fire_Click( bTarget, bData );
		}
		if( phv->hdr.code == NM_INLINE_IMAGE ) {
			INLINEIMAGEINFO iii;
			BITMAP bm;

			iii.hbm = ::SHLoadDIBitmap( phv->szTarget );
			if( ! iii.hbm )
				::SendMessage( hCtrl, DTM_IMAGEFAIL, 0, (LPARAM)phv->dwCookie );
			else {
				iii.dwCookie = phv->dwCookie;
				GetObject( iii.hbm, sizeof(BITMAP), &bm );
				iii.iOrigHeight = bm.bmHeight;
				iii.iOrigWidth = bm.bmWidth;
				iii.bOwnBitmap = TRUE;
				::SendMessage( hCtrl, DTM_SETIMAGE, 0, (LPARAM)&iii );
			}
		}
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnFocus( UINT msg, WPARAM wParam, LPARAM lParam, BOOL& bHandled )
	{
		::SendMessage( hCtrl, msg, wParam, lParam );
		if( msg == WM_SETFOCUS ) ::SetFocus( hCtrl );
		bHandled = TRUE;
		return S_OK;
	}

	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		HPEN hPen;
		RECT Rect;

		if( lBorder ) {
			this->GetClientRect( &Rect );
			hPen = CreatePen( PS_SOLID, 1, RGB( 0, 0, 0 ) );
			hPen = (HPEN)::SelectObject( di.hdcDraw, hPen );
			::Rectangle( di.hdcDraw, 0, 0, Rect.right, Rect.bottom );
			::DeleteObject( ::SelectObject( di.hdcDraw, hPen ) );
		}
		return S_OK;
	}
private:
	BOOL AToW( char *, unsigned short *);
	HWND hCtrl;
	long lBorder;
	long lShrink;
};

#endif //__HTML_H_
