// HTML.cpp : Implementation of CHTML

#include "stdafx.h"
#include "MGCEHCtrl.h"
#include "HTML.h"

/////////////////////////////////////////////////////////////////////////////
// CHTML


STDMETHODIMP CHTML::Clear()
{
	::SetWindowText( hCtrl, L"" );
	return S_OK;
}

STDMETHODIMP CHTML::Show()
{
	this->ShowWindow( SW_SHOW );
	return S_OK;
}

STDMETHODIMP CHTML::Hide()
{
	this->ShowWindow( SW_HIDE );
	return S_OK;
}

STDMETHODIMP CHTML::AddText(BSTR bText)
{
	::SendMessage( hCtrl, DTM_ADDTEXTW, 0, (LPARAM)bText );
	SysFreeString( bText );
	return S_OK;
}

STDMETHODIMP CHTML::SetText(BSTR bText)
{
	::SetWindowText( hCtrl, L"" );
	::SendMessage( hCtrl, DTM_ADDTEXTW, 0, (LPARAM)bText );
	SysFreeString( bText );
	return S_OK;
}

STDMETHODIMP CHTML::AddTextFromFile(BSTR bFilename)
{
	HANDLE hFile;
	DWORD dwSize, dwRead;
	unsigned short *pucBuffer;
	char *pszBuffer;

	hFile = ::CreateFile( bFilename, GENERIC_READ, 0, NULL, OPEN_EXISTING,
					      FILE_ATTRIBUTE_NORMAL, NULL );
	if( hFile == INVALID_HANDLE_VALUE ) {
		Error( L"Unable to open specified file" );
		SysFreeString( bFilename );
		return E_FAIL;
	}
	SysFreeString( bFilename );
	dwSize = ::GetFileSize( hFile, NULL );
	pucBuffer = (unsigned short *)malloc( ( dwSize * 2 ) + 8 );
	if( ! pucBuffer ) {
		CloseHandle( hFile );
		SysFreeString( bFilename );
		return E_OUTOFMEMORY;
	}

	pszBuffer = (char *)malloc( dwSize + 4 );
	if( ! pszBuffer ) {
		free( pucBuffer );
		CloseHandle( hFile );
		SysFreeString( bFilename );
		return E_OUTOFMEMORY;
	}

	::ReadFile( hFile, pszBuffer, dwSize, &dwRead, NULL );
	::CloseHandle( hFile );
	if( dwSize != dwRead ) {
		free( pucBuffer );
		free( pszBuffer );
		Error( L"Invalid file" );
		SysFreeString( bFilename );
		return E_FAIL;
	}
	AToW( pszBuffer, pucBuffer );
	free( pszBuffer );
	::SendMessage( hCtrl, DTM_ADDTEXTW, 0, (LPARAM)pucBuffer );
	free( pucBuffer );
	SysFreeString( bFilename );
	return S_OK;
}


STDMETHODIMP CHTML::SetTextFromFile(BSTR bFilename)
{
	::SetWindowText( hCtrl, L"" );
	AddTextFromFile( bFilename );
	SysFreeString( bFilename );
	return S_OK;
}

BOOL CHTML::AToW( char *pszBuffer, unsigned short *pucBuffer )
{
	while( *pszBuffer )	*pucBuffer++ = (unsigned short)*pszBuffer++;
	*pucBuffer = 0;
	return( TRUE );
}

STDMETHODIMP CHTML::get_Border(long *pVal)
{
	*pVal = lBorder;
	return S_OK;
}

STDMETHODIMP CHTML::put_Border(long newVal)
{
	RECT Rect;

	lBorder = newVal;
	this->GetClientRect( &Rect );
	if( newVal )
		::SetWindowPos( hCtrl, NULL, 1, 1, Rect.right - 2, Rect.bottom - 2, SWP_NOZORDER );
	else
		::SetWindowPos( hCtrl, NULL, 0, 0, Rect.right, Rect.bottom, SWP_NOZORDER );
	InvalidateRect( NULL, TRUE );
	return S_OK;
}


STDMETHODIMP CHTML::ToAnchor(BSTR bName)
{
	::SendMessage( hCtrl, DTM_ANCHORW, 0, (LPARAM)bName );
	SysFreeString( bName );
	return S_OK;
}

STDMETHODIMP CHTML::TextDone()
{
	::SendMessage( hCtrl, DTM_ENDOFSOURCE, 0, 0 );
	return S_OK;
}

STDMETHODIMP CHTML::SelectAll()
{
	::SendMessage( hCtrl, DTM_SELECTALL, 0, 0 );
	return S_OK;
}

STDMETHODIMP CHTML::get_ForceFit(long *pVal)
{
	*pVal = lShrink;
	return S_OK;
}

STDMETHODIMP CHTML::put_ForceFit(long newVal)
{
	lShrink = newVal;
	::SendMessage( hCtrl, DTM_ENABLESHRINK, 0, newVal );
	return S_OK;
}

STDMETHODIMP CHTML::get_Tabstop(long *pVal)
{
	if( GetWindowLong( GWL_STYLE ) & WS_TABSTOP )  *pVal = 1;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CHTML::put_Tabstop(long newVal)
{
	if( newVal ) SetWindowLong( GWL_STYLE, GetWindowLong( GWL_STYLE ) | WS_TABSTOP );
	else SetWindowLong( GWL_STYLE, GetWindowLong( GWL_STYLE ) & ~WS_TABSTOP );
	return S_OK;
}

STDMETHODIMP CHTML::SetFocus()
{
	::SetFocus( hCtrl );
	return S_OK;
}


STDMETHODIMP CHTML::get_Style(long *pVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hCtrl, GWL_EXSTYLE );
	if( ( dwStyle & WS_EX_CLIENTEDGE ) == WS_EX_CLIENTEDGE )  *pVal = 1;
	else
	if( ( dwStyle & WS_EX_WINDOWEDGE ) == WS_EX_WINDOWEDGE )  *pVal = 2;
	else *pVal = 0;
	return S_OK;
}

STDMETHODIMP CHTML::put_Style(long newVal)
{
	DWORD dwStyle;

	dwStyle = ::GetWindowLong( hCtrl, GWL_EXSTYLE );
	dwStyle = dwStyle & ~( WS_EX_CLIENTEDGE | WS_EX_STATICEDGE | WS_EX_WINDOWEDGE );
	if( newVal == 1 ) dwStyle |= WS_EX_CLIENTEDGE;
	if( newVal == 2 ) dwStyle |= WS_EX_WINDOWEDGE;
	::SetWindowLong( hCtrl, GWL_EXSTYLE, dwStyle );
	::SetWindowPos( hCtrl, NULL, 0, 0, 0, 0,
				    SWP_NOZORDER | SWP_NOSIZE | SWP_NOMOVE | SWP_FRAMECHANGED );
	return S_OK;
}


STDMETHODIMP CHTML::get_Version(long *pVal)
{
	*pVal = 102;
	return S_OK;
}

STDMETHODIMP CHTML::Copy()
{
	HWND hTarget;

	hTarget = ::GetWindow( hCtrl, GW_CHILD );
	if( hTarget )  ::SendMessage( hTarget, WM_COMMAND, 0x000156BA, 0 );
	else           ::SendMessage( hTarget, WM_COPY, 0, 0 );
	return S_OK;
}

STDMETHODIMP CHTML::get_hWnd(long *pVal)
{
	*pVal = (long)m_hWnd;
	return S_OK;
}
