Attribute VB_Name = "Import"
Sub getProjectProperties()
Dim s, s1, s2 As String
Dim p As Integer
Dim p1 As Integer
Dim prop As CProperty
Dim Form As CForm
Dim module As New CModule
Main.labStatus.Caption = "Get Project Properties"

   chan = 1
   On Error GoTo endNow
   Open gProject.Path For Input As #chan
   On Error GoTo 0
   Do Until EOF(chan)
      Line Input #chan, s
      p = InStr(s, "=")
      If p > 0 Then
         Set prop = New CProperty
         prop.Name = left(s, p - 1)
         prop.Value = Mid(s, p + 1)
         gProject.Properties.Add prop
         If prop.Name = "Form" Then
            Set Form = New CForm
            Form.Path = TrimAll(prop.Value)
            gProject.Forms.Add Form
         End If
         If prop.Name = "Module" Then
            Set module = New CModule
            s = InStr(prop.Value, ";")
            module.Name = left(prop.Value, s - 1)
            module.Path = TrimAll(Mid(prop.Value, s + 1))
            p1 = InStrRev(module.Path, "\") 'trim off path up to last \
            If p1 > 0 Then module.Path = Mid(module.Path, p1 + 1)
            gProject.Modules.Add module
         End If
         If prop.Name = "Name" Then gProject.Name = TrimAll(prop.Value)
      End If
   Loop
   Close #chan
endNow:
End Sub
Sub getForms()
Dim Form As CForm
For Each Form In gProject.Forms
   Main.labStatus.Caption = "Getting form " & Form.Path
   getForm Form
Next
End Sub
Sub getForm(Form As CForm)
Dim s As String
Dim s1 As String
Dim s2 As String
Dim p As Integer
Dim prop As CProperty
Dim section As String 'can be Nothing Form, Control, Property
Dim property As String
Dim control As CControl
Dim frameStack(20) As CControl
Dim frameStackPtr As Integer
Dim Code As String
Dim quote As String
Dim log As String
Dim i As Integer
   
   chan = 1
   quote = Chr(34)
   On Error GoTo fileNotFound
   Open gProject.ProjectPath & Form.Path For Input As #chan
   On Error GoTo 0
   section = "Nothing"
   
   Do Until EOF(chan)
      Line Input #chan, s
      i = i + 1
      If Int(i / 100) = i / 100 Then
         Main.labStatus.Caption = "Getting Form " & Form.Path & " Line " & Str(i)
         Main.labStatus.Refresh
      End If
      
      Do While right(s, 2) = " _" 'combine continuation lines
         Line Input #chan, s1
         s = Mid(s, 1, Len(s) - 1) & Trim(s1)
      Loop
      
      'determine what section of the .ebf file we are processing
      If s = "VERSION 5.00" Then GoTo skipLine
      
      If left(s, 13) = "Begin VB.Form" Then
         section = "Form"
         Form.Name = TrimAll(Mid(s, 15))
         frameStackPointer = 0
         currentFrame = 0
         GoTo skipLine
      End If
      
      If Mid(Trim(s), 1, 6) = "Begin " Then 'new control
         section = "Control"
         Set control = New CControl
         p = InStr(s, "Begin ") + 6
         s1 = Mid(s, p)
         p = InStr(s1, " ")
         control.ControlType = TrimAll(left(s1, p - 1))
         If left(control.ControlType, 5) = "VBCE." Then control.ControlType = Mid(control.ControlType, 6)
         If left(control.ControlType, 3) = "VB." Then control.ControlType = Mid(control.ControlType, 4)
         control.ControlType = lookupProgID(control.ControlType)
         control.Name = TrimAll(Mid(s1, p + 1))
         control.Duplicate = False
         Form.Controls.Add control
         Set prop = New CProperty
         
         prop.Name = "ParentHWnd"
         If frameStackPtr = 0 Then
            prop.Value = Form.Name
         Else
            prop.Value = frameStack(frameStackPtr).Name
         End If
         control.Properties.Add prop
         
         If control.ControlType = "frame" Then
            frameStackPtr = frameStackPtr + 1
            If frameStackPtr > 20 Then
               putMessage "FATAL ERROR: Too many nested frames (limit is 20)"
               GoTo ExitSub
            End If
            Set frameStack(frameStackPtr) = control
         End If
         GoTo skipLine
      End If
      
      If Mid(Trim(s), 1, 13) = "BeginProperty" Then
         If section = "Control" Then
            section = "Property"
         Else
            If section <> "Form" Then MsgBox "Unexpected BeginProperty found. Please let support@nsbasic.com know about this!"
         End If
         s1 = Mid(Trim(s), 15)
         s2 = InStr(s1, " ")
         If s2 = 0 Then s2 = Len(s)
         property = Trim(Mid(s1, 1, s2))
         GoTo skipLine
      End If
      
      If section = "Attribute" And left(s, 9) <> "Attibute" Then section = "Code"
      
      If left(s, 9) = "Attribute" Then
         s = Mid(s, 11) 'treat attribute lines like regular properties
         section = "Attribute"
      End If
      
      If Mid(Trim(s), 1, 12) = "EndProperty" And section = "Property" Then
         section = "Control"
         GoTo skipLine
      End If
      If Mid(Trim(s), 1, 12) = "EndProperty" And section = "Form" Then
         GoTo skipLine
      End If
    
      If Mid(Trim(s), 1, 3) = "End" And section = "Control" Then
         If frameStackPtr > 0 Then
            If control.ControlType = "frame" Then
               frameStackPtr = frameStackPtr - 1
               If frameStackPtr < 0 Then
                  putMessage "FATAL ERROR: Frame Stack Underflow. Bad eVB Project."
                  GoTo ExitSub
               End If
               If frameStackPtr = 0 Then section = "Form"
            End If
            Set control = frameStack(frameStackPtr)
         Else
            section = "Form"
         End If
         
         GoTo skipLine
      End If
      
      If Mid(s, 1, 3) = "End" And section = "Form" Then
         section = "Nothing"
         GoTo skipLine
      End If
      
      'now, process the line depending on the section
      If section = "Code" Then
         If s = "Option Explicit" Then
            gProject.OptionExplicit = True
            GoTo skipLine
         End If
         If InStr(s, "App.") Then gProject.App = True
         If InStr(s, "Clipboard.") Then gProject.Clipboard = True
         If InStr(LCase(s), " createobject") Then s = getCreateObject(s)
         Code = Code & s & vbCr
         GoTo skipLine
      End If
      
      p = InStr(s, "=")
      Set prop = New CProperty
      prop.Name = Trim(left(s, p - 1))
      prop.Value = Trim(Mid(s, p + 1))
      Select Case section
      Case "Form", "Attribute"
         Form.Properties.Add prop
      Case "Control"
         control.Properties.Add prop
      Case "Property"
         prop.Name = property & "." & prop.Name
         control.Properties.Add prop
      End Select
      
skipLine:
   fldMessages = fldMessages & vbCrLf & section & " " & frameStackPtr & s
   Loop
ExitSub:
   Close #chan
   Form.Code = splitStatements(Code)
   Exit Sub
fileNotFound:
   putMessage Form.Path & " not found. All files must be in " & gProject.ProjectPath
End Sub
Sub getModules()
Dim module As CModule
For Each module In gProject.Modules
   Main.labStatus.Caption = "Getting module " & module.Name
   getModule module
Next
End Sub
Sub getModule(module As CModule)
Dim p As Integer
Dim s As String
Dim Code As String

   chan = 1
   Code = ""
   On Error GoTo fileNotFound
   Open gProject.ProjectPath & module.Path For Input As #chan
   On Error GoTo 0
   Line Input #chan, s  'skip Attribute VB_Name line at start
   
   Do Until EOF(chan)
      Line Input #chan, s
      
      Do While right(s, 2) = " _" 'combine continuation lines
         Line Input #chan, s1
         s = Mid(s, 1, Len(s) - 1) & Trim(s1)
      Loop
      
      If s = "Option Explicit" Then
         gProject.OptionExplicit = True
      Else
         If InStr(s, "App.") Then gProject.App = True
         If InStr(s, "Clipboard.") Then gProject.Clipboard = True
         If InStr(LCase(s), " createobject") Then s = getCreateObject(s)
         Code = Code & s & vbCr
      End If
   Loop
   
   Close #chan
   module.Code = splitStatements(Code)
   Exit Sub
fileNotFound:
   putMessage module.Path & " not found. All files must be in " & gProject.ProjectPath
End Sub
Function getCreateObject(s As String) As String
'for CreateObject and CreateObjectWithEvents, need to set up in object table
'set objectname=CreateObject[withEvents]("progID")
Dim objectName, progID As String
Dim p, p1 As Integer
Dim object As CObject
Dim quote As String
Dim spaces As String

   quote = Chr(34)
   If left(Trim(s), 3) <> "Set" Then
      s = s & "'NSB: Could not get ObjectName. Object may not be properly converted."
      Exit Function
   End If
   spaces = left(s, InStr(s, "Set") - 1)
   s = Mid(Trim(s), 5) 'get rid of Set
   p = InStr(s, " ")
   objectName = left(s, p - 1)
   p = InStr(p + 1, s, "(")
   s = Mid(s, p + 1) 'trim off CreateObject[withEvents])
   If left(s, 1) <> quote Then
      s = s & "'NSB: Could not get ProgID. Object may not be properly converted"
      Exit Function
   End If
   s = Mid(s, 2)
   p = InStr(s, quote)
   progID = left(s, p - 1)
   ControlType = lookupProgID(progID)
   
   'add object into table
   Set object = New CObject
   object.Name = objectName
   object.ControlType = lookupProgID(progID)
   gProject.Objects.Add object
   
   'fix up the statement while we're at it
   'yes, this should be done in export, but we've got everything we need now...
   getCreateObject = spaces & "addObject " & quote & ControlType & quote & "," & quote & objectName & quote
End Function
Sub buildObjects()
'This table contains all the objects in the project
'These can be intrinsic controls, objects or ActiveX controls
'Initially, just the controls are loaded in
'This table can be used to find duplicate object names

Dim Form As CForm
Dim Form1 As CForm
Dim control As CControl
Dim object As CObject
Dim object2 As CObject
Dim ControlType As String
Dim Index As Integer       'index to controls on form, starts at 1

   For Each Form In gProject.Forms
      Index = 0
      For Each control In Form.Controls
         Main.labStatus.Caption = "Building Objects: Form " & Form.Name & " Object: " & control.Name
         Index = Index + 1
         control.Index = Index
         'Is there an control with this name already? eVB allows this, NSB does not.
         For Each object In gProject.Objects
            If object.Name = control.Name Then
               'putMessage "Duplicate control name: " & control.Name & " is on " & Form.Name & " and " & object.formname & ". Rename one of the controls in the original eVB project."
               putMessage "Control " & control.Name & " on form " & Form.Name & " renamed to " & Form.Name & "_" & control.Name
               control.Duplicate = True
            End If
         Next
         For Each Form1 In gProject.Forms
            If control.Name = Form1.Name Then
              putMessage "Control " & control.Name & " on " & Form.Name & " has same name as form " & Form1.Name & ". Rename one of the controls in the original eVB project."
            End If
         Next
            
         ControlType = control.ControlType
         If left(ControlType, 1) = "*" Then ControlType = Mid(ControlType, 2)

         'add it by the name of the object
         Set object = New CObject
         object.Name = control.Name
         object.ControlType = ControlType
         object.formname = Form.Name
         object.Index = control.Index
         object.Duplicate = control.Duplicate
         gProject.Objects.Add object
         
         'also set up the reference by index in the form
         Set object2 = New CObject
         object2.Name = Form.Name & "(" & object.Index & ")"
         object2.formname = object.formname
         object2.ControlType = ControlType
         object2.Index = control.Index
         object2.Duplicate = control.Duplicate
         gProject.Objects.Add object2
         
      Next
   Next
End Sub
Function splitStatements(Code)
Dim i As Double
Dim quote As String
splitStatements = Code
quote = Chr(34)

'This subroutine still has two problems
'1. dealing with IF <cond> then <statement>:END IF
'2. putting the correct number of spaces in front of a newly split statement

'changes ":" line split statements into separate lines
   i = 1
   Do While i < Len(Code)
      If Mid(Code, i, 1) = ":" Then
         Mid(Code, i, 1) = vbCr
      End If
      If Mid(Code, i, 1) = Chr(34) Then 'literal string - skip over
         i = i + 1
         Do While Mid(Code, i, 1) <> Chr(34) And i < Len(Code)
            i = i + 1
         Loop
      End If
      If Mid(Code, i, 1) = "'" Then 'Comment - go to end of line
         Do While Mid(Code, i, 1) <> vbCr And i < Len(Code)
            i = i + 1
         Loop
      End If
      If Mid(Code, i, 1) = "(" Then 'paren - continue to end paren
         Do While Mid(Code, i, 1) <> ")" And i < Len(Code)
            i = i + 1
         Loop
      End If
      If Mid(Code, i, 1) = "[" Then 'bracket - continue to end bracket
         Do While Mid(Code, i, 1) <> "]" And i < Len(Code)
            i = i + 1
         Loop
      End If
      i = i + 1
   Loop
   splitStatements = Code
End Function
      
